<?php
/* ------------------------------------------------------------------------------------
*  COPYRIGHT AND TRADEMARK NOTICE
*  Copyright 2008-2026 Arnan de Gans. All Rights Reserved.
*  The software AdRotate, related services and ADROTATE the name are owned by Arnan de Gans.

*  COPYRIGHT NOTICES AND ALL THE COMMENTS SHOULD REMAIN INTACT.
*  By using this code you agree to indemnify Arnan de Gans from any
*  liability that might arise from its use.
------------------------------------------------------------------------------------ */

/*-------------------------------------------------------------
 Name:      adrotate_export_stats
 Purpose:   Export CSV data of given month
-------------------------------------------------------------*/
function adrotate_export_stats() {
	global $wpdb;

	if(wp_verify_nonce($_POST['adrotate_nonce'],'adrotate_export_ads') OR wp_verify_nonce($_POST['adrotate_nonce'],'adrotate_export_groups')
	OR wp_verify_nonce($_POST['adrotate_nonce'],'adrotate_export_advertiser') OR wp_verify_nonce($_POST['adrotate_nonce'],'adrotate_export_global')) {
		$id = $type = $start_date = $end_date = $adstats = $csv_emails = '';
		if(isset($_POST['adrotate_export_id'])) $id	= strip_tags(htmlspecialchars(trim($_POST['adrotate_export_id'], '\t\n '), ENT_QUOTES));
		if(isset($_POST['adrotate_export_type'])) $type = strip_tags(htmlspecialchars(trim($_POST['adrotate_export_type'], '\t\n '), ENT_QUOTES));
		if(isset($_POST['adrotate_start_date'])) $start_date = strip_tags(trim($_POST['adrotate_start_date'], '\t\n '));
		if(isset($_POST['adrotate_end_date'])) $end_date = strip_tags(trim($_POST['adrotate_end_date'], '\t\n '));
		if(isset($_POST['adrotate_export_format'])) $format = trim($_POST['adrotate_export_format']);
		if(isset($_POST['adrotate_export_addresses'])) $csv_emails = trim($_POST['adrotate_export_addresses']);

		// Sort out start dates
		if(strlen($start_date) > 0) {
			$from_name = $start_date;
			list($start_day, $start_month, $start_year) = explode('-', $start_date);
			$start_date = mktime(0, 0, 0, $start_month, $start_day, $start_year);
		} else {
			$from_name = 'invalid';
			$start_date = 0;
		}

		// Sort out end dates
		if(strlen($end_date) > 0) {
			$until_name = $end_date;
			list($end_day, $end_month, $end_year) = explode('-', $end_date);
			$end_date = mktime(23, 59, 0, $end_month, $end_day, $end_year);
		} else {
			$until_name = 'invalid';
			$end_date = 0;
		}

		// Enddate is too early, reset
		if($end_date <= $start_date) $end_date = $start_date + (30 * DAY_IN_SECONDS); // 30 days

		// Format
		if($format != 'default' AND $format != 'individual') $format = 'default';

		// Email addresses/delivery
		if(strlen($csv_emails) > 0) {
			$csv_emails = explode(',', trim($csv_emails));
			foreach($csv_emails as $csv_email) {
				$csv_email = strip_tags(htmlspecialchars(trim($csv_email), ENT_QUOTES));
				if(strlen($csv_email) > 0) {
					if(preg_match('/^[a-z0-9]+([_\\.-][a-z0-9]+)*@([a-z0-9]+([\.-][a-z0-9]+)*)+\\.[a-z]{2,}$/i', $csv_email) ) {
						$clean_advertiser_email[] = $csv_email;
					}
				}
			}
			$emails = array_unique(array_slice($clean_advertiser_email, 0, 3));
			$emailcount = count($emails);
		} else {
			$emails = array();
			$emailcount = 0;
		}


		$adstats = array(); // Store the result
		$generated = array("Generated on ".date_i18n('M d Y, H:i'));

		if($type == 'single' OR $type == 'group' OR $type == 'global') {
			if($type == 'single') {
				$ads = $wpdb->get_results($wpdb->prepare("SELECT `thetime`, SUM(`clicks`) as `clicks`, SUM(`impressions`) as `impressions` FROM `{$wpdb->prefix}adrotate_stats` WHERE `thetime` >= %d AND `thetime` <= %d AND `ad` = %d GROUP BY `thetime` ORDER BY `thetime` ASC;", $start_date, $end_date, $id), ARRAY_A);
				$title = $wpdb->get_var($wpdb->prepare("SELECT `title` FROM `{$wpdb->prefix}adrotate` WHERE `id` = %d;", $id));

				$filename = "AdRotate_advert_ID_".$id."_".$from_name."_".$until_name.".csv";
				$topic = array("Report for ad '".$title."'");
				$period = array("Period - From: ".$from_name." Until: ".$until_name);
				$keys = array("Day", "Impressions", "Clicks");
			}

			if($type == 'group') {
				$title = $wpdb->get_var($wpdb->prepare("SELECT `name` FROM `{$wpdb->prefix}adrotate_groups` WHERE `id` = %d;", $id));
				$filename = "AdRotate_group_ID_".$id."_".$from_name."_".$until_name.".csv";
				$topic = array("Report for group '".$title."'");
				$period = array("Period - From: ".$from_name." Until: ".$until_name);

				if($format == 'individual') {
					$ads = $wpdb->get_results($wpdb->prepare("SELECT `ad`, `title`, SUM(`clicks`) as `clicks`, SUM(`impressions`) as `impressions` FROM `{$wpdb->prefix}adrotate_stats`, `{$wpdb->prefix}adrotate` WHERE `ad` = `{$wpdb->prefix}adrotate`.`id` AND `{$wpdb->prefix}adrotate_stats`.`thetime` >= %d AND `{$wpdb->prefix}adrotate_stats`.`thetime` <= %d AND `group` = %d GROUP BY `ad` ORDER BY `ad` ASC;", $start_date, $end_date, $id), ARRAY_A);

					$keys = array("Advert", "Advert ID", "Impressions", "Clicks");
				} else {
					$ads = $wpdb->get_results($wpdb->prepare("SELECT `thetime`, SUM(`clicks`) as `clicks`, SUM(`impressions`) as `impressions` FROM `{$wpdb->prefix}adrotate_stats` WHERE `thetime` >= %d AND `thetime` <= %d AND  `group` = %d GROUP BY `thetime` ORDER BY `thetime` ASC;", $start_date, $end_date, $id), ARRAY_A);

					$keys = array("Day", "Impressions", "Clicks");
				}
			}

			if($type == 'global') {
				$filename = "AdRotate_stats_".$from_name."_".$until_name.".csv";
				$topic = array("Global report");
				$period = array("Period - From: ".$from_name." Until: ".$until_name);

				if($format == 'individual') {
					$ads = $wpdb->get_results($wpdb->prepare("SELECT `ad`, `title`, SUM(`clicks`) as `clicks`, SUM(`impressions`) as `impressions` FROM `{$wpdb->prefix}adrotate_stats`, `{$wpdb->prefix}adrotate` WHERE `ad` = `{$wpdb->prefix}adrotate`.`id` AND `{$wpdb->prefix}adrotate_stats`.`thetime` >= %d AND `{$wpdb->prefix}adrotate_stats`.`thetime` <= %d GROUP BY `ad` ORDER BY `ad` ASC;", $start_date, $end_date), ARRAY_A);

					$keys = array("Advert", "Advert ID", "Impressions", "Clicks");
				} else {
					$ads = $wpdb->get_results($wpdb->prepare("SELECT `thetime`, SUM(`clicks`) as `clicks`, SUM(`impressions`) as `impressions` FROM `{$wpdb->prefix}adrotate_stats` WHERE `thetime` >= %d AND `thetime` <= %d GROUP BY `thetime` ORDER BY `thetime` ASC;", $start_date, $end_date), ARRAY_A);

					$keys = array("Day", "Impressions", "Clicks");
				}
			}


			if($format == 'individual') {
				$x = 0;
				foreach($ads as $ad) {
					// Prevent gaps in display
					if(empty($ad['impressions'])) $ad['impressions'] = 0;
					if(empty($ad['clicks'])) $ad['clicks'] = 0;

					// Build array
					$adstats[$x]['name'] = stripslashes(htmlspecialchars_decode($ad['title']));
					$adstats[$x]['id'] = $ad['ad'];
					$adstats[$x]['impressions'] = $ad['impressions'];
					$adstats[$x]['clicks'] = $ad['clicks'];
					$x++;
				}
			} else {
				$x = 0;
				foreach($ads as $ad) {
					// Prevent gaps in display
					if(empty($ad['impressions'])) $ad['impressions'] = 0;
					if(empty($ad['clicks'])) $ad['clicks'] = 0;

					// Build array
					$adstats[$x]['day']	= date_i18n("M d Y", $ad['thetime']);
					$adstats[$x]['impressions'] = $ad['impressions'];
					$adstats[$x]['clicks'] = $ad['clicks'];
					$x++;
				}
			}
		}

		if($type == 'advertiser') { // Global advertiser stats
			$ads = $wpdb->get_results($wpdb->prepare("SELECT `ad` FROM `{$wpdb->prefix}adrotate_linkmeta` WHERE `group` = 0 AND `user` = %d ORDER BY `ad` ASC;", $id));

			$x=0;
			foreach($ads as $ad) {
				$title = $wpdb->get_var("SELECT `title` FROM `{$wpdb->prefix}adrotate` WHERE `id` = '{$ad->ad}';");
				$startshow = $wpdb->get_var("SELECT `starttime` FROM `{$wpdb->prefix}adrotate_schedule`, `{$wpdb->prefix}adrotate_linkmeta` WHERE `ad` = '{$ad->ad}' AND `schedule` = `{$wpdb->prefix}adrotate_schedule`.`id` ORDER BY `starttime` ASC LIMIT 1;");
				$endshow = $wpdb->get_var("SELECT `stoptime` FROM `{$wpdb->prefix}adrotate_schedule`, `{$wpdb->prefix}adrotate_linkmeta` WHERE `ad` = '{$ad->ad}' AND  `schedule` = `{$wpdb->prefix}adrotate_schedule`.`id` ORDER BY `stoptime` DESC LIMIT 1;");
				$username = $wpdb->get_var($wpdb->prepare("SELECT `display_name` FROM `$wpdb->users`, `{$wpdb->prefix}adrotate_linkmeta` WHERE `$wpdb->users`.`ID` = `user` AND `ad` = %d;", $id));

				$startshow = (is_null($startshow)) ? 0 : $startshow;
				$endshow = (is_null($endshow)) ? 0 : $endshow;
				$stat = adrotate_stats($ad->ad);

				// Prevent gaps in display
				if($stat['impressions'] == 0 OR $stat['clicks'] == 0) {
					$ctr = "0";
				} else {
					$ctr = round((100/$stat['impressions']) * $stat['clicks'],2);
				}

				// Build array
				$adstats[$x]['title'] = $title;
				$adstats[$x]['id'] = $ad->ad;
				$adstats[$x]['startshow'] = date_i18n('M d Y', $startshow);
				$adstats[$x]['endshow']	= date_i18n('M d Y', $endshow);
				$adstats[$x]['impressions']	= $stat['impressions'];
				$adstats[$x]['clicks'] = $stat['clicks'];
				$adstats[$x]['ctr']	= $ctr;
				$x++;
			}

			$filename = "AdRotate_advertiser_".$username.".csv";
			$topic = array("Advertiser report for ".$username);
			$period = array("Period - Not Applicable");
			$keys = array("Title", "Ad ID", "First visibility", "Last visibility", "Clicks", "Impressions", "CTR (%)");
		}

		if($type == 'advertiser-single') { // Single advertiser stats
			$ads = $wpdb->get_results($wpdb->prepare("SELECT `thetime`, SUM(`clicks`) as `clicks`, SUM(`impressions`) as `impressions` FROM `{$wpdb->prefix}adrotate_stats` WHERE (`thetime` >= '{$from}' AND `thetime` <= '{$until}') AND `ad` = %d GROUP BY `thetime` ORDER BY `thetime` ASC;", $id), ARRAY_A);
			$title = $wpdb->get_var($wpdb->prepare("SELECT `title` FROM `{$wpdb->prefix}adrotate` WHERE `id` = %d;", $id));
			$username = $wpdb->get_var($wpdb->prepare("SELECT `display_name` FROM `$wpdb->users`, `{$wpdb->prefix}adrotate_linkmeta` WHERE `$wpdb->users`.`ID` = `user` AND `ad` = %d;", $id));

			$filename = "AdRotate_stats_advert_ID_".$id."_".$from_name."_".$until_name.".csv";
			$topic = array("Advertiser report for ".$username." for ad '".$title."'");
			$period = array("Period - From: ".$from_name." Until: ".$until_name);
			$keys = array("Day", "Impressions", "Clicks");

			$x=0;
			foreach($ads as $ad) {
				// Prevent gaps in display
				if(empty($ad['impressions'])) $ad['impressions'] = 0;
				if(empty($ad['clicks'])) $ad['clicks'] = 0;

				// Build array
				$adstats[$x]['day']	= date_i18n('M d Y', $ad['thetime']);
				$adstats[$x]['impressions'] = $ad['impressions'];
				$adstats[$x]['clicks'] = $ad['clicks'];
				$x++;
			}
		}

		if($adstats) {
			if(!file_exists(WP_CONTENT_DIR . '/'.$adrotate_config['report_folder'].'/')) mkdir(WP_CONTENT_DIR . '/'.$adrotate_config['report_folder'].'/', 0755);
			$fp = fopen(WP_CONTENT_DIR . '/'.$adrotate_config['report_folder'].'/'.$filename, 'w');

			if($fp) {
				fputcsv($fp, $topic);
				fputcsv($fp, $period);
				fputcsv($fp, $generated);
				fputcsv($fp, $keys);
				foreach($adstats as $stat) {
					fputcsv($fp, $stat);
				}

				fclose($fp);

				if($emailcount > 0) {
					$attachments = array(WP_CONTENT_DIR . '/'.$adrotate_config['report_folder'].'/'.$filename);
					$siteurl 	= get_option('siteurl');
					$email 		= get_option('admin_email');

				    $headers = "MIME-Version: 1.0\r\n" .
		    					"From: AdRotate Plugin <".$email.">\r\n" .
		    					"Content-Type: text/html; charset=\"" . get_option('blog_charset') . "\"\r\n";

					$subject = esc_html__("[AdRotate] CSV Report!", 'adrotate-pro');

					$message = 	"<p>".esc_html__("Hello", 'adrotate-pro').",</p>";
					$message .= "<p>".esc_html__("Attached in this email you will find the exported CSV file you generated on ", 'adrotate-pro')." $siteurl.</p>";
					$message .= "<p>".esc_html__("Have a nice day!", 'adrotate-pro')."<br />";
					$message .= esc_html__("Your AdRotate Notifier", 'adrotate-pro')."<br />";
					$message .= "https://ajdg.solutions/</p>";

					wp_mail($emails, $subject, $message, $headers, $attachments);

					if($type == 'single') wp_redirect('admin.php?page=adrotate-statistics&status=212&view=advert&id='.$id);
					if($type == 'group') wp_redirect('admin.php?page=adrotate-statistics&status=212&view=group&id='.$id);
					if($type == 'global') wp_redirect('admin.php?page=adrotate-statistics&status=212');
					if($type == 'advertiser') wp_redirect('admin.php?page=adrotate-advertiser&status=303');
					if($type == 'advertiser-single') wp_redirect('admin.php?page=adrotate-advertiser&status=303&view=report&ad='.$id);
					exit;
				}
				if($type == 'single') wp_redirect('admin.php?page=adrotate-statistics&status=215&view=advert&id='.$id.'&file='.$filename);
				if($type == 'group') wp_redirect('admin.php?page=adrotate-statistics&status=215&view=group&id='.$id.'&file='.$filename);
				if($type == 'global') wp_redirect('admin.php?page=adrotate-statistics&status=215&file='.$filename);
				if($type == 'advertiser') wp_redirect('admin.php?page=adrotate-advertiser&status=215&file='.$filename);
				if($type == 'advertiser-single') wp_redirect('admin.php?page=adrotate-advertiser&status=215&view=report&ad='.$id.'&file='.$filename);
				exit;
			} else {
				if($type == 'single') wp_redirect('admin.php?page=adrotate-statistics&status=507&view=advert&id='.$id);
				if($type == 'group') wp_redirect('admin.php?page=adrotate-statistics&status=507&view=group&id='.$id);
				if($type == 'global') wp_redirect('admin.php?page=adrotate-statistics&status=507');
				if($type == 'advertiser') wp_redirect('admin.php?page=adrotate-advertiser&status=507');
				if($type == 'advertiser-single') wp_redirect('admin.php?page=adrotate-advertiser&status=507&view=report&ad='.$id);
				exit;
			}
		} else {
			if($type == 'single') wp_redirect('admin.php?page=adrotate-statistics&status=503&view=advert&id='.$id);
			if($type == 'group') wp_redirect('admin.php?page=adrotate-statistics&status=503&view=group&id='.$id);
			if($type == 'global') wp_redirect('admin.php?page=adrotate-statistics&status=503');
			if($type == 'advertiser') wp_redirect('admin.php?page=adrotate-advertiser&status=503');
			if($type == 'advertiser-single') wp_redirect('admin.php?page=adrotate-advertiser&status=503&view=report&ad='.$id);
			exit;
		}
	} else {
		adrotate_nonce_error();
		exit;
	}
}

/*-------------------------------------------------------------
 Name:      adrotate_export_ads
 Purpose:   Export adverts in various formats
-------------------------------------------------------------*/
function adrotate_export_ads($ids) {
	global $wpdb;

	$where = false;
	if(count($ids) > 1) {
		$where = "`id` = ";
		foreach($ids as $key => $id) {
			$where .= "'{$id}' OR `id` = ";
		}
		$where = rtrim($where, " OR `id` = ");
	}

	if(count($ids) == 1) {
		$where = "`id` = '{$ids[0]}'";
	}

	if($where) {
		$to_export = $wpdb->get_results("SELECT * FROM `{$wpdb->prefix}adrotate` WHERE {$where} ORDER BY `id` ASC;", ARRAY_A);
	}

	$adverts = array();
	$keys = false;
	foreach($to_export as $export) {
		$starttime = $stoptime = 0;

		// Figure out schedule times
		$starttime = $wpdb->get_var("SELECT `starttime` FROM `{$wpdb->prefix}adrotate_schedule`, `{$wpdb->prefix}adrotate_linkmeta` WHERE `ad` = '".$export['id']."' AND `schedule` = `{$wpdb->prefix}adrotate_schedule`.`id` ORDER BY `starttime` ASC LIMIT 1;");
		$stoptime = $wpdb->get_var("SELECT `stoptime` FROM `{$wpdb->prefix}adrotate_schedule`, `{$wpdb->prefix}adrotate_linkmeta` WHERE `ad` = '".$export['id']."' AND  `schedule` = `{$wpdb->prefix}adrotate_schedule`.`id` ORDER BY `stoptime` DESC LIMIT 1;");

		$adverts[$export['id']] = array(
			'id' => $export['id'],
			'title' => $export['title'],
			'bannercode' => stripslashes($export['bannercode']),
			'imagetype' => (empty($export['imagetype'])) ? '' : $export['imagetype'],
			'image' => (empty($export['image'])) ? '' : $export['image'],
			'tracker' => $export['tracker'],
			'show_everyone' => $export['show_everyone'],
			'desktop' => $export['desktop'],
			'mobile' => $export['mobile'],
			'tablet' => $export['tablet'],
			'os_ios' => $export['os_ios'],
			'os_android' => $export['os_android'],
			'weight' => $export['weight'],
			'autodelete' => $export['autodelete'],
			'autodisable' => $export['autodisable'],
			'budget' => $export['budget'],
			'crate' => $export['crate'],
			'irate' => $export['irate'],
			'state_required' => $export['state_req'],
			'cities' => (empty($export['cities'])) ? 'a:0:{}' : $export['cities'],
			'states' => (empty($export['states'])) ? 'a:0:{}' : $export['states'],
			'countries' => (empty($export['countries'])) ? 'a:0:{}' : $export['countries'],
			'schedule_start' => $starttime,
			'schedule_end' => $stoptime
		);
	}

	if(count($adverts) > 0) {
		$filename = "AdRotate_export_adverts_".date_i18n("mdYHis").".csv";
		if(!file_exists(WP_CONTENT_DIR . '/'.$adrotate_config['report_folder'].'/')) mkdir(WP_CONTENT_DIR . '/'.$adrotate_config['report_folder'].'/', 0755);
		$fp = fopen(WP_CONTENT_DIR . '/'.$adrotate_config['report_folder'].'/'.$filename, 'w');

		if($fp) {
			$plugins = get_plugins();
			$plugin_version = $plugins['adrotate-pro/adrotate-pro.php']['Version'];

			$version = array('Version', 'AdRotate Professional', $plugin_version);
			$keys = array('id', 'advert_name', 'bannercode', 'imagetype', 'image_url', 'enable_stats', 'show_everyone', 'show_desktop', 'show_mobile', 'show_tablet', 'show_ios', 'show_android', 'weight', 'autodelete', 'autodisable', 'budget', 'click_rate', 'impression_rate', 'state_required', 'geo_cities', 'geo_states', 'geo_countries', 'schedule_start', 'schedule_end');

			fputcsv($fp, $version);
			fputcsv($fp, $keys);
			foreach($adverts as $advert) {
				fputcsv($fp, $advert);
			}

			fclose($fp);

			wp_redirect('admin.php?page=adrotate&status=215&file='.$filename);
			exit;
		}
	} else {
		wp_redirect('admin.php?page=adrotate&status=509');
		exit;
	}
}

/*-------------------------------------------------------------
 Name:      adrotate_import_ads
 Purpose:   Import adverts from file
-------------------------------------------------------------*/
function adrotate_import_ads() {
	global $wpdb, $current_user, $userdata;

	if(wp_verify_nonce($_POST['adrotate_nonce_tools'], 'adrotate_import')) {
		if(current_user_can('adrotate_ad_manage')) {
			if($_FILES['adrotate_file']['error'] == 4) {
				wp_redirect('admin.php?page=adrotate&view=import&status=506');
				exit;
			} else if ($_FILES['adrotate_file']['error'] > 0) {
				wp_redirect('admin.php?page=adrotate&view=import&status=507');
				exit;
			} else if($_FILES['adrotate_file']['size'] > 8192000) {
				wp_redirect('admin.php?page=adrotate&view=import&status=511');
				exit;
			} else {
				$now = current_time('timestamp');
				$ninetydays = $now + (90 * 86400);

				if($_FILES['adrotate_file']['type'] == 'text/csv') {
					// Load the uploaded file
					$csv_name = $_FILES['adrotate_file']['tmp_name'];
					$rows = array_map('str_getcsv', file($csv_name));

					// Figure out the plugin version that generated the file, assume 0 if custom made
					$version = array_shift($rows);
					$version = (strtolower($version[1]) == 'adrotate professional') ? $version[2] : 0;

					// Array keys
					$header = array_shift($rows);

					// Basic check if the file is compatible
					if($version === 0 OR version_compare($version, "5.24", ">=")) {
						// Go through all ads and insert into the database
						foreach ($rows as $row) {
							$advert = array_combine($header, $row);

							$wpdb->insert($wpdb->prefix.'adrotate', array(
								'title' => (!empty($advert['advert_name'])) ? $advert['advert_name'] : 'Advert '.$advert['id'],
								'bannercode' => (!empty($advert['bannercode'])) ? $advert['bannercode'] : '',
								'thetime' => $now,
								'updated' => $now,
								'author' => $current_user->user_login,
								'imagetype' => ($advert['imagetype'] == 'image' OR $advert['imagetype'] == 'dropdown') ? $advert['imagetype'] : '',
								'image' => (!empty($advert['image_url'])) ? $advert['image_url'] : '',
								'tracker' => ($advert['enable_stats'] == 'Y' OR $advert['enable_stats'] == 'N' OR $advert['enable_stats'] == 'C' OR $advert['enable_stats'] == 'I') ? $advert['enable_stats'] : 'N',
								'show_everyone' => ($advert['show_everyone'] == 'Y' OR $advert['show_everyone'] == 'N') ? $advert['show_everyone'] : 'Y',
								'desktop' => ($advert['show_desktop'] == 'Y' OR $advert['show_desktop'] == 'N') ? $advert['show_desktop'] : 'Y',
								'mobile' => ($advert['show_mobile'] == 'Y' OR $advert['show_mobile'] == 'N') ? $advert['show_mobile'] : 'Y',
								'tablet' => ($advert['show_tablet'] == 'Y' OR $advert['show_tablet'] == 'N') ? $advert['show_tablet'] : 'Y',
								'os_ios' => ($advert['show_ios'] == 'Y' OR $advert['show_ios'] == 'N') ? $advert['show_ios'] : 'Y',
								'os_android' => ($advert['show_android'] == 'Y' OR $advert['show_android'] == 'N') ? $advert['show_android'] : 'Y',
								'type' => 'import',
								'weight' => (is_numeric($advert['weight'])) ? $advert['weight'] : 6,
								'autodelete' => ($advert['autodelete'] == 'Y' OR $advert['autodelete'] == 'N') ? $advert['autodelete'] : 'N',
								'autodisable' => ($advert['autodisable'] == 'Y' OR $advert['autodisable'] == 'N') ? $advert['autodisable'] : 'N',
								'budget' => (is_numeric($advert['budget'])) ? $advert['budget'] : 0,
								'crate' => (is_numeric($advert['click_rate'])) ? $advert['click_rate'] : 0,
								'irate' => (is_numeric($advert['impression_rate'])) ? $advert['impression_rate'] : 0,
								'state_req' => ($advert['state_required'] == 'Y' OR $advert['state_required'] == 'N') ? $advert['state_required'] : 'N',
								'cities' => (!empty($advert['geo_cities'])) ? $advert['geo_cities'] : 'a:0:{}',
								'states' => (!empty($advert['geo_states'])) ? $advert['geo_states'] : 'a:0:{}',
								'countries' => (!empty($advert['geo_countries'])) ? $advert['geo_countries'] : 'a:0:{}',
							));
							$new_advert_id = $wpdb->insert_id;

							// Add a schedule
							$wpdb->insert($wpdb->prefix.'adrotate_schedule', array(
								'name' => 'Schedule for advert '.$new_advert_id,
								'starttime' => (is_numeric($advert['schedule_start'])) ? $advert['schedule_start'] : $now,
								'stoptime' => (is_numeric($advert['schedule_end'])) ? $advert['schedule_end'] : $ninetydays,
								'maxclicks' => 0,
								'maximpressions' => 0,
								'spread' => 'N',
								'spread_all' => 'N',
								'daystarttime' => '0000',
								'daystoptime' => '0000',
								'day_mon' => 'Y',
								'day_tue' => 'Y',
								'day_wed' => 'Y',
								'day_thu' => 'Y',
								'day_fri' => 'Y',
								'day_sat' => 'Y',
								'day_sun' => 'Y',
								'autodelete' => 'N',
							));
							$new_schedule_id = $wpdb->insert_id;

							// Link schedule and advert
							$wpdb->insert($wpdb->prefix.'adrotate_linkmeta', array(
								'ad' => $new_advert_id,
								'group' => 0,
								'user' => 0,
								'schedule' => $new_schedule_id,
							));

							unset($row, $advert, $new_advert_id, $new_schedule_id);
						}
					} else {
						// Nope, not compatble, return to dashboard
						unset($header, $version, $rows);
						unlink($csv_name);
						wp_redirect('admin.php?page=adrotate&view=import&status=225');
					}

					// Clean up
					unset($header, $version, $rows);
					unlink($csv_name);
				}

				// Verify all ads
				adrotate_evaluate_ads();

				// return to dashboard
				wp_redirect('admin.php?page=adrotate&view=import&status=216');
				exit;
			}
		} else {
			wp_redirect('admin.php?page=adrotate&view=import&status=500');
			exit;
		}
	} else {
		adrotate_nonce_error();
		exit;
	}
}

/*-------------------------------------------------------------
 Name:      adrotate_portable_hash
 Purpose:   Export/import adverts via a portable hash
-------------------------------------------------------------*/
function adrotate_portable_hash($action, $data, $what = 'advert') {
	$source = get_option('siteurl');

	if(in_array("aes-128-cbc", openssl_get_cipher_methods())) {

		$allowed_columns = array('title', 'bannercode', 'thetime', 'author', 'imagetype', 'image', 'tracker', 'show_everyone', 'desktop', 'mobile', 'tablet', 'os_ios', 'os_android', 'weight', 'autodelete', 'autodisable', 'budget', 'crate', 'irate', 'state_req', 'cities', 'states', 'countries');

		$advert = array();

		if($action == 'export') {
			$portable_hash = array('meta' => array('type' => $what, 'source' => $source, 'exported' => current_time('timestamp')), 'data' => array());

			// Basic formatting and checks
			foreach($data as $column => $value) {
				if(in_array($column, $allowed_columns)) {
					if(empty($value) AND ($column == 'cities' OR $column == 'states' OR $column == 'countries')) $value = "a:0:{}";

					if(!empty($value)) {
						$advert[$column] = trim($value);
					}
				}
			}

			$portable_hash['data'] = $advert;
			$portable_hash = serialize($portable_hash);

			return openssl_encrypt($portable_hash, 'aes-128-cbc', '983jdnn3idjk02id', false, 'oi1u23kj123hj7jd');
	    }

		if($action == 'import') {
			$data = openssl_decrypt($data, 'aes-128-cbc', '983jdnn3idjk02id', false, 'oi1u23kj123hj7jd');
			$data = unserialize($data);

			if(is_array($data)) {
				if(array_key_exists('meta', $data) AND array_key_exists('data', $data)) {
					if($data['meta']['type'] == 'advert' AND $source != $data['meta']['source']) {
						// Basic formatting and checks
						foreach($data['data'] as $column => $value) {
							if(in_array($column, $allowed_columns)) {
								if(empty($value) AND ($column == 'cities' OR $column == 'states' OR $column == 'countries')) $value = "a:0:{}";

								if(!empty($value)) {
									$advert[$column] = trim($value);
								}
							}
						}

						// Add a modified time
						$advert['updated'] = current_time("timestamp");

						return $advert;
					} else if($data['meta']['type'] == 'group') {
						// maybe
					} else if($data['meta']['type'] == 'schedule') {
						// maybe
					} else {
						adrotate_return('adrotate', 514);
					}
				}
			}
			adrotate_return('adrotate', 513);
	    }

	}
}
?>
