<?php
/* ------------------------------------------------------------------------------------
*  COPYRIGHT AND TRADEMARK NOTICE
*  Copyright 2008-2026 Arnan de Gans. All Rights Reserved.
*  The software AdRotate, related services and ADROTATE the name are owned by Arnan de Gans.

*  COPYRIGHT NOTICES AND ALL THE COMMENTS SHOULD REMAIN INTACT.
*  By using this code you agree to indemnify Arnan de Gans from any
*  liability that might arise from its use.
------------------------------------------------------------------------------------ */

/*-------------------------------------------------------------
 Name:      adrotate_get_stats
 Purpose:   Quick check for the latest number of clicks and impressions
-------------------------------------------------------------*/
function adrotate_get_stats($ad_id, $when = 0, $until = 0) {
	global $wpdb;

	$stats = $wpdb->get_row("SELECT SUM(`clicks`) as `clicks`, SUM(`impressions`) as `impressions` FROM `{$wpdb->prefix}adrotate_stats` WHERE `ad` = {$ad_id} AND `thetime` >= {$when} AND `thetime` <= {$until};", ARRAY_A);

	if(empty($stats['clicks'])) $stats['clicks'] = 0;
	if(empty($stats['impressions'])) $stats['impressions'] = 0;

	return $stats;
}

/*-------------------------------------------------------------
 Name:      adrotate_date_start
 Purpose:   Get and return the localized UNIX time for the current hour, day and start of the week
-------------------------------------------------------------*/
function adrotate_date_start($what) {
	$now = current_time('timestamp');
	$string = gmdate('Y-m-d H:i:s', time());
	$timezone = get_option('timezone_string');
	preg_match('#([0-9]{1,4})-([0-9]{1,2})-([0-9]{1,2}) ([0-9]{1,2}):([0-9]{1,2}):([0-9]{1,2})#', $string, $matches);

	switch($what) {
		case 'hour' :
			$string_time = gmmktime($matches[4], 0, 0, $matches[2], $matches[3], $matches[1]);
			$result = gmdate('U', $string_time + (get_option('gmt_offset') * 3600));
		break;
		case 'day' :
			$result = gmdate('U', gmmktime(0, 0, 0, gmdate('n'), gmdate('j')));

			if($timezone) {
				$result = strtotime('00:00:00') + (get_option('gmt_offset') * 3600);
			}
		break;
		case 'week' :
			$result = gmdate('U', gmmktime(0, 0, 0));

			if($timezone) {
				$result = strtotime('Last Monday', $now) + (get_option('gmt_offset') * 3600);
			}
		break;
	}

	return $result;
}

/*-------------------------------------------------------------
 Name:      adrotate_count_impression
 Purpose:   Count Impressions where needed
-------------------------------------------------------------*/
function adrotate_count_impression($ad_id, $group_id = 0) {
	global $wpdb, $adrotate_config;

	if(($adrotate_config['enable_loggedin_impressions'] == 'Y' AND is_user_logged_in()) OR ($adrotate_config['enable_admin_stats'] == 'Y' AND is_admin()) OR !is_user_logged_in()) {
		$now = current_time('timestamp');
		$today = adrotate_date_start('day');
		$remote_ip 	= adrotate_get_remote_ip();

		if(adrotate_is_human() AND $remote_ip != 'unknown' AND !empty($remote_ip)) {
			$impression_timer = $now - $adrotate_config['impression_timer'];
			$saved_timer = $wpdb->get_var($wpdb->prepare("SELECT `timer` FROM `{$wpdb->prefix}adrotate_tracker` WHERE `ipaddress` = '%s' AND `stat` = 'i' AND `bannerid` = %d ORDER BY `timer` DESC LIMIT 1;", $remote_ip, $ad_id));

			if($saved_timer < $impression_timer) {
				$stats = $wpdb->get_var($wpdb->prepare("SELECT `id` FROM `{$wpdb->prefix}adrotate_stats` WHERE `ad` = %d AND `group` = %d AND `thetime` = {$today};", $ad_id, $group_id));
				if($stats > 0) {
					$wpdb->query("UPDATE `{$wpdb->prefix}adrotate_stats` SET `impressions` = `impressions` + 1 WHERE `id` = {$stats};");
				} else {
					$wpdb->insert($wpdb->prefix.'adrotate_stats', array('ad' => $ad_id, 'group' => $group_id, 'thetime' => $today, 'clicks' => 0, 'impressions' => 1));
				}

				$wpdb->insert($wpdb->prefix."adrotate_tracker", array('ipaddress' => $remote_ip, 'timer' => $now, 'bannerid' => $ad_id, 'stat' => 'i'));
			}
		}
	}
}

/*-------------------------------------------------------------
 Name:      adrotate_impression_callback
 Purpose:   Register a impression for dynamic groups
-------------------------------------------------------------*/
function adrotate_impression_callback() {
	if(!defined('DONOTCACHEPAGE')) define('DONOTCACHEPAGE', true);
	if(!defined('DONOTCACHEDB')) define('DONOTCACHEDB', true);
	if(!defined('DONOTCACHEOBJECT')) define('DONOTCACHEOBJECT', true);

	$meta = $_POST['track'];
	$meta = base64_decode($meta);

	$meta = esc_attr($meta);
	// Don't use $impression_timer - It's for impressions used in javascript
	list($ad_id, $group_id, $impression_timer) = explode(',', $meta, 3);
	if(is_numeric($ad_id) AND is_numeric($group_id)) {
		adrotate_count_impression($ad_id, $group_id);
	}

	die();
}

/*-------------------------------------------------------------
 Name:      adrotate_count_click
 Purpose:   Count Clicks where needed
-------------------------------------------------------------*/
function adrotate_count_click($ad_id, $group_id = 0) {
	global $wpdb, $adrotate_config;

	if(($adrotate_config['enable_loggedin_clicks'] == 'Y' AND is_user_logged_in()) OR ($adrotate_config['enable_admin_stats'] == 'Y' AND is_admin()) OR !is_user_logged_in()) {
		$now = current_time('timestamp');
		$today = adrotate_date_start('day');
		$remote_ip = adrotate_get_remote_ip();

		if(adrotate_is_human() AND $remote_ip != 'unknown' AND !empty($remote_ip)) {
			$click_timer = $now - $adrotate_config['click_timer'];
			$saved_timer = $wpdb->get_var($wpdb->prepare("SELECT `timer` FROM `{$wpdb->prefix}adrotate_tracker` WHERE `ipaddress` = '%s' AND `stat` = 'c' AND `bannerid` = %d ORDER BY `timer` DESC LIMIT 1;", $remote_ip, $ad_id));

			if($saved_timer < $click_timer) {
				$stats = $wpdb->get_var($wpdb->prepare("SELECT `id` FROM `{$wpdb->prefix}adrotate_stats` WHERE `ad` = %d AND `group` = %d AND `thetime` = {$today};", $ad_id, $group_id));
				if($stats > 0) {
					$wpdb->query("UPDATE `{$wpdb->prefix}adrotate_stats` SET `clicks` = `clicks` + 1 WHERE `id` = {$stats};");
				} else {
					$wpdb->insert($wpdb->prefix.'adrotate_stats', array('ad' => $ad_id, 'group' => $group_id, 'thetime' => $today, 'clicks' => 1, 'impressions' => 1));
				}

				$wpdb->insert($wpdb->prefix.'adrotate_tracker', array('ipaddress' => $remote_ip, 'timer' => $now, 'bannerid' => $ad_id, 'stat' => 'c'));
			}

			// Advertising budget
			$wpdb->query("UPDATE `{$wpdb->prefix}adrotate` SET `budget` = `budget` - `crate` WHERE `id` = {$ad_id} AND `crate` > 0;");
		}
	}

	unset($remote_ip, $track, $meta, $ad_id, $group_id, $remote, $banner);
}

/*-------------------------------------------------------------
 Name:      adrotate_click_callback
 Purpose:   Register clicks for clicktracking (Dynamic group or otherwise)
-------------------------------------------------------------*/
function adrotate_click_callback() {
	if(!defined('DONOTCACHEPAGE')) define('DONOTCACHEPAGE', true);
	if(!defined('DONOTCACHEDB')) define('DONOTCACHEDB', true);
	if(!defined('DONOTCACHEOBJECT')) define('DONOTCACHEOBJECT', true);

	$meta = $_POST['track'];
	$meta = base64_decode($meta);

	$meta = esc_attr($meta);
	// Don't use $impression_timer - It's for impressions used in javascript
	list($ad_id, $group_id, $impression_timer) = explode(',', $meta, 3);

	if(is_numeric($ad_id) AND is_numeric($group_id)) {
		adrotate_count_click($ad_id, $group_id);
	}

	die();
}
?>
