# AdRotate Pro changelog

## 5.27 - February 06, 2026
* Update - Correct support link in ticket support banner
* Update - Expanded support content to include if GooseUp is installed
* Change - Improved RSS feed display
* Removed - Built-in update function
* Fix - Google Tag Manager setting/selection not working
* Fix - Double spaces in Manage Adverts navigation
* Fix - Adblock disguise string not saving

## 5.26.2 - January 14, 2026
* Fix - More reliable way of checking if GooseUp is active

## 5.26.1 - January 4, 2026
* Fix - Several PHP Warnings in the dashboard if no license was ever activated
* Fix - Incorrect use of $adrotate_config when activating the plugin for the first time
* New - Support for the GooseUp Update Plugin
* Change - Make 'force de-activating' a license more accessible

## 5.26 - December 11, 2025
* New - Reports folder can now be moved/renamed just like Banners folder can
* Security - Check if reports folder has a blank html file for hiding files
* Fix - Schedules created through Edit Advert now assume the adverts name
* Fix - Better check if banners and reports folder exist
* Change - Internal RSS feed fetcher for one url at a time

## 5.25.1 - December 2, 2025
* Update - Removed old/obsolete geo targeting code for Telize and GeoBytes
* Fix - Missing $visitor_ip for sessions

## 5.25 - November 28, 2025
* Update - Dashboard now works better on smaller devices (responsive)
* Update - All advert settings now included in CSV exports
* Update - All new import/export routines for CSV files
* Update - Improved portability hash generation
* Update - All dashboard settings pages refreshed
* Update - Much improved sanitization for dashboard inputs
* Update - Support dashboard page refreshed
* Update - Removed unused CSS from dashboard.css
* New - All new import adverts dashboard
* Change - Import adverts is now located in the Manage Adverts dashboard
* Fix - Auto disabling of ads not working
* Fix - Non-existent/new sessions no longer give a deprecated warning

## 5.24.1 - November 24, 2025
* Update - Database version parity with AdRotate Banner Manager

## 5.24 - November 5, 2025
* Performance - Removed GROUP BY statements from a few common stats queries
* Performance - Removed '' (apostrophes) from integer values in a few queries
* Performance - Removed column labels from get_var queries
* Performance - Added better PREPARE instructions for some queries
* Performance - Added missing ; (semicolons) in a few queries
* Performance - Added faster INDEX for stats and stats_archive tables
* Change - Database version 75
* Change - Moved action links to plugin meta text
* Fix - Widget title no longer converts to a slug
* Update - Support dashboard page
* Update - AdRotate Pro dashboard page
* Update - Notification texts
* Update - Block code
* Removed - Experimental Goosecache code/references

## 5.23.3 - October 19, 2025
* Fix - Removed unreliable/broken WordPress redirect when activating the plugin
* Fix - Improved error handling for dashboard notifications
* Fix - Improved error handling for failed license (de)activation
* Update - AJdG Updates 1.8.7

## 5.23.2 - September 19, 2025
* Fix - Default value for zindex not correctly set
* Fix - Missing license expiry date in update check
* Fix - Missing columns when duplicating ads and groups
* Fix - Handling of API errors for Geo Targeting
* Update - Much improved sorting option for all tables and applicable columns
* Update - Added a few more sortable columns
* Update - Tablesorter 2.0.5b
* Update - Activation/de-activation/uninstall routine

## 5.23.1 - August 22, 2025
* Fix - Output warning when activating the plugin for the first time
* Update - License API to version 1.8.6
* Update - Update API to version 2.1

## 5.23 - August 13, 2025
* Performance - No more redundant queries when using any Manage Adverts dashboard
* Performance - More specific queries for loading the various Manage Adverts dashboards
* Performance - Code cleanup for group editing
* Performance - No longer checks with wordpress.org for updates
* Change - Reworked the Manage Adverts loading code for a massive speed increase on larger sites
* Change - Reworked the Manage Groups loading code for more uniform code
* Change - Reworked the Manage Schedule loading code for more uniform code
* Fix - Selected ads not visible when editing groups
* Fix - Removed remaining multisite $site values causing warnings
* Fix - Removed remaining multisite site values from stats causing issues
* Fix - License management de-activating a license twice now gives appropriate response
* Fix - License management error reporting for invalid email used
* Fix - License management error reporting for invalid license key
* Fix - AdRotate Geo error reporting
* Removed - Unused goosebox.js file

## 5.22 - August 8, 2025
* New - Option to auto-disable expired adverts
* update - Start and end dates for ads now separate columns in the various dashboards
* update - Improved compatibility with AJdG API
* update - Improved IP Address detection
* update - License activation now stores license creation date
* update - Simplified de-activation code
* update - Simplified uninstall code
* update - Set sslverify to true for AdRotate Geo lookups
* removed - Server response indicator from Maintenance dashboard
* removed - Birthday banner
* removed - Review banner
* removed - Multisite dashboard
* removed - Cross-site ads support
* i18n - Updated Dutch translation
* i18n - Deleted wrongly translated strings from translations

## 5.21 - Jun 12, 2025
* fix - AdRotate Geo response not processed properly
* update - Better formatted update requests
* update - Code formatting for remote requests
* update - Updated for new AJdG API (Licenses)

## 5.20 - Jun 7, 2025
* update - Updated for new AJdG API (Updates)
* update - Updated for new AJdG API (Geo Targeting)
* fix - XSS security flaw when saving widgets
* update - Improved widget saving code and formatting

## 5.19.1 - March 5, 2025
* fix - Adcode not properly prepared for output

## 5.19 - March 4, 2025
* new - Lite license
* new - Group mode for wallpaper ads (Experimental)
* new - Setting for Wallpaper ads Z-Index in Misc
* update - Dashboard tweaks
* update - Pot file for translations
* security - Escaped all translation output with WordPress functions

## 5.18.1 - December 16, 2024
* fix - Better formatted ads.txt file
* change - Update routine no longer only works inside the dashboard

## 5.18 - November 18, 2024
* update - Added alt tag for tracking pixel
* update - Updated advert block description
* update - Updated group block description
* fix - Not all relevant files showing in subfolders
* fix - Wrong value for switching blog databases in multisites
* fix - Missing dashboards for multisite instances

## 5.17.2 - October 10, 2024
* fix - Text indicating unfiltered html suggesting the wrong setting
* fix - Wrong variable for clicktracking preventing clicks from recording

## 5.17.1 - October 1, 2024
* update - WordPress media uploader only lists and allows relevant files
* fix - Running multiple bulk actions only doing the first
* fix - Warning when doing bulk actions when no ads selected
* fix - Warning when doing bulk actions when no groups selected
* fix - Warning when doing bulk actions when no schedules selected

## 5.17 - September 12, 2024
* change - Use WordPress native function when uploading files
* change - Use WordPress native function when creating folders
* change - Creating folders checks if folder already exists
* change - Uploading a file checks if file already exists
* new - Duplicate groups from bulk actions
* new - Duplicate schedules from bulk actions
* fix - AdRotate redirects from the queue now go to the right page

## 5.16.3 - July 25, 2024
* fix - Duplicate ads filter hiding adverts when it shouldn't
* fix - AdRotate Geo error data stored in the wrong spot for sessions.

## 5.16.2 - July 13, 2024
* fix - Missing mimetype when uploading banner images
* fix - Unfiltered HTML indicator reversed in Maintenance
* fix - Faulty linebreak output from header code
* fix - Javascript not always loading in the dashboard
* change - More dashboard code moved to load in the dashboard only

## 5.16.1 - July 12, 2024
* fix - Missing _nonce value for database update button
* fix - Filename issue with dynamic groups

## 5.16 - July 11, 2024
* new - Upload webp banner images through the media manager
* new - Reset function for Geo Targeting
* fix - Added missing sortable classes to some dashboard pages
* fix - More reliable midnight lookup reset for Geo Targeting
* fix - Check if an invalid combination of Device and OS is made
* fix - Geo Targeting city/state filter more reliable
* fix - Duplicate ads filter more reliable
* fix - Some cancel buttons not going to the right page
* security - Low level users can no longer upload html/js/zip files
* security - DISALLOW_UNFILTERED_HTML required for Javascript ads
* security - DISALLOW_UNFILTERED_HTML required for header code
* security - DISALLOW_UNFILTERED_HTML required for group wrapper
* change - Separated most dashboard code from the front-end
* change - Replaced $_SESSION with WordPress Transients
* update - Consistent use of single and double-quotes
* tweak - Force certain variables to be strings before saving
* tweak - Better descriptions for Device Type and Mobile OS
* i18n - Added missing and new strings to translations
* removed - Welcome pointer when first activating the plugin

## 5.15.4 - May 22, 2024
* update - Rollback to v1.1 for clicktracker Javascript
* update - Export files now include all current ad features
* removed - Restriction on dynamic groups for ads cycle length
* removed - Restriction to disable dynamic groups on mobile devices
* fix - Better handling of large CSV files for imports
* fix - Better handling of MaxMind error responses
* fix - Removed left over 'other_os' code from export columns
* fix - Better validation of numeric values in export files

## 5.15.3 - April 29, 2024
* tweak - Better check if a session exists and has geo data
* tweak - Better check if a session exists and has duplicate advert ids
* tweak - Removed unused CSS and JS
* update - Now uses License API v1.7

## 5.15.2 - April 15, 2024
* fix - Fixed fatal error for adrotate_header preventing some websites from loading

## 5.15.1 - April 14, 2024
* fix - Removed remaining network widget code causing errors for Network users

## 5.15 - April 11, 2024
* update - Added sortable tables back in
* update - Network dashboard descriptions and labels
* update - Enabled/disabled icons now based on generated svg
* update - Device icons now based on generated svg
* fix - Error when there are no ads while the plugin is network activated
* fix - strlen on null error when no advertiser is set for certain adverts
* fix - debug output above advertiser selection
* fix - Incorrect advertiser settings in Manage Advertiser
* fix - Missing variable in advert dropdown in advertiser contact form
* fix - AdRotate Geo array error when a license error occurs
* i18n - All translations updated with an auto-translator
* removed - Outdated Network Widget (retired in 2023)
* removed - Obsolete Single Advert Widget (retired in 2020)
* removed - Obsolete Group Widget (retired in 2020)
* removed - Obsolete Universal tracker support for Google Analytics
* removed - Conflicting 'Site Dashboard' option in Network Settings

## 5.14.4 - February 13, 2024
* change - No longer requires jQuery for clicktracker
* change - No longer lists image files that do not belong to the advertiser
* fix - Wrong variable count when de-activating a license
* fix - Array conversion in PHP8 for advertisers
* fix - Variable names for mobile devices for advertisers
* fix - Missing variable defaults when saving adverts
* fix - Stats graph not rendering for advertisers

## 5.14.3 - January 2, 2024
* fix - Better check if MobileDetect is already loaded
* fix - Better check if stats are enabled in groups
* fix - Better check if stats are enabled in schedules
* fix - Better check if stats are enabled in disabled ads
* fix - Column count for Manage dashboards when stats are on or off

## 5.14.2 - December 8, 2023
* fix - Block groups showing adverts more than once
* fix - Dynamic groups not always hiding first advert
* change - Improved PHP 8 compatibility

## 5.14 & 5.14.1 - December 5, 2023
* fix - Duplicate ads filter not working for all adverts
* fix - Weight filter not working properly for some groups
* new - Blocks now support fragmented cache
* new - Generate video ads with Advert Generator (experimental)
* new - Option to select a multisite group when editing groups
* fix - Removed periods/dots from widgets
* fix - Added default status when Geo Targeting is disabled
* fix - Groups no longer redundantly switch instances for multisites
* fix - Hide group size in Manage Groups if it's set to 'auto'
* fix - 'Auto delete' not as bold text in Manage Adverts
* change - Reworked operating system selection for mobile adverts
* change - Reworked group output and made it more efficient
* change - Reworked multisite site switch, use dashboard option instead
* change - Requires PHP 7.4 or newer

## 5.13 & 5.13.1 - September 4, 2023
* fix - Typo in DONOTCACHEOBJECT constant name
* fix - Wrong weight for advertiser created adverts
* fix - Advert status selector when moderating advertiser adverts
* update - Updated MobileDetect to version 3.74
* tweak - Description text for Advert Generator
* tweak - Added title to weekday ticks for schedules
* tweak - Added title to impression ticks for schedules
* new - Devices logic checks to advertiser dashboard
* new - Dashboard notification when ads are queued up
* removed - Experimental weight levels from advertiser dashboard
* api - Updated AdRotate Geo IP/country database

## 5.12.5 - June 24, 2023
* fix - Improved handling for uploaded zip files
* fix - Missing space in welcome popup title
* fix - Schedule expiry notifications
* tweak - Improved error reporting for uploaded zip files
* tweak - Added 'application/zip-compressed' as acceptable mime-type
* tweak - Simplified General Settings page
* tweak - Clarified test button text on Notifications settings page
* tweak - Updated schedule selection when editing adverts

## 5.12.4 - May 25, 2023
* fix - Redirect when sending a test email notification
* fix - Tracking pixel not always 0x0 pixels in responsive themes
* fix - Saving a disabled advert giving unexpected errors
* change - Plugin update notification removed
* change - Updated error message for invalid license (de)activations

## 5.12.3 - April 3, 2023
* fix - No longer add empty onclick attributes to links
* fix - Correct license expiry date when activating a license
* new - Include the advert you need help with in your support request
* tweak - Add tracking pixel to ads instead of tagging the banner image
* tweak - Support notification text updated
* tweak - Support request form text updated

## 5.12.2 - March 21, 2023
* added - Support links for new users on the license page
* added - Better support links for new users on the contact form
* removed - Hide license option
* removed - wp_cache_set() for stats dashboard
* fix - Group CSS value saving as a wrong type on some new setups

## 5.12.1 - February 23, 2023
* new - Support for ZIP files generated in Microsoft Windows
* tweak - Improved reporting to GA4 using the click event
* tweak - Improved reporting to GA4 using the impression event
* tweak - Removed redundant update checks
* fix - Hide license not consistent throughout settings

## 5.12 - February 8, 2023
* new - Google Analytics 4 support through Global Tag (gtag.js)
* fix - Update group CSS when Adblock Disguise hash changes
* fix - License form sometimes hidden when it should not be
* tweak - All but the first ad are set to display:none; for dynamic groups

## 5.11 - January 27, 2023
* new - Error indicators in Manage Groups
* new - Added more error indicators in Manage Schedules
* fix - Advert saved with (false) unknown error
* change - Updated Google Tag Manager references for GA4
* change - Updated Google Global Tag to depreciated
* change - Removed redundant Google settings from stats

## 5.10.5 - January 23, 2023
* fix - Some variables being the wrong type
* fix - Undefined variable for some post injection choices
* tweak - Better handling of saving group settings

## 5.10.4 - January 17, 2023
* fix - Missing $wpdb value for multisite output
* fix - Post Injection multiple groups for 'inside' options
* fix - Post Injection no redundant looping through post_content

## 5.10.3 - January 13, 2023
* fix - Blocks not working for Post Injection
* fix - Post Injection not always showing every advert
* fix - Post Injection sometimes selecting the wrong ads
* fix - Missing count() for posts in Post Injection
* fix - Top advert for Post Injection on forums not always visible
* tweak - Reduced skipping of last paragraphs for Post Injection to 4
* tweak - Moved update triggers to init from admin_init
* tweak - Moved update data to a site transient
* change - Updated support email template for ticket system

## 5.10.2 - January 12, 2023
* fix - Fatal error on dashboard for some people

## 5.10.1 - January 11, 2023
* fix - Error on WooCommerce products without ads
* fix - Post Injection not filtering content correctly
* fix - Post Injection array using incorrect fields
* fix - Post Injection code simplified

## 5.10 - January 10, 2023
* new - More placement options for Post Injection
* new - Post Injection for WooCommerce product pages
* new - Post Injection for bbPress forum and topic pages
* fix - Better advert selection for Post Injection (internal)
* fix - Occasional double or missing adverts with Post Injection
* fix - Incorrect notifications when saving ads or doing tasks
* fix - Missing notifications when doing tasks
* fix - Archive function not always visible when editing adverts
* fix - Plugin information popup now always works
* change - Removed unused maintenance functions

## 5.9.1 - December 7, 2022
* change - Much improved image code rendering for advert generator
* change - Basic url check for advert generator
* change - Now shows 4 decimals for advertiser budget value
* fix - CPM not subtracted correctly

## 5.9 - October 31, 2022
* change - Use WP provided version for plugin_version
* change - Updated support dashboard page
* change - Updated help tabs
* fix - More reliable display of updates
* fix - More reliable reset of AdRotate Geo lookups
* i18n - Updated all included translations

## 5.8.24 - September 13, 2022
* fix - Better handling when group css is not loading
* fix - Stats tracking checkboxes now also work for Google Tracker
* fix - Stats tracking checkboxes now also work for Matomo Tracker
* fix - Missing variable $schedule_warning in some new setups
* tweak - Don't do sessions and geo targeting for CLI
* tweak - Don't do sessions and geo targeting for cron

## 5.8.23 - August 14, 2022
* fix - Advert generator dropdown now looks in subfolders for images
* fix - Auto not working for the size in advert groups
* update - Premium Support form
* update - Removed unused 'Save options' button from maintenance page
* i18n - Updated all included translations

## 5.8.22 - June 22, 2022
* new - See all advertiser stats from 'Manage Advertisers'
* new - Expanded group stats with list of adverts
* new - Expanded advertiser profile with list of adverts
* update - Optimized several stats dashboard queries
* fix - Incomplete description for state iso codes in Geo Targeting
* fix - Missing indexes in update cache array when banned
* change - Double quotation marks no longer allowed in names
* i18n - Fixed several Dutch phrases

## 5.8.21 - May 18, 2022
* update - Tested with WordPress 6
* fix - Double file extension when uploading file
* fix - Uploading zip files now reliably detects mime type

## 5.8.20 - April 28, 2022
* fix - Schedules not being saved when editing adverts
* fix - Impression spread not working properly
* fix - Impression spread configuration errors not always showing
* fix - Several queries using wrong quotations

## 5.8.19 - April 20, 2022
* new - Group and Advert block support
* new - Better global notifications for schedules with warnings
* new - Option to disable schedule warnings.
* new - Don't make Geo/Update requests if banned
* fix - Inaccurate status for spread option when editing schedules
* fix - Low risk security fixes for saving adverts and groups
* fix - Low risk security fixes for saving advertiser input
* fix - Low risk security fixes for saving schedules
* fix - Removed obsolete code related to advertiser contact options
* fix - Better validate uploaded files
* fix - Better handling of server errors for updates
* fix - Better handling of server responses for AdRotate Geo
* update - Borlabs cache code - Requires Borlabs Cache 1.6.5+
* update - Removed unused 'save options' button in Maintenance dashboard

## 5.8.18 - March 1, 2022
* fix - Sometimes missing indexes notice in AdRotate Geo status check
* fix - Text color for AdRotate Geo status check
* fix - Low-risk security flaw on certain text fields
* new - Advert status for exceeding click/impression limits
* new - Advert status for exceeding advertiser budget limits
* new - ads.txt can now be in a non-standard location
* new - Option to manually create an ads.txt file
* new - Option to manually create a banners and reports folder
* new - Improved status indicators for banners folder
* new - Impression spread for all adverts using a schedule (campaigns)
* new - Upload .webp files via the AdRotate asset manager
* update - Reworded the weight function
* update - Added a description to the weight function
* update - Re-arranged device checkboxes
* update - Redid dashboard help tabs

## 5.8.17 - November 16, 2021
* fix - Notice about height on stats
* fix - Overall stats now only count active adverts
* fix - Archiving adverts deleted wrong stats in some cases
* fix - Uninstaller calling unused/broken functions
* fix - Geo Targeting now properly handles failed server responses

## 5.8.16 - September 11, 2021
* new - Option to disable stats for Admin users
* update - Updated MobileDetect to version 2.8.37
* update - Updated dashboard
* fix - Adblock disguise no longer generates invalid CSS classes
* fix - Improved PHP8 compatibility
* fix - Dashboard tweaks

## 5.8.15 - August 03, 2021
* new - Enable stats for clicks or impressions for supported adverts
* new - Warning if %image% is used in adverts
* new - Enable/disable 7 day notification of expiring adverts
* update - Updated dashboard
* fix - Error status for script/ins/iframe ads with click counting enabled
* fix - Error status for ads without a link with click counting enabled
* fix - Better session handling
* i18n - Added more translation strings for email notifications

## 5.8.14 - July 07, 2021
* reversal - Re-added option to disable dynamic mode on mobile
* change - Simplified settings text in General Settings
* change - Merged Advertiser tab into Roles tab
* change - Removed global permissions for advertisers
* change - Advertiser advert creation dashboard overhauled
* change - Geo Targeting now matches city/state/country independently
* change - Geo Targeting now filters faster
* new - Edit/Create adverts are now separate permissions for advertisers
* new - User Profile controls for advertisers expanded and overhauled
* fix - Advertiser permissions work more reliably
* fix - Advert no longer fails evaluation if a script tag is present
* fix - Initiate sessions a bit later
* i18n - Corrected 'Post Injection' labels in Dutch translation

## 5.8.13 - May 07, 2021
* fix - Disabled AMP group option
* new - Assets now list generated reports
* new - Post Injection up to 20 paragraphs
* update - Asset and media dashboard
* update - Reworded error when deleting a file fails
* change - Silently fail when deleting a non-existing file
* change - Removed option to disable dynamic mode on mobile
* i18n - Improved Italian translation (Thanks Davide)

## 5.8.12 - March 15, 2021
* fix - Labels for all checkboxes
* new - Labels for all radio buttons
* update - HTML dashboard code cleanup

## 5.8.11 - February 1, 2021
* fix - Dashboard notifications screwing up dashboard layout

## 5.8.10 - January 26, 2021
* fix - Correct ISO code for Israel
* fix - Dashboard tweaks
* fix - Added Telegram as a 'news&updates' option

## 5.8.9 - December 28, 2020
* new - Added support for special territories in Geo Targeting
* new - Added new export format for global stats
* new - Added new export format for group stats
* fix - Missing tracker variable for archived adverts
* fix - AdRotate Geo reset value not always set
* fix - Stats not always showing up for archived adverts
* fix - Error handling for ipstack Geo Targeting
* tweak - Adjusted error handling for update checks
* tweak - AdRotate Geo reset value is now a transient
* tweak - Reworded spread impressions description
* tweak - Schedule notifications more clearly describe their issue

## 5.8.8 - November 23, 2020
* new - Geo Targeting server response indicator
* fix - MaxMind response variable incorrectly set
* fix - AdRotate Geo response value for errors correctly read
* change - Removed check update button from Maintenance dashboard
* change - Removed support for Google Universal Tracker
* change - Only count impressions if stats are explicitly enabled
* api - Update API responds with status codes for dashboard
* api - Geo API responds with status codes for dashboard on error

## 5.8.7 - November 3, 2020
* tweak - Improved file placement for unzipped adverts
* tweak - Rely more on WordPress time settings
* tweak - Process Update/Geo API responses when banned
* new - Automatically remove unexpected files from unzipped adverts
* fix - Wrongly check for ipstack lookup quota
* fix - Don't rely on WordPress to recognize errors from API responses

## 5.8.6 - October 9, 2020
* fix - Added missing error notices for certain combinations of settings
* fix - Replaced adrotate_now() with current_time('timestamp')
* fix - Better handling of slow/no response from update server
* fix - Backward compatibility with older WordPress versions
* tweak - More consistent use of date() and date_i18n()
* tweak - Reworded advert error notifications
* change - Update checks now show last checked date
* change - %image% tag no longer supported
* change - Now requires WordPress 5.0 or newer

## 5.8.5 - August 5, 2020
- Tested to work on WordPress 5.5
* new - Update API server status indicator in Maintenance
* new - Email CC option for Premium Support messages
* fix - Zip uploads not always working
* api - WordPress 5.5 compatibility
* change - Simplified AdRotate Geo code
* change - Simplified License activation code
* change - Better error handling for Update API

## 5.8.4 - July 13, 2020
* CAUTION - PHP snippet syntax has changed, check manual!
* new - License validity available in your Dashboard
* new - Remove wrapper code from advert for inline use with PHP
* new - Remove wrapper code from advert for inline use with Shortcode
* new - Create folders from the Media Manager
* change - Geo Lookup requests for may now take up to 5 seconds
* fix - Faulty ; in the group CSS output for margins
* fix - Plugin updates not always showing without an active license
* fix - Check for update when activating license
* fix - Possible SQL injection vulnerability for certain urls
* fix - Improved MySQL 8 compatibility
* fix - Improved error handling for AdRotate Geo
* fix - Advertisers no longer create empty ads when adding new adverts
* api - Updated license (de)activation routine
* api - Smaller data size for update checks and Geotargeting (faster)
* api - Requests may now take up to 5 seconds (up from 2 seconds)
* api - Clearer status message for invalid and expired licenses
* api - More accurate latency calculation

## 5.8.3 - May 18, 2020
* new - Configuration notifications when editing groups
* new - Configuration notifications when editing schedules
* new - Set schedule to auto-delete when creating an advert
* new - Added ipstack status notifications
* new - Portable adverts
* fix - Better handling for errors when the update check fails
* change - Better 'onboarding' for new users
* change - Tweaks to notification banner for upgrading users
* change - Tweaks to AdRotate Geo notifications
* change - Dashboard tweaks
* i18n - Updated Dutch, French, German, Italian and Spanish
* api - Provide basic update info for inactive licenses

## 5.8.2 - April 30, 2020
- Improved WordPress 5.4.1 compatibility
* i18n - Updated french translation
* fix - Double dashboard notifications for expired licenses

## 5.8.1 - April 28, 2020
* fix - Uninstall not working for some people

## 5.8 - April 22, 2020
* change - No longer uses WordPress mechanism for update checks
* change - Maintenance dashboard optimised and reworded
* change - Removed old/unused debug code
* change - Compacted Javascript files
* new - Check if AdRotate is installed
* new - Check if faulty adrotate plugin folders exist
* new - Added separate State field
* new - Option to require cities to be in states or provinces
* new - Skip uninstall procedure if AdRotate is installed
* new - Updated advertiser add/edit advert dashboard
* fix - Warnings when trying to add advert as disabled advertiser
* i18n - Updated Polish translation, Thanks Michal
* i18n - Updated Dutch translation using pre-translation
* i18n - Updated Spanish translation using pre-translation
* i18n - Updated German translation using pre-translation
* i18n - Added French translation using pre-translation
* i18n - Added Italian translation using pre-translation
* i18n - Removed Greek translation
* i18n - Removed Bulgarian translation
* i18n - Removed Russian translation
* i18n - Removed Swedish translation
* i18n - Removed Brazilian translation

## 5.7.3 - March 16, 2020
* fix - 'Install Update' button not always working
* fix - Missing array for network settings on non-network setups
* fix - Better check for Borlabs Cache availability
* fix - Manual update and Background task reset button
* fix - More reliable importing of adverts
* fix - More reliable trigger for database update script
* change - Removed 'AdRotate Switch banner'
* change - AdRotate Geo now provides 30000 lookups per day
* change - Updated import advert script
* change - Updated export advert script
* new - Hide the license key and email on Network setups
* new - Force de-activate license option for Network setups
* new - Email notification when adverts expire in a week
* new - Now uses Update API 8
* new - Now uses AdRotate Geo 6

## 5.7.2 - February 14, 2020
* fix - HTML output when installing/updatig other plugins
* fix - missing $wp_roles variable when de-activating AdRotate Pro

## 5.7.1 - February 12, 2020
* fix - Better organised $_SESSION data for duplicate adverts
* fix - Date selection for exports not working for some users
* fix - Date selection for group stats not working for some users
* fix - Date selection for advert stats not working for some users
* fix - Better error handling for Geo Targeting
* fix - Vulnerability related to groups
* fix - Better error handling when checking for updates
* change - Dashboard tweaks

## 5.7 - January 9, 2020
* new - Tooltips for useful tags when editing adverts
* new - New widget format to better counter Ad blockers
* fix - Duplicate filter not storing used advert ids correctly
* fix - Duplicate filter not clear on which groups modes it work in
* fix - Date format for advert stats exports not showing correctly
* fix - Date format for group stats exports not showing correctly
* fix - Date selection for exports not working for some users
* fix - Date selection for group stats not working for some users
* fix - Not able to unset _SESSION on dashboard in some cases
* fix - Group CSS option missing for some new installations
* fix - Group CSS not generated properly on some older PHP versions
* change - Dashboard tweaks

## 5.6.4 - December 3, 2019
* reversal - Date format (dd-mm-yyyy) for date pickers
* new - Datepicker months can be numbers (01-12) or names (Jan-Dec)
* new - Update data is cached for 6 hours and refreshed once a day
* change - Update checker no longer relies on WordPress schedule
* change - Update checker no longer uses transient filter
* fix - WordPress sending millions of update checks for some users
* fix - PHP Error when archiving adverts with no stats

## 5.6.3 - November 26, 2019
* fix - Selected dates not output correctly when editing schedules
* fix - End dates not always correct when exporting stats

## 5.6.2 - November 21, 2019
* change - More modern and polished look for notifications
* change - Clearer date format (dd-mmm-yyyy) for date pickers
* change - Dashboard tweaks
* fix - Improved multisite/network support
* fix - Persistent license notification on multisite instances
* fix - No longer tries to output WP_Error responses as updates
* fix - Session not always created when using duplicate advert filter
* fix - Geo Targeting debug array not working
* fix - Advertiser dashboard assets not loading correctly

## 5.6.1 - November 8, 2019
* fix - More reliable duplicate advert filter
* fix - Create an actual session if possible
* fix - Error that your license is expired while it is not for some users
* fix - AdRotate now better removes all database settings on uninstall
* fix - Several PHP Warnings on new installs
* new - Now using Sessions for Geo Targeting instead of cookies
* change - Improved WordPress 5.3 compatibility

## 5.6 - October 21, 2019
* new - Uploaded zip files are automatically extracted
* new - Support for HTML5 folder structures
* new - Support for Matomo Analytics Events tracking
* change - Piwik support removed
* change - Asset dropdown menu no longer looks for flash files
* change - Dashboard indicator if your license expired or not
* fix - Much improved API communications for updates
* fix - Advert generator adding srcset attribute for single image adverts
* fix - Correct display of license type in License tab
* fix - Correct dates when creating new schedules
* fix - Removed obsolete database options
* api - Update requests are now cached for 12 hours
* api - Faster and more reliable update checks

## 5.5 - September 23, 2019
* new - Filter to prevent double adverts when using groups
* change - Removed many unused Debug code
* change - Tweaks to the installation script
* change - Better advert error state when no operating systems are selected
* change - Better advert error state when no devices are selected
* fix - Dashboard widgets
* i18n - Added missing strings in support dashboard
* i18n - Renamed/converted en_US to proper pot file

## 5.4.2 - August 20, 2019
* fix - Faulty folder name after updating

## 5.4.1 - August 19, 2019
* new - More configuration checks when editing adverts
* fix - Missing semicolon in CSS for groups
* fix - Missing variable $lastyear when deleting old stats
* change - Dashboard tweaks

## 5.4 - July 22, 2019
* new - Support for Google Tag Manager
* new - AdRotate Geo cookie reset when saving Geo Targeting settings
* fix - Adverts not moved to Trash properly
* fix - Spread impressions requires 'Maximum Impressions' to be set
* fix - Geo Targeting layout for Advertisers
* fix - Permissions not declared for some Advertisers
* fix - Live Previews for Advertisers
* change - Reset lookup quota when disabling Geo Targeting
* change - Bin renamed to 'Trash'
* change - Depreciate support for Google Universal Tracker
* change - Stats Settings redone/modernized
* change - Google Analytics Event renamed to "Adverts"
* removed - Obsolete "Responsive Advert" code and database column
* removed - Defunct Message option from Advertiser dashboard
* removed - Defunct Transactions, code and database items

## 5.3 - July 11, 2019
* new - Support to edit ads.txt
* fix - State and Statecode not converted to lowercase for ipstack
* fix - Missing $wpdb value for multisite groups
* fix - Geo Targeting dashboard layout
* fix - Possible vulnerability for users with privileged access
* change - Dashboard tweaks

## 5.2.1 - July 1, 2019
* fix - Better error handling when Update Requests fail

## 5.2 - June 24, 2019
* fix - Datepicker not always working when overlapping graphs
* fix - Generated CSS not deleting properly when deleting groups
* fix - Generated CSS not cleaned properly when doing maintenance
* fix - Outputting generated CSS code more efficient
* update - Faster and more reliable Update Library
* change - Now uses Update Api v6
* change - Now requires WordPress 4.6 or newer

## 5.1.1 - May 13, 2019
* fix - Blinking adverts in Dynamic Groups

## 5.1 - May 2, 2019
* new - Premium Support Dashboard
* new - Facebook Support Group widget
* new - Viewport options in Advert Generator
* update - No longer render dynamic CSS for groups on pageload
* update - Menu labels
* update - 150ms fading effect for adverts in dynamic groups
* removed - Front-end Dashboard for advertisers
* fix - Graphs showing wrong date ranges for some users
* fix - Network Widget not able to show groups in some situations
* i18n - Updated all translation files

## 5.0.1 - April 4, 2019
* fix - Stats displaying wrong dates
* fix - Stats dropdowns showing wrong dates

## 5.0 - March 29, 2019
* new - Advertising Partners dashboard
* new - Advert Header code support
* new - Dynamic ranges for statistics graphs
* fix - Example adverts in Advertiser dashboard
* update - Better localized dates for stats
* update - Dashboard formatting and layout
* update - Exports finally use the new datepicker
