<?php
/* ------------------------------------------------------------------------------------
*  COPYRIGHT AND TRADEMARK NOTICE
*  Copyright 2008-2026 Arnan de Gans. All Rights Reserved.
*  The software AdRotate, related services and ADROTATE the name are owned by Arnan de Gans.

*  COPYRIGHT NOTICES AND ALL THE COMMENTS SHOULD REMAIN INTACT.
*  By using this code you agree to indemnify Arnan de Gans from any
*  liability that might arise from its use.
------------------------------------------------------------------------------------ */
?>
<h2><?php esc_html_e("Summary", 'adrotate-pro'); ?></h2>
<p><em><?php esc_html_e("Overall statistics over active adverts", 'adrotate-pro'); ?></em></p>

<table class="widefat" style="margin-top:.5em;">					

	<tbody>
	<tr>
        <td width="33%"><div class="stats_large"><?php esc_html_e("Adverts", 'adrotate-pro'); ?><br /><div class="number_large"><?php echo $stats['ad_amount']; ?></div></div></td>
        <td width="33%"><div class="stats_large"><?php esc_html_e("Impressions", 'adrotate-pro'); ?><br /><div class="number_large"><?php echo $stats['total_impressions']; ?></div></div></td>
        <td width="34%"><div class="stats_large"><?php esc_html_e("CTR", 'adrotate-pro'); ?><br /><div class="number_large"><?php echo $ctr; ?> %</div></div></td>
	</tr>
	<tr>
        <td colspan="3">
	        <div class="stats_large">
		        <?php esc_html_e("Best performing advert", 'adrotate-pro'); ?> 
		        <?php if($stats['thebest']) {
		        	echo '\''.$stats['thebest']['title'].'\' ';
		        	echo esc_html__("with", 'adrotate-pro').' '.$stats['thebest']['clicks'].' '.esc_html__("clicks.", 'adrotate-pro'); ?><br />
		        	<div style="margin: 10px;"><?php echo adrotate_preview($stats['thebest']['id']); ?></div>
		        <?php } else { ?>
		        	<br /><?php esc_html_e("No advert stands out at this time.", 'adrotate-pro'); ?>
				<?php } ?>
			</div>
        </td>
	</tr>
	<tr>
        <td colspan="3">
	        <div class="stats_large">
		        <?php esc_html_e("Least performing advert", 'adrotate-pro'); ?> 
		        <?php if($stats['theworst']) {
		        	echo '\''.$stats['theworst']['title'].'\' ';
		        	echo esc_html__("with", 'adrotate-pro').' '.$stats['theworst']['clicks'].' '.esc_html__("clicks.", 'adrotate-pro'); ?><br />
		        	<div style="margin: 10px;"><?php echo adrotate_preview($stats['theworst']['id']); ?></div>
		        <?php } else { ?>
		        	<br /><?php esc_html_e("No advert stands out at this time.", 'adrotate-pro'); ?>
				<?php } ?>
			</div>
		</td>
	</tr>
	</tbody>

</table>

<h2><?php esc_html_e("Monthly overview of clicks and impressions", 'adrotate-pro'); ?></h2>

<form method="get" action="admin.php">
	<table class="widefat" style="margin-top:.5em;">
		<tbody>
		<tr>
	        <td colspan="3">
					<input type="hidden" name="page" value="adrotate-advertiser" />
					<?php esc_html_e("Period", 'adrotate-pro'); ?> (dd-mm-yyyy): 
					
					<input tabindex="2" type="text" id="startdate_graph_picker" name="graph_start" value="<?php echo gmdate('d-m-Y', $graph_start_date); ?>" class="datepicker ajdg-datepicker ajdg-inputfield" autocomplete="off" />
					<input tabindex="3" type="text" id="enddate_graph_picker" name="graph_end" value="<?php echo gmdate('d-m-Y', $graph_end_date); ?>" class="datepicker ajdg-datepicker ajdg-inputfield" autocomplete="off" />
					<input tabindex="4" type="submit" name="graph_submit" class="button-secondary" value="<?php esc_html_e("Go", 'adrotate-pro'); ?>" /> <em><?php esc_html_e("The maximum range is about 3 months, larger ranges will make the graph unreadable.", 'adrotate-pro'); ?></em>
			</td>
	  	</tr>	
		<tr>
	        <th colspan="3">
				<?php echo adrotate_stats_graph('advertiserfull', false, $current_user->ID, 1, $graph_start_date, $graph_end_date); ?>
	        </th>
		</tr>
		<tr>
	        <td width="33%"><div class="stats_large"><?php esc_html_e("Impressions", 'adrotate-pro'); ?><br /><div class="number_large"><?php echo $stats_graph_month['impressions']; ?></div></div></td>
	        <td width="33%"><div class="stats_large"><?php esc_html_e("Clicks", 'adrotate-pro'); ?><br /><div class="number_large"><?php echo $stats_graph_month['clicks']; ?></div></div></td>
	        <td width="34%"><div class="stats_large"><?php esc_html_e("CTR", 'adrotate-pro'); ?><br /><div class="number_large"><?php echo $ctr_graph_month; ?> %</div></div></td>
		</tr>
		</tbody>

	</table>
</form>

<h2><?php esc_html_e("Export options for montly overview", 'adrotate-pro'); ?></h2>
<form method="post" action="admin.php?page=adrotate-advertiser">
<?php wp_nonce_field('adrotate_export_advertiser','adrotate_nonce'); ?>
<input type="hidden" name="adrotate_export_id" value="<?php echo $current_user->ID; ?>" />
<input type="hidden" name="adrotate_export_type" value="advertiser" />

<?php 
$start_date	= adrotate_date_start('day');
$end_date = $start_date + (86400 * 7);
?>

<table class="widefat" style="margin-top:.5em;">					

    <tbody>
    <tr>
		<th><?php esc_html_e("Select period", 'adrotate-pro'); ?></th>
		<td>
			<input tabindex="1" type="date" id="datepicker" name="adrotate_start_date" value="<?php echo gmdate("Y-m-d", $start_date); ?>" class="datepicker" /> / <input tabindex="2" type="date" id="datepicker" name="adrotate_end_date" value="<?php echo gmdate("Y-m-d", $end_date); ?>" class="datepicker" />
		</td>
	</tr>
    <tr>
		<th><?php esc_html_e("Email options", 'adrotate-pro'); ?></th>
		<td>
  			<input tabindex="3" type="text" name="adrotate_export_addresses" size="45" class="search-input" value="" autocomplete="off" /> <em><?php esc_html_e("Maximum of 3 email addresses, comma seperated. Leave empty to download the CSV file instead.", 'adrotate-pro'); ?></em>
		</td>
	</tr>
    <tr>
		<th>&nbsp;</th>
		<td>
  			<input tabindex="4" type="submit" name="adrotate_export" class="button-primary" value="<?php esc_html_e("Export", 'adrotate-pro'); ?>" /> <em><?php esc_html_e("Download or email your selected timeframe as a CSV file.", 'adrotate-pro'); ?></em>
		</td>
	</tr>
	</tbody>

</table>
</form>