<?php
/* ------------------------------------------------------------------------------------
*  COPYRIGHT AND TRADEMARK NOTICE
*  Copyright 2008-2026 Arnan de Gans. All Rights Reserved.
*  The software AdRotate, related services and ADROTATE the name are owned by Arnan de Gans.

*  COPYRIGHT NOTICES AND ALL THE COMMENTS SHOULD REMAIN INTACT.
*  By using this code you agree to indemnify Arnan de Gans from any
*  liability that might arise from its use.
------------------------------------------------------------------------------------ */
?>
<form name="banners" id="post" method="post" action="admin.php?page=adrotate-advertisers">

	<h2><?php esc_html_e("Advertisers", 'adrotate-pro'); ?></h2>
	<em><?php esc_html_e("These are users marked as Advertisers. You can add more advertisers by editing existing users or creating new users.", 'adrotate-pro'); ?></em>

	<table class="widefat tablesorter manage-advertisers-main" style="margin-top:.5em;">
		<thead>
		<tr>
			<th><?php esc_html_e("Name", 'adrotate-pro'); ?></th>
			<th width="25%"><?php esc_html_e("Email", 'adrotate-pro'); ?></th>
			<th width="5%"><?php esc_html_e("Adverts", 'adrotate-pro'); ?></th>
		</tr>
		</thead>
		<tbody>
	<?php
	if (count($advertisers) > 0) {
		$class = '';
		foreach($advertisers as $user_id => $user) {			
			$errorclass = '';
			if($user['has_adverts'] <= 0) $errorclass = ' row_blue';

			$class = ('alternate' != $class) ? 'alternate' : '';
			$class = ($errorclass != '') ? $errorclass : $class;
			?>
		    <tr id='adrotateindex' class='<?php echo $class; ?>'>
				<td data-sort-value="<?php echo $user['name']; ?>"><strong><a class="row-title" href="<?php echo admin_url('/admin.php?page=adrotate-advertisers&view=profile&user='.$user_id);?>" title="<?php esc_html_e("Edit", 'adrotate-pro'); ?>"><?php echo $user['name'];?></a></strong> - <a href="<?php echo admin_url('/admin.php?page=adrotate-statistics&view=advertiser&id='.$user_id);?>" title="<?php esc_html_e("Stats", 'adrotate-pro'); ?>"><?php esc_html_e("Stats", 'adrotate-pro'); ?></a></td>
				<td data-sort-value="<?php echo $user['email']; ?>"><a class="row-title" href="<?php echo admin_url('/admin.php?page=adrotate-advertisers&view=contact&user='.$user_id);?>" title="<?php esc_html_e("Contact", 'adrotate-pro'); ?>"><?php echo $user['email']; ?></a></td>
				<td data-sort-value="<?php echo $user['has_adverts']; ?>"><center><?php echo $user['has_adverts']; ?></center></td>
			</tr>
			<?php } ?>
		<?php } else { ?>
		<tr id='no-advertisers'>
			<td colspan="3"><em><?php esc_html_e("Nothing here!", 'adrotate-pro'); ?></em></td>
		</tr>
	<?php } ?>
	</tbody>
</table>
<p><center>
	<span style="border: 1px solid #466f82; height: 12px; width: 12px; background-color: #8dcede">&nbsp;&nbsp;&nbsp;&nbsp;</span> <?php esc_html_e("Has no adverts", 'adrotate-pro'); ?>
</center></p>
</form>