<?php
/* ------------------------------------------------------------------------------------
*  COPYRIGHT AND TRADEMARK NOTICE
*  Copyright 2008-2026 Arnan de Gans. All Rights Reserved.
*  The software AdRotate, related services and ADROTATE the name are owned by Arnan de Gans.

*  COPYRIGHT NOTICES AND ALL THE COMMENTS SHOULD REMAIN INTACT.
*  By using this code you agree to indemnify Arnan de Gans from any
*  liability that might arise from its use.
------------------------------------------------------------------------------------ */
?>

<h2><?php esc_html_e("Archived Adverts", 'adrotate-pro'); ?></h2>
<p><em><?php esc_html_e("The archive is a way of permanently disabling adverts. Archiving adverts is meant to preserve stats and/or settings. While you can edit the adverts, you can not activate them again. They can however be duplicated to new adverts which you can use.", 'adrotate-pro'); ?> <?php esc_html_e("Archived adverts have their stats moved to a separate database table which may increase the overall speed of your site.", 'adrotate-pro'); ?></em></p>
<p><em><strong><?php esc_html_e("Caution:", 'adrotate-pro'); ?></strong> <?php esc_html_e("Archiving multiple adverts at the same time may slow down your site, in some cases a lot of data has to be moved. Not every hosting provider allows you to move large quantities of data. To avoid this, archive one or two adverts at a time.", 'adrotate-pro'); ?></em></p>

<form name="banners" id="post" method="post" action="admin.php?page=adrotate&view=archive">
	<?php wp_nonce_field('adrotate_bulk_ads_archive','adrotate_nonce'); ?>

	<div class="tablenav top">
		<div class="alignleft actions">
			<select name="adrotate_action" id="cat" class="postform">
		        <option value=""><?php esc_html_e("Bulk Actions", 'adrotate-pro'); ?></option>
		        <option value="duplicate"><?php esc_html_e("Duplicate", 'adrotate-pro'); ?></option>
		        <option value="delete"><?php esc_html_e("Delete (Permanently)", 'adrotate-pro'); ?></option>
		        <option value="export-xml"><?php esc_html_e("Export to XML", 'adrotate-pro'); ?></option>
			</select> <input type="submit" id="post-action-submit" name="adrotate_action_submit" value="<?php esc_html_e("Go", 'adrotate-pro'); ?>" class="button-secondary" />
		</div>	
		<br class="clear" />
	</div>

	<table class="widefat tablesorter manage-ads-archived" style="margin-top:.5em;">
		<thead>
		<tr>
			<td scope="col" class="manage-column column-cb check-column"><input type="checkbox" /></td>
			<th width="2%"><center><?php esc_html_e("ID", 'adrotate-pro'); ?></center></th>
			<th width="12%"><?php esc_html_e("Start date", 'adrotate-pro'); ?></th>
			<th width="12%"><?php esc_html_e("End date", 'adrotate-pro'); ?></th>
			<th><?php esc_html_e("Name", 'adrotate-pro'); ?></th>
			<th width="5%"><center><?php esc_html_e("Device", 'adrotate-pro'); ?></center></th>
			<th width="5%"><center><?php esc_html_e("Weight", 'adrotate-pro'); ?></center></th>
		</tr>
		</thead>
		<tbody>
	<?php
	$banners = $wpdb->get_results("SELECT `id`, `title`, `type`, `tracker`, `weight`, `desktop`, `mobile`, `tablet`, `budget`, `crate`, `irate` FROM `{$wpdb->prefix}adrotate` WHERE `type` = 'archived' ORDER BY `id` ASC;");
	if(count($banners) > 0) {
		$class = '';
		foreach($banners as $banner) {
			// Format temporary titles
			$title = (strlen($banner->title) == 0) ? 'Advert '.$banner->id.' [temp]' : $banner->title;
		
			// Figure out the first and last time the ad should show
			$starttime = $stoptime = 0;
			$starttime = $wpdb->get_var("SELECT `starttime` FROM `{$wpdb->prefix}adrotate_schedule`, `{$wpdb->prefix}adrotate_linkmeta` WHERE `ad` = {$banner->id} AND `schedule` = `{$wpdb->prefix}adrotate_schedule`.`id` ORDER BY `starttime` ASC LIMIT 1;");
			$stoptime = $wpdb->get_var("SELECT `stoptime` FROM `{$wpdb->prefix}adrotate_schedule`, `{$wpdb->prefix}adrotate_linkmeta` WHERE `ad` = {$banner->id} AND  `schedule` = `{$wpdb->prefix}adrotate_schedule`.`id` ORDER BY `stoptime` DESC LIMIT 1;");
		
			// Is there an advertiser?
			if($adrotate_config['enable_advertisers'] == 'Y') {
				$advertiser = $wpdb->get_var("SELECT `display_name` FROM `{$wpdb->prefix}adrotate_linkmeta`, `$wpdb->users` WHERE `$wpdb->users`.`id` = `{$wpdb->prefix}adrotate_linkmeta`.`user` AND `ad` = {$banner->id} AND `group` = 0 AND `schedule` = 0 LIMIT 1;");
			} else {
				$advertiser = '';
			}

			// Load and format groups for this ad
			$grouplist = adrotate_ad_is_in_groups($banner->id);

			// Determine mobile devices
			$mobile = '';
			if($banner->desktop == 'Y') {
				$mobile .= '<img src="'.adrotate_icon('desktop').'" width="12" height="12" title="Desktop" />';
			}
			if($banner->mobile == 'Y') {
				$mobile .= '<img src="'.adrotate_icon('mobile').'" width="12" height="12" title="Mobile" />';
			}
			if($banner->tablet == 'Y') {
				$mobile .= '<img src="'.adrotate_icon('tablet').'" width="12" height="12" title="Tablet" />';
			}

			$class = ($class != 'alternate') ? 'alternate' : '';
			?>
		    <tr id='adrotateindex' class='<?php echo $class; ?>'>
				<th class="check-column"><input type="checkbox" name="bannercheck[]" value="<?php echo $banner->id; ?>" /></th>
				<td><center><?php echo $banner->id;?></center></td>
				<td><?php echo date_i18n('F d, Y', $starttime);?></td>
				<td><?php echo date_i18n('F d, Y', $stoptime);?></td>
				<td>
					<strong><a class="row-title" href="<?php echo admin_url('/admin.php?page=adrotate&view=edit&ad='.$banner->id);?>" title="<?php esc_html_e("Edit", 'adrotate-pro'); ?>"><?php echo stripslashes($title);?></a></strong> <?php if($adrotate_config['stats'] == 1 AND $banner->tracker != 'N') { ?>- <a href="<?php echo admin_url('/admin.php?page=adrotate-statistics&view=advert&id='.$banner->id);?>" title="<?php esc_html_e("Stats", 'adrotate-pro'); ?>"><?php esc_html_e("Stats", 'adrotate-pro'); ?></a><?php } ?>
					<span style="color:#999;">
						<?php if(strlen($grouplist) > 0) echo '<br /><span style="font-weight:bold;">'.esc_html__("Groups:", 'adrotate-pro').'</span> '.$grouplist; ?>
						<?php if(!empty($advertiser) AND $adrotate_config['enable_advertisers'] == 'Y') echo '<br /><span style="font-weight:bold;">'.esc_html__("Advertiser:", 'adrotate-pro').'</span> '.$advertiser;
						if($banner->crate > 0 OR $banner->irate > 0) { echo ' <span style="font-weight:bold;">'.esc_html__("Budget:", 'adrotate-pro').'</span> '.number_format($banner->budget, 2, '.', '').' - '.esc_html__("CPC:", 'adrotate-pro').' '.number_format($banner->crate, 2, '.', '').' - '.esc_html__("CPM:", 'adrotate-pro').' '.number_format($banner->irate, 2, '.', ''); } ?>
				</td>
				<td><center><?php echo $mobile; ?></center></td>
				<td><center><?php echo $banner->weight; ?></center></td>
			</tr>
		<?php 
			unset($banner, $title, $starttime, $stoptime, $advertiser, $grouplist, $mobile);
		}
		
		unset($banners); 
		?>
	<?php } else { ?>
		<tr id='no-adverts'>
			<th class="check-column">&nbsp;</th>
			<td colspan="5"><em><?php esc_html_e("Nothing here!", 'adrotate-pro'); ?></em></td>
		</tr>
	<?php } ?>
	</tbody>
</table>

</form>
