<?php
/* ------------------------------------------------------------------------------------
*  COPYRIGHT AND TRADEMARK NOTICE
*  Copyright 2008-2026 Arnan de Gans. All Rights Reserved.
*  The software AdRotate, related services and ADROTATE the name are owned by Arnan de Gans.

*  COPYRIGHT NOTICES AND ALL THE COMMENTS SHOULD REMAIN INTACT.
*  By using this code you agree to indemnify Arnan de Gans from any
*  liability that might arise from its use.
------------------------------------------------------------------------------------ */
?>
<h2><?php esc_html_e("Adverts that need attention", 'adrotate-pro'); ?></h2>
<p><?php esc_html_e("The adverts listed here are currently not showing on your website. This is because they are almost expired, have expired or have configuration issues.", 'adrotate-pro'); ?><br /><?php esc_html_e("To fix the issue edit each advert and look for one or more notification at the top to see what AdRotate thinks is wrong with it.", 'adrotate-pro'); ?></p>

<form name="errorbanners" id="post" method="post" action="admin.php?page=adrotate">
	<?php wp_nonce_field('adrotate_bulk_ads_error','adrotate_nonce'); ?>
	<div class="tablenav">
		<div class="alignleft actions">
			<select name="adrotate_action" id="cat" class="postform">
		        <option value=""><?php esc_html_e("Bulk Actions", 'adrotate-pro'); ?></option>
		        <option value="deactivate"><?php esc_html_e("Deactivate", 'adrotate-pro'); ?></option>
		        <option value="archive"><?php esc_html_e("Archive (Permanently)", 'adrotate-pro'); ?></option>
		        <option value="trash"><?php esc_html_e("Move to Trash", 'adrotate-pro'); ?></option>
		        <option value="reset"><?php esc_html_e("Reset stats", 'adrotate-pro'); ?></option>
		        <option value="" disabled><?php esc_html_e("-- Renew --", 'adrotate-pro'); ?></option>
		        <option value="renew-31536000"><?php esc_html_e("For 1 year", 'adrotate-pro'); ?></option>
		        <option value="renew-5184000"><?php esc_html_e("For 180 days", 'adrotate-pro'); ?></option>
		        <option value="renew-2592000"><?php esc_html_e("For 30 days", 'adrotate-pro'); ?></option>
		        <option value="renew-604800"><?php esc_html_e("For 7 days", 'adrotate-pro'); ?></option>
			</select>
			<input type="submit" id="post-action-submit" name="adrotate_action_submit" value="<?php esc_html_e("Go", 'adrotate-pro'); ?>" class="button-secondary" />
		</div>
	
		<br class="clear" />
	</div>
	
		<table class="widefat tablesorter manage-ads-error" style="margin-top:.5em;">
			<thead>
			<tr>
				<td scope="col" class="manage-column column-cb check-column"><input type="checkbox" /></td>
				<th width="2%"><center><?php esc_html_e("ID", 'adrotate-pro'); ?></center></th>
				<th width="12%"><?php esc_html_e("Start date", 'adrotate-pro'); ?></th>
				<th width="12%"><?php esc_html_e("End date", 'adrotate-pro'); ?></th>
				<th><?php esc_html_e("Name", 'adrotate-pro'); ?></th>
			</tr>
			</thead>
			<tbody>
		<?php 
		foreach($error as $banner) {
			$grouplist = adrotate_ad_is_in_groups($banner['id']);
			
			$class = '';
			if($banner['type'] == 'error') $class = 'row_yellow'; 
			if($banner['type'] == 'a_error') $class = 'row_yellow'; 
			if($banner['type'] == 'expired') $class = 'row_red';
			if($banner['type'] == '2days') $class = 'row_orange';
			if($banner['type'] == 'limit') $class = 'row_blue';

			$mobile = '';
			if($banner['desktop'] == 'Y') {
				$mobile .= "<img src=\"".adrotate_icon('desktop')."\" width=\"12\" height=\"12\" title=\"Desktop\" />";
			}
			if($banner['mobile'] == 'Y') {
				$mobile .= "<img src=\"".adrotate_icon('mobile')."\" width=\"12\" height=\"12\" title=\"Mobile\" />";
			}
			if($banner['tablet'] == 'Y') {
				$mobile .= "<img src=\"".adrotate_icon('tablet')."\" width=\"12\" height=\"12\" title=\"Tablet\" />";
			}
			?>
		    <tr id="adrotateindex" class="<?php echo $class; ?>">
				<th class="check-column"><input type="checkbox" name="bannercheck[]" value="<?php echo $banner['id']; ?>" /></th>
				<td><center><?php echo $banner['id'];?></center></td>
				<td data-sort-value="<?php echo $banner['firstactive']; ?>"><?php echo date_i18n('F d, Y', $banner['firstactive']);?></td>
				<td data-sort-value="<?php echo $banner['lastactive']; ?>"><span style="color: <?php echo adrotate_prepare_color($banner['lastactive']);?>;"><?php echo date_i18n('F d, Y', $banner['lastactive']);?></span></td>
				<td>
					<strong><a class="row-title" href="<?php echo admin_url("/admin.php?page=adrotate&view=edit&ad=".$banner['id']);?>" title="<?php esc_html_e("Edit", 'adrotate-pro'); ?>"><?php echo stripslashes($banner['title']);?></a></strong> <?php if($adrotate_config['stats'] == 1 AND $banner['type'] != 'error' AND $banner['type'] != 'a_error') { ?>- <a href="<?php echo admin_url('/admin.php?page=adrotate-statistics&view=advert&id='.$banner['id']);?>" title="<?php esc_html_e("Stats", 'adrotate-pro'); ?>"><?php esc_html_e("Stats", 'adrotate-pro'); ?></a><?php } ?>
					<span style="color:#999;">
						<br /><strong><?php echo esc_html__("Devices:", 'adrotate-pro'); ?></strong> <?php echo $mobile; ?>, <strong><?php echo esc_html__("Weight:", 'adrotate-pro'); ?></strong> <?php echo $banner['weight']; ?>
						<?php if(!empty($banner['advertiser']) AND $adrotate_config['enable_advertisers'] == 'Y') echo "<span style=\"font-weight:bold;\">".esc_html__("Advertiser:", 'adrotate-pro')."</span> ".$banner['advertiser']; ?>
						<?php if(strlen($grouplist) > 0) echo "<br /><span style=\"font-weight:bold;\">".esc_html__("Groups:", 'adrotate-pro')."</span> ".$grouplist; ?>
					</span>
				</td>
			</tr>
			<?php } ?>
		</tbody>

	</table>
	<p><center>
		<span style="border: 1px solid #e6db55; height: 12px; width: 12px; background-color: #ffffe0">&nbsp;&nbsp;&nbsp;&nbsp;</span> <?php esc_html_e("Configuration errors", 'adrotate-pro'); ?>
		&nbsp;&nbsp;&nbsp;&nbsp;<span style="border: 1px solid #466f82; height: 12px; width: 12px; background-color: #ebf3fa">&nbsp;&nbsp;&nbsp;&nbsp;</span> <?php esc_html_e("Limit reached", 'adrotate-pro'); ?>
		&nbsp;&nbsp;&nbsp;&nbsp;<span style="border: 1px solid #c80; height: 12px; width: 12px; background-color: #fdefc3">&nbsp;&nbsp;&nbsp;&nbsp;</span> <?php esc_html_e("Expires soon", 'adrotate-pro'); ?>
		&nbsp;&nbsp;&nbsp;&nbsp;<span style="border: 1px solid #c00; height: 12px; width: 12px; background-color: #ffebe8">&nbsp;&nbsp;&nbsp;&nbsp;</span> <?php esc_html_e("Expired", 'adrotate-pro'); ?>
	</center></p>
</form>
