<?php
/* ------------------------------------------------------------------------------------
*  COPYRIGHT AND TRADEMARK NOTICE
*  Copyright 2008-2026 Arnan de Gans. All Rights Reserved.
*  The software AdRotate, related services and ADROTATE the name are owned by Arnan de Gans.

*  COPYRIGHT NOTICES AND ALL THE COMMENTS SHOULD REMAIN INTACT.
*  By using this code you agree to indemnify Arnan de Gans from any
*  liability that might arise from its use.
------------------------------------------------------------------------------------ */
?>
<div class="upload-plugin ajdg-upload">
	<p class="install-help"><?php _e("If you have a CSV file you can import your adverts by uploading it here.", 'adrotate-pro'); ?></p>
	<form method="post" enctype="multipart/form-data" class="wp-upload-form" action="admin.php?page=adrotate&view=import">
		<?php wp_nonce_field('adrotate_import','adrotate_nonce_tools'); ?>
		<input type="hidden" name="MAX_FILE_SIZE" value="8192000" />

		<label class="screen-reader-text" for="adrotate_file"><?php _e("CSV file", 'adrotate-pro'); ?></label>
		<input type="file" id="file" name="adrotate_file" accept=".csv">
		<input type="submit" name="adrotate_import" class="button" value="<?php _e("Import", 'adrotate-pro'); ?>" disabled="">
	</form>
</div>
<p><center><?php _e("Make sure that the file is compatible and formatted correctly. The maximum size is 8MB and the file must have comma separated columns.", 'adrotate-pro'); ?><br /><strong><?php _e("AdRotate Pro does a few basic checks but can not detect it if columns are missing or if they are in the wrong order.", 'adrotate-pro'); ?></strong><br /><?php _e("This is especially important if you're creating your own import files. To make creating files easier, export 1 advert as a template.", 'adrotate-pro'); ?></center></p>
