<?php
/* ------------------------------------------------------------------------------------
*  COPYRIGHT AND TRADEMARK NOTICE
*  Copyright 2008-2026 Arnan de Gans. All Rights Reserved.
*  The software AdRotate, related services and ADROTATE the name are owned by Arnan de Gans.

*  COPYRIGHT NOTICES AND ALL THE COMMENTS SHOULD REMAIN INTACT.
*  By using this code you agree to indemnify Arnan de Gans from any
*  liability that might arise from its use.
------------------------------------------------------------------------------------ */
?>

<h2><?php esc_html_e("Moderation Queue", 'adrotate-pro'); ?></h2>
<p><em><?php esc_html_e("The moderation queue lists adverts assigned to your advertisers that need reviewing. This includes changes made by advertisers.", 'adrotate-pro'); ?></em></p>

<form name="banners" id="post" method="post" action="admin.php?page=adrotate-moderate">
	<?php wp_nonce_field('adrotate_bulk_ads_queue','adrotate_nonce'); ?>

	<div class="tablenav">
		<div class="alignleft actions">
			<select name="adrotate_action" id="cat" class="postform">
		        <option value=""><?php esc_html_e("Bulk Actions", 'adrotate-pro'); ?></option>
		        <option value="approve"><?php esc_html_e("Approve", 'adrotate-pro'); ?></option>
		        <option value="queue"><?php esc_html_e("Queue", 'adrotate-pro'); ?></option>
		        <option value="reject"><?php esc_html_e("Reject", 'adrotate-pro'); ?></option>
		        <option value="delete"><?php esc_html_e("Delete", 'adrotate-pro'); ?></option>
			</select>
			<input type="submit" id="post-action-submit" name="adrotate_action_submit" value="<?php esc_html_e("Go", 'adrotate-pro'); ?>" class="button-secondary" />
		</div>
	
		<br class="clear" />
	</div>

	<table class="widefat tablesorter moderate-queue" style="margin-top:.5em;">
		<thead>
		<tr>
			<td scope="col" class="manage-column column-cb check-column"><input type="checkbox" /></td>
			<th width="2%"><center><?php esc_html_e("ID", 'adrotate-pro'); ?></center></th>
			<th width="12%"><?php esc_html_e("Start date", 'adrotate-pro'); ?></th>
			<th width="12%"><?php esc_html_e("End date", 'adrotate-pro'); ?></th>
			<th><?php esc_html_e("Name", 'adrotate-pro'); ?></th>
			<th width="5%"><?php esc_html_e("Device", 'adrotate-pro'); ?></th>
			<th width="5%"><?php esc_html_e("Weight", 'adrotate-pro'); ?></th>
			<th width="20%"><?php esc_html_e("Advertiser", 'adrotate-pro'); ?></th>
		</tr>
		</thead>
		<tbody>
	<?php
	$banners = $wpdb->get_results("SELECT `id`, `title`, `type`, `tracker`, `weight`, `desktop`, `mobile`, `tablet`, `budget`, `crate`, `irate` FROM `{$wpdb->prefix}adrotate` WHERE `type` = 'queue' OR `type` = 'reject' ORDER BY `id` ASC;");

	if(count($banners) > 0) {
		$class = '';
		foreach($banners as $banner) {			
			// Format temporary titles
			$title = (strlen($banner->title) == 0) ? 'Advert '.$banner->id.' [temp]' : $banner->title;
		
			// Figure out the first and last time the ad should show
			$starttime = $stoptime = 0;
			$starttime = $wpdb->get_var("SELECT `starttime` FROM `{$wpdb->prefix}adrotate_schedule`, `{$wpdb->prefix}adrotate_linkmeta` WHERE `ad` = {$banner->id} AND `schedule` = `{$wpdb->prefix}adrotate_schedule`.`id` ORDER BY `starttime` ASC LIMIT 1;");
			$stoptime = $wpdb->get_var("SELECT `stoptime` FROM `{$wpdb->prefix}adrotate_schedule`, `{$wpdb->prefix}adrotate_linkmeta` WHERE `ad` = {$banner->id} AND  `schedule` = `{$wpdb->prefix}adrotate_schedule`.`id` ORDER BY `stoptime` DESC LIMIT 1;");

			// Is there an advertiser?
			if($adrotate_config['enable_advertisers'] == 'Y') {
				$advertiser = $wpdb->get_var("SELECT `display_name` FROM `{$wpdb->prefix}adrotate_linkmeta`, `$wpdb->users` WHERE `$wpdb->users`.`id` = `{$wpdb->prefix}adrotate_linkmeta`.`user` AND `ad` = {$banner->id} AND `group` = 0 AND `schedule` = 0 LIMIT 1;");
			} else {
				$advertiser = '';
			}
			
			// Load and format groups for this ad
			$grouplist = adrotate_ad_is_in_groups($banner->id);
			
			$errorclass = '';
			if($banner->type == 'error' OR $banner->type == 'a_error') $errorclass = ' row_yellow';
			if($banner->type == 'reject') $errorclass = ' row_red';
			if(($banner->crate > 0 OR $banner->irate > 0) AND $banner->budget == 0) $errorclass = ' row_blue';

			$class = ('alternate' != $class) ? 'alternate' : '';
			$class = ($errorclass != '') ? $errorclass : $class;

			$mobile = '';
			if($banner->desktop == 'Y') {
				$mobile .= "<img src=\"".adrotate_icon('desktop')."\" width=\"12\" height=\"12\" title=\"Desktop\" />";
			}
			if($banner->mobile == 'Y') {
				$mobile .= "<img src=\"".adrotate_icon('mobile')."\" width=\"12\" height=\"12\" title=\"Mobile\" />";
			}
			if($banner->tablet == 'Y') {
				$mobile .= "<img src=\"".adrotate_icon('tablet')."\" width=\"12\" height=\"12\" title=\"Tablet\" />";
			}
			?>
		    <tr id="adrotateindex" class="<?php echo $class; ?>">
				<th class="check-column"><input type="checkbox" name="bannercheck[]" value="<?php echo $banner->id; ?>" /></th>
				<td><center><?php echo $banner->id;?></center></td>
				<td><?php echo date_i18n('F d, Y', $starttime);?><br /><span style="color: <?php echo adrotate_prepare_color($stoptime);?>;"><?php echo date_i18n('F d, Y', $stoptime);?></span></td>
				
				<td data-sort-value="<?php echo $starttime; ?>"><?php echo date_i18n('F d, Y', $starttime);?></td>
				<td data-sort-value="<?php echo $stoptime; ?>"><span style="color: <?php echo adrotate_prepare_color($stoptime);?>;"><?php echo date_i18n('F d, Y', $stoptime);?></span></td>

				<td data-sort-value="<?php echo $title; ?>">
					<strong><a class="row-title" href="<?php echo admin_url('/admin.php?page=adrotate&view=edit&ad='.$banner->id);?>" title="<?php esc_html_e("Edit", 'adrotate-pro'); ?>"><?php echo stripslashes($title);?></a></strong>
					<?php if($groups) { echo "<br /><span style=\"color:#999\"><strong>".esc_html__("Groups:", 'adrotate-pro')."</strong> ".$grouplist."</span>"; } ?>
				</td>
				<td><center><?php echo $mobile; ?></center></td>
				<td><center><?php echo $banner->weight; ?></center></td>
				<td><?php echo $advertiser_name; ?></td>
			</tr>
		<?php 
			unset($banner, $title, $starttime, $stoptime, $advertiser, $grouplist, $mobile);
		}
		
		unset($banners); 
		?>
		<?php } else { ?>
		<tr id="no-groups">
			<th class="check-column">&nbsp;</th>
			<td colspan="6"><em><?php esc_html_e("Nothing here!", 'adrotate-pro'); ?></em></td>
		</tr>
	<?php } ?>
	</tbody>
</table>
<p><center>
	<span style="border: 1px solid #e6db55; height: 12px; width: 12px; background-color: #ffffe0">&nbsp;&nbsp;&nbsp;&nbsp;</span> <?php esc_html_e("Configuration errors", 'adrotate-pro'); ?>
	&nbsp;&nbsp;&nbsp;&nbsp;<span style="border: 1px solid #c00; height: 12px; width: 12px; background-color: #ffebe8">&nbsp;&nbsp;&nbsp;&nbsp;</span> <?php esc_html_e("Rejected.", 'adrotate-pro'); ?>
	&nbsp;&nbsp;&nbsp;&nbsp;<span style="border: 1px solid #466f82; height: 12px; width: 12px; background-color: #ebf3fa">&nbsp;&nbsp;&nbsp;&nbsp;</span> <?php esc_html_e("Limit reached", 'adrotate-pro'); ?>
</center></p>
</form>