<?php
/* ------------------------------------------------------------------------------------
*  COPYRIGHT AND TRADEMARK NOTICE
*  Copyright 2008-2026 Arnan de Gans. All Rights Reserved.
*  The software AdRotate, related services and ADROTATE the name are owned by Arnan de Gans.

*  COPYRIGHT NOTICES AND ALL THE COMMENTS SHOULD REMAIN INTACT.
*  By using this code you agree to indemnify Arnan de Gans from any
*  liability that might arise from its use.
------------------------------------------------------------------------------------ */

$banners = $wpdb->get_results("
	SELECT `id`, `title`, `type`, `tracker`, `weight`, `autodelete`, `autodisable`, `desktop`, `mobile`, `tablet`, `budget`, `crate`, `irate`
	FROM
		`{$wpdb->prefix}adrotate`
	WHERE
		`type` = 'active'
		OR `type` = '7days'
		OR `type` = '2days'
		OR `type` = 'error'
		OR `type` = 'a_error'
		OR `type` = 'expired'
		OR `type` = 'limit'
		OR `type` = 'disabled'
	ORDER BY `id` ASC;
");

$active = $error = $disabled = array();
foreach($banners as $banner) {
	// Format temporary titles
	$title = (strlen($banner->title) == 0) ? 'Advert '.$banner->id.' [temp]' : $banner->title;

	// Figure out the first and last time the ad should show
	$starttime = $stoptime = 0;
	$starttime = $wpdb->get_var("SELECT `starttime` FROM `{$wpdb->prefix}adrotate_schedule`, `{$wpdb->prefix}adrotate_linkmeta` WHERE `ad` = {$banner->id} AND `schedule` = `{$wpdb->prefix}adrotate_schedule`.`id` ORDER BY `starttime` ASC LIMIT 1;");
	$stoptime = $wpdb->get_var("SELECT `stoptime` FROM `{$wpdb->prefix}adrotate_schedule`, `{$wpdb->prefix}adrotate_linkmeta` WHERE `ad` = {$banner->id} AND  `schedule` = `{$wpdb->prefix}adrotate_schedule`.`id` ORDER BY `stoptime` DESC LIMIT 1;");

	// Figure out the specific advert type (status)
	$type = $banner->type;
	if($type == 'active' AND $stoptime <= $now) $type = 'expired';
	if($type == 'active' AND $stoptime <= $in2days) $type = '2days';
	if($type == 'active' AND $stoptime <= $in7days) $type = '7days';

	// Is there an advertiser?
	if($adrotate_config['enable_advertisers'] == 'Y') {
		$advertiser = $wpdb->get_var("SELECT `display_name` FROM `{$wpdb->prefix}adrotate_linkmeta`, `$wpdb->users` WHERE `$wpdb->users`.`id` = `{$wpdb->prefix}adrotate_linkmeta`.`user` AND `ad` = {$banner->id} AND `group` = 0 AND `schedule` = 0 LIMIT 1;");
	} else {
		$advertiser = '';
	}

	if($type == 'active' OR $type == '7days') {
		$active[$banner->id] = array(
			'id' => $banner->id,
			'title' => $title,
			'type' => $type,
			'tracker' => $banner->tracker,
			'weight' => $banner->weight,
			'autodelete' => $banner->autodelete,
			'autodisable' => $banner->autodisable,
			'desktop' => $banner->desktop,
			'mobile' => $banner->mobile,
			'tablet' => $banner->tablet,
			'budget' => $banner->budget,
			'crate' => $banner->crate,
			'irate' => $banner->irate,
			'firstactive' => $starttime,
			'lastactive' => $stoptime,
			'advertiser' => $advertiser
		);
	}

	if($type == 'error' OR $type == 'a_error' OR $type == 'expired' OR $type == '2days' OR $type == 'limit') {
		$error[$banner->id] = array(
			'id' => $banner->id,
			'title' => $title,
			'type' => $type,
			'tracker' => $banner->tracker,
			'weight' => $banner->weight,
			'desktop' => $banner->desktop,
			'mobile' => $banner->mobile,
			'tablet' => $banner->tablet,
			'firstactive' => $starttime,
			'lastactive' => $stoptime,
			'advertiser' => $advertiser
		);
	}

	if($type == 'disabled') {
		$disabled[$banner->id] = array(
			'id' => $banner->id,
			'title' => $title,
			'type' => $banner->type,
			'tracker' => $banner->tracker,
			'weight' => $banner->weight,
			'desktop' => $banner->desktop,
			'mobile' => $banner->mobile,
			'tablet' => $banner->tablet,
			'firstactive' => $starttime,
			'lastactive' => $stoptime,
			'advertiser' => $advertiser
		);
	}

	unset($banner, $title, $type, $starttime, $stoptime, $advertiser);
}

unset($banners);
?>

<?php
// Load dashboard part for ads with errors
if(count($error) > 0) include(plugin_dir_path(__FILE__).'manage-adverts-error.php');
?>

<h2><?php esc_html_e("Active Adverts", 'adrotate-pro'); ?></h2>

<form name="banners" id="post" method="post" action="admin.php?page=adrotate">
	<?php wp_nonce_field('adrotate_bulk_ads_active','adrotate_nonce'); ?>

	<div class="tablenav top">
		<div class="alignleft actions">
			<select name="adrotate_action" id="cat" class="postform">
		        <option value=""><?php esc_html_e("Bulk Actions", 'adrotate-pro'); ?></option>
		        <option value="duplicate"><?php esc_html_e("Duplicate", 'adrotate-pro'); ?></option>
		        <option value="deactivate"><?php esc_html_e("Deactivate", 'adrotate-pro'); ?></option>
		        <option value="archive"><?php esc_html_e("Archive (Permanently)", 'adrotate-pro'); ?></option>
		        <option value="trash"><?php esc_html_e("Move to Trash", 'adrotate-pro'); ?></option>
		        <option value="reset"><?php esc_html_e("Reset stats", 'adrotate-pro'); ?></option>
		        <option value="export-csv"><?php esc_html_e("Export to CSV", 'adrotate-pro'); ?></option>
		        <option value="" disabled><?php esc_html_e("-- Renew --", 'adrotate-pro'); ?></option>
		        <option value="renew-31536000"><?php esc_html_e("For 1 year", 'adrotate-pro'); ?></option>
		        <option value="renew-15552000"><?php esc_html_e("For 180 days", 'adrotate-pro'); ?></option>
		        <option value="renew-5184000"><?php esc_html_e("For 60 days", 'adrotate-pro'); ?></option>
		        <option value="renew-2592000"><?php esc_html_e("For 30 days", 'adrotate-pro'); ?></option>
		        <option value="renew-604800"><?php esc_html_e("For 7 days", 'adrotate-pro'); ?></option>
		        <option value="" disabled><?php esc_html_e("-- Weight --", 'adrotate-pro'); ?></option>
		        <option value="weight-2">2 - <?php esc_html_e("Barely visible", 'adrotate-pro'); ?></option>
		        <option value="weight-4">4 - <?php esc_html_e("Less than average", 'adrotate-pro'); ?></option>
		        <option value="weight-6">6 - <?php esc_html_e("Normal coverage", 'adrotate-pro'); ?></option>
		        <option value="weight-8">8 - <?php esc_html_e("More than average", 'adrotate-pro'); ?></option>
		        <option value="weight-10">10 - <?php esc_html_e("Best visibility", 'adrotate-pro'); ?></option>
			</select>
			<input type="submit" id="post-action-submit" name="adrotate_action_submit" value="<?php esc_html_e("Go", 'adrotate-pro'); ?>" class="button-secondary" />
		</div>
		<br class="clear" />
	</div>

	<table class="widefat tablesorter manage-ads-main" style="margin-top:.5em;">
		<thead>
		<tr>
			<td scope="col" class="manage-column column-cb check-column"><input type="checkbox" /></td>
			<th width="2%"><center><?php esc_html_e("ID", 'adrotate-pro'); ?></center></th>
			<th width="12%"><?php esc_html_e("Start date", 'adrotate-pro'); ?></th>
			<th width="12%"><?php esc_html_e("End date", 'adrotate-pro'); ?></th>
			<th><?php esc_html_e("Name", 'adrotate-pro'); ?></th>
			<?php if($adrotate_config['stats'] == 1) { ?>
				<th width="5%"><center><?php esc_html_e("Shown", 'adrotate-pro'); ?></center></th>
				<th width="5%"><center><?php esc_html_e("Today", 'adrotate-pro'); ?></center></th>
				<th width="5%"><center><?php esc_html_e("Clicks", 'adrotate-pro'); ?></center></th>
				<th width="5%"><center><?php esc_html_e("Today", 'adrotate-pro'); ?></center></th>
				<th width="7%"><center><?php esc_html_e("CTR", 'adrotate-pro'); ?></center></th>
			<?php } ?>
			<?php if($adrotate_config['stats'] > 1) { ?>
				<th width="7%"><center><?php esc_html_e("Stats", 'adrotate-pro'); ?></center></th>
			<?php } ?>
		</tr>
		</thead>
		<tbody>
	<?php
	if(count($active) > 0) {
		$tick = '<img src="'.adrotate_icon('tick').'" width="10" height"10" title="Enabled" />';
		$cross = '<img src="'.adrotate_icon('cross').'" width="10" height"10" title="Disabled" />';

		$class = '';
		foreach($active as $banner) {
			if($adrotate_config['stats'] == 1 AND $banner['tracker'] != 'N') {
				$stats = adrotate_stats($banner['id']);
				$stats_today = adrotate_stats($banner['id'], false, $today);
				$ctr = adrotate_ctr($stats['clicks'], $stats['impressions']);
			}

			$grouplist = adrotate_ad_is_in_groups($banner['id']);

			$class = ($class != 'alternate') ? 'alternate' : '';
			if($banner['type'] == '7days') $class .= ' row_orange';

			$mobile = '';
			if($banner['desktop'] == 'Y') {
				$mobile .= "<img src=\"".adrotate_icon('desktop')."\" width=\"12\" height=\"12\" title=\"Desktop\" />";
			}
			if($banner['mobile'] == 'Y') {
				$mobile .= "<img src=\"".adrotate_icon('mobile')."\" width=\"12\" height=\"12\" title=\"Mobile\" />";
			}
			if($banner['tablet'] == 'Y') {
				$mobile .= "<img src=\"".adrotate_icon('tablet')."\" width=\"12\" height=\"12\" title=\"Tablet\" />";
			}
			?>

		    <tr id="adrotateindex" class="<?php echo $class; ?>">
				<th class="check-column"><input type="checkbox" name="bannercheck[]" value="<?php echo $banner['id']; ?>" /></th>
				<td><center><?php echo $banner['id'];?></center></td>
				<td data-sort-value="<?php echo $banner['firstactive']; ?>"><?php echo date_i18n('F d, Y', $banner['firstactive']); ?></td>
				<td data-sort-value="<?php echo $banner['lastactive']; ?>"><span style="color: <?php echo adrotate_prepare_color($banner['lastactive']);?>;"><?php echo date_i18n('F d, Y', $banner['lastactive']);?></span></td>
				<td>
					<strong><a class="row-title" href="<?php echo admin_url('/admin.php?page=adrotate&view=edit&ad='.$banner['id']);?>" title="<?php esc_html_e("Edit", 'adrotate-pro'); ?>"><?php echo stripslashes($banner['title']);?></a></strong> <?php if($adrotate_config['stats'] == 1 AND $banner['tracker'] != 'N') { ?>- <a href="<?php echo admin_url('/admin.php?page=adrotate-statistics&view=advert&id='.$banner['id']);?>" title="<?php esc_html_e("Stats", 'adrotate-pro'); ?>"><?php esc_html_e("Stats", 'adrotate-pro'); ?></a><?php } ?>
					<span style="color:#999;">
						<br /><strong><?php echo esc_html__("Devices:", 'adrotate-pro'); ?></strong> <?php echo $mobile; ?>, <strong><?php echo esc_html__("Weight:", 'adrotate-pro'); ?></strong> <?php echo $banner['weight']; ?>, <strong><?php esc_html_e("Auto Delete:", 'adrotate-pro'); ?></strong> <?php echo ($banner['autodelete'] == 'Y') ? $tick : $cross; ?>, <strong><?php esc_html_e("Auto Disable:", 'adrotate-pro'); ?></strong> <?php echo ($banner['autodisable'] == 'Y') ? $tick : $cross; ?>
						<?php if(strlen($grouplist) > 0) echo "<br /><span style=\"font-weight:bold;\">".esc_html__("Groups:", 'adrotate-pro')."</span> ".$grouplist; ?>
						<?php if(!empty($banner['advertiser']) AND $adrotate_config['enable_advertisers'] == 'Y') echo "<br /><span style=\"font-weight:bold;\">".esc_html__("Advertiser:", 'adrotate-pro')."</span> ".$banner['advertiser'];
						if($banner['crate'] > 0 OR $banner['irate'] > 0) { echo " <span style=\"font-weight:bold;\">".esc_html__("Budget:", 'adrotate-pro')."</span> ".number_format($banner['budget'], 2, '.', '')." - ".esc_html__("CPC:", 'adrotate-pro')." ".number_format($banner['crate'], 2, '.', '')." - ".esc_html__("CPM:", 'adrotate-pro')." ".number_format($banner['irate'], 2, '.', ''); } ?>
				</td>
				<?php if($adrotate_config['stats'] == 1 AND $banner['tracker'] != 'N') { ?>
					<td><center><?php echo $stats['impressions']; ?></center></td>
					<td><center><?php echo $stats_today['impressions']; ?></center></td>
					<td><center><?php echo $stats['clicks']; ?></center></td>
					<td><center><?php echo $stats_today['clicks']; ?></center></td>
					<td><center><?php echo $ctr; ?> %</center></td>
				<?php } else if($adrotate_config['stats'] > 1) { ?>
					<td><center><?php echo ($banner['tracker'] != 'N') ? $tick : $cross; ?></center></td>
				<?php } else { ?>
					<td><center>&hellip;</center></td>
					<td><center>&hellip;</center></td>
					<td><center>&hellip;</center></td>
					<td><center>&hellip;</center></td>
					<td><center>&hellip;</center></td>
				<?php } ?>
			</tr>
		<?php
			unset($banner, $stats, $stats_today, $ctr, $grouplist, $mobile);
		}
		?>
	<?php } else { ?>
		<tr id='no-adverts'>
			<th class="check-column">&nbsp;</th>
			<td colspan="<?php echo ($adrotate_config['stats'] == 1) ? '8' : '4'; ?>"><em><?php esc_html_e("No adverts created yet!", 'adrotate-pro'); ?></em></td>
		</tr>
	<?php } ?>
	</tbody>
</table>
<p><center>
	<span style="border: 1px solid #c80; height: 12px; width: 12px; background-color: #fdefc3">&nbsp;&nbsp;&nbsp;&nbsp;</span> <?php esc_html_e("Expires soon", 'adrotate-pro'); ?>
</center></p>

</form>

<?php
// Load dashboard part for disabled ads
if(count($disabled) > 0) include(plugin_dir_path(__FILE__).'manage-adverts-disabled.php');
?>
