<?php
/* ------------------------------------------------------------------------------------
*  COPYRIGHT AND TRADEMARK NOTICE
*  Copyright 2008-2026 Arnan de Gans. All Rights Reserved.
*  The software AdRotate, related services and ADROTATE the name are owned by Arnan de Gans.

*  COPYRIGHT NOTICES AND ALL THE COMMENTS SHOULD REMAIN INTACT.
*  By using this code you agree to indemnify Arnan de Gans from any
*  liability that might arise from its use.
------------------------------------------------------------------------------------ */

if(!$group_edit_id) {
	$edit_id = $wpdb->get_var("SELECT `id` FROM `{$wpdb->prefix}adrotate_groups` WHERE `name` = '' ORDER BY `id` DESC LIMIT 1;");
	if($edit_id == 0) {
		$wpdb->insert($wpdb->prefix.'adrotate_groups', array('name' => '', 'modus' => 0, 'fallback' => '0', 'cat' => '', 'cat_loc' => 0, 'cat_par' => 0, 'page' => '', 'page_loc' => 0, 'page_par' => 0, 'woo_cat' => '', 'woo_loc' => 0, 'bbpress' => '', 'bbpress_loc' => 0, 'mobile' => 0, 'geo' => 0, 'wrapper_before' => '', 'wrapper_after' => '', 'gridrows' => 2, 'gridcolumns' => 2, 'admargin' => 0, 'admargin_bottom' => 0, 'admargin_left' => 0, 'admargin_right' => 0, 'adwidth' => '728', 'adheight' => '90', 'adspeed' => 6000, 'repeat_impressions' => 'Y'));
	    $edit_id = $wpdb->insert_id;
	}
	$group_edit_id = $edit_id;
}

$edit_group = $wpdb->get_row("SELECT * FROM `{$wpdb->prefix}adrotate_groups` WHERE `id` = {$group_edit_id};");

if($edit_group) {
	$groups = $wpdb->get_results("SELECT `id`, `name` FROM `{$wpdb->prefix}adrotate_groups` WHERE `name` != '' ORDER BY `id` ASC;");
	$banners = $wpdb->get_results("SELECT `id`, `title`, `type`, `tracker`, `desktop`, `mobile`, `tablet`, `weight`, `crate`, `budget`, `irate` FROM `{$wpdb->prefix}adrotate` WHERE (`type` != 'empty' AND `type` != 'a_empty' AND `type` != 'archived' AND `type` != 'trash' AND `type` != 'generator') ORDER BY `id` ASC;");

	// Which ads are in the group?
	$bannermeta = $wpdb->get_results("SELECT `ad` FROM `{$wpdb->prefix}adrotate_linkmeta` WHERE `group` = {$edit_group->id} AND `user` = 0 AND `schedule` = 0;");

	$banner_array = array();
	foreach($bannermeta as $meta) {
		$banner_array[] = $meta->ad;
		unset($meta);
	}

	if($group_edit_id AND $edit_group->name != '') {
		// Errors
		if($edit_group->modus == 2 AND $edit_group->gridrows == 1 AND $edit_group->gridcolumns == 1)
			echo "<div class=\"error\"><p>". esc_html__("Your block is a 1x1 grid. Either add more rows or columns or set the group to Default mode.", 'adrotate-pro')."</p></div>";

		if($edit_group->cat_loc > 0 AND strlen($edit_group->cat) == 0)
			echo "<div class=\"error\"><p>". esc_html__("You have enabled Post Injection but did not select any categories.", 'adrotate-pro')."</p></div>";

		if($edit_group->page_loc > 0 AND strlen($edit_group->page) == 0)
			echo "<div class=\"error\"><p>". esc_html__("You have enabled Page Injection but did not select any pages.", 'adrotate-pro')."</p></div>";

		if($edit_group->woo_loc > 0 AND strlen($edit_group->woo_cat) == 0)
			echo "<div class=\"error\"><p>". esc_html__("You have enabled Post Injection but did not select any WooCommerce categories.", 'adrotate-pro')."</p></div>";

		if($edit_group->bbpress_loc > 0 AND strlen($edit_group->bbpress) == 0)
			echo "<div class=\"error\"><p>". esc_html__("You have enabled Page Injection but did not select any bbPress forums.", 'adrotate-pro')."</p></div>";
	}
	?>

	<form name="editgroup" id="post" method="post" action="admin.php?page=adrotate-groups">
		<?php wp_nonce_field('adrotate_save_group','adrotate_nonce'); ?>
		<input type="hidden" name="adrotate_id" value="<?php echo $edit_group->id;?>" />

		<?php if($edit_group->name == '') { ?>
			<h2><?php esc_html_e("New Group", 'adrotate-pro'); ?></h2>
		<?php } else { ?>
			<h2><?php esc_html_e("Edit Group", 'adrotate-pro'); ?></h2>
		<?php } ?>

	   	<table class="widefat" style="margin-top:.5em;">

			<tbody>
		    <tr>
				<th width="15%"><?php esc_html_e("Name", 'adrotate-pro'); ?></th>
				<td width="35%">
					<label for="adrotate_groupname"><input tabindex="1" name="adrotate_groupname" type="text" class="ajdg-fullwidth ajdg-inputfield" size="50" value="<?php echo stripslashes($edit_group->name); ?>" autocomplete="off" /></label>
				</td>
				<td>
					<em><?php esc_html_e("Visible on the Advertiser dashboard!", 'adrotate-pro'); ?></em>
				</td>
			</tr>
		    <tr>
				<th valign="top"><?php esc_html_e("Mode", 'adrotate-pro'); ?></strong></th>
				<td>
			       	<select tabindex="2" name="adrotate_modus" class="ajdg-fullwidth">
			        	<option value="0" <?php if($edit_group->modus == 0) { echo 'selected'; } ?>><?php esc_html_e("Default - Show one ad at a time", 'adrotate-pro'); ?></option>
			        	<option value="1" <?php if($edit_group->modus == 1) { echo 'selected'; } ?>><?php esc_html_e("Dynamic Mode - Show a different ad every few seconds", 'adrotate-pro'); ?></option>
			        	<option value="2" <?php if($edit_group->modus == 2) { echo 'selected'; } ?>><?php esc_html_e("Block Mode - Show a block of adverts", 'adrotate-pro'); ?></option>
			        	<option value="3" <?php if($edit_group->modus == 3) { echo 'selected'; } ?>><?php esc_html_e("Wallpaper Mode - Show a wallpaper advert (Advanced)", 'adrotate-pro'); ?></option>
			        </select>
				</td>
				<td>
			        <p><em><?php esc_html_e("Dynamic mode requires jQuery. Enable this in AdRotate Settings if your theme does not load it.", 'adrotate-pro'); ?></em></p>
				</td>
			</tr>
		    <tr>
				<th valign="top"><?php esc_html_e("Advert size", 'adrotate-pro'); ?></strong></th>
				<td width="35%">
					<label for="adrotate_adwidth"><input tabindex="3" name="adrotate_adwidth" type="text" class="ajdg-inputfield" size="3" value="<?php echo $edit_group->adwidth; ?>" autocomplete="off" /> <?php esc_html_e("px wide", 'adrotate-pro'); ?>,</label> <label for="adrotate_adheight"><input tabindex="4" name="adrotate_adheight" type="text" class="ajdg-inputfield" size="3" value="<?php echo $edit_group->adheight; ?>" autocomplete="off" /> <?php esc_html_e("px high.", 'adrotate-pro'); ?></label>
				</td>
				<td>
			        <em><?php esc_html_e("Define the maximum size of the adverts in pixels. Size can be \'auto\' (Not recommended).", 'adrotate-pro'); ?> <?php esc_html_e("The size will be visible in management and is for reference when in default mode.", 'adrotate-pro'); ?></em>
				</td>
			</tr>
			</tbody>
		</table>

		<h2><?php esc_html_e("Dynamic and Block Mode", 'adrotate-pro'); ?></h2>
	   	<table class="widefat" style="margin-top:.5em;">

			<tbody>
		    <tr>
				<th width="15%"><?php esc_html_e("Block size", 'adrotate-pro'); ?></strong></th>
				<td width="35%">
			       	<label for="adrotate_gridrows"><select tabindex="5" name="adrotate_gridrows">
				       	<?php for($rows=1;$rows<=32;$rows++) { ?>
			        	<option value="<?php echo $rows; ?>" <?php if($edit_group->gridrows == $rows) { echo 'selected'; } ?>><?php echo $rows; ?></option>
						<?php } ?>
			        </select> <?php esc_html_e("rows", 'adrotate-pro'); ?>,</label> <label for="adrotate_gridcolumns"><select tabindex="6" name="adrotate_gridcolumns">
				       	<?php for($columns=1;$columns<=12;$columns++) { ?>
			        	<option value="<?php echo $columns; ?>" <?php if($edit_group->gridcolumns == $columns) { echo 'selected'; } ?>><?php echo $columns; ?></option>
						<?php } ?>
			        </select> <?php esc_html_e("columns", 'adrotate-pro'); ?>.</label>
				</td>
				<td>
			        <em><?php esc_html_e("Block Mode", 'adrotate-pro'); ?> - <?php esc_html_e("Larger blocks will degrade your sites performance! Default: 2/2.", 'adrotate-pro'); ?></em>
				</td>
			</tr>
		    <tr>
				<th valign="top"><?php esc_html_e("Automatic refresh", 'adrotate-pro'); ?></strong></th>
				<td>
			       	<label for="adrotate_adspeed"><select tabindex="7" name="adrotate_adspeed">
			        	<option value="3000" <?php if($edit_group->adspeed == 3000) { echo 'selected'; } ?>>3</option>
			        	<option value="4000" <?php if($edit_group->adspeed == 4000) { echo 'selected'; } ?>>4</option>
			        	<option value="5000" <?php if($edit_group->adspeed == 5000) { echo 'selected'; } ?>>5</option>
			        	<option value="6000" <?php if($edit_group->adspeed == 6000) { echo 'selected'; } ?>>6</option>
			        	<option value="7000" <?php if($edit_group->adspeed == 7000) { echo 'selected'; } ?>>7</option>
			        	<option value="8000" <?php if($edit_group->adspeed == 8000) { echo 'selected'; } ?>>8</option>
			        	<option value="9000" <?php if($edit_group->adspeed == 9000) { echo 'selected'; } ?>>9</option>
			        	<option value="10000" <?php if($edit_group->adspeed == 10000) { echo 'selected'; } ?>>10</option>
			        	<option value="12000" <?php if($edit_group->adspeed == 12000) { echo 'selected'; } ?>>12</option>
			        	<option value="15000" <?php if($edit_group->adspeed == 15000) { echo 'selected'; } ?>>15</option>
			        	<option value="20000" <?php if($edit_group->adspeed == 20000) { echo 'selected'; } ?>>20</option>
			        	<option value="25000" <?php if($edit_group->adspeed == 25000) { echo 'selected'; } ?>>25</option>
			        	<option value="35000" <?php if($edit_group->adspeed == 35000) { echo 'selected'; } ?>>35</option>
			        	<option value="45000" <?php if($edit_group->adspeed == 45000) { echo 'selected'; } ?>>45</option>
			        	<option value="60000" <?php if($edit_group->adspeed == 60000) { echo 'selected'; } ?>>60</option>
			        	<option value="90000" <?php if($edit_group->adspeed == 90000) { echo 'selected'; } ?>>90</option>
			        </select> <?php esc_html_e("seconds.", 'adrotate-pro'); ?></label>
				</td>
				<td>
			        <em><?php esc_html_e("Dynamic Mode", 'adrotate-pro'); ?> - <?php esc_html_e("Load a new advert in this interval without reloading the page. Default: 6.", 'adrotate-pro'); ?></em>
				</td>
			</tr>
			<tr>
				<th valign="top"><?php esc_html_e("Repeat impressions", 'adrotate-pro'); ?></th>
				<td>
					<label for="adrotate_repeat_impressions"><input type="checkbox" name="adrotate_repeat_impressions" id="adrotate_repeat_impressions" <?php if($edit_group->repeat_impressions == 'Y') { ?>checked="checked" <?php } ?> /> <?php esc_html_e("Count impressions for every cycle of adverts?", 'adrotate-pro'); ?></label>
				</td>
				<td>
					<em><?php esc_html_e("Dynamic Mode", 'adrotate-pro'); ?> - <?php esc_html_e("Uncheck this option to only count impressions for the first cycle of adverts.", 'adrotate-pro'); ?></em>
				</td>
			</tr>
			</tbody>
		</table>

		<h2><?php esc_html_e("Usage", 'adrotate-pro'); ?></h2>
	   	<table class="widefat" style="margin-top:.5em;">
			<tbody>
			<tr>
		        <th width="15%"><?php esc_html_e("Widget", 'adrotate-pro'); ?></th>
		        <td colspan="3"><?php esc_html_e("Drag the AdRotate widget to the sidebar where you want to place the group and select the group.", 'adrotate-pro'); ?></td>
	    	</tr>
			<tr>
		        <th width="15%"><?php esc_html_e("In a post or page", 'adrotate-pro'); ?></th>
		        <td width="35%">[adrotate group="<?php echo $edit_group->id; ?>"]</td>
		        <th width="15%"><?php esc_html_e("Directly in a theme", 'adrotate-pro'); ?></th>
		        <td width="35%">&lt;?php echo adrotate_group(<?php echo $edit_group->id; ?>); ?&gt;</td>
	      	</tr>
	      	</tbody>
		</table>

		<p class="submit">
			<input tabindex="8" type="submit" name="adrotate_group_submit" class="button-primary" value="<?php esc_html_e("Save Group", 'adrotate-pro'); ?>" />
			<a href="admin.php?page=adrotate-groups" class="button"><?php esc_html_e("Cancel", 'adrotate-pro'); ?></a>
		</p>

		<h2><?php esc_html_e("Advanced", 'adrotate-pro'); ?></h2>
	   	<table class="widefat" style="margin-top:.5em;">
		    <tr>
				<th width="15%" valign="top"><?php esc_html_e("Advert Margin", 'adrotate-pro'); ?></strong></th>
				<td width="35%">
					<label for="adrotate_admargin_top">Top: <input tabindex="9" name="adrotate_admargin_top" type="text" class="ajdg-inputfield" size="3" value="<?php echo $edit_group->admargin; ?>" autocomplete="off" />
					Bottom: <input tabindex="10" name="adrotate_admargin_bottom" type="text" class="ajdg-inputfield" size="3" value="<?php echo $edit_group->admargin_bottom; ?>" autocomplete="off" /> <?php esc_html_e("pixel(s)", 'adrotate-pro'); ?>.<br />
					Left: <input tabindex="11" name="adrotate_admargin_left" type="text" class="ajdg-inputfield" size="3" value="<?php echo $edit_group->admargin_left; ?>" autocomplete="off" />
					Right: <input tabindex="12" name="adrotate_admargin_right" type="text" class="ajdg-inputfield" size="3" value="<?php echo $edit_group->admargin_right; ?>" autocomplete="off" /> <?php esc_html_e("pixel(s)", 'adrotate-pro'); ?>.</label>
				</td>
				<td>
			        <em><?php esc_html_e("A transparent area outside the advert in pixels. Default: 0/0/0/0.", 'adrotate-pro'); ?> <?php esc_html_e("Set to 0 to disable.", 'adrotate-pro'); ?> <?php esc_html_e("Margins are automatically disabled for blocks where required.", 'adrotate-pro'); ?></em>
				</td>
			</tr>
		    <tr>
				<th valign="top"><?php esc_html_e("Align the group", 'adrotate-pro'); ?></strong></th>
				<td>
			       	<label for="adrotate_align"><select tabindex="13" name="adrotate_align">
			        	<option value="0" <?php if($edit_group->align == 0) { echo 'selected'; } ?>><?php esc_html_e("None (Default)", 'adrotate-pro'); ?></option>
			        	<option value="1" <?php if($edit_group->align == 1) { echo 'selected'; } ?>><?php esc_html_e("Left", 'adrotate-pro'); ?></option>
			        	<option value="2" <?php if($edit_group->align == 2) { echo 'selected'; } ?>><?php esc_html_e("Right", 'adrotate-pro'); ?></option>
			        	<option value="3" <?php if($edit_group->align == 3) { echo 'selected'; } ?>><?php esc_html_e("Center", 'adrotate-pro'); ?></option>
			        </select></label>
				</td>
				<td>
			        <em><?php esc_html_e("Align the group in your post or page. Using \'center\' may affect your margin setting. Not every theme supports this feature.", 'adrotate-pro'); ?></em>
				</td>
			</tr>
			<?php if($adrotate_config['enable_geo'] > 0) { ?>
		    <tr>
				<th width="15%" valign="top"><?php esc_html_e("Geo Targeting", 'adrotate-pro'); ?></th>
				<td width="35%">
					<label for="adrotate_geo"><input tabindex="14" type="checkbox" name="adrotate_geo" id="adrotate_geo" value="1" <?php if($edit_group->geo == '1') { ?>checked="checked"<?php } ?> /> <?php esc_html_e("Enable Geo Targeting for this group.", 'adrotate-pro'); ?></label>
				</td>
				<td>
					<em><?php esc_html_e("Do not forget to set up Geo Targeting for your adverts as well.", 'adrotate-pro'); ?></em>
				</td>
			</tr>
			<?php } ?>
		    <tr>
				<th width="15%" valign="top"><?php esc_html_e("Mobile support", 'adrotate-pro'); ?></th>
				<td width="35%">
					<label for="adrotate_mobile"><input tabindex="15" type="checkbox" name="adrotate_mobile" id="adrotate_mobile" value="1" <?php if($edit_group->mobile == '1') { ?>checked="checked"<?php } ?> /> <?php esc_html_e("Enable mobile support for this group.", 'adrotate-pro'); ?></label>
				</td>
				<td>
					<em><?php esc_html_e("Do not forget to put at least one mobile advert in this group or no adverts may show.", 'adrotate-pro'); ?></em>
				</td>
			</tr>
		    <tr>
				<th valign="top"><?php esc_html_e("Fallback group", 'adrotate-pro'); ?></th>
				<td>
					<label for="adrotate_fallback">
					<select tabindex="16" name="adrotate_fallback">
			        <option value="0"><?php esc_html_e("No", 'adrotate-pro'); ?></option>
				<?php if($groups) { ?>
					<?php foreach($groups as $group) { ?>
						<?php if($group->id == $edit_group->id) continue; ?>
				        <option value="<?php echo $group->id;?>" <?php if($edit_group->fallback == $group->id) { echo 'selected'; } ?>><?php echo $group->id;?> - <?php echo $group->name;?></option>
		 			<?php } ?>
				<?php } ?>
					</select>
				</td>
		        <td>
			        <em><?php esc_html_e("Select another group to fall back on when all adverts are expired, not in the visitors geographic area or are otherwise unavailable.", 'adrotate-pro'); ?></em>
				</td>
			</tr>
			</tbody>
		</table>

		<h2><?php esc_html_e("Post Injection", 'adrotate-pro'); ?></h2>
	   	<p><em><?php esc_html_e("Do not create groups doing that add adverts in (almost) the same location or too many adverts may show on posts or pages causing overlaps and double showings. Also make sure to not choose settings that saturate the content with adverts or it may become hard to read. Use with care!", 'adrotate-pro'); ?></em></p>
		<div id="dashboard-widgets-wrap">
			<div id="dashboard-widgets" class="metabox-holder">
				<div id="left-column" class="ajdg-postbox-container">

					<div class="ajdg-postbox">
						<h2 class="ajdg-postbox-title"><?php esc_html_e("For posts", 'adrotate-pro'); ?></h2>
						<div id="postinjection" class="ajdg-postbox-content">
							<p><label for="adrotate_cat_location">
							    <select tabindex="18" name="adrotate_cat_location">
							    	<option value="0" <?php if($edit_group->cat_loc == 0) { echo 'selected'; } ?>><?php esc_html_e("Disabled", 'adrotate-pro'); ?></option>
							    	<option value="5" <?php if($edit_group->cat_loc == 5) { echo 'selected'; } ?>><?php esc_html_e("Widget", 'adrotate-pro'); ?></option>
							    	<option value="1" <?php if($edit_group->cat_loc == 1) { echo 'selected'; } ?>><?php esc_html_e("Before content", 'adrotate-pro'); ?></option>
							    	<option value="2" <?php if($edit_group->cat_loc == 2) { echo 'selected'; } ?>><?php esc_html_e("After content", 'adrotate-pro'); ?></option>
							    	<option value="3" <?php if($edit_group->cat_loc == 3) { echo 'selected'; } ?>><?php esc_html_e("Before and after content", 'adrotate-pro'); ?></option>
							    	<option value="4" <?php if($edit_group->cat_loc == 4) { echo 'selected'; } ?>><?php esc_html_e("Inside the content...", 'adrotate-pro'); ?></option>
							    </select>
							</label>
							<label for="adrotate_cat_paragraph">
							    <select tabindex="19" name="adrotate_cat_paragraph">
							    	<option value="0" <?php if($edit_group->cat_par == 0) { echo 'selected'; } ?>>...</option>
							    	<option value="99" <?php if($edit_group->cat_par == 99) { echo 'selected'; } ?>><?php esc_html_e("after the middle paragraph", 'adrotate-pro'); ?></option>
							    	<option value="110" <?php if($edit_group->cat_par == 110) { echo 'selected'; } ?>><?php esc_html_e("after about a 3rd of the content", 'adrotate-pro'); ?></option>
							    	<option value="111" <?php if($edit_group->cat_par == 111) { echo 'selected'; } ?>><?php esc_html_e("after about 2/3rds of the content", 'adrotate-pro'); ?></option>
							    	<option value="100" <?php if($edit_group->cat_par == 100) { echo 'selected'; } ?>><?php esc_html_e("every 3 paragraphs", 'adrotate-pro'); ?></option>
							    	<option value="101" <?php if($edit_group->cat_par == 101) { echo 'selected'; } ?>><?php esc_html_e("every 4 paragraphs", 'adrotate-pro'); ?></option>
							    	<option value="102" <?php if($edit_group->cat_par == 102) { echo 'selected'; } ?>><?php esc_html_e("every 5 paragraphs", 'adrotate-pro'); ?></option>
							    	<option value="103" <?php if($edit_group->cat_par == 103) { echo 'selected'; } ?>><?php esc_html_e("every 6 paragraphs", 'adrotate-pro'); ?></option>
							    	<option value="104" <?php if($edit_group->cat_par == 104) { echo 'selected'; } ?>><?php esc_html_e("every 7 paragraphs", 'adrotate-pro'); ?></option>
							    	<option value="105" <?php if($edit_group->cat_par == 105) { echo 'selected'; } ?>><?php esc_html_e("every 8 paragraphs", 'adrotate-pro'); ?></option>
							    	<option value="1" <?php if($edit_group->cat_par == 1) { echo 'selected'; } ?>><?php esc_html_e("after the 1st paragraph", 'adrotate-pro'); ?></option>
							    	<option value="2" <?php if($edit_group->cat_par == 2) { echo 'selected'; } ?>><?php esc_html_e("after the 2nd paragraph", 'adrotate-pro'); ?></option>
							    	<option value="3" <?php if($edit_group->cat_par == 3) { echo 'selected'; } ?>><?php esc_html_e("after the 3rd paragraph", 'adrotate-pro'); ?></option>
							    	<option value="4" <?php if($edit_group->cat_par == 4) { echo 'selected'; } ?>><?php esc_html_e("after the 4th paragraph", 'adrotate-pro'); ?></option>
							    	<option value="5" <?php if($edit_group->cat_par == 5) { echo 'selected'; } ?>><?php esc_html_e("after the 5th paragraph", 'adrotate-pro'); ?></option>
							    	<option value="6" <?php if($edit_group->cat_par == 6) { echo 'selected'; } ?>><?php esc_html_e("after the 6th paragraph", 'adrotate-pro'); ?></option>
							    	<option value="7" <?php if($edit_group->cat_par == 7) { echo 'selected'; } ?>><?php esc_html_e("after the 7th paragraph", 'adrotate-pro'); ?></option>
							    	<option value="8" <?php if($edit_group->cat_par == 8) { echo 'selected'; } ?>><?php esc_html_e("after the 8th paragraph", 'adrotate-pro'); ?></option>
							    	<option value="10" <?php if($edit_group->cat_par == 10) { echo 'selected'; } ?>><?php esc_html_e("after the 10th paragraph", 'adrotate-pro'); ?></option>
							    	<option value="12" <?php if($edit_group->cat_par == 12) { echo 'selected'; } ?>><?php esc_html_e("after the 12th paragraph", 'adrotate-pro'); ?></option>
							    	<option value="14" <?php if($edit_group->cat_par == 14) { echo 'selected'; } ?>><?php esc_html_e("after the 14th paragraph", 'adrotate-pro'); ?></option>
							    	<option value="16" <?php if($edit_group->cat_par == 16) { echo 'selected'; } ?>><?php esc_html_e("after the 16th paragraph", 'adrotate-pro'); ?></option>
							    	<option value="18" <?php if($edit_group->cat_par == 18) { echo 'selected'; } ?>><?php esc_html_e("after the 18th paragraph", 'adrotate-pro'); ?></option>
							    	<option value="20" <?php if($edit_group->cat_par == 20) { echo 'selected'; } ?>><?php esc_html_e("after the 20th paragraph", 'adrotate-pro'); ?></option>
							    </select>
							</label></p>
							<p><strong><?php esc_html_e("Select post categories", 'adrotate-pro'); ?></strong></p>
							<div class="adrotate-select">
								<?php echo adrotate_select_categories($edit_group->cat, 0, 0, 0); ?>
							</div>
						</div>
					</div>

				</div>
				<div id="right-column" class="ajdg-postbox-container">

					<div class="ajdg-postbox">
						<h2 class="ajdg-postbox-title"><?php esc_html_e("For pages", 'adrotate-pro'); ?></h2>
						<div id="pageinjection" class="ajdg-postbox-content">
							<p><label for="adrotate_page_location">
						        <select tabindex="20" name="adrotate_page_location">
						        	<option value="0" <?php if($edit_group->page_loc == 0) { echo 'selected'; } ?>><?php esc_html_e("Disabled", 'adrotate-pro'); ?></option>
						        	<option value="5" <?php if($edit_group->page_loc == 5) { echo 'selected'; } ?>><?php esc_html_e("Widget", 'adrotate-pro'); ?></option>
						        	<option value="1" <?php if($edit_group->page_loc == 1) { echo 'selected'; } ?>><?php esc_html_e("Before content", 'adrotate-pro'); ?></option>
						        	<option value="2" <?php if($edit_group->page_loc == 2) { echo 'selected'; } ?>><?php esc_html_e("After content", 'adrotate-pro'); ?></option>
						        	<option value="3" <?php if($edit_group->page_loc == 3) { echo 'selected'; } ?>><?php esc_html_e("Before and after content", 'adrotate-pro'); ?></option>
						        	<option value="4" <?php if($edit_group->page_loc == 4) { echo 'selected'; } ?>><?php esc_html_e("Inside the content...", 'adrotate-pro'); ?></option>
						        </select>
							</label>
					        <label for="adrotate_page_paragraph">
						        <select tabindex="21" name="adrotate_page_paragraph">
						        	<option value="0" <?php if($edit_group->page_par == 0) { echo 'selected'; } ?>>...</option>
						        	<option value="99" <?php if($edit_group->page_par == 99) { echo 'selected'; } ?>><?php esc_html_e("after the middle paragraph", 'adrotate-pro'); ?></option>
							    	<option value="110" <?php if($edit_group->page_par == 110) { echo 'selected'; } ?>><?php esc_html_e("after about a 3rd of the content", 'adrotate-pro'); ?></option>
							    	<option value="111" <?php if($edit_group->page_par == 111) { echo 'selected'; } ?>><?php esc_html_e("after about 2/3rds of the content", 'adrotate-pro'); ?></option>
							    	<option value="100" <?php if($edit_group->page_par == 100) { echo 'selected'; } ?>><?php esc_html_e("every 3 paragraphs", 'adrotate-pro'); ?></option>
							    	<option value="101" <?php if($edit_group->page_par == 101) { echo 'selected'; } ?>><?php esc_html_e("every 4 paragraphs", 'adrotate-pro'); ?></option>
							    	<option value="102" <?php if($edit_group->page_par == 102) { echo 'selected'; } ?>><?php esc_html_e("every 5 paragraphs", 'adrotate-pro'); ?></option>
							    	<option value="103" <?php if($edit_group->page_par == 103) { echo 'selected'; } ?>><?php esc_html_e("every 6 paragraphs", 'adrotate-pro'); ?></option>
							    	<option value="104" <?php if($edit_group->page_par == 104) { echo 'selected'; } ?>><?php esc_html_e("every 7 paragraphs", 'adrotate-pro'); ?></option>
							    	<option value="105" <?php if($edit_group->page_par == 105) { echo 'selected'; } ?>><?php esc_html_e("every 8 paragraphs", 'adrotate-pro'); ?></option>
						        	<option value="1" <?php if($edit_group->page_par == 1) { echo 'selected'; } ?>><?php esc_html_e("after the 1st paragraph", 'adrotate-pro'); ?></option>
						        	<option value="2" <?php if($edit_group->page_par == 2) { echo 'selected'; } ?>><?php esc_html_e("after the 2nd paragraph", 'adrotate-pro'); ?></option>
						        	<option value="3" <?php if($edit_group->page_par == 3) { echo 'selected'; } ?>><?php esc_html_e("after the 3rd paragraph", 'adrotate-pro'); ?></option>
						        	<option value="4" <?php if($edit_group->page_par == 4) { echo 'selected'; } ?>><?php esc_html_e("after the 4th paragraph", 'adrotate-pro'); ?></option>
						        	<option value="5" <?php if($edit_group->page_par == 5) { echo 'selected'; } ?>><?php esc_html_e("after the 5th paragraph", 'adrotate-pro'); ?></option>
						        	<option value="6" <?php if($edit_group->page_par == 6) { echo 'selected'; } ?>><?php esc_html_e("after the 6th paragraph", 'adrotate-pro'); ?></option>
						        	<option value="7" <?php if($edit_group->page_par == 7) { echo 'selected'; } ?>><?php esc_html_e("after the 7th paragraph", 'adrotate-pro'); ?></option>
						        	<option value="8" <?php if($edit_group->page_par == 8) { echo 'selected'; } ?>><?php esc_html_e("after the 8th paragraph", 'adrotate-pro'); ?></option>
							    	<option value="10" <?php if($edit_group->page_par == 10) { echo 'selected'; } ?>><?php esc_html_e("after the 10th paragraph", 'adrotate-pro'); ?></option>
							    	<option value="12" <?php if($edit_group->page_par == 12) { echo 'selected'; } ?>><?php esc_html_e("after the 12th paragraph", 'adrotate-pro'); ?></option>
							    	<option value="14" <?php if($edit_group->page_par == 14) { echo 'selected'; } ?>><?php esc_html_e("after the 14th paragraph", 'adrotate-pro'); ?></option>
							    	<option value="16" <?php if($edit_group->page_par == 16) { echo 'selected'; } ?>><?php esc_html_e("after the 16th paragraph", 'adrotate-pro'); ?></option>
							    	<option value="18" <?php if($edit_group->page_par == 18) { echo 'selected'; } ?>><?php esc_html_e("after the 18th paragraph", 'adrotate-pro'); ?></option>
							    	<option value="20" <?php if($edit_group->page_par == 20) { echo 'selected'; } ?>><?php esc_html_e("after the 20th paragraph", 'adrotate-pro'); ?></option>
						        </select>
							</label></p>

							<p><strong><?php esc_html_e("Select pages", 'adrotate-pro'); ?></strong></p>
							<div class="adrotate-select">
								<?php echo adrotate_select_pages($edit_group->page, 0, 0, 0); ?>
							</div>
						</div>
					</div>

				</div>
			</div>
		</div>

		<div id="dashboard-widgets-wrap">
			<div id="dashboard-widgets" class="metabox-holder">
				<div id="left-column" class="ajdg-postbox-container">

					<?php if(is_plugin_active('woocommerce/woocommerce.php')) { ?>
					<div class="ajdg-postbox">
						<h2 class="ajdg-postbox-title"><?php esc_html_e("For WooCommerce products", 'adrotate-pro'); ?></h2>
						<div id="postinjection" class="ajdg-postbox-content">
							<p><label for="adrotate_woo_location">
							    <select tabindex="18" name="adrotate_woo_location">
							    	<option value="0" <?php if($edit_group->woo_loc == 0) { echo 'selected'; } ?>><?php esc_html_e("Disabled", 'adrotate-pro'); ?></option>
							    	<option value="1" <?php if($edit_group->woo_loc == 1) { echo 'selected'; } ?>><?php esc_html_e("Before content", 'adrotate-pro'); ?></option>
							    	<option value="2" <?php if($edit_group->woo_loc == 2) { echo 'selected'; } ?>><?php esc_html_e("After content", 'adrotate-pro'); ?></option>
							    	<option value="3" <?php if($edit_group->woo_loc == 3) { echo 'selected'; } ?>><?php esc_html_e("Before and after content", 'adrotate-pro'); ?></option>
							    </select>
							</label></p>
							<p><strong><?php esc_html_e("Select product categories", 'adrotate-pro'); ?></strong></p>
							<div class="adrotate-select">
								<?php echo adrotate_select_woo_categories($edit_group->woo_cat, 0, 0, 0); ?>
							</div>
						</div>
					</div>
					<?php } ?>

				</div>
				<div id="right-column" class="ajdg-postbox-container">

					<?php if(is_plugin_active('bbpress/bbpress.php')) { ?>
					<div class="ajdg-postbox">
						<h2 class="ajdg-postbox-title"><?php esc_html_e("For bbPress forum pages and topics", 'adrotate-pro'); ?></h2>
						<div id="pageinjection" class="ajdg-postbox-content">
							<p><label for="adrotate_bbpress_location">
						        <select tabindex="20" name="adrotate_bbpress_location">
						        	<option value="0" <?php if($edit_group->bbpress_loc == 0) { echo 'selected'; } ?>><?php esc_html_e("Disabled", 'adrotate-pro'); ?></option>
						        	<option value="1" <?php if($edit_group->bbpress_loc == 1) { echo 'selected'; } ?>><?php esc_html_e("Before content", 'adrotate-pro'); ?></option>
						        	<option value="2" <?php if($edit_group->bbpress_loc == 2) { echo 'selected'; } ?>><?php esc_html_e("After content", 'adrotate-pro'); ?></option>
						        	<option value="3" <?php if($edit_group->bbpress_loc == 3) { echo 'selected'; } ?>><?php esc_html_e("Before and after content", 'adrotate-pro'); ?></option>
						        </select>
							</label></p>

							<p><strong><?php esc_html_e("Select bbPress forums", 'adrotate-pro'); ?></strong></p>
							<div class="adrotate-select">
								<?php echo adrotate_select_bbpress_forums($edit_group->bbpress, 0, 0, 0); ?>
							</div>
						</div>
					</div>
					<?php } ?>

				</div>
			</div>
		</div>

	   	<div class="clear"></div>

		<h2><?php esc_html_e("Usage", 'adrotate-pro'); ?></h2>
	   	<table class="widefat" style="margin-top:.5em;">
			<tbody>
			<tr>
		        <th width="15%"><?php esc_html_e("Widget", 'adrotate-pro'); ?></th>
		        <td colspan="3"><?php esc_html_e("Drag the AdRotate widget to the sidebar where you want to place the group and select the group.", 'adrotate-pro'); ?></td>
	    	</tr>
			<tr>
		        <th width="15%"><?php esc_html_e("In a post or page", 'adrotate-pro'); ?></th>
		        <td width="35%">[adrotate group="<?php echo $edit_group->id; ?>"]</td>
		        <th width="15%"><?php esc_html_e("Directly in a theme", 'adrotate-pro'); ?></th>
		        <td width="35%">&lt;?php echo adrotate_group(<?php echo $edit_group->id; ?>); ?&gt;</td>
	      	</tr>
	      	</tbody>
		</table>

		<p class="submit">
			<input tabindex="22" type="submit" name="adrotate_group_submit" class="button-primary" value="<?php esc_html_e("Save Group", 'adrotate-pro'); ?>" />
			<a href="admin.php?page=adrotate-groups" class="button"><?php esc_html_e("Cancel", 'adrotate-pro'); ?></a>
		</p>

	   	<h2><?php esc_html_e("Wrapper code", 'adrotate-pro'); ?></h2>
	   	<p><em><?php esc_html_e("Wraps around each advert. HTML/JavaScript allowed, use with care!", 'adrotate-pro'); ?></em></p>
	   	<table class="widefat" style="margin-top:.5em;">

			<tbody>
		    <tr>
				<th width="15%" valign="top"><?php esc_html_e("Before advert", 'adrotate-pro'); ?></strong></th>
				<td width="35%"><textarea tabindex="23" name="adrotate_wrapper_before" rows="3" class="ajdg-fullwidth"><?php echo stripslashes($edit_group->wrapper_before); ?></textarea></td>
				<td>
			        <p><strong><?php esc_html_e("Example:", 'adrotate-pro'); ?></strong> <em>&lt;span style="background-color:#aaa;"&gt;</em></p>
			        <p><strong><?php esc_html_e("Options:", 'adrotate-pro'); ?></strong> <em>%id%</em></p>
				</td>
			</tr>
		    <tr>
				<th valign="top"><?php esc_html_e("After advert", 'adrotate-pro'); ?></strong></th>
				<td><textarea tabindex="24" name="adrotate_wrapper_after" rows="3" class="ajdg-fullwidth"><?php echo stripslashes($edit_group->wrapper_after); ?></textarea></td>
				<td>
					<p><strong><?php esc_html_e("Example:", 'adrotate-pro'); ?></strong> <em>&lt;/span&gt;</em></p>
				</td>
			</tr>
			</tbody>

		</table>

		<h2><?php esc_html_e("Select adverts", 'adrotate-pro'); ?></h2>
	   	<table class="widefat" style="margin-top:.5em;">
			<thead>
			<tr>
				<td width="2%" scope="col" class="manage-column column-cb check-column"><input type="checkbox" /></td>
				<th width="2%"><center><?php esc_html_e("ID", 'adrotate-pro'); ?></center></th>
				<th><?php esc_html_e("Name", 'adrotate-pro'); ?></th>
				<th width="5%"><center><?php esc_html_e("Device", 'adrotate-pro'); ?></center></th>
				<th width="15%"><?php esc_html_e("Visible until", 'adrotate-pro'); ?></th>
				<th width="5%"><center><?php esc_html_e("Weight", 'adrotate-pro'); ?></center></th>
				<th width="5%"><center><?php esc_html_e("Shown", 'adrotate-pro'); ?></center></th>
				<th width="5%"><center><?php esc_html_e("Clicks", 'adrotate-pro'); ?></center></th>
			</tr>
			</thead>

			<tbody>
			<?php if(count($banners) > 0) {
				$class = '';
				foreach($banners as $banner) {
					$stoptime = $wpdb->get_var("SELECT `stoptime` FROM `{$wpdb->prefix}adrotate_schedule`, `{$wpdb->prefix}adrotate_linkmeta` WHERE `ad` = {$banner->id} AND `schedule` = `{$wpdb->prefix}adrotate_schedule`.`id` ORDER BY `stoptime` DESC LIMIT 1;");

					if($adrotate_config['stats'] == 1 AND $banner->tracker != 'N') {
						$stats = adrotate_stats($banner->id);
					}

					$errorclass = '';
					if($banner->type == 'error' OR $banner->type == 'a_error') $errorclass = ' row_yellow';
					if($stoptime <= $in2days OR $stoptime <= $in7days) $errorclass = ' row_orange';
					if($stoptime <= $now OR (($banner->crate > 0 OR $banner->irate > 0) AND $banner->budget == 0)) $errorclass = ' row_red';

					$class = ('alternate' != $class) ? 'alternate' : '';
					$class = ($errorclass != '') ? $errorclass : $class;

					$mobile = '';
					if($banner->desktop == 'Y') {
						$mobile .= "<img src=\"".adrotate_icon('desktop')."\" width=\"12\" height=\"12\" title=\"Desktop\" />";
					}
					if($banner->mobile == 'Y') {
						$mobile .= "<img src=\"".adrotate_icon('mobile')."\" width=\"12\" height=\"12\" title=\"Mobile\" />";
					}
					if($banner->tablet == 'Y') {
						$mobile .= "<img src=\"".adrotate_icon('tablet')."\" width=\"12\" height=\"12\" title=\"Tablet\" />";
					}
					?>
				    <tr class="<?php echo $class; ?>">
						<th class="check-column"><input type="checkbox" name="adselect[]" value="<?php echo $banner->id; ?>" <?php if(in_array($banner->id, $banner_array)) echo "checked"; ?> /></th>
						<td><center><?php echo $banner->id; ?></center></td>
						<td><?php echo stripslashes($banner->title); ?></td>
						<td><center><?php echo $mobile; ?></center></td>
						<td><span style="color: <?php echo adrotate_prepare_color($stoptime);?>;"><?php echo date_i18n('F d, Y', $stoptime); ?></span></td>
						<td><center><?php echo $banner->weight; ?></center></td>
						<?php if($adrotate_config['stats'] == 1 AND $banner->tracker != 'N') { ?>
							<td><center><?php echo $stats['impressions']; ?></center></td>
							<td><center><?php echo $stats['clicks']; ?></center></td>
						<?php } else { ?>
							<td><center>--</center></td>
							<td><center>--</center></td>
						<?php } ?>
					</tr>
				<?php unset($stoptime, $stats);?>
	 			<?php } ?>
			<?php } else { ?>
			<tr>
				<th class="check-column">&nbsp;</th>
				<td colspan="7"><em><?php esc_html_e("No adverts created!", 'adrotate-pro'); ?></em></td>
			</tr>
			<?php } ?>
			</tbody>
		</table>

		<p><center>
			<span style="border: 1px solid #e6db55; height: 12px; width: 12px; background-color: #ffffe0">&nbsp;&nbsp;&nbsp;&nbsp;</span> <?php esc_html_e("Configuration errors", 'adrotate-pro'); ?>
			&nbsp;&nbsp;&nbsp;&nbsp;<span style="border: 1px solid #c80; height: 12px; width: 12px; background-color: #fdefc3">&nbsp;&nbsp;&nbsp;&nbsp;</span> <?php esc_html_e("Expires soon", 'adrotate-pro'); ?>
			&nbsp;&nbsp;&nbsp;&nbsp;<span style="border: 1px solid #c00; height: 12px; width: 12px; background-color: #ffebe8">&nbsp;&nbsp;&nbsp;&nbsp;</span> <?php esc_html_e("Expired", 'adrotate-pro'); ?>
		</center></p>

		<p class="submit">
			<input tabindex="25" type="submit" name="adrotate_group_submit" class="button-primary" value="<?php esc_html_e("Save Group", 'adrotate-pro'); ?>" />
			<a href="admin.php?page=adrotate-groups" class="button"><?php esc_html_e("Cancel", 'adrotate-pro'); ?></a>
		</p>

	</form>
<?php
} else {
	echo adrotate_error('error_loading_item');
}
?>
