<?php
/* ------------------------------------------------------------------------------------
*  COPYRIGHT AND TRADEMARK NOTICE
*  Copyright 2008-2026 Arnan de Gans. All Rights Reserved.
*  The software AdRotate, related services and ADROTATE the name are owned by Arnan de Gans.

*  COPYRIGHT NOTICES AND ALL THE COMMENTS SHOULD REMAIN INTACT.
*  By using this code you agree to indemnify Arnan de Gans from any
*  liability that might arise from its use.
------------------------------------------------------------------------------------ */
?>

<form name="settings" id="post" method="post" action="admin.php?page=adrotate-settings&tab=geo">
<?php wp_nonce_field('adrotate_settings','adrotate_nonce_settings'); ?>
<input type="hidden" name="adrotate_settings_tab" value="<?php echo $active_tab; ?>" />

<h1><?php _e("Geo Targeting", 'adrotate-pro'); ?></h1>

<div class="ajdg-box-wrap">
	<div class="ajdg-box-three">

		<div class="ajdg-box">
			<h2 class="ajdg-box-title"><?php _e("Geo Targeting service", 'adrotate-pro'); ?></h2>
			<div class="ajdg-box-content">

				<p><label for="adrotate_enable_geo">
					<strong><?php _e("Geo service to use:", 'adrotate-pro'); ?></strong> <span class="alignright"><select name="adrotate_enable_geo">
						<option value="0" <?php if($adrotate_config['enable_geo'] == 0) { echo 'selected'; } ?>><?php esc_html_e("Disabled", 'adrotate-pro'); ?></option>
						<option value="5" <?php if($adrotate_config['enable_geo'] == 5) { echo 'selected'; } ?>>AdRotate Geo</option>
						<option value="7" <?php if($adrotate_config['enable_geo'] == 7) { echo 'selected'; } ?>>ipstack</option>
						<option value="4" <?php if($adrotate_config['enable_geo'] == 4) { echo 'selected'; } ?>>MaxMind City</option>
						<option value="3" <?php if($adrotate_config['enable_geo'] == 3) { echo 'selected'; } ?>>MaxMind Country</option>
						<option value="6" <?php if($adrotate_config['enable_geo'] == 6) { echo 'selected'; } ?>>CloudFlare</option>
					</select></span>
				</label></p>
				
				<p>
					<strong>AdRotate Geo</strong> - <?php _e("30000 free lookups every day, uses GeoLite2 databases from MaxMind!", 'adrotate-pro'); ?><br />
					<strong><?php _e("Supports:", 'adrotate-pro'); ?></strong> <em>ipv4/ipv6, Countries, Cities, DMA codes, States and State ISO (3166-2) codes.</em><br />
					<strong><?php _e("Scalability:", 'adrotate-pro'); ?></strong> <em><?php _e("Suitable for small to medium sized websites.", 'adrotate-pro'); ?></em>
				</p>

				<p>
					<strong>ipstack</strong> (<a href="https://ipstack.com/product" target="_blank>"><?php _e("More info", 'adrotate-pro'); ?></a>) - <?php _e("10000 free lookups per month, requires account.", 'adrotate-pro'); ?><br />
					<strong><?php _e("Supports:", 'adrotate-pro'); ?></strong> <em>ipv4, Countries, Cities, DMA codes, States and State ISO (3166-2) codes.</em><br />
					<strong><?php _e("Scalability:", 'adrotate-pro'); ?></strong> <em><?php _e("Suitable for small to medium sized websites with a free account - Paid options available.", 'adrotate-pro'); ?></em>
				</p>

				<p>
					<strong>MaxMind GeoIP2</strong> (<a href="https://www.maxmind.com/en/geoip2-precision-city-service" target="_blank>"><?php _e("More info", 'adrotate-pro'); ?></a>)- <?php _e("The most accurate geo targeting available.", 'adrotate-pro'); ?><br />
					<strong><?php _e("Supports:", 'adrotate-pro'); ?></strong> <em>ipv4/ipv6, Countries, States, State ISO (3166-2) codes, Cities and DMA codes.</em><br />
					<strong><?php _e("Scalability:", 'adrotate-pro'); ?></strong> <em><?php _e("Suitable for any size website as long as you have lookups.", 'adrotate-pro'); ?></em>
				</p>
				
				<p>
					<strong>CloudFlare IP Geolocation</strong> - <?php _e("Basic geolocation included in every CloudFlare account.", 'adrotate-pro'); ?><br />
					<strong><?php _e("Supports:", 'adrotate-pro'); ?></strong> <em>ipv4/ipv6, Countries.</em><br />
					<strong><?php _e("Scalability:", 'adrotate-pro'); ?></strong> <em><?php _e("Suitable for any size website.", 'adrotate-pro'); ?></em>
				</p>

			</div>
		</div>

		<?php if($adrotate_config['enable_geo'] > 0) { ?>
		<div class="ajdg-box">
			<h2 class="ajdg-box-title"><?php _e("Your Geo Targeting Data", 'adrotate-pro'); ?></h2>
			<div class="ajdg-box-content">

				<p>
					<strong><?php _e("Lookups remaining:", 'adrotate-pro'); ?> <?php echo $adrotate_geo_requests; ?></strong><br />
					<small><?php _e("This number is provided by the geo service and not checked for accuracy. Not every geo service provides a quota.", 'adrotate-pro'); ?></small>
				</p>
				
				<p>
					<strong><?php echo "Your IP Address:"; ?></strong> <?php echo adrotate_get_remote_ip(); ?>
				</p>
				<pre><?php
					$adrotate_session = get_transient('adrotate_'.md5(adrotate_get_remote_ip()));			
					if(isset($adrotate_session['geo'])) {
						print_r($adrotate_session['geo']);
					} else {
						_e("No geo data found. Visit a page with a Geo Targeted advert on it to start a session.", 'adrotate-pro');
					}
				?></pre><br />
				<small><?php _e("When you change Geo Services the session needs to refresh. Wait for it to expire (~60 minutes) or click the reset button in the maintenance tab.", 'adrotate-pro'); ?></small>

			</div>
		</div>
		<?php } ?>

		<div class="ajdg-box">
			<h2 class="ajdg-box-title"><?php _e("MaxMind City/Country and ipstack", 'adrotate-pro'); ?></h2>
			<div class="ajdg-box-content">

				<p><label for="adrotate_geo_email">
					<strong><?php _e("User ID:", 'adrotate-pro'); ?></strong> <input tabindex="20" name="adrotate_geo_email" type="text" class="search-input" style="width:100%;" value="" autocomplete="off" />
					<br /><small><?php _e("Only used for MaxMind accounts.", 'adrotate-pro'); ?></small>
				</label></p>

				<p><label for="adrotate_geo_pass">
					<strong><?php _e("License Key/API Key:", 'adrotate-pro'); ?></strong> <input tabindex="30" name="adrotate_geo_pass" type="text" class="search-input" style="width:100%;" value="" autocomplete="off" />
					<br /><small><?php _e("Used for Maxmind and ipstack accounts.", 'adrotate-pro'); ?></small>
				</label></p>

			</div>
		</div>

		<div class="ajdg-box">
			<p class="submit">
			  	<input type="submit" name="adrotate_save_options" class="button-primary" value="<?php _e("Save settings", 'adrotate-pro'); ?>" tabindex="1000" />
			</p>
		</div>

	</div>
	<div class="ajdg-box-one">

		<?php include_once(dirname(__DIR__).'/sidebar.php'); ?>

	</div>
</div>

</form>