<?php
/* ------------------------------------------------------------------------------------
*  COPYRIGHT AND TRADEMARK NOTICE
*  Copyright 2008-2026 Arnan de Gans. All Rights Reserved.
*  The software AdRotate, related services and ADROTATE the name are owned by Arnan de Gans.

*  COPYRIGHT NOTICES AND ALL THE COMMENTS SHOULD REMAIN INTACT.
*  By using this code you agree to indemnify Arnan de Gans from any
*  liability that might arise from its use.
------------------------------------------------------------------------------------ */
?>
<form name="settings" id="post" method="post" action="admin.php?page=adrotate-settings&tab=license">
<?php wp_nonce_field('adrotate_license','adrotate_nonce_license'); ?>
<input type="hidden" name="adrotate_settings_tab" value="<?php echo $active_tab; ?>" />

<h1><?php _e("AdRotate Pro License", 'adrotate-pro'); ?></h1>

<div class="ajdg-box-wrap">
	<div class="ajdg-box-three">

		<div class="ajdg-box">
			<h2 class="ajdg-box-title"><?php _e("Your license", 'adrotate-pro'); ?></h2>
			<div class="ajdg-box-content">

				<p><?php _e("Activate your AdRotate Pro License to receive automatic updates, and with a Single, Duo or Multi license use AdRotate Geo and be eligble for ticket support.", 'adrotate-pro'); ?></p>

				<p><label for="adrotate_license_email">
					<strong><?php _e("License Email:", 'adrotate-pro'); ?></strong> <input tabindex="20" name="adrotate_license_email" type="text" class="search-input" style="width:100%;" value="<?php echo $a['email'];?>" autocomplete="off" <?php echo ($a['status'] === 1) ? 'disabled' : ''; ?> />
					<br /><small><?php _e("The email address you used in your purchase of AdRotate Pro.", 'adrotate-pro'); ?></small>
				</label></p>

				<p><label for="adrotate_license_key">
					<strong><?php _e("License Key:", 'adrotate-pro'); ?></strong> <input tabindex="30" name="adrotate_license_key" type="text" class="search-input" style="width:100%;" value="<?php echo $a['key'];?>" autocomplete="off" <?php echo ($a['status'] === 1) ? 'disabled' : ''; ?> />
					<br /><small><?php _e("You can find the license key in your order email.", 'adrotate-pro'); ?></small>
				</label></p>

				<?php if($a['status'] === 1) { ?>
				<hr>
				<p><label for="adrotate_license_force">
					<strong><?php _e("Force de-activate:", 'adrotate-pro'); ?></strong> <input type="checkbox" name="adrotate_license_force" id="adrotate_license_force" />
					<br /><small><?php _e("If your license has expired or you reset the license on ajdg.solutions you may need to force de-activate the license before you can activate (a different) one.", 'adrotate-pro'); ?></small>
				</label></p>
				<?php } ?>

			</div>
		</div>

		<div class="ajdg-box">
			<p class="submit">
				<?php if($a['status'] === 0) { ?>
				<input type="submit" id="post-role-submit" name="adrotate_license_activate" value="<?php _e("Activate license", 'adrotate-pro'); ?>" class="button-primary" />
				<?php } else { ?>
				<input type="submit" id="post-role-submit" name="adrotate_license_deactivate" value="<?php _e("De-activate license", 'adrotate-pro'); ?>" class="button-primary" />
				<?php } ?>
				&nbsp;&nbsp;<em><?php _e("Click only once! this may take a few seconds.", 'adrotate-pro'); ?></em>
			</p>
		</div>

	</div>
	<div class="ajdg-box-one">

		<?php if($a['status'] === 1) { ?>

		<div class="ajdg-box">
			<h2 class="ajdg-box-title"><?php _e("License activated", 'adrotate-pro'); ?></h2>
			<div class="ajdg-box-content">

				<?php if($a['created'] > 0 AND $a['created'] < (current_time('timestamp') - (DAY_IN_SECONDS * 365))) { ?>
				<p><strong><?php _e("Your license has expired!", 'adrotate-pro'); ?></strong><br />
				<?php _e("As a thank you for your continued usage and support of AdRotate Pro you can get a new license at a special discounted price.", 'adrotate-pro'); ?> <a href="https://ajdg.solutions/get-your-new-adrotate-pro-license/" target="_blank"><?php _e("Get a new license", 'adrotate-pro'); ?> &raquo;</a></p>
				<?php } ?>

				<p>
					<strong><?php _e("License:", 'adrotate-pro'); ?></strong> <?php echo $a['type'].' License'; ?><br />
					<strong><?php _e("Activated on:", 'adrotate-pro'); ?></strong> <?php echo date_i18n('F d, Y', $a['activated']); ?><br />
					<strong><?php _e("Expires (approx):", 'adrotate-pro'); ?></strong> <?php echo date_i18n('F d, Y', $a['created'] + (DAY_IN_SECONDS * 365)); ?>
				</p>

			</div>
		</div>

		<?php } ?>

		<div class="ajdg-box">
			<h2 class="ajdg-box-title"><?php _e("Need help with your license?", 'adrotate-pro'); ?></h2>
			<div class="ajdg-box-content">

				<p><?php _e("If you are having trouble with your license or ran out of activations you can reset unused sites in your account on the AJdG Solutions website."); ?></p>
				<p><?php _e("If that does not help or you have another problem with your license, please", 'adrotate-pro'); ?> <a href="https://support.ajdg.net/index.php?a=add&category=6"><?php _e("contact support", 'adrotate-pro'); ?></a> <?php _e("for assistance.", 'adrotate-pro'); ?></p>

			</div>
		</div>

	</div>
</div>

</form>
