<?php
/* ------------------------------------------------------------------------------------
*  COPYRIGHT AND TRADEMARK NOTICE
*  Copyright 2008-2026 Arnan de Gans. All Rights Reserved.
*  The software AdRotate, related services and ADROTATE the name are owned by Arnan de Gans.

*  COPYRIGHT NOTICES AND ALL THE COMMENTS SHOULD REMAIN INTACT.
*  By using this code you agree to indemnify Arnan de Gans from any
*  liability that might arise from its use.
------------------------------------------------------------------------------------ */
?>

<form name="settings" id="post" method="post" action="admin.php?page=adrotate-settings&tab=maintenance">
<?php wp_nonce_field('adrotate_settings','adrotate_nonce_settings'); ?>
<input type="hidden" name="adrotate_settings_tab" value="<?php echo $active_tab; ?>" />

<h1><?php _e("Maintenance", 'adrotate-pro'); ?></h1>

<div class="ajdg-box-wrap">
	<div class="ajdg-box-three">

		<div class="ajdg-box">
			<h2 class="ajdg-box-title"><?php _e("Status", 'adrotate-pro'); ?></h2>
			<div class="ajdg-box-content">

				<p>
					<strong><?php _e("Advert status:", 'adrotate-pro'); ?></strong><br />
					<strong><?php _e("Normal", 'adrotate-pro'); ?></strong> -> <?php echo $advert_status['normal']; ?><br />
					<strong><?php _e("Error", 'adrotate-pro'); ?></strong> -> <?php echo $advert_status['error']; ?><br />
					<strong><?php _e("Expired", 'adrotate-pro'); ?></strong> -> <?php echo $advert_status['expired']; ?><br />
					<strong><?php _e("Expires Soon", 'adrotate-pro'); ?></strong> -> <?php echo $advert_status['expiressoon']; ?><br />
					<strong><?php _e("Unknown", 'adrotate-pro'); ?></strong> -> <?php echo $advert_status['unknown']; ?>
				</p>

				<p>
					<strong><?php _e("Banners/assets Folder", 'adrotate-pro'); ?></strong><br />
					<?php
					echo WP_CONTENT_DIR.'/'.$adrotate_config['banner_folder'].'/ -> ';
					echo (is_writable(WP_CONTENT_DIR.'/'.$adrotate_config['banner_folder'].'/')) ? '<span style="color:#009900;">'.esc_html__("Exists and appears writable", 'adrotate-pro').'</span>' : '<span style="color:#CC2900;">'.esc_html__("Not writable or does not exist", 'adrotate-pro').'</span>';
					?>
				</p>

				<p>
					<strong><?php _e("Reports folder:", 'adrotate-pro'); ?></strong><br />
					<?php
					echo WP_CONTENT_DIR.'/'.$adrotate_config['report_folder'].'/ -> ';
					echo (is_writable(WP_CONTENT_DIR.'/'.$adrotate_config['report_folder'].'/')) ? '<span style="color:#009900;">'.esc_html__("Exists and appears writable", 'adrotate-pro').'</span>' : '<span style="color:#CC2900;">'.esc_html__("Not writable or does not exist", 'adrotate-pro').'</span>';
					echo '<br />';
					echo WP_CONTENT_DIR.'/'.$adrotate_config['report_folder'].'/index.html -> ';
					echo (file_exists(WP_CONTENT_DIR.'/'.$adrotate_config['report_folder'].'/index.html')) ? '<span style="color:#009900;">'.esc_html__("Exists", 'adrotate-pro').'</span>' : '<span style="color:#CC2900;">'.esc_html__("Not found (Required for security)", 'adrotate-pro').'</span>';
					?>
				</p>

				<p>
					<strong><?php _e("ads.txt file:", 'adrotate-pro'); ?></strong><br />
					<?php
					echo ABSPATH.$adrotate_config['adstxt_file'].'ads.txt -> ';
					echo (file_exists(ABSPATH.$adrotate_config['adstxt_file'].'ads.txt')) ? '<span style="color:#009900;">'.esc_html__("Exists", 'adrotate-pro').'</span>' : '<span style="color:#CC2900;">'.esc_html__("Not found", 'adrotate-pro').'</span>';
					?>
				</p>

				<p>
					<strong><?php _e("Unfiltered HTML:", 'adrotate-pro'); ?></strong> 
					<?php
					if(defined('DISALLOW_UNFILTERED_HTML') AND !DISALLOW_UNFILTERED_HTML) {
						echo "<span style=\"color:#009900;\">".esc_html__("Excellent! Editors, Administrators and Superadmins can use unfiltered code.", 'adrotate-pro')."</span>";
					} else {
						echo "<span style=\"color:#CC2900;\">".esc_html__("Your website's current setup does not allow for unfiltered code to be used in adverts.", 'adrotate-pro')."</span><br />".esc_html__("This is required for javascript adverts to work. To enable this you need to set the DISALLOW_UNFILTERED_HTML definition to 'false' in your wp-config.php file.", 'adrotate-pro')." <a href=\"https://support.ajdg.net/knowledgebase.php?article=43\" target=\"_blank\">".esc_html__("How to enable unfiltered html", 'adrotate-pro')."</a>?";
					}
					?>
				</p>

			</div>
		</div>

		<div class="ajdg-box">
			<h2 class="ajdg-box-title"><?php _e("Background tasks", 'adrotate-pro'); ?></h2>
			<div class="ajdg-box-content">

				<p>
					<strong><?php _e("Delete expired trackerdata:", 'adrotate-pro'); ?></strong> <?php if(!$tracker) '<span style="color:#CC2900;">'._e("Not scheduled!", 'adrotate-pro').'</span>'; else echo '<span style="color:#009900;">'.date_i18n(get_option('date_format')." H:i", $tracker).'</span>'; ?>
				</p>

				<p>
					<strong><?php _e("Send email notifications:", 'adrotate-pro'); ?></strong> <?php if(!$adschedule) '<span style="color:#CC2900;">'._e("Not scheduled!", 'adrotate-pro').'</span>'; else echo '<span style="color:#009900;">'.date_i18n(get_option('date_format')." H:i", $adschedule).'</span>'; ?>
				</p>

				<p>
					<strong><?php _e("Delete adverts from trash:", 'adrotate-pro'); ?></strong> <?php if(!$trash) '<span style="color:#CC2900;">'._e("Not scheduled!", 'adrotate-pro').'</span>'; else echo '<span style="color:#009900;">'.date_i18n(get_option('date_format')." H:i", $trash).'</span>'; ?>
				</p>

				<p>
					<strong><?php _e("Delete or disable expired adverts:", 'adrotate-pro'); ?></strong> <?php if(!$autodeletedisable) '<span style="color:#CC2900;">'._e("Not scheduled!", 'adrotate-pro').'</span>'; else echo '<span style="color:#009900;">'.date_i18n(get_option('date_format')." H:i", $autodeletedisable).'</span>'; ?>
				</p>
				
				<p><em><?php _e("The listed date is the next time the task is supposed to run.", 'adrotate-pro'); ?></em></p>

			</div>
		</div>

		<div class="ajdg-box">
			<h2 class="ajdg-box-title"><?php _e("Maintenance", 'adrotate-pro'); ?></h2>
			<div class="ajdg-box-content">

				<p>
					<strong><?php _e("Check adverts:", 'adrotate-pro'); ?></strong> <span class="alignright"><a class="button" href="<?php echo wp_nonce_url(admin_url('admin.php?page=adrotate-settings&tab=maintenance&action=check-all-ads'), 'maintenance', 'adrotate-nonce'); ?>" onclick="return confirm('<?php _e("You are about to check all adverts for errors.", 'adrotate-pro'); ?>\n\n<?php _e("This might take a few seconds!", 'adrotate-pro'); ?>\n\n<?php _e("OK to continue, CANCEL to stop.", 'adrotate-pro'); ?>')"><?php _e("Check all adverts for configuration errors", 'adrotate-pro'); ?></a></span><br />
					<small><?php _e("Apply all evaluation rules to all adverts to see if any error slipped in. This may take a few seconds.", 'adrotate-pro'); ?></small>
				</p>

				<?php if($adrotate_notifications['notification_email'] == "Y") { ?>
				<p>
					<strong><?php _e("Email notification:", 'adrotate-pro'); ?></strong> <span class="alignright"><a class="button" href="<?php echo wp_nonce_url(admin_url('admin.php?page=adrotate-settings&tab=maintenance&action=test-mail'), 'maintenance', 'adrotate-nonce'); ?>"><?php _e("Send test email notification", 'adrotate-pro'); ?></a></span><br />
					<small><?php _e("Send a test notification to the configured email addresses to see if email notifications work!", 'adrotate-pro'); ?></small>
				</p>
				<?php } ?>

				<?php if($adrotate_config['enable_geo'] > 0) { ?>
				<p>
					<strong><?php _e("Geo Targeting:", 'adrotate-pro'); ?></strong> <span class="alignright"><a class="button" href="<?php echo wp_nonce_url(admin_url('admin.php?page=adrotate-settings&tab=maintenance&action=reset-geo'), 'maintenance', 'adrotate-nonce'); ?>" onclick="return confirm('<?php _e("You are about to reset your Geo Targeting quota. AdRotate will attempt to contact the Geo service and process its response.", 'adrotate-pro'); ?>\n\n<?php _e("This might take a few seconds!", 'adrotate-pro'); ?>\n\n<?php _e("OK to continue, CANCEL to stop.", 'adrotate-pro'); ?>')"><?php _e("Reset geo targeting quota", 'adrotate-pro'); ?></a></span><br />
					<small><?php _e("Jiggle the server to try and reset your lookup quota!", 'adrotate-pro'); ?></small>
				</p>
				<?php } ?>

				<p>
					<strong><?php _e("Required folders:", 'adrotate-pro'); ?></strong> <span class="alignright"><a class="button" href="<?php echo wp_nonce_url(admin_url('admin.php?page=adrotate-settings&tab=maintenance&action=create-filefolders'), 'maintenance', 'adrotate-nonce'); ?>" onclick="return confirm('<?php _e("Only continue if your banners or reports folder, or ads.txt file are missing!", 'adrotate-pro'); ?>\n\n<?php _e("This might take a few seconds!", 'adrotate-pro'); ?>\n\n<?php _e("OK to continue, CANCEL to stop.", 'adrotate-pro'); ?>')"><?php _e("Create missing folders/files", 'adrotate-pro'); ?></a></span><br />
					<small><?php _e("This creates a 'banners' folder, 'reports' folder and 'ads.txt' file if one or more of these are missing.", 'adrotate-pro'); ?></small>
				</p>


				<p>
					<strong><?php _e("Background tasks:", 'adrotate-pro'); ?></strong> <span class="alignright"><a class="button" href="<?php echo wp_nonce_url(admin_url('admin.php?page=adrotate-settings&tab=maintenance&action=reset-tasks'), 'maintenance', 'adrotate-nonce'); ?>" onclick="return confirm('<?php _e("Only continue if background tasks show up as missing on this page.", 'adrotate-pro'); ?>\n\n<?php _e("This might take a few seconds!", 'adrotate-pro'); ?>\n\n<?php _e("OK to continue, CANCEL to stop.", 'adrotate-pro'); ?>')"><?php _e("Reset background tasks", 'adrotate-pro'); ?></a></span><br />
					<small><?php _e("If automated tasks such as expiring adverts does not work reliably or one of the schedules listed on this page is missing, use this button to reset the tasks.", 'adrotate-pro'); ?></small>
				</p>

			</div>
		</div>

		<div class="ajdg-box">
			<h2 class="ajdg-box-title"><?php _e("Internal Versions", 'adrotate-pro'); ?></h2>
			<div class="ajdg-box-content">

				<p>
					<strong><?php _e("AdRotate version:", 'adrotate-pro'); ?></strong><br />
					<?php
					echo __("Current:", 'adrotate-pro')."<span style=\"color:#009900;\">".$adrotate_version['current']."</span>";
					if($adrotate_version['current'] != ADROTATE_VERSION) {
						echo "<span style=\"color:#CC2900;\">".__("Should be:", 'adrotate-pro')." ".ADROTATE_VERSION."</span>";
					}
					echo " - ".__("Previous:", 'adrotate-pro')." ".$adrotate_version['previous']; ?>
				</p>
		
				<p>
					<strong><?php _e("Database version:", 'adrotate-pro'); ?></strong><br />
					<?php
					echo __("Current:", 'adrotate-pro')."<span style=\"color:#009900;\">".$adrotate_db_version['current']."</span>";
					if($adrotate_db_version['current'] != ADROTATE_DB_VERSION) {
						echo "<span style=\"color:#CC2900;\">".__("Should be:", 'adrotate-pro')." ".ADROTATE_DB_VERSION."</span>";
					}
					echo " - ".__("Previous:", 'adrotate-pro')." ".$adrotate_db_version['previous']; ?>
				</p>

				<?php if($adrotate_db_version['current'] < ADROTATE_DB_VERSION OR $adrotate_version['current'] < ADROTATE_VERSION) { ?>
				<p>
					<strong><?php _e("Manual upgrade:", 'adrotate-pro'); ?></strong> <a class="button" href="<?php echo wp_nonce_url(admin_url('admin.php?page=adrotate-settings&tab=maintenance&action=update-db'), 'maintenance', 'adrotate-nonce'); ?>"><?php _e("Run updater manually", 'adrotate-pro'); ?></a>
				</p>
				<p>
					<em><?php _e("If the automatic update for some reason doesn't complete. Or you notice that the above versions are mismatched you can update the database and settings using this button.", 'adrotate-pro'); ?></em>
				</p>
				<?php } ?>

			</div>
		</div>

	</div>
	<div class="ajdg-box-one">

		<?php include_once(dirname(__DIR__).'/sidebar.php'); ?>

	</div>
</div>

</form>