<?php
/* ------------------------------------------------------------------------------------
*  COPYRIGHT AND TRADEMARK NOTICE
*  Copyright 2008-2026 Arnan de Gans. All Rights Reserved.
*  The software AdRotate, related services and ADROTATE the name are owned by Arnan de Gans.

*  COPYRIGHT NOTICES AND ALL THE COMMENTS SHOULD REMAIN INTACT.
*  By using this code you agree to indemnify Arnan de Gans from any
*  liability that might arise from its use.
------------------------------------------------------------------------------------ */
?>

<form name="settings" id="post" method="post" action="admin.php?page=adrotate-settings&tab=misc">
<?php wp_nonce_field('adrotate_settings','adrotate_nonce_settings'); ?>
<input type="hidden" name="adrotate_settings_tab" value="<?php echo $active_tab; ?>" />

<h1><?php _e("Miscellaneous", 'adrotate-pro'); ?></h1>

<div class="ajdg-box-wrap">
	<div class="ajdg-box-three">

		<div class="ajdg-box">
			<h2 class="ajdg-box-title"><?php _e("Settings", 'adrotate-pro'); ?></h2>
			<div class="ajdg-box-content">

				<p><label for="adrotate_zindex">
					<strong><?php _e("Wallpaper ads Z-Index:", 'adrotate-pro'); ?></strong> <span class="alignright"><select name="adrotate_zindex" tabindex="10">
						<option value="-1" <?php if($adrotate_config['zindex'] == "-1") { echo 'selected'; } ?>>-1 (Default)</option>
						<option value="-10" <?php if($adrotate_config['zindex'] == "-10") { echo 'selected'; } ?>>-10</option>
						<option value="-999" <?php if($adrotate_config['zindex'] == "-999") { echo 'selected'; } ?>>-999</option>
						<option value="0" <?php if($adrotate_config['zindex'] == "0") { echo 'selected'; } ?>>0</option>
						<option value="1" <?php if($adrotate_config['zindex'] == "1") { echo 'selected'; } ?>>1</option>
						<option value="10" <?php if($adrotate_config['zindex'] == "10") { echo 'selected'; } ?>>10</option>
					</select></span>
					<br /><small><?php _e("Lower the Z-Index when your wallpaper ads overlay your website. Think of the Z-Index as a set of layers, a higher layer sits more to the front. 0 or 1 is usually the default layer, even if undefined.", 'adrotate-pro'); ?></small>
				</label></p>

				<p><label for="adrotate_widgetalign">
					<strong><?php _e("Widget alignment:", 'adrotate-pro'); ?></strong> <span class="alignright"><select name="adrotate_widgetalign" tabindex="20">
						<option <?php echo ($adrotate_config['widgetalign'] == 'N') ? 'selected' : '';  ?> value="N"><?php _e("No", 'adrotate-pro'); ?></option>
						<option <?php echo ($adrotate_config['widgetalign'] == 'Y') ? 'selected' : '';  ?> value="Y"><?php _e("Yes", 'adrotate-pro'); ?></option>
					</select></span>
					<br /><small><?php _e("Enable this if your widgets do not align with your themes sidebar. (Some themes ignore this!)", 'adrotate-pro'); ?></small>
				</label></p>

				<p><label for="adrotate_widgetpadding">
					<strong><?php _e("Widget padding:", 'adrotate-pro'); ?></strong> <span class="alignright"><select name="adrotate_widgetpadding" tabindex="30">
						<option <?php echo ($adrotate_config['widgetpadding'] == 'N') ? 'selected' : '';  ?> value="N"><?php _e("No", 'adrotate-pro'); ?></option>
						<option <?php echo ($adrotate_config['widgetpadding'] == 'Y') ? 'selected' : '';  ?> value="Y"><?php _e("Yes", 'adrotate-pro'); ?></option>
					</select></span>
					<br /><small><?php _e("Enable this to remove the padding (blank space) around ads in widgets. (Some themes prevent this!)", 'adrotate-pro'); ?></small>
				</label></p>

				<p><label for="adrotate_hide_schedules">
					<strong><?php _e("Hide schedules:", 'adrotate-pro'); ?></strong> <span class="alignright"><select name="adrotate_hide_schedules" tabindex="40">
						<option <?php echo ($adrotate_config['hide_schedules'] == 'N') ? 'selected' : '';  ?> value="N"><?php _e("No", 'adrotate-pro'); ?></option>
						<option <?php echo ($adrotate_config['hide_schedules'] == 'Y') ? 'selected' : '';  ?> value="Y"><?php _e("Yes", 'adrotate-pro'); ?></option>
					</select></span>
					<br /><small><?php _e("When editing adverts, hide schedules that are not in use by that advert.", 'adrotate-pro'); ?></small>
				</label></p>

				<?php if($adrotate_config['w3caching'] == 'Y' AND !defined('W3TC_DYNAMIC_SECURITY')) { ?>
				<p>
					<strong><?php _e("NOTICE:", 'adrotate-pro'); ?></strong> <?php _e("You have enabled W3 Total Caching support but not defined the security hash.", 'adrotate-pro'); ?>
				</p>
				<p>
					<?php _e("AdRotate has generated the following line for you to add to your wp-config.php around line 52 (below the WordPress nonces). If you do not know how to add this line, check out the following guide;", 'adrotate-pro'); ?> <a href="https://support.ajdg.net/knowledgebase.php?article=46"><?php _e("Set up W3 Total Caching.", 'adrotate-pro'); ?></a>
					<br /><pre>define('W3TC_DYNAMIC_SECURITY', 'adrotate');</pre>
				</p>
				<?php } ?>

				<p><label for="adrotate_w3caching">
					<strong><?php _e("W3 Total Caching compatibility:", 'adrotate-pro'); ?></strong> <span class="alignright"><select name="adrotate_w3caching" tabindex="50">
						<option <?php echo ($adrotate_config['w3caching'] == 'N') ? 'selected' : '';  ?> value="N"><?php _e("No", 'adrotate-pro'); ?></option>
						<option <?php echo ($adrotate_config['w3caching'] == 'Y') ? 'selected' : '';  ?> value="Y"><?php _e("Yes", 'adrotate-pro'); ?></option>
					</select></span>
					<br /><small><?php _e("Check this box if you use W3 Total Caching on your site.", 'adrotate-pro'); ?> - <a href="https://support.ajdg.net/knowledgebase.php?article=46" target="_blank"><?php _e("Setup guide.", 'adrotate-pro'); ?></a></small>
				</label></p>

				<p><label for="adrotate_borlabscache">
					<strong><?php _e("Borlabs Cache compatibility:", 'adrotate-pro'); ?></strong> <span class="alignright"><select name="adrotate_borlabscache" tabindex="60">
						<option <?php echo ($adrotate_config['borlabscache'] == 'N') ? 'selected' : '';  ?> value="N"><?php _e("No", 'adrotate-pro'); ?></option>
						<option <?php echo ($adrotate_config['borlabscache'] == 'Y') ? 'selected' : '';  ?> value="Y"><?php _e("Yes", 'adrotate-pro'); ?></option>
					</select></span>
					<br /><small><?php _e("Check this box if you use Borlabs Caching on your site.", 'adrotate-pro'); ?> - <a href="https://support.ajdg.net/knowledgebase.php?article=46" target="_blank"><?php _e("Setup guide.", 'adrotate-pro'); ?></a></small>
				</label></p>

				<p>
					<em><?php _e("It may take a while for adverts to start rotating. The caching plugin needs to refresh/clear the cache. This can several days if not done manually.", 'adrotate-pro'); ?> <?php _e("Caching support only works for [shortcodes] and the AdRotate Widget and Blocks. If you use a PHP Snippet you need to wrap your PHP in the exclusion code yourself.", 'adrotate-pro'); ?></em>
				</p>

			</div>
		</div>

		<div class="ajdg-box">
			<p class="submit">
			  	<input type="submit" name="adrotate_save_options" class="button-primary" value="<?php _e("Save settings", 'adrotate-pro'); ?>" tabindex="1000" />
			</p>
		</div>

	</div>
	<div class="ajdg-box-one">

		<?php include_once(dirname(__DIR__).'/sidebar.php'); ?>

	</div>
</div>

</form>