<?php
/* ------------------------------------------------------------------------------------
*  COPYRIGHT AND TRADEMARK NOTICE
*  Copyright 2008-2026 Arnan de Gans. All Rights Reserved.
*  The software AdRotate, related services and ADROTATE the name are owned by Arnan de Gans.

*  COPYRIGHT NOTICES AND ALL THE COMMENTS SHOULD REMAIN INTACT.
*  By using this code you agree to indemnify Arnan de Gans from any
*  liability that might arise from its use.
------------------------------------------------------------------------------------ */
?>

<form name="settings" id="post" method="post" action="admin.php?page=adrotate-settings&tab=notifications">
<?php wp_nonce_field('adrotate_settings','adrotate_nonce_settings'); ?>
<input type="hidden" name="adrotate_settings_tab" value="<?php echo $active_tab; ?>" />

<h1><?php _e("Notifications", 'adrotate-pro'); ?></h1>

<div class="ajdg-box-wrap">
	<div class="ajdg-box-three">

		<div class="ajdg-box">
			<h2 class="ajdg-box-title"><?php _e("Dashboard Banner", 'adrotate-pro'); ?></h2>
			<div class="ajdg-box-content">

				<p><?php _e("These show in a dashboard banner visible to all users who have access to AdRotate.", 'adrotate-pro'); ?></p>

				<p><label for="adrotate_notification_dash">
					<strong><?php _e("Show a dashboard notification:", 'adrotate-pro'); ?></strong> <span class="alignright"><select name="adrotate_notification_dash" tabindex="10">
						<option <?php echo ($adrotate_notifications['notification_dash'] == 'Y') ? 'selected' : '';  ?> value="Y"><?php _e("Yes", 'adrotate-pro'); ?></option>
						<option <?php echo ($adrotate_notifications['notification_dash'] == 'N') ? 'selected' : '';  ?> value="N"><?php _e("No", 'adrotate-pro'); ?></option>
					</select></span><br />
					<small><?php _e("Notifications for adverts with configuration errors can not be turned off.", 'adrotate-pro'); ?></small>
				</label></p>

				<p><label for="adrotate_notification_dash_expired">
					<strong><?php _e("Expired adverts:", 'adrotate-pro'); ?></strong> <span class="alignright"><select name="adrotate_notification_dash_expired" tabindex="20">
						<option <?php echo ($adrotate_notifications['notification_dash_expired'] == 'Y') ? 'selected' : '';  ?> value="Y"><?php _e("Yes", 'adrotate-pro'); ?></option>
						<option <?php echo ($adrotate_notifications['notification_dash_expired'] == 'N') ? 'selected' : '';  ?> value="N"><?php _e("No", 'adrotate-pro'); ?></option>
					</select></span><br />
					<small><?php _e("These adverts have already expired and might need to be disabled or renewed.", 'adrotate-pro'); ?></small>
				</label></p>

				<p><label for="adrotate_notification_dash_soon">
					<strong><?php _e("Adverts that are almost expiring:", 'adrotate-pro'); ?></strong> <span class="alignright"><select name="adrotate_notification_dash_soon" tabindex="30">
						<option <?php echo ($adrotate_notifications['notification_dash_soon'] == 'Y') ? 'selected' : '';  ?> value="Y"><?php _e("Yes", 'adrotate-pro'); ?></option>
						<option <?php echo ($adrotate_notifications['notification_dash_soon'] == 'N') ? 'selected' : '';  ?> value="N"><?php _e("No", 'adrotate-pro'); ?></option>
					</select></span><br />
					<small><?php _e("These will expire within 2 days and might need to be disabled or renewed.", 'adrotate-pro'); ?></small>
				</label></p>

				<p><label for="adrotate_notification_dash_week">
					<strong><?php _e("Adverts expiring soon:", 'adrotate-pro'); ?></strong> <span class="alignright"><select name="adrotate_notification_dash_week" tabindex="40">
						<option <?php echo ($adrotate_notifications['notification_dash_week'] == 'Y') ? 'selected' : '';  ?> value="Y"><?php _e("Yes", 'adrotate-pro'); ?></option>
						<option <?php echo ($adrotate_notifications['notification_dash_week'] == 'N') ? 'selected' : '';  ?> value="N"><?php _e("No", 'adrotate-pro'); ?></option>
					</select></span><br />
					<small><?php _e("These will expire within 7 days and might need to be disabled or renewed.", 'adrotate-pro'); ?></small>
				</label></p>

				<p><label for="adrotate_notification_schedules">
					<strong><?php _e("Schedules with warnings:", 'adrotate-pro'); ?></strong> <span class="alignright"><select name="adrotate_notification_schedules" tabindex="50">
						<option <?php echo ($adrotate_notifications['notification_schedules'] == 'Y') ? 'selected' : '';  ?> value="Y"><?php _e("Yes", 'adrotate-pro'); ?></option>
						<option <?php echo ($adrotate_notifications['notification_schedules'] == 'N') ? 'selected' : '';  ?> value="N"><?php _e("No", 'adrotate-pro'); ?></option>
					</select></span><br />
					<small><?php _e("Schedules with configuration warnings may interupt the showing of adverts.", 'adrotate-pro'); ?></small>
				</label></p>

			</div>
		</div>

		<div class="ajdg-box">
			<h2 class="ajdg-box-title"><?php _e("Email Message", 'adrotate-pro'); ?></h2>
			<div class="ajdg-box-content">

				<p><label for="adrotate_notification_mail">
					<strong><?php _e("Send alert emails:", 'adrotate-pro'); ?></strong> <span class="alignright"><select name="adrotate_notification_mail" tabindex="60">
						<option <?php echo ($adrotate_notifications['notification_email'] == 'N') ? 'selected' : '';  ?> value="N"><?php _e("No", 'adrotate-pro'); ?></option>
						<option <?php echo ($adrotate_notifications['notification_email'] == 'Y') ? 'selected' : '';  ?> value="Y"><?php _e("Yes", 'adrotate-pro'); ?></option>
					</select></span><br />
					<small><?php _e("Choose if you want to be notified via email for common issues with adverts.", 'adrotate-pro'); ?></small>

				</label></p>

				<p><label for="adrotate_notification_mail_publisher">
					<strong><?php _e("E-mail addresses to notify:", 'adrotate-pro'); ?></strong><br />
					<textarea name="adrotate_notification_mail_publisher" style="width:100%;" rows="1" tabindex="70"><?php echo get_option('admin_email'); ?></textarea><br />
					<small><?php _e("Messages are sent once every 24 hours.  Maximum of 5 addresses. Comma separated. This field may not be empty!", 'adrotate-pro'); ?></small>
				</label></p>

				<p><label for="adrotate_notification_mail_status">
					<strong><?php _e("Daily digest:", 'adrotate-pro'); ?></strong> <span class="alignright"><select name="adrotate_notification_mail_status" tabindex="80">
						<option <?php echo ($adrotate_notifications['notification_mail_status'] == 'Y') ? 'selected' : '';  ?> value="Y"><?php _e("Yes", 'adrotate-pro'); ?></option>
						<option <?php echo ($adrotate_notifications['notification_mail_status'] == 'N') ? 'selected' : '';  ?> value="N"><?php _e("No", 'adrotate-pro'); ?></option>
					</select></span><br />
					<small><?php _e("Daily digest of any advert status other than normal.", 'adrotate-pro'); ?></small>
				</label></p>

				<p><label for="adrotate_notification_mail_geo">
					<strong><?php _e("Geo Targeting:", 'adrotate-pro'); ?></strong> <span class="alignright"><select name="adrotate_notification_mail_geo" tabindex="90">
						<option <?php echo ($adrotate_notifications['notification_mail_geo'] == 'Y') ? 'selected' : '';  ?> value="Y"><?php _e("Yes", 'adrotate-pro'); ?></option>
						<option <?php echo ($adrotate_notifications['notification_mail_geo'] == 'N') ? 'selected' : '';  ?> value="N"><?php _e("No", 'adrotate-pro'); ?></option>
					</select></span><br />
					<small><?php _e("When you are running out of Geo Targeting Lookups.", 'adrotate-pro'); ?></small>
				</label></p>

				<p><label for="adrotate_notification_mail_queue">
					<strong><?php _e("Advertisers:", 'adrotate-pro'); ?></strong> <span class="alignright"><select name="adrotate_notification_mail_queue" tabindex="100">
						<option <?php echo ($adrotate_notifications['notification_mail_queue'] == 'Y') ? 'selected' : '';  ?> value="Y"><?php _e("Yes", 'adrotate-pro'); ?></option>
						<option <?php echo ($adrotate_notifications['notification_mail_queue'] == 'N') ? 'selected' : '';  ?> value="N"><?php _e("No", 'adrotate-pro'); ?></option>
					</select></span><br />
					<small><?php _e("Any advertiser saving an advert in your moderation queue.", 'adrotate-pro'); ?></small>
				</label></p>

				<p><label for="adrotate_notification_mail_approved">
					<strong><?php _e("Moderator approval:", 'adrotate-pro'); ?></strong> <span class="alignright"><select name="adrotate_notification_mail_approved" tabindex="110">
						<option <?php echo ($adrotate_notifications['notification_mail_approved'] == 'Y') ? 'selected' : '';  ?> value="Y"><?php _e("Yes", 'adrotate-pro'); ?></option>
						<option <?php echo ($adrotate_notifications['notification_mail_approved'] == 'N') ? 'selected' : '';  ?> value="N"><?php _e("No", 'adrotate-pro'); ?></option>
					</select></span><br />
					<small><?php _e("A moderator approved an advert from the moderation queue.", 'adrotate-pro'); ?></small>
				</label></p>

				<p><label for="adrotate_notification_mail_rejected">
					<strong><?php _e("Moderator rejection:", 'adrotate-pro'); ?></strong> <span class="alignright"><select name="adrotate_notification_mail_rejected" tabindex="120">
						<option <?php echo ($adrotate_notifications['notification_mail_rejected'] == 'Y') ? 'selected' : '';  ?> value="Y"><?php _e("Yes", 'adrotate-pro'); ?></option>
						<option <?php echo ($adrotate_notifications['notification_mail_rejected'] == 'N') ? 'selected' : '';  ?> value="N"><?php _e("No", 'adrotate-pro'); ?></option>
					</select></span><br />
					<small><?php _e("A moderator rejected an advert from the moderation queue.", 'adrotate-pro'); ?></small>
				</label></p>

			</div>
		</div>

		<div class="ajdg-box">
			<p class="submit">
			  	<input type="submit" name="adrotate_save_options" class="button-primary" value="<?php _e("Save settings", 'adrotate-pro'); ?>" tabindex="1000" />
			</p>
		</div>

	</div>
	<div class="ajdg-box-one">

		<?php include_once(dirname(__DIR__).'/sidebar.php'); ?>

	</div>
</div>

</form>