<?php
/* ------------------------------------------------------------------------------------
*  COPYRIGHT AND TRADEMARK NOTICE
*  Copyright 2008-2026 Arnan de Gans. All Rights Reserved.
*  The software AdRotate, related services and ADROTATE the name are owned by Arnan de Gans.

*  COPYRIGHT NOTICES AND ALL THE COMMENTS SHOULD REMAIN INTACT.
*  By using this code you agree to indemnify Arnan de Gans from any
*  liability that might arise from its use.
------------------------------------------------------------------------------------ */
?>

<form name="settings" id="post" method="post" action="admin.php?page=adrotate-settings&tab=roles">
<?php wp_nonce_field('adrotate_settings','adrotate_nonce_settings'); ?>
<input type="hidden" name="adrotate_settings_tab" value="<?php echo $active_tab; ?>" />

<h1><?php _e("Access Roles", 'adrotate-pro'); ?></h1>

<div class="ajdg-box-wrap">
	<div class="ajdg-box-three">

		<div class="ajdg-box">
			<h2 class="ajdg-box-title"><?php _e("Administrator permissions", 'adrotate-pro'); ?></h2>
			<div class="ajdg-box-content">

				<p><label for="adrotate_global_report">
					<strong><?php _e("Statistics page:", 'adrotate-pro'); ?></strong> <span class="alignright"><select name="adrotate_global_report" tabindex="10">
						<?php wp_dropdown_roles($adrotate_config['global_report']); ?>
					</select></span><br />
					<small><?php _e("Who can access the Statistics dashboard page?", 'adrotate-pro'); ?></small>
				</label></p>

				<p><label for="adrotate_ad_manage">
					<strong><?php _e("Manage/Add/Edit adverts:", 'adrotate-pro'); ?></strong> <span class="alignright"><select name="adrotate_ad_manage" tabindex="20">
						<?php wp_dropdown_roles($adrotate_config['ad_manage']); ?>
					</select></span><br />
					<small><?php _e("Who can add and edit adverts?", 'adrotate-pro'); ?></small>
				</label></p>

				<p><label for="adrotate_ad_delete">
					<strong><?php _e("Delete/Reset adverts:", 'adrotate-pro'); ?></strong> <span class="alignright"><select name="adrotate_ad_delete" tabindex="30">
						<?php wp_dropdown_roles($adrotate_config['ad_delete']); ?>
					</select></span><br />
					<small><?php _e("Who can delete adverts and reset advert stats?", 'adrotate-pro'); ?></small>
				</label></p>

				<p><label for="adrotate_group_manage">
					<strong><?php _e("Manage/Add/Edit groups:", 'adrotate-pro'); ?></strong> <span class="alignright"><select name="adrotate_group_manage" tabindex="40">
						<?php wp_dropdown_roles($adrotate_config['group_manage']); ?>
					</select></span><br />
					<small><?php _e("Who can add and edit groups?", 'adrotate-pro'); ?></small>
				</label></p>

				<p><label for="adrotate_group_delete">
					<strong><?php _e("Delete groups:", 'adrotate-pro'); ?></strong> <span class="alignright"><select name="adrotate_group_delete" tabindex="50">
						<?php wp_dropdown_roles($adrotate_config['group_delete']); ?>
					</select></span><br />
					<small><?php _e("Who can add and edit groups?", 'adrotate-pro'); ?></small>
				</label></p>

				<p><label for="adrotate_schedule_manage">
					<strong><?php _e("Manage/Add/Edit schedules:", 'adrotate-pro'); ?></strong> <span class="alignright"><select name="adrotate_schedule_manage" tabindex="60">
						<?php wp_dropdown_roles($adrotate_config['schedule_manage']); ?>
					</select></span><br />
					<small><?php _e("Who can add and edit schedules?", 'adrotate-pro'); ?></small>
				</label></p>

				<p><label for="adrotate_schedule_delete">
					<strong><?php _e("Delete schedules:", 'adrotate-pro'); ?></strong> <span class="alignright"><select name="adrotate_schedule_delete" tabindex="70">
						<?php wp_dropdown_roles($adrotate_config['schedule_delete']); ?>
					</select></span><br />
					<small><?php _e("Who can delete schedules?", 'adrotate-pro'); ?></small>
				</label></p>

				<p><label for="adrotate_advertiser_manage">
					<strong><?php _e("Manage advertisers:", 'adrotate-pro'); ?></strong> <span class="alignright"><select name="adrotate_advertiser_manage" tabindex="80">
						<?php wp_dropdown_roles($adrotate_config['advertiser_manage']); ?>
					</select></span><br />
					<small><?php _e("Who can see and manage advertisers?", 'adrotate-pro'); ?></small>
				</label></p>

				<p><label for="adrotate_moderate">
					<strong><?php _e("Moderate new adverts:", 'adrotate-pro'); ?></strong> <span class="alignright"><select name="adrotate_moderate" tabindex="90">
						<?php wp_dropdown_roles($adrotate_config['moderate']); ?>
					</select></span><br />
					<small><?php _e("Who can approve adverts submitted by advertisers?", 'adrotate-pro'); ?></small>
				</label></p>

				<p><label for="adrotate_moderate_approve">
					<strong><?php _e("Moderation Queue:", 'adrotate-pro'); ?></strong> <span class="alignright"><select name="adrotate_moderate_approve" tabindex="100">
						<?php wp_dropdown_roles($adrotate_config['moderate_approve']); ?>
					</select></span><br />
					<small><?php _e("Who can approve or reject adverts submitted by advertisers?", 'adrotate-pro'); ?></small>
				</label></p>

			</div>
		</div>

		<div class="ajdg-box">
			<h2 class="ajdg-box-title"><?php _e("Advertisers", 'adrotate-pro'); ?></h2>
			<div class="ajdg-box-content">

				<p><label for="adrotate_enable_advertisers">
					<strong><?php _e("Enable Advertisers:", 'adrotate-pro'); ?></strong> <span class="alignright"><select name="adrotate_enable_advertisers" tabindex="110">
						<option <?php echo ($adrotate_config['enable_advertisers'] == 'N') ? 'selected' : '';  ?> value="N"><?php _e("No", 'adrotate-pro'); ?></option>
						<option <?php echo ($adrotate_config['enable_advertisers'] == 'Y') ? 'selected' : '';  ?> value="Y"><?php _e("Yes", 'adrotate-pro'); ?></option>
					</select></span>
					<br /><small><?php _e("Allow adverts to be coupled to users (Advertisers).", 'adrotate-pro'); ?></small>
				</label></p>

				<p><label for="adrotate_role">
					<?php $do_role = (is_object(get_role('adrotate_advertiser'))) ? 'Y' : 'N'; ?>
					<strong><?php _e("Advertiser role:", 'adrotate-pro'); ?></strong> <span class="alignright"><select name="adrotate_role" tabindex="120">
						<option <?php echo ($do_role == 'N') ? 'selected' : '' ?> value="N"><?php _e("No", 'adrotate-pro'); ?></option>
						<option <?php echo ($do_role == 'Y') ? 'selected' : '' ?> value="Y"><?php _e("Yes", 'adrotate-pro'); ?></option>
					</select></span>
					<br /><small><?php _e("Create a seperate user role for your advertisers.", 'adrotate-pro'); ?></small>
				</label></p>

				<p><label for="adrotate_advertiser">
					<strong><?php _e("Advertiser page:", 'adrotate-pro'); ?></strong> <span class="alignright"><select name="adrotate_advertiser" tabindex="130">
						<?php wp_dropdown_roles($adrotate_config['advertiser']); ?>
					</select></span><br />
					<small><?php _e("Role to allow users/advertisers to see their advertisement page.", 'adrotate-pro'); ?></small>
				</label></p>

			</div>
		</div>

		<div class="ajdg-box">
			<p class="submit">
			  	<input type="submit" name="adrotate_save_options" class="button-primary" value="<?php _e("Save settings", 'adrotate-pro'); ?>" tabindex="1000" />
			</p>
		</div>

	</div>
	<div class="ajdg-box-one">

		<?php include_once(dirname(__DIR__).'/sidebar.php'); ?>

	</div>
</div>

</form>