<?php
/* ------------------------------------------------------------------------------------
*  COPYRIGHT AND TRADEMARK NOTICE
*  Copyright 2008-2026 Arnan de Gans. All Rights Reserved.
*  The software AdRotate, related services and ADROTATE the name are owned by Arnan de Gans.

*  COPYRIGHT NOTICES AND ALL THE COMMENTS SHOULD REMAIN INTACT.
*  By using this code you agree to indemnify Arnan de Gans from any
*  liability that might arise from its use.
------------------------------------------------------------------------------------ */

$adverts = $wpdb->get_results("SELECT * FROM `{$wpdb->prefix}adrotate` WHERE `title` != '' AND (`type` = 'active' OR `type` = '7days' OR `type` = '2days' OR `type` = 'error' OR `type` = 'a_error' OR `type` = 'limit' OR `type` = 'disabled') ORDER BY `id` ASC;");
?>

<div class="ajdg-box-wrap">
	<div class="ajdg-box-two">

		<div class="ajdg-box">
			<h2 class="ajdg-box-title"><?php _e("Getting help with AdRotate Professional", 'adrotate-pro'); ?></h2>
			<div class="ajdg-box-content">
				<p><img src="<?php echo plugins_url('/images/icon-support.png', dirname(__FILE__)); ?>" class="alignleft pro-image" /><?php esc_html_e("Is something not working the way you expect it to? If you need help you can check the manuals and guides on my website. There is a lot of information on the support forum asked by other users. Chances are your question has already been asked and answered or if not, I am always happy to help!", 'adrotate-pro'); ?></p>

				<p><strong><?php esc_html_e("Ticket support for AdRotate Pro users", 'adrotate-pro'); ?></strong><br /><em><?php esc_html_e("Use the form on the right to create a support ticket. Or visit the support page.", 'adrotate-pro'); ?> <a href="https://support.ajdg.net/index.php?a=add" target="_blank"><?php esc_html_e("Ticket support", 'adrotate-pro'); ?> &raquo;</a></em></p>
				<p><a href="https://support.ajdg.net/knowledgebase.php" target="_blank"><strong><?php esc_html_e("AdRotate Pro Knowledge Base", 'adrotate-pro'); ?></strong></a><br /><em><?php esc_html_e("Take a look at the AdRotate Pro Manuals and Guides.", 'adrotate-pro'); ?> <a href="https://support.ajdg.net/knowledgebase.php" target="_blank"><?php esc_html_e("Find answers", 'adrotate-pro'); ?> &raquo;</a></em></p>
				<p><a href="https://support.ajdg.net/" target="_blank"><strong><?php esc_html_e("Report security issues", 'adrotate-pro'); ?></strong></a><br /><em><?php esc_html_e("Found a security flaw?", 'adrotate-pro'); ?> <a href="https://support.ajdg.net/" target="_blank"><?php esc_html_e("Please report it", 'adrotate-pro'); ?> &raquo;</a></em></p>

				<h2 class="ajdg-postbox-title"><?php esc_html_e("Plugins and services", 'adrotate-pro'); ?></h2>
				<table width="100%">
					<tr>
						<td width="50%">
							<div class="ajdg-box-content ajdg-box-sale">
								<a href="https://ajdg.solutions/product/adrotate-html5-setup-service/" target="_blank"><div class="header"><img src="<?php echo plugins_url("/images/offers/html5-service.jpg", dirname(__FILE__)); ?>" alt="HTML5 Advert setup" width="228" height="120"></div></a>
								<a href="https://ajdg.solutions/product/adrotate-html5-setup-service/" target="_blank"><div class="title"><?php esc_html_e("HTML5 Advert setup", 'adrotate-pro'); ?></div></a>
								<div class="sub_title"><?php esc_html_e("Professional service", 'adrotate-pro'); ?></div>
								<div class="cta"><a role="button" class="cta_button" href="https://ajdg.solutions/product/adrotate-html5-setup-service/" target="_blank"><?php esc_html_e("Learn more", 'adrotate-pro'); ?></a></div>
								<hr>
								<div class="description"><?php esc_html_e("Do you have a HTML5 advert but can’t get it to work in AdRotate Pro? I’ll install and configure it for you.", 'adrotate-pro'); ?></div>
							</div>							
						</td>
						<td>
							<div class="ajdg-box-content ajdg-box-sale">
								<a href="https://ajdg.solutions/plugins/" target="_blank"><div class="header"><img src="<?php echo plugins_url("/images/offers/more-plugins.jpg", dirname(__FILE__)); ?>" alt="AJdG Solutions Plugins" width="228" height="120"></div></a>
								<a href="https://ajdg.solutions/plugins/" target="_blank"><div class="title"><?php esc_html_e("All my plugins", 'adrotate-pro'); ?></div></a>
								<div class="sub_title"><?php esc_html_e("WordPress", 'adrotate-pro'); ?></div>
								<div class="cta"><a role="button" class="cta_button" href="https://ajdg.solutions/plugins/" target="_blank"><?php esc_html_e("View all plugins", 'adrotate-pro'); ?></a></div>
								<hr>
								<div class="description"><?php esc_html_e("Cool plugins that improve WooCommerce online store; faster checkout, no checkout, payment stats and more!", 'adrotate-pro'); ?></div>
							</div>
						</td>
					</tr>
				</table>
			</div>
		</div>

	</div>
	<div class="ajdg-box-two">

		<div class="ajdg-box">
			<h2 class="ajdg-box-title"><?php _e("Create a support ticket", 'adrotate-pro'); ?></h2>
			<div class="ajdg-box-content">

				<?php if($a['status'] == 1 AND $a['created'] < (current_time('timestamp') - (DAY_IN_SECONDS * 365))) { ?>
					<p><img src="<?php echo plugins_url('/images/icon-contact.png', dirname(__FILE__)); ?>" class="alignleft pro-image" /><strong><?php esc_html_e("Your license has expired.", 'adrotate-pro'); ?></strong><br /><?php esc_html_e("As a thank you for your continued use and support of AdRotate Professional you can get a new license at a special discounted price.", 'adrotate-pro'); ?></a>
					<p><?php esc_html_e("Licenses are valid for 1 year from purchasing. Activating a new license key will re-enable the Premium Support contact form and lets you use AdRotate Geo again.", 'adrotate-pro'); ?></a>
</p>

					<p class="submit">
						<a href="https://ajdg.solutions/get-your-new-adrotate-pro-license/" target="_blank" class="button-primary"><?php esc_html_e("Get new License", 'adrotate-pro'); ?></a>	
						<a href="<?php echo admin_url('admin.php?page=adrotate-settings&tab=license'); ?>" class="button"><?php esc_html_e("I already have a new License key", 'adrotate-pro'); ?></a>	
						<a href="https://support.ajdg.net/index.php?a=add&category=6" class="button" target="_blank"><?php esc_html_e("I need help", 'adrotate-pro'); ?></a>	
					</p>
				<?php } else if($a['status'] == 1 AND $a['created'] > (current_time('timestamp') - (DAY_IN_SECONDS * 365))) { ?>					
					<form name="request" id="post" method="post" action="admin.php?page=adrotate">
						<?php wp_nonce_field('ajdg_nonce_support_request','ajdg_nonce_support'); ?>
					
						<p><img src="<?php echo plugins_url('/images/icon-contact.png', dirname(__FILE__)); ?>" class="alignleft pro-image" />&raquo; <?php esc_html_e("What went wrong? Or what are you trying to do?", 'adrotate-pro'); ?><br />&raquo; <?php esc_html_e("Include error messages and/or relevant information.", 'adrotate-pro'); ?><br />&raquo; <?php esc_html_e("Try to remember any actions that may cause the problem.", 'adrotate-pro'); ?><br />&raquo; <?php esc_html_e("Any code/HTML will be stripped from your message.", 'adrotate-pro'); ?></p>
					
						<h2><?php esc_html_e("Your question", 'adrotate-pro'); ?></h2>
						<p><label for="ajdg_support_username"><strong><?php esc_html_e("Your name:", 'adrotate-pro'); ?></strong><br /><input tabindex="1" name="ajdg_support_username" type="text" class="search-input" style="width:100%;" value="<?php echo $current_user->display_name;?>" autocomplete="off" /></label></p>
						<p><label for="ajdg_support_email"><strong><?php esc_html_e("Your Email Address:", 'adrotate-pro'); ?></strong><br /><input tabindex="2" name="ajdg_support_email" type="text" class="search-input" style="width:100%;" value="<?php echo $current_user->user_email;?>" autocomplete="off" /></label></p>
						<p><label for="ajdg_support_subject"><strong><?php esc_html_e("Subject:", 'adrotate-pro'); ?></strong><br /><input tabindex="3" name="ajdg_support_subject" type="text" class="search-input" style="width:100%;" value="" autocomplete="off" /></label></p>
						<p><label for="ajdg_support_message"><strong><?php esc_html_e("Problem description / Question:", 'adrotate-pro'); ?></strong><br /><textarea tabindex="4" name="ajdg_support_message" style="width:100%; height:100px;"></textarea></label></p>

						<p><label for="ajdg_support_advert"><strong><?php esc_html_e("Advert I need help with:", 'adrotate-pro'); ?></strong> 
							<select tabindex="16" name="ajdg_support_advert">
						        <option value="0"><?php esc_html_e("-- Optionally select an advert --", 'adrotate-pro'); ?></option>
							<?php if($adverts) { ?>
								<?php foreach($adverts as $advert) { ?>
							        <option value="<?php echo $advert->id;?>"><?php echo $advert->id;?> - <?php echo stripslashes($advert->title);?></option>
								<?php } ?>
							<?php } ?>
								</select> <span class="ajdg-tooltip">[?]<span class="ajdg-tooltiptext ajdg-tooltip-top"><?php esc_html_e("Selecting an advert will include the ad settings for Arnan to test on his website. Does not include group or schedule data.", 'adrotate-pro'); ?></span></span>
						</label></p>

						<p><label for="ajdg_support_account"><input tabindex="5" name="ajdg_support_account" id="ajdg_support_account" type="checkbox" /> <?php esc_html_e("Please log in to my website and take a look.", 'adrotate-pro'); ?> <span class="ajdg-tooltip">[?]<span class="ajdg-tooltiptext ajdg-tooltip-top">Checking this option will create a (temporary) account for Arnan to log in and take a look at your setup.</span></span></label></p>
<!-- 							<p><label for="ajdg_support_copy"><input tabindex="5" name="ajdg_support_copy" id="ajdg_support_copy" type="checkbox" /> <?php esc_html_e("Send me a copy of this message.", 'adrotate-pro'); ?></label></p> -->

						<h2><?php esc_html_e("Your feedback (optional)", 'adrotate-pro'); ?></h2>
						<p><label for="ajdg_support_favorite"><strong><?php esc_html_e("Favorite feature in AdRotate Professional?", 'adrotate-pro'); ?></strong><br /><input tabindex="6" name="ajdg_support_favorite" type="text" class="search-input" style="width:100%;" value="" autocomplete="off" /></label></p>
						<p><label for="ajdg_support_feedback"><strong><?php esc_html_e("Which feature do you think should be improved?", 'adrotate-pro'); ?></strong><br /><input tabindex="7" name="ajdg_support_feedback" type="text" class="search-input" style="width:100%;" value="" autocomplete="off" /></label></p>
</span></label></p>
					
						<p><strong><?php esc_html_e("When you send this form the following data will be submitted:", 'adrotate-pro'); ?></strong><br/>
						<em><?php esc_html_e("Your name, Account email address as entered above. Added information includes your website url and some basic WordPress information. This is so Arnan will have a better understanding of your website so he can help you faster.", 'adrotate-pro'); ?></em></p>
					

						<p class="submit">
							<input tabindex="8" type="submit" name="adrotate_support_submit" class="button-primary" value="<?php esc_html_e("Create ticket", 'adrotate-pro'); ?>" />&nbsp;&nbsp;&nbsp;<em><?php esc_html_e("Please use English or Dutch only!", 'adrotate-pro'); ?></em>
						</p>

						<p><strong><?php esc_html_e("Note:", 'adrotate-pro'); ?></strong> <?php esc_html_e("Creating multiple tickets with the same question will put you at the very end of my support priorities. Please do not send the same message more than once here or elsewhere. Thank you!", 'adrotate-pro'); ?></p>
					
					</form>
		
				<?php } else { ?>
					<p><img src="<?php echo plugins_url('/images/icon-contact.png', dirname(__FILE__)); ?>" class="alignleft pro-image" /><?php esc_html_e("When you activate your AdRotate Professional license you can use fast ticket support right from this page. Tickets submitted through your dashboard always get priority over other contact methods. No more queueing up in forums or through email.", 'adrotate-pro'); ?></p>
					<p><?php esc_html_e("Ticket support is available for Single, Duo and Multi licenses.", 'adrotate-pro'); ?></p>

					<p class="submit">
						<a href="<?php echo admin_url('admin.php?page=adrotate-settings&tab=license'); ?>" class="button-primary"><?php esc_html_e("Activate License", 'adrotate-pro'); ?></a>	
						<a href="https://support.ajdg.net/knowledgebase.php?category=2" class="button" target="_blank"><?php esc_html_e("I need help with my license", 'adrotate-pro'); ?></a>	
					</p>
				<?php }	?>

			</div>
		</div>

	</div>
</div>