<?php

namespace Directorist_Booking\App\Models;

use Directorist_Booking\WpMVC\App;
use Directorist_Booking\WpMVC\Database\Eloquent\Model;
use Directorist_Booking\WpMVC\Database\Eloquent\Relations\HasMany;
use Directorist_Booking\WpMVC\Database\Resolver;

class Post extends Model {
    public static function get_table_name():string {
        return 'posts';
    }

    public function meta(): HasMany {
        return $this->has_many( PostMeta::class, 'post_id', 'ID' );
    }

    public function resolver():Resolver {
        return App::$container->get( Resolver::class );
    }
}