<?php

namespace Directorist_Booking\App\Providers;

defined( "ABSPATH" ) || exit;

use Directorist_Booking\WpMVC\Contracts\Provider;
use Directorist_Booking\WpMVC\Exceptions\Exception;

class CustomPage implements Provider {
    public function boot() {
        if ( get_option( 'atbdp_booking_confirmation' ) < 1 ) {
            add_action( 'wp_loaded', [ $this, 'add_custom_page' ] );
        }
    }

    public function add_custom_page() {
        $create_permission = apply_filters( 'atbdp_create_required_pages', true );
        if ( $create_permission ) {
            bdb_create_required_pages();
        }
    }
}