<?php

namespace Directorist_Booking\App\Providers;

use Directorist_Booking\WpMVC\Contracts\Provider;

class MenuServiceProvider implements Provider
{
    public function boot() {
        add_filter( 'atbdp_listing_meta_admin_submission', [ $this, 'atbdp_bdb_admin_submission' ] );
        add_filter( 'atbdp_listing_meta_user_submission', [ $this, 'atbdp_listing_meta_user_submission' ] );
    }

    /**
     * Save meta for admin
     */
    public function atbdp_bdb_admin_submission( $metas ) {

        $metas['_bdb']                             = ! empty( $_POST['bdb'] ) ? atbdp_sanitize_array( $_POST['bdb'] ) : []; // we are expecting array value
        $metas['_bdb_hide_booking']                = ! empty( $_POST['bdb_hide_booking'] ) ? sanitize_text_field( $_POST['bdb_hide_booking'] ) : '';
        $metas['_bdb_payment_booking']             = ! empty( $_POST['bdb_payment_booking'] ) ? sanitize_text_field( $_POST['bdb_payment_booking'] ) : '';
        $metas['_bdb_instant_booking']             = ! empty( $_POST['bdb_instant_booking'] ) ? sanitize_text_field( $_POST['bdb_instant_booking'] ) : '';
        $metas['_bdb_calender_unavailable']        = ! empty( $_POST['bdb_calender_unavailable'] ) ? sanitize_text_field( $_POST['bdb_calender_unavailable'] ) : '';
        $metas['_bdb_calender_price']              = ! empty( $_POST['bdb_calender_price'] ) ? sanitize_text_field( $_POST['bdb_calender_price'] ) : '';
        $metas['_bdb_reservation_fee']             = ! empty( $_POST['bdb_reservation_fee'] ) ? (float) $_POST['bdb_reservation_fee'] : '';
        $metas['_bdb_weekend_price']               = ! empty( $_POST['bdb_weekend_price'] ) ? (float) $_POST['bdb_weekend_price'] : '';
        $metas['_bdb_reservation_guest']           = ! empty( $_POST['bdb_reservation_guest'] ) ? (int) $_POST['bdb_reservation_guest'] : '';
        $metas['_bdb_slot_status']                 = ! empty( $_POST['bdb_slot_status'] ) ? sanitize_text_field( $_POST['bdb_slot_status'] ) : '';
        $metas['_bdb_display_slot_available_text'] = ! empty( $_POST['bdb_display_slot_available_text'] ) ? sanitize_text_field( $_POST['bdb_display_slot_available_text'] ) : '';
        $metas['_bdb_display_available_time']      = ! empty( $_POST['bdb_display_available_time'] ) ? sanitize_text_field( $_POST['bdb_display_available_time'] ) : '';
        $metas['_bdb_slot_available_text']         = ! empty( $_POST['bdb_slot_available_text'] ) ? sanitize_text_field( $_POST['bdb_slot_available_text'] ) : '';
        $metas['_bdb_available_time_text']         = ! empty( $_POST['bdb_available_time_text'] ) ? sanitize_text_field( $_POST['bdb_available_time_text'] ) : '';
        $metas['_bdb_booking_type']                = ! empty( $_POST['bdb_booking_type'] ) ? $_POST['bdb_booking_type'] : '';
        $metas['_bdb_display_available_ticket']    = ! empty( $_POST['bdb_display_available_ticket'] ) ? $_POST['bdb_display_available_ticket'] : '';
        $metas['_bdb_available_ticket_text']       = ! empty( $_POST['bdb_available_ticket_text'] ) ? $_POST['bdb_available_ticket_text'] : '';
        $metas['_bdb_event_ticket']                = ! empty( $_POST['bdb_event_ticket'] ) ? $_POST['bdb_event_ticket'] : '';
        $metas['_bdb_maximum_ticket_allowed']      = ! empty( $_POST['bdb_maximum_ticket_allowed'] ) ? $_POST['bdb_maximum_ticket_allowed'] : '';

        //refund policy data
        $metas['_enable_refund'] = ! empty( $_POST['enable_refund'] ) ? $_POST['enable_refund'] : '';
        $metas['_refund_policy'] = ! empty( $_POST['refund_policy'] ) ? $_POST['refund_policy'] : '';
        $metas['_refund_rules']  = ! empty( $_POST['refund_rules'] ) ? directorist_clean( $_POST['refund_rules'] ) : [];

        
        return $metas;
    }

    /**
     * Save meta for frontend
     */
    public function atbdp_listing_meta_user_submission( $metas ) {

        $metas['_bdb']                             = ! empty( $_POST['bdb'] ) ? atbdp_sanitize_array( $_POST['bdb'] ) : []; // we are expecting array value
        $metas['_bdb_hide_booking']                = ! empty( $_POST['bdb_hide_booking'] ) ? sanitize_text_field( $_POST['bdb_hide_booking'] ) : '';
        $metas['_bdb_payment_booking']             = ! empty( $_POST['bdb_payment_booking'] ) ? sanitize_text_field( $_POST['bdb_payment_booking'] ) : '';
        $metas['_bdb_instant_booking']             = ! empty( $_POST['bdb_instant_booking'] ) ? sanitize_text_field( $_POST['bdb_instant_booking'] ) : '';
        $metas['_bdb_calender_unavailable']        = ! empty( $_POST['bdb_calender_unavailable'] ) ? sanitize_text_field( $_POST['bdb_calender_unavailable'] ) : '';
        $metas['_bdb_calender_price']              = ! empty( $_POST['bdb_calender_price'] ) ? sanitize_text_field( $_POST['bdb_calender_price'] ) : '';
        $metas['_bdb_reservation_fee']             = ! empty( $_POST['bdb_reservation_fee'] ) ? (float) $_POST['bdb_reservation_fee'] : '';
        $metas['_bdb_weekend_price']               = ! empty( $_POST['bdb_weekend_price'] ) ? (float) $_POST['bdb_weekend_price'] : '';
        $metas['_bdb_reservation_guest']           = ! empty( $_POST['bdb_reservation_guest'] ) ? (int) $_POST['bdb_reservation_guest'] : '';
        $metas['_bdb_slot_status']                 = ! empty( $_POST['bdb_slot_status'] ) ? sanitize_text_field( $_POST['bdb_slot_status'] ) : '';
        $metas['_bdb_display_slot_available_text'] = ! empty( $_POST['bdb_display_slot_available_text'] ) ? sanitize_text_field( $_POST['bdb_display_slot_available_text'] ) : '';
        $metas['_bdb_display_available_time']      = ! empty( $_POST['bdb_display_available_time'] ) ? sanitize_text_field( $_POST['bdb_display_available_time'] ) : '';
        $metas['_bdb_slot_available_text']         = ! empty( $_POST['bdb_slot_available_text'] ) ? sanitize_text_field( $_POST['bdb_slot_available_text'] ) : '';
        $metas['_bdb_available_time_text']         = ! empty( $_POST['bdb_available_time_text'] ) ? sanitize_text_field( $_POST['bdb_available_time_text'] ) : '';
        $metas['_bdb_booking_type']                = ! empty( $_POST['bdb_booking_type'] ) ? $_POST['bdb_booking_type'] : '';
        $metas['_bdb_event_ticket']                = ! empty( $_POST['bdb_event_ticket'] ) ? $_POST['bdb_event_ticket'] : '';
        $metas['_bdb_display_available_ticket']    = ! empty( $_POST['bdb_display_available_ticket'] ) ? $_POST['bdb_display_available_ticket'] : '';
        $metas['_bdb_available_ticket_text']       = ! empty( $_POST['bdb_available_ticket_text'] ) ? $_POST['bdb_available_ticket_text'] : '';
        $metas['_bdb_maximum_ticket_allowed']      = ! empty( $_POST['bdb_maximum_ticket_allowed'] ) ? $_POST['bdb_maximum_ticket_allowed'] : '';

        //refund policy data
        $metas['_enable_refund'] = ! empty( $_POST['enable_refund'] ) ? $_POST['enable_refund'] : '';
        $metas['_refund_policy'] = ! empty( $_POST['refund_policy'] ) ? $_POST['refund_policy'] : '';
        $metas['_refund_rules']  = ! empty( $_POST['refund_rules'] ) ? directorist_clean( $_POST['refund_rules'] ) : [];
        return $metas;
    }
}