<?php

namespace Directorist_Booking\App\Providers\Refund;

defined( "ABSPATH" ) || exit;

use Directorist_Booking\WpMVC\Contracts\Provider;
use Directorist_Booking\WpMVC\Exceptions\Exception;
use Directorist_Booking\App\Providers\Database;
class AdminRefund implements Provider {
    public function boot() {
        add_action( 'init', [ $this, 'booking_refund' ] );
        add_filter( 'manage_bdb_refund_posts_columns', [ $this, 'bdb_refund_add_new_plan_columns' ] );
        add_action( 'manage_bdb_refund_posts_custom_column', [ $this, 'bdb_refund_column_content' ], 10, 2 );
        add_action( 'pre_get_posts', [ $this, 'reorder_my_cpt' ] );
        add_action( 'publish_bdb_refund', [ $this, 'save_post' ], 10, 2 );
    }

    public function save_post( $post_id, $post ) {

        if ( 'bdb_refund' !== $post->post_type ) {
            return;
        }
        $booking_id    = get_post_meta( $post_id, '_refund_booking_id' );
        $commission_id = get_post_meta( $post_id, '_refund_commission_id', true );
        $amount        = get_post_meta( $post_id, '_amount', true );

        $booking_id = ! empty( $booking_id ) ? $booking_id[0] : '';

        Database::set_booking_status( $booking_id, 'cancelled' );
        
        update_post_meta( $post_id, '_refund_status', 'paid' );
        if ( ! empty( $commission_id ) ) {
            $balance_pay = get_post_meta( $commission_id, '_total_balance_pay', true );
            if ( ! empty( $balance_pay ) && $balance_pay > $amount ) {
                $total_payable_amount = $balance_pay - $amount;
                update_post_meta( $commission_id, '_total_balance_pay', $total_payable_amount );
            }
            
        }

        //mail ( Admin to Visitor )
        $user_name  = get_post_meta( $post_id, '_refund_user_name', true );
        $owner_id   = get_post_meta( $post_id, '_refund_owner_id', true );
        $user_id    = get_post_meta( $post_id, '_refund_booking_author', true );
        $listing_id = get_post_meta( $post_id, '_refund_listing_id', true );
        $admin_mail = get_option( 'admin_email' );

        $site_name  = get_bloginfo( 'name' );
        $owner_info = get_userdata( $owner_id );
        $user_info  = get_userdata( $user_id );

        $headers = "From: {$site_name} <{$admin_mail}>\r\n";
        $sub     = __( 'Refund Confirmation', 'directorist-booking' );

        $body = Database::replace_in_content(
            __(
                "Hello ==USERNAME_WHO_BOOKED==,

        This email is to confirm that we have processed your refund of ==REFUND_AMOUNT== and the payment has been successfully completed.

        Thank you for being a valued customer & for being so patient while we were processing your request. We hope that this speedy turnaround was satisfactory. Should you have any questions or concerns, please do not hesitate to contact us.

        Sincerely, 
        Administrator
        ", 'directorist-booking'
            ), $listing_id, $user_info, $amount 
        );

        $body = atbdp_email_html( $sub, $body );

        ATBDP()->email->send_mail( $user_info->user_email, $sub, $body, $headers );

        //mail ( Admin to Listing Owner )
        $body = Database::replace_in_content(
            __(
                "Hello ==LISTING_OWNER==,

        This email is to confirm that we have processed your refund of ==REFUND_AMOUNT== and the payment has been successfully completed.

        Thank you for being a valued customer & for being so patient while we were processing your request. We hope that this speedy turnaround was satisfactory. Should you have any questions or concerns, please do not hesitate to contact us.

        Sincerely, 
        Administrator
        ", 'directorist-booking'
            ), $listing_id, $owner_info, $amount 
        );

        $body = atbdp_email_html( $sub, $body );

        ATBDP()->email->send_mail( $owner_info->user_email, $sub, $body, $headers );
    }

    public function reorder_my_cpt( $q ) {
        if ( is_admin() && in_array( $q->get( 'post_type' ), [ 'bdb_refund' ] ) ) {
            $q->set( 'meta_key', '_refund_status' );
            $q->set( 'meta_value', [ 'admin_processing', 'paid' ] );
        }
    }

    public function booking_refund() {

        $labels_two = [
            'name'               => _x( 'Refunds', 'Post type general name', 'directorist-booking' ),
            'singular_name'      => _x( 'Refund', 'Post type singular name', 'directorist-booking' ),
            'menu_name'          => _x( 'Refunds', 'Admin Menu text', 'directorist-booking' ),
            'name_admin_bar'     => _x( 'Refunds', 'Add New on Toolbar', 'directorist-booking' ),
            'new_item'           => __( 'New Refunds', 'directorist-booking' ),
            'edit_item'          => __( 'Edit Refunds', 'directorist-booking' ),
            'view_item'          => __( 'View Refunds', 'directorist-booking' ),
            'all_items'          => __( 'Refunds', 'directorist-booking' ),
            'search_items'       => __( 'Search Refunds', 'directorist-booking' ),
            'parent_item_colon'  => __( 'Parent Refunds:', 'directorist-booking' ),
            'not_found'          => __( 'No Refund found.', 'directorist-booking' ),
            'not_found_in_trash' => __( 'No Refunds found in Trash.', 'directorist-booking' ),
        ];

        $args_two = [
            'labels'              => $labels_two,
            'supports'            => [ 'title', 'editor' ],
            'public'              => true,
            'publicly_queryable'  => true,
            'show_ui'             => true,
            'show_in_menu'        => 'edit.php?post_type=bdb_commission',
            'query_var'           => true,
            'rewrite'             => [ 'slug' => 'commission' ],
            'capabilities'        => [
                'create_posts' => 'do_not_allow',
            ],
            'has_archive'         => true,
            'hierarchical'        => false,
            'menu_position'       => null,
            'show_in_nav_menus'   => true,
            'can_export'          => true,
            'exclude_from_search' => true,
            //'capability_type' => 'at_biz_dir',
            'map_meta_cap'        => true,
        ];

        register_post_type( 'bdb_refund', $args_two );
    }

    public function bdb_refund_add_new_plan_columns() {
        $columns = [
            'cb'                => '<input type="checkbox" />',                      // Render a checkbox instead of text
            'user_name'         => __( 'User Name', 'directorist-booking' ),
            'payment_status'    => __( 'Payment Status', 'directorist-booking' ),
            'order_date'        => __( 'Order Date', 'directorist-booking' ),
            'refund_request_on' => __( 'Refund Request On', 'directorist-booking' ),
            'amount'            => __( 'Amount', 'directorist-booking' ),
        ];

        return $columns;
    }

    public function bdb_refund_column_content( $column, $post_id ) {
        echo '</select>';
        switch ( $column ) {
            case 'user_name' :
                $post_meta = get_post_meta( $post_id );
                $username  = isset( $post_meta['_refund_user_name'] ) ? esc_attr( $post_meta['_refund_user_name'][0] ) : '';
                printf( '<p><a href="%s"> %s</a></p>', get_edit_post_link( $post_id ), $username );
                break;
            case 'payment_status' :
                $post_meta = get_post_status( $post_id );
                echo $post_meta ;
                break;
            case 'order_date' :
                $post_meta   = get_post_meta( $post_id );
                $booking_id  = isset( $post_meta['_refund_booking_id'] ) ? esc_attr( $post_meta['_refund_booking_id'][0] ) : '';
                $get_booking = Database::get_booking_by_id( $booking_id );
                
                echo ! empty( $get_booking['created'] ) ? date( get_option( 'date_format' ), strtotime( $get_booking['created'] ) ) : '';
                break;
            case 'refund_request_on' :
                
                echo get_the_date();
                break;
            case 'amount' :
                $post_meta   = get_post_meta( $post_id );
                $balance_pay = isset( $post_meta['_amount'][0] ) ? $post_meta['_amount'][0] : '';
                echo $balance_pay ;
                break;
        }
    }
}