<?php

namespace Directorist_Booking\App\Providers\Refund;

defined( "ABSPATH" ) || exit;

use Directorist_Booking\WpMVC\Contracts\Provider;
use Directorist_Booking\WpMVC\Exceptions\Exception;
use Directorist_Booking\App\Providers\Database;

class UserRefund implements Provider {
    public function boot() {
        add_action( 'wp_ajax_bdb_user_refund_form' , [ $this, 'ajax_bdb_user_refund_form' ] );
        add_action( 'wp_ajax_nopriv_bdb_user_refund_form', [ $this, 'ajax_bdb_user_refund_form' ] );

        add_action( 'wp_ajax_bdb_owner_refund' , [ $this, 'ajax_bdb_owner_refund' ] );
        add_action( 'wp_ajax_nopriv_bdb_owner_refund', [ $this, 'ajax_bdb_owner_refund' ] );

        add_action( 'wp_ajax_bdb_owner_refund_decline' , [ $this, 'ajax_bdb_owner_refund_decline' ] );
        add_action( 'wp_ajax_nopriv_bdb_owner_refund_decline', [ $this, 'ajax_bdb_owner_refund_decline' ] );
    }

    public function ajax_bdb_owner_refund_decline() {
        if ( ! directorist_verify_nonce() ) {
            $data['error'] = __( 'Something is wrong! Please refresh and retry.', 'directorist-booking' );
            return wp_send_json( $data );
        }

        $refund_id = ! empty( $_POST['refund_id'] ) ? directorist_clean( wp_unslash( $_POST['refund_id'] ) ) : '';

        $user_name  = get_post_meta( $refund_id, '_refund_user_name', true );
        $owner_id   = get_post_meta( $refund_id, '_refund_owner_id', true );
        $user_id    = get_post_meta( $refund_id, '_refund_booking_author', true );
        $listing_id = get_post_meta( $refund_id, '_refund_listing_id', true );

        //mail
        $site_name  = get_bloginfo( 'name' );
        $owner_info = get_userdata( $owner_id );
        $user_info  = get_userdata( $user_id );

        $headers = "From: {$site_name} <{$owner_info->user_email}>\r\n";
        $sub     = __( 'Refund request cancellation mail', 'directorist-booking' );

        $body = Database::replace_in_content(
            __(
                "Hello ==USERNAME_WHO_BOOKED==,

        We appreciate your interest in the refund request. Unfortunately, we've been unable to process the request as it didn't match the terms and conditions associated with the product's refund policy. We apologize for any inconvenience this may have caused.

        We hope you have a great day!
        ", 'directorist-booking'
            ), $listing_id, $user_info 
        );

        $body = atbdp_email_html( $sub, $body );

        ATBDP()->email->send_mail( $user_info->user_email, $sub, $body, $headers );

        // delete the post
        wp_delete_post( $refund_id );

        wp_send_json( 'done' );
    }

    public function ajax_bdb_user_refund_form() {
        if ( ! directorist_verify_nonce() ) {
            $data['error'] = __( 'Something is wrong! Please refresh and retry.', 'directorist-booking' );
            return wp_send_json( $data );
        }

        $amount                = ! empty( $_POST['amount'] ) ? directorist_clean( wp_unslash( $_POST['amount'] ) ) : '';
        $refund_reason         = ! empty( $_POST['refund_reason'] ) ? directorist_clean( wp_unslash( $_POST['refund_reason'] ) ) : '';
        $payment_details       = ! empty( $_POST['payment_details'] ) ? directorist_clean( wp_unslash( $_POST['payment_details'] ) ) : '';
        $refund_booking_id     = ! empty( $_POST['refund_booking_id'] ) ? directorist_clean( wp_unslash( $_POST['refund_booking_id'] ) ) : '';
        $refund_user_name      = ! empty( $_POST['refund_user_name'] ) ? directorist_clean( wp_unslash( $_POST['refund_user_name'] ) ) : '';
        $refund_booking_author = ! empty( $_POST['refund_booking_author'] ) ? directorist_clean( wp_unslash( $_POST['refund_booking_author'] ) ) : '';
        $refund_owner_id       = ! empty( $_POST['refund_owner_id'] ) ? directorist_clean( wp_unslash( $_POST['refund_owner_id'] ) ) : '';
        $refund_listing_id     = ! empty( $_POST['refund_listing_id'] ) ? directorist_clean( wp_unslash( $_POST['refund_listing_id'] ) ) : '';
        $refund_commission_id  = ! empty( $_POST['refund_commission_id'] ) ? directorist_clean( wp_unslash( $_POST['refund_commission_id'] ) ) : '';
        $get_booking           = Database::get_booking_by_id( $refund_booking_id );
        $order_data            = ! empty( $get_booking['created'] ) ? date( get_option( 'date_format' ), strtotime( $get_booking['created'] ) ) : '';
        $details               = "
		
		
		=== Summary ===
		Refund Reason: $refund_reason
        Payment Details: $payment_details
		Amount: $amount

        Order Date: $order_data
        Refund Requested On:
		";

        $args    = [
            'post_title'   => 'New refund request from ' . $refund_user_name,
            'post_content' => $details,
        ];
        $default = [
            'post_type'   => 'bdb_refund',
            'post_status' => 'pending',
        ];

        $refund = wp_insert_post( array_merge( $default, $args ) );
        
        update_post_meta( $refund, '_amount', $amount );
        update_post_meta( $refund, '_refund_reason', $refund_reason );
        update_post_meta( $refund, '_payment_details', $payment_details );
        update_post_meta( $refund, '_refund_booking_id', $refund_booking_id );
        update_post_meta( $refund, '_refund_user_name', $refund_user_name );
        update_post_meta( $refund, '_refund_booking_author', $refund_booking_author );
        update_post_meta( $refund, '_refund_owner_id', $refund_owner_id );
        update_post_meta( $refund, '_refund_listing_id', $refund_listing_id );
        update_post_meta( $refund, '_refund_commission_id', $refund_commission_id );
        update_post_meta( $refund, '_refund_status', 'on_hold' );
        
        if ( is_wp_error( $refund ) ) {
            $response['error']   = true;
            $response['message'] = esc_html__( 'Error requesting refund, please try again.', 'directorist-booking' );
            wp_send_json( $response );
        }
        $response['message'] = esc_html__( 'Successfully submitted your refund request', 'directorist-booking' );

        wp_send_json( $response );
    }

    public function ajax_bdb_owner_refund() {
        if ( ! directorist_verify_nonce() ) {
            $data['error'] = __( 'Something is wrong! Please refresh and retry.', 'directorist-booking' );
            return wp_send_json( $data );
        }

        $refund_id  = ! empty( $_POST['refund_id'] ) ? directorist_clean( wp_unslash( $_POST['refund_id'] ) ) : '';
        $user_name  = get_post_meta( $refund_id, '_refund_user_name', true );
        $owner_id   = get_post_meta( $refund_id, '_refund_owner_id', true );
        $user_id    = get_post_meta( $refund_id, '_refund_booking_author', true );
        $listing_id = get_post_meta( $refund_id, '_refund_listing_id', true );

        $refund_booking_id   = get_post_meta( $refund_id, '_refund_booking_id', true );
        $refund_reason       = get_post_meta( $refund_id, '_refund_reason', true );
        $payment_details     = get_post_meta( $refund_id, '_payment_details', true );
        $amount              = get_post_meta( $refund_id, '_amount', true );
        $listing_id          = get_post_meta( $refund_id, '_refund_listing_id', true );
        $get_booking         = Database::get_booking_by_id( $refund_booking_id );
        $order_data          = ! empty( $get_booking['created'] ) ? date( get_option( 'date_format' ), strtotime( $get_booking['created'] ) ) : '';
        $refund_requested_on = get_the_date( '', $refund_id );
        $content             = "
		
		
		=== Summary ===
		Refund Reason: $refund_reason
        Payment Details: $payment_details
		Amount: $amount

        Order Date: $order_data
        Refund Requested On: $refund_requested_on
		";

        $update_post = [
            'ID'           => $refund_id,
            'post_content' => $content
        ];

        update_post_meta( $refund_id, '_refund_status', 'admin_processing' );

        wp_update_post( $update_post );

        //mail ( Author to Visitor )
        $site_name  = get_bloginfo( 'name' );
        $owner_info = get_userdata( $owner_id );
        $user_info  = get_userdata( $user_id );

        $headers = "From: {$site_name} <{$owner_info->user_email}>\r\n";
        $sub     = __( 'Refund approval mail on progress', 'directorist-booking' );

        $body = Database::replace_in_content(
            __(
                "Hello ==USERNAME_WHO_BOOKED==,

        We are pleased to inform you that we have accepted your refund request and have started the process. We will transfer the amount back to your original payment source within 10 working days. 

        If you have any queries or need more information, please do not hesitate to contact us. 

        Thank you for choosing us.

        Sincerely, 
        ==LISTING_TITLE==
        ", 'directorist-booking'
            ), $listing_id, $user_info 
        );

        $body = atbdp_email_html( $sub, $body );

        ATBDP()->email->send_mail( $user_info->user_email, $sub, $body, $headers );

        //mail ( Author to Admin )
        $site_name  = get_bloginfo( 'name' );
        $owner_info = get_userdata( $owner_id );
        $user_info  = get_userdata( $user_id );
        $admin_mail = get_option( 'admin_email' );

        $headers = "From: {$site_name} <{$owner_info->user_email}>\r\n";
        $sub     = __( 'Refund request approval', 'directorist-booking' );

        $body = Database::replace_in_content(
            __(
                "Hello Administrator,

        I hope this email finds you well. I would like to request a refund request approval for ==LISTING_TITLE== purchased by ==USERNAME_WHO_BOOKED== as it has fulfilled all the terms and conditions of our associated refund policy. Thanks in advance for your time and consideration.

        Sincerely,
        ==LISTING_TITLE==
        ", 'directorist-booking'
            ), $listing_id, $user_info 
        );

        $body = atbdp_email_html( $sub, $body );

        ATBDP()->email->send_mail( $admin_mail, $sub, $body, $headers );

        wp_send_json( 'done' );
    }
}