<?php

namespace Directorist_Booking\App\Providers;

defined( "ABSPATH" ) || exit;

use Directorist_Booking\WpMVC\Contracts\Provider;
use Directorist_Booking\WpMVC\Exceptions\Exception;

class Widget implements Provider {
    public function boot() {
        add_action( 'widgets_init', [ $this, 'add_widget_for_booking' ] );
    }

    public function add_widget_for_booking() {
        $booking = get_directorist_option( 'enable_booking',1 );
        if ( ! empty( $booking ) ) {
            register_widget( BDB_Widget_Template::class );
        }
    }
}