<?php

namespace Directorist_Booking\App\Providers;

defined( "ABSPATH" ) || exit;

use Directorist_Booking\WpMVC\Contracts\Provider;
use Directorist_Booking\WpMVC\Exceptions\Exception;
use Directorist_Booking\App\Providers\Database;

class WooCommercePayment implements Provider {
    public function boot() {
        add_action( 'wp_ajax_bdb_wcc_payment' , [ $this, 'ajax_bdb_wcc_payment' ] );
        add_action( 'wp_ajax_nopriv_bdb_wcc_payment', [ $this, 'ajax_bdb_wcc_payment' ] );

        add_action( 'woocommerce_order_status_completed', [ $this, 'booking_paid' ], 9, 3 ); 
    }

    public function ajax_bdb_wcc_payment() {
        $email      = ! empty( $_POST['email'] ) ? esc_attr( $_POST['email'] ) : '';
        $first_name = ! empty( $_POST['first_name'] ) ? esc_attr( $_POST['first_name'] ) : '';
        $user_id    = ! empty( $_POST['user_id'] ) ? esc_attr( $_POST['user_id'] ) : '';
        $owner_id   = ! empty( $_POST['owner_id'] ) ? esc_attr( $_POST['owner_id'] ) : '';
        $price      = ! empty( $_POST['price'] ) ? esc_attr( $_POST['price'] ) : '';
        $booking_id = ! empty( $_POST['booking_id'] ) ? esc_attr( $_POST['booking_id'] ) : '';
        $confirmed  = ! empty( $_POST['confirmed'] ) ? esc_attr( $_POST['confirmed'] ) : '';

        $data = json_decode( wp_unslash( htmlspecialchars_decode( wp_unslash( $_POST['value'] ) ) ), true );
        
        $order = wc_create_order();

        $args['totals']['subtotal'] = $price;
        $args['totals']['total']    = $price;

        $order->add_product( wc_get_product( 137 ), 1, $args );

        $order->set_address( ['first_name' => $first_name], 'billing' );
        $order->set_customer_id( $user_id );
        $order->set_billing_email( $email );

        $order->calculate_totals();
        $order->save();
        
        $order->update_meta_data( 'owner_id', $owner_id );
        $order->update_meta_data( '_listing_id', $data['listing_id'] );
        $order->save_meta_data();

        $payment_url = $order->get_checkout_payment_url();
        $order_id    = $order->get_order_number();

        $instant_booking = get_post_meta( $data['listing_id'], '_bdb_instant_booking', true );
        $status          = 'waiting';
        if ( ! empty( $instant_booking ) ) {
            $status = 'confirmed';
        }
        $services = ( isset( $data['services'] ) ) ? $data['services'] : false;

        if ( 'done' == $confirmed ) {

            switch ( $data['listing_type'] ) {
                case 'event' :

                    $comment = [
                        'first_name' => $first_name,
                    //'last_name' => $_POST['lastname'],
                        'email'      => $_POST['email'],
                        'phone'      => $_POST['phone'],
                        'message'    => $_POST['message'],
                        'tickets'    => $data['tickets'],
                    //'service' => $comment_services,
                    ];

                    Database::insert_booking(
                        [
                            'owner_id'   => $owner_id,
                            'order_id'   => $order_id,
                            'listing_id' => $data['listing_id'],
                            'date_start' => $data['date_start'],
                            'date_end'   => $data['date_start'],
                            'comment'    => json_encode( $comment ),
                            'type'       => 'reservation',
                            'price'      => $price,
                            'status'     => $status
                        ]
                    );

                    $already_sold_tickets = (int) get_post_meta( $data['listing_id'], '_event_tickets_sold', true );
                    $sold_now             = $already_sold_tickets + $data['tickets'];
                    update_post_meta( $data['listing_id'], '_event_tickets_sold', $sold_now );


                case 'rent' :

                    // get default status
                    $status = apply_filters( 'bdb_rental_default_status', 'waiting' );

                    // count free places
                    $free_places = Database::count_free_places( $data['listing_id'], $data['date_start'], $data['date_end'] );

                    if ( $free_places > 0 ) {

                        $count_per_guest = get_post_meta( $data['listing_id'], "_count_per_guest", true );
                        //check count_per_guest

                        if ( $count_per_guest ) {

                            $multiply                                 = 1;
                            if ( isset( $data['adults'] ) ) $multiply = $data['adults'];

                            $price = Database::calculate_price( $data['listing_id'], $data['date_start'], $data['date_end'], $multiply );
                        } else {
                            $price = Database::calculate_price( $data['listing_id'], $data['date_start'], $data['date_end'], 1 );
                        }

                        Database::insert_booking(
                            [
                                'owner_id'   => $owner_id,
                                'order_id'   => $order_id,
                                'listing_id' => $data['listing_id'],
                                'date_start' => $data['date_start'],
                                'date_end'   => $data['date_end'],
                                'comment'    => json_encode(
                                    [
                                        'first_name'     => $first_name,
                                    //'last_name' => $_POST['lastname'],
                                        'email'          => $_POST['email'],
                                        'phone'          => $_POST['phone'],
                                        'year'           => $_POST['rv_year'],
                                        'length'         => $_POST['length'],
                                        'slide_outs'     => $_POST['slide_outs'],
                                        'message'        => $_POST['message'],
                                        'checkbox_items' => isset( $_POST['single_listing_checkbox'] ) ? serialize( $_POST['single_listing_checkbox'] ) : [],
                                        'checkbox_label' => isset( $_POST['single_listing_checkbox_label'] ) ? $_POST['single_listing_checkbox_label'] : '',
                                    //'childrens' => $data['childrens'],
                                        'adults'         => $data['adults'],
                                    //'service' => $comment_services,
                                    // 'tickets' => $data['tickets']
                                    ]
                                ),
                                'type'       => 'reservation',
                                'price'      => $price,
                                'status'     => $status
                            ]
                        );

                    } else {

                        $error   = true;
                        $message = __( 'Unfortunately those dates are not available anymore.', 'directorist-booking' );

                    }

                    break;

                case 'service' :

                    // when we dealing with opening hours
                    if ( ! isset( $data['slot'] ) ) {
                        $count_per_guest = get_post_meta( $data['listing_id'], "_count_per_guest", true );
                        //check count_per_guest

                        if ( $count_per_guest ) {

                            $multiply                                 = 1;
                            if ( isset( $data['adults'] ) ) $multiply = $data['adults'];

                            $price = Database::calculate_price( $data['listing_id'], $data['date_start'], $data['date_end'], $multiply );
                        } else {
                            $price = Database::calculate_price( $data['listing_id'], $data['date_start'], $data['date_end'], 1 );
                        }

                        Database::insert_booking(
                            [
                                'owner_id'   => $owner_id,
                                'order_id'   => $order_id,
                                'listing_id' => $data['listing_id'],
                                'date_start' => $data['date_start'] . ' ' . $data['_hour'] . ':00',
                                'date_end'   => $data['date_end'] . ' ' . $data['_hour'] . ':00',
                                'comment'    => json_encode(
                                    ['first_name' => $first_name,
                                    //'last_name' => $_POST['lastname'],
                                        'email'   => $_POST['email'],
                                        'phone'   => $_POST['phone'],
                                        'adults'  => isset( $data['adults'] ) ? $data['adults'] : '',
                                        'message' => $_POST['message'],
                                    //'service' => $comment_services,

                                    ]
                                ),
                                'type'       => 'reservation',
                                'price'      => $price,
                                'status'     => $status
                            ]
                        );

                    } else {

                        // here when we have enabled slots

                        $free_places = Database::count_free_places( $data['listing_id'], $data['date_start'], $data['date_end'], $data['slot'] );

                        if ( $free_places > 0 ) {

                            $slot = json_decode( wp_unslash( $data['slot'] ) );

                            // converent hours to mysql format
                            $hours      = explode( '-', $slot[0] );
                            $hour_start = date( "H:i:s", strtotime( $hours[0] ) );
                            $hour_end   = date( "H:i:s", strtotime( $hours[1] ) );

                            $count_per_guest = get_post_meta( $data['listing_id'], "_count_per_guest", true );
                            //check count_per_guest
                            $services = ( isset( $data['services'] ) ) ? $data['services'] : false;
                            if ( $count_per_guest ) {

                                $multiply                                 = 1;
                                if ( isset( $data['adults'] ) ) $multiply = $data['adults'];

                                $price = Database::calculate_price( $data['listing_id'], $data['date_start'], $data['date_end'], $multiply );
                            } else {
                                $price = Database::calculate_price( $data['listing_id'], $data['date_start'], $data['date_end'], 1 );
                            }
                            Database::insert_booking(
                                [
                                    'owner_id'   => $owner_id,
                                    'order_id'   => $order_id,
                                    'listing_id' => $data['listing_id'],
                                    'date_start' => $data['date_start'] . ' ' . $hour_start,
                                    'date_end'   => $data['date_end'] . ' ' . $hour_end,
                                    'comment'    => json_encode(
                                        ['first_name'        => $first_name,
                                        //'last_name' => $_POST['lastname'],
                                            'email'          => $_POST['email'],
                                            'phone'          => $_POST['phone'],
                                        //'childrens' => $data['childrens'],
                                            'adults'         => isset( $data['adults'] ) ? $data['adults'] : 0,
                                            'message'        => $_POST['message'],
                                            'year'           => $_POST['rv_year'],
                                            'length'         => $_POST['length'],
                                            'slide_outs'     => $_POST['slide_outs'],
                                            'message'        => $_POST['message'],
                                            'checkbox_items' => isset( $_POST['single_listing_checkbox'] ) ? serialize( $_POST['single_listing_checkbox'] ) : [],
                                            'checkbox_label' => isset( $_POST['single_listing_checkbox_label'] ) ? $_POST['single_listing_checkbox_label'] : '',
                                        //'service' => $comment_services,

                                        ]
                                    ),
                                    'type'       => 'reservation',
                                    'price'      => $price,
                                    'status'     => $status
                                ]
                            );

                        } else {

                            $error   = true;
                            $message = __( 'Those dates are not available.', 'directorist-booking' );

                        }

                    }

                break;
            }

        } elseif ( 'updated' == $confirmed ) {
            global $wpdb;
            $update_values['order_id'] = $order_id;
            $wpdb->update( $wpdb->prefix . 'directorist_booking', $update_values, [ 'id' => $booking_id ] );

        }

        //$this->add_new_booking( $order_id, $data );

        wp_send_json( $payment_url );
        // wp_safe_redirect( $payment_url );
    }

    public function booking_paid( $order_id ) {
        global $wpdb;
        $booking_data = $wpdb->get_row( 'SELECT * FROM `' . $wpdb->prefix . 'directorist_booking` WHERE `order_id`=' . esc_sql( $order_id ), 'ARRAY_A' );

        if ( ! empty( $booking_data ) && ( $order_id == $booking_data['order_id'] ) ) {
            bdb_commission_system( $order_id );
            Database::set_booking_status( $booking_data['ID'], 'paid' );
        }
    }
}