(()=>{"use strict";const e=function(e){const t={CALENDAR_CONTAINER_ID:"directorist-booking-calender",VIEW_DROPDOWN_ID:"booking-calendar-view-dropdown",INITIAL_VIEW:"dayGridMonth",DEBOUNCE_DELAY:500,SEARCH_MIN_LENGTH:2,SEARCH_TIMEOUT:1e4},n="#booking-event-search",o="#booking-event-category",i="#booking-calendar-view",a="#connect-google-calendar";let r=[0,6],s={currentSearch:"",currentCategory:"",isSearching:!1,lastSearchRequest:null,searchResults:[],totalResults:0,hasSearched:!1};const d='<svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">\n    <g clip-path="url(#clip0_8492_3804)">\n    <path d="M10.6848 3.31592H3.31641V10.6843H10.6848V3.31592Z" fill="white"/>\n    <path d="M10.6834 14L13.9993 10.6842L12.3414 10.4014L10.6834 10.6842L10.3809 12.2007L10.6834 14Z" fill="#EA4335"/>\n    <path d="M0 10.6842V12.8947C0 13.5054 0.494594 14 1.10523 14H3.31581L3.65624 12.3421L3.31581 10.6842L1.50932 10.4014L0 10.6842Z" fill="#188038"/>\n    <path d="M13.9993 3.31581V1.10523C13.9993 0.494594 13.5047 0 12.894 0H10.6834C10.4818 0.822281 10.3809 1.42742 10.3809 1.81541C10.3809 2.20336 10.4817 2.70349 10.6834 3.31581C11.4168 3.52581 11.9694 3.63081 12.3414 3.63081C12.7133 3.63081 13.2659 3.52585 13.9993 3.31581Z" fill="#1967D2"/>\n    <path d="M13.9994 3.31592H10.6836V10.6843H13.9994V3.31592Z" fill="#FBBC04"/>\n    <path d="M10.6848 10.6841H3.31641V13.9999H10.6848V10.6841Z" fill="#34A853"/>\n    <path d="M10.6842 0H1.10529C0.494594 0 0 0.494594 0 1.10523V10.6842H3.31581V3.31581H10.6842V0Z" fill="#4285F4"/>\n    <path d="M4.82798 9.0317C4.55258 8.84565 4.36188 8.57396 4.25781 8.21466L4.89705 7.95129C4.95502 8.17234 5.05634 8.34365 5.20101 8.46524C5.34467 8.58681 5.51967 8.6467 5.72415 8.6467C5.9332 8.6467 6.11279 8.58313 6.26293 8.456C6.4131 8.32891 6.48863 8.16681 6.48863 7.97065C6.48863 7.76984 6.40942 7.60588 6.25101 7.47879C6.09258 7.3517 5.89363 7.28815 5.65601 7.28815H5.28665V6.65541H5.61822C5.82268 6.65541 5.99491 6.60012 6.13491 6.48955C6.27491 6.37908 6.34491 6.22798 6.34491 6.03548C6.34491 5.8642 6.28229 5.72786 6.15705 5.62565C6.03182 5.52338 5.87334 5.47181 5.68084 5.47181C5.49293 5.47181 5.34374 5.52158 5.23322 5.62193C5.12273 5.72257 5.03968 5.84968 4.99188 5.99129L4.35915 5.72786C4.44293 5.49024 4.59677 5.28024 4.82241 5.09879C5.04805 4.91734 5.33636 4.82617 5.68636 4.82617C5.9452 4.82617 6.17822 4.87594 6.38455 4.97629C6.59084 5.0767 6.75293 5.21577 6.86991 5.39263C6.98694 5.57036 7.04491 5.76931 7.04491 5.99036C7.04491 6.216 6.9906 6.4067 6.88194 6.56327C6.77327 6.71984 6.63967 6.83955 6.48124 6.92338V6.96112C6.68581 7.04547 6.8635 7.184 6.9952 7.36181C7.12874 7.54141 7.19601 7.756 7.19601 8.00658C7.19601 8.25705 7.13241 8.48088 7.00531 8.67705C6.87822 8.87327 6.70234 9.02798 6.47938 9.14036C6.2556 9.25274 6.00415 9.30989 5.72508 9.30989C5.40177 9.31077 5.10339 9.21774 4.82798 9.0317ZM8.75433 5.85955L8.05252 6.36705L7.70159 5.83472L8.96066 4.92652H9.44328V9.21036H8.75433V5.85955Z" fill="#4285F4"/>\n  </g>\n  <defs>\n    <clipPath id="clip0_8492_3804">\n      <rect width="14" height="14" fill="white"/>\n    </clipPath>\n  </defs>\n  </svg>',c=[{id:"service1",price:150,listing_title:"Professional Consultation Service",date_start:"2025-10-20 09:00:00",date_end:"2025-10-20 11:00:00",booking_type:"service",booking_author_name:"John Anderson",comment:{first_name:"John Anderson",email:"john@example.com",phone:"01712345678",adults:"1 Person",location:"Office Room 302, Dhaka",service:!1,message:"Professional consultation session to discuss project requirements and timeline."}},{id:"service2",price:100,listing_title:"Business Strategy Consultation",date_start:"2025-10-27 09:00:00",date_end:"2025-10-27 11:00:00",booking_type:"service",booking_author_name:"David Smith",comment:{first_name:"David Smith",email:"david@example.com",phone:"01717171717",adults:"1 Person",location:"Gulshan-2, Dhaka",service:!1,message:"Business strategy consultation focused on growth and scaling."}},{id:"service3",price:120,listing_title:"Marketing Consultation",date_start:"2025-10-27 11:00:00",date_end:"2025-10-27 13:00:00",booking_type:"service",booking_author_name:"Sarah Johnson",comment:{first_name:"Sarah Johnson",email:"sarah.j@example.com",phone:"01818181818",adults:"1 Person",location:"Banani, Dhaka",service:!1,message:"Marketing strategy consultation for digital transformation."}},{id:"service4",price:180,listing_title:"Technical Architecture Review",date_start:"2025-10-27 13:00:00",date_end:"2025-10-27 15:00:00",booking_type:"service",booking_author_name:"Michael Chen",comment:{first_name:"Michael Chen",email:"m.chen@example.com",phone:"01919191919",adults:"1 Person",location:"Dhanmondi-27, Dhaka",service:!1,message:"Technical consultation for system architecture and scalability."}},{id:"service5",price:90,listing_title:"Financial Planning Session",date_start:"2025-10-27 15:00:00",date_end:"2025-10-27 17:00:00",booking_type:"service",booking_author_name:"Emily Davis",comment:{first_name:"Emily Davis",email:"emily.d@example.com",phone:"01616161616",adults:"1 Person",location:"Motijheel, Dhaka",service:!1,message:"Financial consultation for business planning and budgeting."}},{id:"service6",price:200,listing_title:"Legal Advisory Consultation",date_start:"2025-10-27 17:00:00",date_end:"2025-10-27 19:00:00",booking_type:"service",booking_author_name:"Robert Williams",comment:{first_name:"Robert Williams",email:"r.williams@example.com",phone:"01515151515",adults:"1 Person",location:"Uttara, Dhaka",service:!1,message:"Legal consultation for business incorporation and compliance."}},{id:"service7",price:150,listing_title:"HR Strategy Consultation",date_start:"2025-10-27 19:00:00",date_end:"2025-10-27 21:00:00",booking_type:"service",booking_author_name:"Jessica Brown",comment:{first_name:"Jessica Brown",email:"jessica.b@example.com",phone:"01414141414",adults:"1 Person",location:"Mirpur DOHS, Dhaka",service:!1,message:"HR consultation for talent acquisition and organizational development."}},{id:"rent1",price:5e3,listing_title:"Conference Hall Rental",date_start:"2025-10-13 09:00:00",date_end:"2025-10-16 18:00:00",booking_type:"rent",booking_author_name:"Cameron Williamson",comment:{first_name:"Cameron Williamson",email:"cameron@example.com",phone:"01812345678",adults:"50 Persons",location:"Conference Hall A, Banani, Dhaka",service:!1,message:"3-day conference hall rental for annual company summit."}},{id:"rent2",price:3500,listing_title:"Office Space Rental",date_start:"2025-10-20 08:00:00",date_end:"2025-10-22 18:00:00",booking_type:"rent",booking_author_name:"Jane Copper",comment:{first_name:"Jane Copper",email:"jane@example.com",phone:"01913456789",adults:"20 Persons",location:"Office Tower 5, Gulshan-1, Dhaka",service:!1,message:"2-day office space rental for startup team offsite."}},{id:"rent3",price:4e3,listing_title:"Training Center Rental",date_start:"2025-10-24 09:00:00",date_end:"2025-10-26 17:00:00",booking_type:"rent",booking_author_name:"Cameron Wilson",comment:{first_name:"Cameron Wilson",email:"wilson@example.com",phone:"01614567890",adults:"30 Persons",location:"Training Center B, Dhanmondi, Dhaka",service:!1,message:"2-day training center for corporate workshop."}},{id:"event1",price:1200,listing_title:"Tech Conference 2025",date_start:"2025-10-13 10:00:00",date_end:"2025-10-13 16:00:00",booking_type:"event",booking_author_name:"Jane Cooper",comment:{first_name:"Jane Cooper",email:"jane.cooper@example.com",phone:"01218901234",adults:"50 Persons",location:"Radisson Blu, Dhaka Water Garden",service:!1,message:"Annual technology conference with industry leaders."}},{id:"event2",price:800,listing_title:"Business Networking Event",date_start:"2025-10-15 18:00:00",date_end:"2025-10-15 21:00:00",booking_type:"event",booking_author_name:"Cameron Wilson",comment:{first_name:"Cameron Wilson",email:"c.wilson@example.com",phone:"01119012345",adults:"30 Persons",location:"Amari Dhaka, Gulshan",service:!1,message:"Professional networking event for business professionals."}},{id:"event3",price:950,listing_title:"Product Launch Event",date_start:"2025-10-18 14:00:00",date_end:"2025-10-18 18:00:00",booking_type:"event",booking_author_name:"Alex Smith",comment:{first_name:"Alex Smith",email:"alex.smith@example.com",phone:"01990123456",adults:"75 Persons",location:"Pan Pacific Sonargaon, Karwan Bazar",service:!1,message:"Grand product launch event with media coverage."}},{id:"event4",price:2e3,listing_title:"Annual Business Summit",date_start:"2025-10-25 09:00:00",date_end:"2025-10-25 18:00:00",booking_type:"event",booking_author_name:"Robert Chen",comment:{first_name:"Robert Chen",email:"robert.chen@example.com",phone:"01891234567",adults:"200 Persons",location:"ICCB (International Convention City Bashundhara)",service:!1,message:"Full-day business summit with keynote speakers and workshops."}}];let l=null,u=[],b=[],g=[],p=0,v=null;function m(e){return e?String(e).replace(/[<>]/g,"").trim():""}function _(e,t){var n;(n=e,navigator.clipboard&&navigator.clipboard.writeText?navigator.clipboard.writeText(n):new Promise(e=>{const t=document.createElement("textarea");t.value=n,t.setAttribute("readonly",""),t.style.position="absolute",t.style.left="-9999px",document.body.appendChild(t),t.select();try{document.execCommand("copy")}catch(e){}document.body.removeChild(t),e()})).then(()=>{if(t){const e=t.innerHTML;t.innerHTML='<svg width="12" height="14" viewBox="0 0 12 14" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M2 7L5 10L10 3" stroke="#16A34A" stroke-opacity="0.9" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/></svg>',t.classList.add("copied"),setTimeout(()=>{t.innerHTML=e,t.classList.remove("copied")},1500)}})}function h(e){return e.filter(e=>"event"!==e.booking_type).map(e=>{const t=e.date_start,n=e.date_end,o=function(e){let t={};if(!e)return t;if("string"==typeof e)try{return t=JSON.parse(e),t}catch(t){if(console.warn("⚠️ Comment is not valid JSON, trying alternative parsing:",e),e.includes("a:")||e.includes("s:"))return{};e.includes("email")||e.includes("phone")||e.includes("location")}else"object"==typeof e&&(t=e);return t}(e.comment),i=e.booking_type,a=e.price,r=e.booking_author_name,s=o.email||e.guest_email||e.email||"",d=o.phone||e.guest_phone||e.phone||"",c=o.adults||e.guest_adults||e.adults||"",l=o.location||e.location||"",u=o.message||e.message||e.description||"",b=o?JSON.stringify(o):"";let g=e.allDay;if("service"===i)g=!1;else if(void 0===g&&t){const e=String(t);g=!e.includes("T")&&!e.includes(" ")&&e.match(/^\d{4}-\d{2}-\d{2}$/)}const p=e=>{if(!e)return e;const t=String(e).trim();return t.includes(" ")&&!t.includes("T")?t.replace(" ","T"):t},v=e.listing_title||`Booking: ${r||"Guest"}`,m={type:i||"",price:a||null,guest_name:r||"",guest_email:s||"",guest_phone:d||"",guest_adults:c||"",location:l||"",description:u||"",comment:b};let _=p(t),h=p(n);if("service"===i&&_&&!h){const e=new Date(_);isNaN(e.getTime())||(e.setHours(e.getHours()+1),h=e.toISOString())}return{id:e.id,title:v,start:_,end:h,allDay:g,extendedProps:m}})}function f(n){g=[...n];const o=h(n);b=o,function(n){const o=e(t.CATEGORY_SELECT);if(!o.length)return void console.warn("⚠️ Booking type dropdown not found in DOM");if(!n||!Array.isArray(n))return void console.warn("⚠️ Invalid events data for dropdown update");const i=new Set;n.forEach(e=>{const t=e.extendedProps?.type;t&&"event"!==t&&i.add(t)});const a=o.val();o.find("option:not(:first)").remove();const r={service:"Service",rent:"Rent"};Array.from(i).sort().forEach(e=>{const t=r[e]||e.charAt(0).toUpperCase()+e.slice(1);o.append(`<option value="${e}">${t}</option>`)}),a&&i.has(a)?o.val(a):o.val("")}(o)}function k(){v=null}function y(e){e.jsEvent&&(e.jsEvent.preventDefault(),e.jsEvent.stopPropagation());const t=e.event,n=e.el,o=function(e){if(!e)return"";let t=e.getAttribute("data-popover-trigger-id");return t||(p+=1,t=`booking-popover-trigger-${p}`,e.setAttribute("data-popover-trigger-id",t)),t}(n),i=document.querySelector(".directorist-booking-event-popover");if(i){const e=i.getAttribute("data-event-id"),n=i.getAttribute("data-trigger-id")||"";if(i.remove(),e===t.id&&n===o)return void k()}const a=t.extendedProps.guest_name,r=t.extendedProps.guest_email,s=t.extendedProps.guest_phone,d=t.extendedProps.guest_adults,c=t.extendedProps.location,l=t.extendedProps.description,u=t.extendedProps.price,b=t.extendedProps.type,g=t.start,m=t.end,h=g&&void 0!==g.getHours(),f=m&&void 0!==m.getHours();h&&(0!==g.getHours()||g.getMinutes()),f&&(0!==m.getHours()||m.getMinutes());let y="",w="";const C="rent"===b;g&&m&&g.toDateString()!==m.toDateString()?(y=`${g.toLocaleDateString("en-US",{weekday:"short",month:"short",day:"numeric",year:"numeric"})} - ${m.toLocaleDateString("en-US",{weekday:"short",month:"short",day:"numeric",year:"numeric"})}`,C||(w=h&&f?`${g.toLocaleTimeString("en-US",{hour:"2-digit",minute:"2-digit",hour12:!0})} - ${m.toLocaleTimeString("en-US",{hour:"2-digit",minute:"2-digit",hour12:!0})}`:h?`From ${g.toLocaleTimeString("en-US",{hour:"2-digit",minute:"2-digit",hour12:!0})}`:"All day")):(y=g.toLocaleDateString("en-US",{weekday:"short",month:"short",day:"numeric",year:"numeric"}),C||(w=h&&f?`${g.toLocaleTimeString("en-US",{hour:"2-digit",minute:"2-digit",hour12:!0})} - ${m.toLocaleTimeString("en-US",{hour:"2-digit",minute:"2-digit",hour12:!0})}`:h?g.toLocaleTimeString("en-US",{hour:"2-digit",minute:"2-digit",hour12:!0}):"All day"));const S=document.createElement("div");S.className="directorist-booking-event-popover "+(b?`directorist-booking-event-popover--${b}`:""),S.setAttribute("data-event-id",t.id),S.setAttribute("data-trigger-id",o),S.innerHTML=`\n      <div class="directorist-booking-event-popover-header">\n        <div class="directorist-booking-event-popover-icon"></div>\n        <div class="directorist-booking-event-popover-title-section">\n          <h3 class="directorist-booking-event-popover-title">${t.title}</h3>\n          <div class="directorist-booking-event-popover-datetime">${C?y:`${y} • ${w}`}</div>\n        </div>\n        <button class="directorist-booking-event-popover-close" title="Close">×</button>\n      </div>\n      <div class="directorist-booking-event-popover-content">\n        ${a||r?`\n        \x3c!-- Guest Info --\x3e\n        <div class="directorist-booking-event-popover-row">\n          <div class="directorist-booking-event-popover-row-icon">\n            <svg width="20" height="22" viewBox="0 0 20 22" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M1 21H19C19 16.5817 14.9706 13 10 13C5.02944 13 1 16.5817 1 21Z" stroke="#000626" stroke-opacity="0.9" stroke-width="1.5"/><path d="M14.5 5.5C14.5 7.98528 12.4853 10 10 10C7.51472 10 5.5 7.98528 5.5 5.5C5.5 3.01472 7.51472 1 10 1C12.4853 1 14.5 3.01472 14.5 5.5Z" stroke="#000626" stroke-opacity="0.9" stroke-width="1.5"/></svg>\n          </div>\n          <div class="directorist-booking-event-popover-row-content">\n            ${a?`<div class="directorist-booking-event-attendee-name">${a}</div>`:""}\n            ${r?`<div class="directorist-booking-event-attendee-email">${r}</div>`:""}\n          </div>\n        </div>`:""}\n        \n        ${s?`\n        \x3c!-- Phone --\x3e\n        <div class="directorist-booking-event-popover-row">\n          <div class="directorist-booking-event-popover-row-icon">\n            <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M18.3333 14.0999V16.5999C18.3343 16.832 18.2866 17.0617 18.1936 17.2744C18.1005 17.4871 17.9643 17.6779 17.7933 17.8348C17.6222 17.9917 17.4203 18.1112 17.2005 18.1855C16.9806 18.2599 16.7477 18.2875 16.5166 18.2666C13.9522 17.988 11.489 17.1117 9.32496 15.7083C7.31151 14.4288 5.60443 12.7217 4.32496 10.7083C2.91663 8.53426 2.04019 6.05908 1.76663 3.48325C1.74579 3.25281 1.77321 3.02055 1.84707 2.80127C1.92092 2.58199 2.03963 2.38049 2.19562 2.2096C2.35162 2.03871 2.54149 1.90218 2.75314 1.80869C2.9648 1.7152 3.1936 1.6668 3.42496 1.66659H5.92496C6.32928 1.66264 6.72136 1.80582 7.028 2.06953C7.33464 2.33324 7.53493 2.69946 7.59163 3.09992C7.69718 3.89997 7.89285 4.68552 8.17496 5.44158C8.28684 5.73986 8.31125 6.0642 8.24493 6.37565C8.17862 6.68709 8.02404 6.97334 7.79996 7.19992L6.74163 8.25825C7.92795 10.3445 9.65536 12.072 11.7416 13.2583L12.8 12.1999C13.0265 11.9758 13.3128 11.8213 13.6242 11.7549C13.9357 11.6886 14.26 11.713 14.5583 11.8249C15.3143 12.107 16.0999 12.3027 16.9 12.4083C17.3048 12.4654 17.6746 12.6693 17.9388 12.9812C18.203 13.2931 18.3435 13.6912 18.3333 14.0999Z" stroke="#000626" stroke-opacity="0.9" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/></svg>\n          </div>\n          <div class="directorist-booking-event-popover-row-content">\n            <div class="directorist-booking-event-text">${s}</div>\n          </div>\n        </div>`:""}\n        \n        ${d?`\n        \x3c!-- Number of Adults --\x3e\n        <div class="directorist-booking-event-popover-row">\n          <div class="directorist-booking-event-popover-row-icon">\n            <svg width="22" height="18" viewBox="0 0 22 18" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M15 17V15C15 13.9391 14.5786 12.9217 13.8284 12.1716C13.0783 11.4214 12.0609 11 11 11H5C3.93913 11 2.92172 11.4214 2.17157 12.1716C1.42143 12.9217 1 13.9391 1 15V17M21 17V15C20.9993 14.1137 20.7044 13.2528 20.1614 12.5523C19.6184 11.8519 18.8581 11.3516 18 11.13M15 1.13C15.8604 1.3503 16.623 1.8507 17.1676 2.55231C17.7122 3.25392 18.0078 4.11683 18.0078 5.005C18.0078 5.89317 17.7122 6.75608 17.1676 7.45769C16.623 8.1593 15.8604 8.6597 15 8.88M11 5C11 7.20914 9.20914 9 7 9C4.79086 9 3 7.20914 3 5C3 2.79086 4.79086 1 7 1C9.20914 1 11 2.79086 11 5Z" stroke="#000626" stroke-opacity="0.9" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/></svg>\n          </div>\n          <div class="directorist-booking-event-popover-row-content">\n            <div class="directorist-booking-event-text">${d}</div>\n          </div>\n        </div>`:""}\n        \n        ${u?`\n        \x3c!-- Price --\x3e\n        <div class="directorist-booking-event-popover-row">\n          <div class="directorist-booking-event-popover-row-icon">\n            <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M10 18.3332C14.6024 18.3332 18.3334 14.6022 18.3334 9.99984C18.3334 5.39746 14.6024 1.6665 10 1.6665C5.39765 1.6665 1.66669 5.39746 1.66669 9.99984C1.66669 14.6022 5.39765 18.3332 10 18.3332Z" stroke="#000626" stroke-opacity="0.9" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/><path d="M10 5V15M13.3333 6.66667H8.33333C7.89131 6.66667 7.46738 6.84226 7.15482 7.15482C6.84226 7.46738 6.66667 7.89131 6.66667 8.33333C6.66667 8.77536 6.84226 9.19929 7.15482 9.51184C7.46738 9.8244 7.89131 10 8.33333 10H11.6667C12.1087 10 12.5326 10.1756 12.8452 10.4882C13.1577 10.8007 13.3333 11.2246 13.3333 11.6667C13.3333 12.1087 13.1577 12.5326 12.8452 12.8452C12.5326 13.1577 12.1087 13.3333 11.6667 13.3333H6.66667" stroke="#000626" stroke-opacity="0.9" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/></svg>\n          </div>\n          <div class="directorist-booking-event-popover-row-content">\n            <div class="directorist-booking-event-price-amount">$${u}</div>\n          </div>\n        </div>`:""}\n        \n        ${c?`\n        \x3c!-- Location --\x3e\n        <div class="directorist-booking-event-popover-row">\n          <div class="directorist-booking-event-popover-row-icon"><svg width="16" height="22" viewBox="0 0 16 22" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M10.5 8C10.5 9.38071 9.38071 10.5 8 10.5C6.61929 10.5 5.5 9.38071 5.5 8C5.5 6.61929 6.61929 5.5 8 5.5C9.38071 5.5 10.5 6.61929 10.5 8Z" stroke="#000626" stroke-opacity="0.9" stroke-width="1.5"/><path d="M15 8.2C15 13.8 8 17 8 17C8 17 1 13.8 1 8.2C1 4.22355 4.13401 1 8 1C11.866 1 15 4.22355 15 8.2Z" stroke="#000626" stroke-opacity="0.9" stroke-width="1.5"/><path d="M14 18C14 19.6569 11.3137 21 8 21C4.68629 21 2 19.6569 2 18" stroke="#000626" stroke-opacity="0.9" stroke-width="1.5"/></svg></div>\n          <div class="directorist-booking-event-popover-row-content">\n            <div class="directorist-booking-event-wrapper">\n              <span class="directorist-booking-event-text">${c}</span>\n              <span class="directorist-booking-event-copy-icon" title="Copy location"><svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M0.25 12C0.25 12.9665 1.0335 13.75 2 13.75H4.25V15.9999C4.25 16.9664 5.0335 17.7499 6 17.7499H16C16.9665 17.7499 17.75 16.9664 17.75 15.9999V5.99995C17.75 5.03345 16.9665 4.24995 16 4.24995H13.75V2C13.75 1.0335 12.9665 0.25 12 0.25L2 0.25C1.0335 0.25 0.25 1.0335 0.25 2L0.25 12ZM12.25 4.24995V2C12.25 1.86193 12.1381 1.75 12 1.75L2 1.75C1.86193 1.75 1.75 1.86193 1.75 2L1.75 12C1.75 12.1381 1.86193 12.25 2 12.25H4.25V5.99995C4.25 5.03345 5.0335 4.24995 6 4.24995H12.25ZM5.75 5.99995C5.75 5.86187 5.86193 5.74995 6 5.74995H16C16.1381 5.74995 16.25 5.86187 16.25 5.99995V15.9999C16.25 16.138 16.1381 16.2499 16 16.2499H6C5.86193 16.2499 5.75 16.138 5.75 15.9999V5.99995Z" fill="#000833" fill-opacity="0.65"/>\n</svg></span>\n            </div>\n          </div>\n        </div>`:""}\n        \n        ${l?`\n        \x3c!-- Description --\x3e\n        <div class="directorist-booking-event-popover-row">\n          <div class="directorist-booking-event-popover-row-icon">\n            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M3 3H11" stroke="#141B34" stroke-width="1.5" stroke-linejoin="round"/><path d="M3 9H11" stroke="#141B34" stroke-width="1.5" stroke-linejoin="round"/><path d="M3 15H21" stroke="#141B34" stroke-width="1.5" stroke-linejoin="round"/><path d="M3 21H21" stroke="#141B34" stroke-width="1.5" stroke-linejoin="round"/></svg>\n          </div>\n          <div class="directorist-booking-event-popover-row-content">\n            <div class="directorist-booking-event-text">${l}</div>\n          </div>\n        </div>`:""}\n      </div>\n    `,document.body.appendChild(S),v=o;const x=n.getBoundingClientRect(),L=S.getBoundingClientRect();let T=x.bottom+window.scrollY+8,E=x.left+window.scrollX;E+L.width>window.innerWidth&&(E=window.innerWidth-L.width-16),E<0&&(E=16),x.bottom+L.height>window.innerHeight&&(T=x.top+window.scrollY-L.height-8),S.style.top=`${T}px`,S.style.left=`${E}px`,requestAnimationFrame(()=>{S.classList.add("directorist-booking-event-popover-active")}),S.querySelector(".directorist-booking-event-popover-close").addEventListener("click",e=>{e.preventDefault(),e.stopPropagation(),S.remove(),k()});const M=e=>{S.contains(e.target)||n.contains(e.target)||(S.remove(),k(),document.removeEventListener("click",M))};setTimeout(()=>{document.addEventListener("click",M)},100);const A=S.querySelector(".directorist-booking-event-copy-icon");A&&A.addEventListener("click",e=>{e.preventDefault(),e.stopPropagation();const t=S.querySelector(".directorist-booking-event-wrapper .directorist-booking-event-text");t&&_(t.textContent,A)});const D=e=>{"Escape"===e.key&&(S.remove(),document.removeEventListener("keydown",D),k())};document.addEventListener("keydown",D)}function w(e){const t=e.getDay();if(r.includes(t))return!0;const n=e.toISOString().split("T")[0];return!!r.includes(n)}function C(e){const t=[];return w(e.date)&&(t.push("fc-off-day"),t.push("fc-day-disabled")),t}function S(e){if(w(e.date)&&(e.el.setAttribute("aria-disabled","true"),e.el.setAttribute("data-off-day","true"),!e.el.querySelector(".fc-off-day-label"))){const t=document.createElement("div");t.className="fc-off-day-label",t.textContent="off-day",t.style.cssText="\n        position: absolute;\n        top: 50%;\n        left: 50%;\n        transform: translate(-50%, -50%);\n        pointer-events: none;\n      ",e.el.style.position="relative",e.el.appendChild(t)}}function x(e){const t=e.event,n=e.el;if(n.setAttribute("data-event-id",t.id),n.classList.add("directorist-event"),t.extendedProps?.type){const e=String(t.extendedProps.type).toLowerCase();n.classList.add(`fc-event-${e}`),n.classList.add(`directorist-event--${e}`);const o=n.closest(".fc-timegrid-event-harness, .fc-timegrid-event-harness-inset, .fc-daygrid-event-harness, .fc-list-event");o&&o.classList.add("directorist-event",`directorist-event--${e}`)}else{n.classList.add("fc-event-service","directorist-event--service");const e=n.closest(".fc-timegrid-event-harness, .fc-timegrid-event-harness-inset, .fc-daygrid-event-harness, .fc-list-event");e&&e.classList.add("directorist-event","directorist-event--service")}const o=document.createElement("div");if(o.className="fc-event-calendar-icon",o.innerHTML=d,n.insertBefore(o,n.firstChild),t.start){const o=t.extendedProps?.type,i="timeGridWeek"===e.view.type,a=document.createElement("div");a.className="fc-event-time-inline";const r=e=>String(e).padStart(2,"0"),s=e=>{const t=e.getHours(),n=e.getMinutes(),o=t>=12?"PM":"AM";return`${(t+11)%12+1}:${r(n)} ${o}`};if("rent"===o){const e=e=>e.toLocaleDateString("en-US",{month:"short",day:"numeric",year:"numeric"}),n=e(t.start),o=t.end?e(t.end):"";a.textContent=o&&n!==o?`${n} - ${o}`:n}else{const e=s(t.start),n=t.end?s(t.end):"",o=n?`${e} - ${n}`:e;if(i){const e=t.start.toLocaleDateString("en-US",{weekday:"short"});a.textContent=`${e} • ${o}`}else a.textContent=o}n.appendChild(a)}let i=!0;if("dayGridMonth"===e.view.type){const e=n.closest(".fc-daygrid-day");e&&e.querySelectorAll(".fc-daygrid-event-harness").length>2&&(i=!1)}if(!i){const e=n.querySelector(".fc-event-location-inline");e&&e.remove()}if(i&&t.extendedProps?.location){const e=document.createElement("div");e.className="fc-event-location-inline";const o=document.createElement("span");o.className="fc-event-location-text",o.textContent=t.extendedProps.location,e.appendChild(o);const i=document.createElement("span");i.innerHTML='<svg width="12" height="14" viewBox="0 0 12 14" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M8.52664 0.824707H0.666992V9.80716H1.7898V1.94751H8.52664V0.824707ZM11.3337 3.07032H2.91261V13.1756H11.3337V3.07032ZM10.2109 12.0528H4.03541V4.19313H10.2109V12.0528Z" fill="#1974A8"/></svg>',i.className="directorist-event-copy-icon",i.title="Copy location",i.setAttribute("aria-label","Copy location"),i.addEventListener("click",e=>{e.preventDefault(),e.stopPropagation(),"function"==typeof e.stopImmediatePropagation&&e.stopImmediatePropagation(),_(t.extendedProps.location,i)},!0),e.appendChild(i),n.appendChild(e)}n.addEventListener("click",e=>{const o=e.target;o&&o.closest&&(o.closest(".directorist-event-copy-icon")||o.closest(".directorist-booking-event-copy-icon")||o.closest(".fc-event-location-inline"))||(e.preventDefault(),e.stopPropagation(),l&&y({event:t,jsEvent:e,el:n,view:l.view}))},!0)}function L(n,o){if(!l)return void console.error("❌ Calendar instance not available, cannot apply filters");const i=m(n).trim(),a=m(o);s.currentSearch=i,s.currentCategory=a,M(!0),s.lastSearchRequest&&4!==s.lastSearchRequest.readyState&&s.lastSearchRequest.abort(),i.length>=t.SEARCH_MIN_LENGTH?function(n,o){const i={action:"bdb_search_booking_events",nonce:bdb_booking.directorist_nonce||bdb_booking.directorist_rest_nonce,search_term:n,booking_type:o,limit:100,offset:0};s.lastSearchRequest=e.ajax({url:bdb_booking.ajax_url,type:"POST",data:i,timeout:t.SEARCH_TIMEOUT,success:function(e){!function(e,t,n){if(e.success&&e.data){const o=e.data.bookings||[],i=e.data.total||o.length;o.length>0?f(o):l&&l.getEvents().forEach(e=>e.remove()),E(i,t,n)}else console.warn("⚠️ Server search returned no results, falling back to client-side"),T(t,n);M(!1)}(e,n,o)},error:function(e,t,i){"abort"!==t&&(console.error("❌ Server search failed:",i),T(n,o))},complete:function(){M(!1)}})}(i,a):T(i,a)}function T(e,t){const n=g.filter(n=>{const o=n.booking_type||"",i=n.booking_author_name||"",a=n.guest_email||"",r=n.location||"",s=n.listing_title||"";if(t&&o!==t)return!1;if(e){const t=e.toLowerCase(),n=s.toLowerCase().includes(t),o=i.toLowerCase().includes(t),d=a.toLowerCase().includes(t),c=r.toLowerCase().includes(t);return n||o||d||c}return!0});A(n),E(n.length,e,t),M(!1)}function E(e,t,n){s.searchResults=e,s.totalResults=e,s.hasSearched=!0;const o=document.querySelector(".search-results-info");if(o)if(t||n){const i=t?`"${t}"`:"",a=n?` (${n})`:"";o.textContent=`Found ${e} results for ${i}${a}`,o.style.display="block"}else o.style.display="none"}function M(e){const t=document.querySelector(n);t&&(e?(t.classList.add("searching"),s.isSearching=!0):(t.classList.remove("searching"),s.isSearching=!1))}function A(e){l?(l.getEvents().forEach(e=>e.remove()),h(e).forEach(e=>{l.addEvent(e)})):console.error("❌ Calendar instance not available in updateCalendarEvents")}function D(e){l&&l.changeView(e)}function j(){const e=document.querySelector(n);e&&(e.value="",e.setAttribute("autocomplete","off"),e.setAttribute("autocorrect","off"),e.setAttribute("autocapitalize","off"),e.setAttribute("spellcheck","false"),e.setAttribute("data-lpignore","true"),e.setAttribute("name","search_"+Math.random().toString(36).substr(2,9)));const t=document.querySelector(o);t&&(t.value="")}return{init:function(){const r=document.getElementById(t.CALENDAR_CONTAINER_ID);if(!r)return console.error("Calendar element not found in DOM"),null;j();try{return function(t){const n=bdb_booking.directorist_rest_url?`${bdb_booking.directorist_rest_url}directorist_booking/bookings/confirmed`:`${window.location.origin}/wp-json/directorist_booking/bookings/confirmed`,o=bdb_booking.directorist_rest_nonce||bdb_booking.directorist_nonce;e.ajax({url:n,method:"GET",headers:{"X-WP-Nonce":o},success:function(e){const n=e.bookings||[];n&&n.length>0?f(n):(console.warn("⚠️ No confirmed bookings from API, using default events"),f(c)),t&&t(b)},error:function(e){console.error("Error fetching events:",e),f(c),t&&t(b)}})}(function(s){const c=new FullCalendar.Calendar(r,{initialView:t.INITIAL_VIEW,headerToolbar:{left:"prev,title,next,today",center:"",right:""},views:{dayGridMonth:{dayMaxEvents:2},timeGridWeek:{dayMaxEvents:!1,slotMinTime:"00:00:00",slotMaxTime:"24:00:00"},timeGridDay:{dayMaxEvents:!1,slotMinTime:"00:00:00",slotMaxTime:"24:00:00"}},dayHeaderContent:function(e){const t=e.date.toLocaleDateString("en-US",{weekday:"short"}),n=e.date.getDate();return"timeGridWeek"===e.view.type?w(e.date)?{html:`<div class="fc-col-header-cell-content fc-col-header-off-day">\n                             <span class="fc-col-header-day-content">\n                               <span class="fc-col-header-day-name">${t}</span>\n                               <span class="fc-col-header-date-num">${n}</span>\n                             </span>\n                             <span class="fc-col-header-off-label">Off-Day</span>\n                           </div>`}:{html:`<div class="fc-col-header-cell-content">\n                            <span class="fc-col-header-day-content">\n                              <span class="fc-col-header-day-name">${t}</span>\n                              <span class="fc-col-header-date-num">${n}</span>\n                             </span>\n                           </div>`}:{html:t}},events:s,eventClick:y,dayCellClassNames:C,dayCellDidMount:S,selectAllow:function(e){return!w(e.start)},eventDisplay:"block",eventOverlap:!0,eventOrder:"start,-duration,allDay,title",eventStartEditable:!1,eventDurationEditable:!1,eventResourceEditable:!1,eventMinHeight:20,slotDuration:"00:30:00",nowIndicator:!0,scrollTime:"06:00:00",scrollTimeReset:!0,slotLabelFormat:{hour:"numeric",minute:"2-digit",omitZeroMinute:!0,meridiem:"short"},moreLinkClick:function(e){e.jsEvent.preventDefault(),e.jsEvent.stopPropagation(),e.jsEvent.stopImmediatePropagation();const t=e.jsEvent.currentTarget;let n,o;return t.closest(".fc-daygrid-day")?(n=t.closest(".fc-daygrid-day"),o=n?.querySelector(".fc-daygrid-day-events"),n&&o?(n.classList.contains("fc-day-expanded")?(n.classList.remove("fc-day-expanded"),o.style.maxHeight="",o.style.overflowY="",o.querySelectorAll(".dynamically-added").forEach(e=>{e.remove()}),t.style.display="",t.textContent=e.allSegs.length-2+"+ More"):(n.classList.add("fc-day-expanded"),o.style.maxHeight="125px",o.style.overflowY="auto",o.style.overflowX="hidden",e.allSegs.slice(2).forEach(e=>{const n=e.event,o=document.createElement("div");o.className="fc-daygrid-event-harness dynamically-added",o.classList.add("directorist-event-harness-inline");const i=document.createElement("a");if(i.className="fc-daygrid-event fc-daygrid-block-event fc-h-event fc-event fc-event-start fc-event-end fc-event-past",i.setAttribute("data-event-id",n.id),n.extendedProps?.type){const e=String(n.extendedProps.type).toLowerCase();i.classList.add(`fc-event-${e}`),i.classList.add("directorist-event",`directorist-event--${e}`),o&&o.classList.add("directorist-event",`directorist-event--${e}`)}const a=document.createElement("div");a.className="fc-event-main";const r=document.createElement("div");if(r.className="fc-event-title",r.textContent=n.title,a.appendChild(r),n.start){const e=n.extendedProps?.type,t=document.createElement("div");if(t.className="fc-event-time-inline","rent"===e){const e=e=>e.toLocaleDateString("en-US",{month:"short",day:"numeric",year:"numeric"}),o=e(n.start),i=n.end?e(n.end):"";t.textContent=i&&o!==i?`${o} - ${i}`:o}else{const e=e=>String(e).padStart(2,"0"),o=t=>{const n=t.getHours(),o=t.getMinutes(),i=n>=12?"PM":"AM";return`${(n+11)%12+1}:${e(o)} ${i}`},i=o(n.start),a=n.end?o(n.end):"";t.textContent=a?`${i} - ${a}`:i}a.appendChild(t)}const s=document.createElement("div");s.className="fc-event-calendar-icon",s.innerHTML=d,i.appendChild(s),i.appendChild(a),o.appendChild(i),i.addEventListener("click",e=>{e.preventDefault(),e.stopPropagation(),l&&y({event:n,jsEvent:e,el:i,view:l.view})}),t.parentNode.insertBefore(o,t)}),t.textContent="Show Less"),"none"):"none"):"none"},moreLinkContent:function(e){return`${e.num}+ More`},eventDidMount:x,height:"auto",slotMinTime:"00:00:00",slotMaxTime:"24:00:00"});c.render(),l=c,e(".fc-toolbar-title").parent().addClass("directorist-calendar-toolbar-nav-container"),function(){const t=e("#booking-calendar-view-dropdown"),n=e(".fc-toolbar .fc-toolbar-chunk:last-child");t.length&&n.length&&(n.empty(),n.html(t.html()))}(),function(){window.addEventListener("load",function(){setTimeout(()=>{j()},100)}),"loading"===document.readyState?document.addEventListener("DOMContentLoaded",j):j(),e(document).on("click",".fc-event",function(t){if(e(t.target).closest(".directorist-event-copy-icon, .fc-event-location-inline, .directorist-booking-event-copy-icon").length)return;t.preventDefault(),t.stopPropagation();const n=e(this),o=n.attr("data-event-id")||n.find("[data-event-id]").attr("data-event-id");if(o&&l){const e=l.getEventById(o);e&&y({event:e,jsEvent:t.originalEvent,el:this,view:l.view})}}),document.addEventListener("click",function(e){const t=e.target,n=t.closest&&(t.closest(".directorist-event-copy-icon")||t.closest(".directorist-booking-event-copy-icon"));if(!n)return;e.preventDefault(),e.stopPropagation(),"function"==typeof e.stopImmediatePropagation&&e.stopImmediatePropagation();const o=n.closest&&n.closest(".fc-event"),i=o?.getAttribute("data-event-id")||o?.querySelector("[data-event-id]")?.getAttribute("data-event-id");let a="";if(i&&l){const e=l.getEventById(i);a=e?.extendedProps?.location||""}if(!a&&o){const e=o.querySelector(".fc-event-location-text");a=e?.textContent||""}if(!a){const e=n.closest(".directorist-booking-event-popover");if(e){const t=e.querySelector(".directorist-booking-event-wrapper .directorist-booking-event-text");a=t?.textContent||""}}a&&_(a,n)},!0);const r=function(e,t){let n;return function(...e){clearTimeout(n),n=setTimeout(()=>{clearTimeout(n),((e,t)=>{L(e,t)})(...e)},t)}}(0,t.DEBOUNCE_DELAY),s=function(){const t=e(this).val(),n=e(o).val();r(t,n)},d=function(){const t=e(this).val(),o=e(n).val();if(l){const e=l.el;e.classList.add("loading"),setTimeout(()=>{L(o,t),e.classList.remove("loading")},100)}else L(o,t)},c=function(){D(e(this).val())},b=function(){"undefined"!=typeof GoogleCalendarModal?GoogleCalendarModal.show():console.error("GoogleCalendarModal not available")};e(document).on("input keyup",n,s),e(document).on("change",o,d),e(document).on("change",i,c),e(document).on("click",a,b),e(document).on("click","#booking-date-modal .directorist-modal__overlay",function(e){e.target===this&&hideDateModal()}),e(document).on("keydown",function(t){"Escape"===t.key&&e("#booking-date-modal").is(":visible")&&hideDateModal()}),u.push({event:"input keyup",selector:n,handler:s},{event:"change",selector:o,handler:d},{event:"change",selector:i,handler:c},{event:"click",selector:a,handler:b})}(),e(".directorist-booking-calender").removeClass("directorist-booking-calender--loader"),window.bookingCalendar=c}),l}catch(e){return console.error("Calendar initialization failed:",e),null}},destroy:function(){u.forEach(({event:t,selector:n,handler:o})=>{e(document).off(t,n,o)}),u=[],l=null,document.querySelectorAll(".directorist-booking-event-popover").forEach(e=>{e.remove()})},getCalendar:()=>l,applyFilters:L,clearFilters:function(){e(n).val(""),e(o).val(""),M(!1),s.currentSearch="",s.currentCategory="",s.isSearching=!1,s.hasSearched=!1,s.lastSearchRequest&&4!==s.lastSearchRequest.readyState&&(s.lastSearchRequest.abort(),s.lastSearchRequest=null),A(g);const t=document.querySelector(".search-results-info");t&&(t.style.display="none")},getFilterState:function(){return{search:e(n).val(),category:e(o).val(),totalEvents:g.length,filteredEvents:l?l.getEvents().length:0}},changeView:D,forceRefresh:function(){l&&requestAnimationFrame(()=>{l.updateSize(),l.render()})},isVisible:function(){const e=document.getElementById(t.CALENDAR_CONTAINER_ID);return e&&null!==e.offsetParent},testFilter:(e,t)=>{L(e,t)},setOffDays:e=>{r=e,l&&l.render()},getOffDays:()=>r}}(jQuery);var t;!function(t){t(document).ready(function(){function e(e=1){var n={action:"bdb_owner_approved_bookings_manage",listing_id:t("#listing_id").val(),listing_status:"approved",dashboard_type:t("#dashboard_type").val(),limit:5,offset:0,page:e};t("#bdb_listing_status").attr("data-status")&&(n.listing_status=t("#bdb_listing_status").attr("data-status")),t("#bdb_listing_id_approved").attr("data-status")&&(n.listing_id=t("#bdb_listing_id_approved").attr("data-status")),t(".dashboard-list-box").addClass("loading"),t.ajax({type:"POST",dataType:"json",url:bdb_booking.ajax_url,data:n,success:function(e){t(".dashboard-list-box").removeClass("loading");const n=window.getBookingContainerIds();window.updateBookingContainers(e,n)}})}function n(e=1){var n={action:"bdb_owner_approved_bookings_manage",listing_id:t("#listing_id").val(),listing_status:"waiting",dashboard_type:t("#dashboard_type").val(),limit:5,offset:0,page:e};t("#bdb_listing_status").attr("data-status")&&(n.listing_status=t("#bdb_listing_status").attr("data-status")),t("#bdb_listing_id_waiting").attr("data-status")&&(n.listing_id=t("#bdb_listing_id_waiting").attr("data-status")),t(".dashboard-list-box").addClass("loading"),t.ajax({type:"POST",dataType:"json",url:bdb_booking.ajax_url,data:n,success:function(e){t(".dashboard-list-box").removeClass("loading");const n=window.getBookingContainerIds();window.updateBookingContainers(e,n)}})}function o(e=1){var n={action:"bdb_owner_approved_bookings_manage",listing_id:t("#listing_id").val(),listing_status:"cancelled",dashboard_type:t("#dashboard_type").val(),limit:5,offset:0,page:e};t("#bdb_listing_status").attr("data-status")&&(n.listing_status=t("#bdb_listing_status").attr("data-status")),t("#bdb_listing_id_cancelled").attr("data-status")&&(n.listing_id=t("#bdb_listing_id_cancelled").attr("data-status")),t(".dashboard-list-box").addClass("loading"),t.ajax({type:"POST",dataType:"json",url:bdb_booking.ajax_url,data:n,success:function(e){t(".dashboard-list-box").removeClass("loading");const n=window.getBookingContainerIds();window.updateBookingContainers(e,n)}})}t(document).on("click","#reject_user_booking",function(e){if(e.preventDefault(),window.confirm(bdb_booking.areyousure)){var n=t(this);n.parents("li").addClass("loading");var o={action:"bdb_user_bookings_manage",booking_id:t(this).data("booking_id"),status:"cancelled"};t.ajax({type:"POST",dataType:"json",url:bdb_booking.ajax_url,data:o,success:function(e){n.parents("li").removeClass("loading"),window.bdb_user_bookings_manage&&window.bdb_user_bookings_manage()}})}}),t(document).on("click",".pagination-container a",function(i){i.preventDefault();var a=t(this).parent().data("paged"),r=t(this).closest(".pagination-container").attr("class");return r.includes("my_booking")||r.includes("user")?window.bdb_user_bookings_manage&&window.bdb_user_bookings_manage(a):r.includes("all_bookings_approved")||r.includes("approved")?e(a):r.includes("all_bookings_waiting")||r.includes("waiting")?n(a):(r.includes("all_bookings_cancelled")||r.includes("cancelled"))&&o(a),t("body, html").animate({scrollTop:t(".dashboard-list-box").offset().top},600),!1}),t(document).on("click","#owner_cancel",function(n){if(n.preventDefault(),window.confirm(bdb_booking.areyousure)){var o=t(this);o.parents("li").addClass("loading");var i={action:"bdb_owner_approved_bookings_manage",booking_id:t(this).data("booking_id"),status:"cancelled"};t.ajax({type:"POST",dataType:"json",url:bdb_booking.ajax_url,data:i,success:function(t){o.parents("li").removeClass("loading"),e()}})}}),t(document).on("click","#owner_delete",function(e){if(e.preventDefault(),window.confirm(bdb_booking.areyousure)){var n=t(this);n.parents("li").addClass("loading");var o={action:"bdb_owner_approved_bookings_manage",booking_id:t(this).data("booking_id"),status:"deleted"};t.ajax({type:"POST",dataType:"json",url:bdb_booking.ajax_url,data:o,success:function(e){n.parents("li").removeClass("loading"),window.bdb_owner_deleted_bookings_manage&&window.bdb_owner_deleted_bookings_manage()}})}}),t(".bdb-approved").on("click",function(t){e()}),t(".bdb-listing-approved").on("click",function(t){e()}),t(document).on("click","#owner_approved",function(e){e.preventDefault();var o=t(this);o.parents("li").addClass("loading");var i={action:"bdb_owner_approved_bookings_manage",booking_id:t(this).data("booking_id"),status:"confirmed"};t.ajax({type:"POST",dataType:"json",url:bdb_booking.ajax_url,data:i,success:function(e){o.parents("li").removeClass("loading"),n()}})}),t(document).on("click","#owner_reject",function(e){if(e.preventDefault(),window.confirm(bdb_booking.areyousure)){var o=t(this);o.parents("li").addClass("loading");var i={action:"bdb_owner_approved_bookings_manage",booking_id:t(this).data("booking_id"),status:"cancelled"};t.ajax({type:"POST",dataType:"json",url:bdb_booking.ajax_url,data:i,success:function(e){o.parents("li").removeClass("loading"),n()}})}}),document.querySelectorAll(".directorist-booking-card__value__copy").forEach(e=>{e.onclick=function(){const e=this.closest(".directorist-booking-card__value");if(!e)return;const t=e.childNodes[0].nodeValue.trim(),n=Object.assign(document.createElement("textarea"),{value:t});document.body.appendChild(n),n.select();try{document.execCommand("copy")?(this.innerHTML="✔️",setTimeout(()=>{this.innerHTML='<i class="directorist-icon-mask" aria-hidden="true" style="--directorist-icon: url(http://directorist.local/wp-content/plugins/directorist/assets/icons/line-awesome/svgs/copy-solid.svg)"></i>'},1500)):alert("Copy failed.")}catch(e){console.error("Copy error:",e)}n.remove()}}),t(".bdb-listing-waiting").on("click",function(e){n()}),t(".bdb-listing-cancelled").on("click",function(e){o()}),t("#bdb_paid").click(function(){t("#bdb_paid").addClass("active"),t("#bdb_all_status").removeClass("active"),t("#bdb_confirmed").removeClass("active")}),t("#bdb_confirmed").click(function(){t("#bdb_confirmed").addClass("active"),t("#bdb_all_status").removeClass("active"),t("#bdb_paid").removeClass("active")}),t("#bdb_all_status").click(function(){t("#bdb_all_status").addClass("active"),t("#bdb_confirmed").removeClass("active"),t("#bdb_paid").removeClass("active")});const i=document.querySelectorAll(".directorist-user-listing"),a=document.querySelector(".directorist-listing-id");0!==i.length&&a&&(i[0].classList.add("active"),a.value=i[0].getAttribute("data-id"));var r=t(".directorist-price").val();t("body .directorist-calendar-day:not(.directorist-weekend) .directorist-calendar-price .directorist-calendar-price-money__currency span").html(r);var s=t(".directorist-weekend-price").val();function d(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,o=new Array(t);n<t;n++)o[n]=e[n];return o}t("body .directorist-calendar-day.directorist-weekend .directorist-calendar-price .directorist-calendar-price-money__currency span").html(s),t(document).on("click","#refund_user_booking",function(e){e.preventDefault();var n=t(this).data("refund_amount"),o=t(this).data("refund_desc"),i=t(this).data("booking_id"),a=t(this).data("user_name"),r=t(this).data("booking_author"),s=t(this).data("owner_id"),d=t(this).data("listing_id"),c=t(this).data("commission_id");t("input[name=amount_demo]").val(n),t("input[name=amount]").val(n),t("input[name=refund_booking_id]").val(i),t("input[name=refund_user_name]").val(a),t("input[name=refund_booking_author]").val(r),t("input[name=refund_owner_id]").val(s),t("input[name=refund_listing_id]").val(d),t("input[name=refund_commission_id]").val(c),t(".amount-info-text").html(o)}),t("body").on("submit","#bdb_user_refund_form",function(e){e.preventDefault();var n=t(e.target),o=new FormData;o.append("action","bdb_user_refund_form"),o.append("directorist_nonce",bdb_booking.directorist_nonce);var i,a=function(e){var t="undefined"!=typeof Symbol&&e[Symbol.iterator]||e["@@iterator"];if(!t){if(Array.isArray(e)||(t=function(e,t){if(e){if("string"==typeof e)return d(e,t);var n=Object.prototype.toString.call(e).slice(8,-1);return"Object"===n&&e.constructor&&(n=e.constructor.name),"Map"===n||"Set"===n?Array.from(e):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?d(e,t):void 0}}(e))){t&&(e=t);var n=0,o=function(){};return{s:o,n:function(){return n>=e.length?{done:!0}:{done:!1,value:e[n++]}},e:function(e){throw e},f:o}}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}var i,a=!0,r=!1;return{s:function(){t=t.call(e)},n:function(){var e=t.next();return a=e.done,e},e:function(e){r=!0,i=e},f:function(){try{a||null==t.return||t.return()}finally{if(r)throw i}}}}(n.serializeArray());try{for(a.s();!(i=a.n()).done;){var r=i.value;if(""===r.value)return t(".refund-form-notice").css("display","block"),void t(this).closest(".user-refund__part").removeClass("atbdp-form-fade");o.append(r.name,r.value),t(this).closest(".user-refund__part").addClass("atbdp-form-fade")}}catch(e){a.e(e)}finally{a.f()}t(".refund-form-notice").css("display","none"),t.ajax({method:"POST",processData:!1,contentType:!1,url:bdb_booking.ajax_url,data:o,success:function(e){location.reload(),t(this).closest(".user-refund__part").removeClass("atbdp-form-fade")},error:function(e){console.error(e)}})}),t("body").on("click",".bdb-refund-approve",function(e){e.preventDefault(),t(this).html("Loading..."),t.ajax({method:"POST",url:bdb_booking.ajax_url,data:{action:"bdb_owner_refund",directorist_nonce:bdb_booking.directorist_nonce,refund_id:t(this).data("id")},success:function(e){location.reload()},error:function(e){console.error(e)}})}),t("body").on("click",".bdb-refund-decline",function(e){e.preventDefault(),t(".bdb-refund-decline").html("Loading..."),t.ajax({method:"POST",url:bdb_booking.ajax_url,data:{action:"bdb_owner_refund_decline",directorist_nonce:bdb_booking.directorist_nonce,refund_id:t(this).data("id")},success:function(e){location.reload()},error:function(e){console.error(e)}})})});let n=null,o=!1,i=!1;function a(){const e=document.getElementById("directorist-booking-calender");if(!e)return!1;const t=window.getComputedStyle(e),n=e.getBoundingClientRect();return"none"!==t.display&&"hidden"!==t.visibility&&"0"!==t.opacity&&n.width>0&&n.height>0&&null!==e.offsetParent}function r(){if(t("#directorist-booking-calender").length&&!o&&!i)if(i=!0,a()){t(".directorist-booking-calender").addClass("directorist-booking-calender--loader");try{n=e.init(),o=!0,window.bookingCalendarInstance=n}catch(e){console.error("❌ Failed to initialize Booking Calendar:",e),t(".directorist-booking-calender").removeClass("directorist-booking-calender--loader"),i=!1}}else i=!1}function s(){n&&o?a()&&setTimeout(()=>{e.forceRefresh&&e.forceRefresh()},150):!o&&t("#directorist-booking-calender").length&&r()}t(document).ready(function(){if(r(),!o){const e=setInterval(()=>{a()&&(r(),o&&clearInterval(e))},500);setTimeout(()=>{clearInterval(e)},1e4)}}),t(document).on("click",'.directorist-booking-nav-link[target="booking-calendar"], .directorist-tab__nav__item[target="booking-calendar"]',function(){setTimeout(()=>{s()},100),setTimeout(()=>{s()},300),setTimeout(()=>{s()},600)}),t(document).on("click",".directorist-tab__nav__item",function(){"booking-calendar"===(t(this).find("[target]").attr("target")||t(this).attr("target"))&&(setTimeout(()=>{s()},100),setTimeout(()=>{s()},300))}),t(window).on("resize",function(){s()}),document.addEventListener("visibilitychange",function(){document.hidden||setTimeout(()=>{s()},100)}),t(document).ready(function(){setTimeout(()=>{!function(){const e=document.getElementById("directorist-booking-calender");if(!e)return;const t=new MutationObserver(function(e){e.forEach(function(e){"attributes"!==e.type||"style"!==e.attributeName&&"class"!==e.attributeName&&"hidden"!==e.attributeName||a()&&setTimeout(()=>{s()},100)})});t.observe(e,{attributes:!0,attributeFilter:["style","class","hidden"]});let n=e.parentElement;for(;n&&n!==document.body;)t.observe(n,{attributes:!0,attributeFilter:["style","class","hidden"]}),n=n.parentElement}()},1e3)}),t(window).on("beforeunload",function(){n&&(e.destroy(),n=null,o=!1)}),window.DirectoristBookingCalendar=e,window.refreshBookingCalendar=s}(jQuery),(t=jQuery)(document).ready(function(){function e(){const e=new URLSearchParams(window.location.search),n=e.get("tab")||"",o=e.get("status")||"";let i="";("my_booking"===n||t(".dashboard-list-box").find("#dashboard_type").length>0)&&(i="user");let a=[n,i,o].filter(e=>e&&e.length>0).join("_");if(0===t("#directorist-booking-requests-"+a).length){const e=t('[id^="directorist-booking-requests-"]').filter(":visible");e.length>0&&(a=e.attr("id").replace("directorist-booking-requests-",""))}return{bookingContainer:"#directorist-booking-requests-"+a,paginationContainer:".pagination-container-"+a,noBookingsInfo:".no-bookings-information-"+a}}function n(e,n){e.data.html?(t(n.noBookingsInfo).hide(),t(n.bookingContainer).html(e.data.html),t(n.paginationContainer).html(e.data.pagination)):(t(n.bookingContainer).empty(),t(n.paginationContainer).html(e.data.pagination),t(n.noBookingsInfo).show())}window.NavigationStateManager=new class{constructor(){this.init()}init(){this.setupSidebarNavigation(),this.setupTabNavigation(),this.setupURLSync()}setupSidebarNavigation(){const e=this.getCurrentTabFromURL(),t=document.querySelectorAll(".directorist-tab__nav__item");if(t.length>0&&t.forEach(e=>{e.classList.remove("active")}),e){const t=document.querySelector(`[target="${e}"]`);if(t){const e=t.closest(".directorist-tab__nav__item");e&&e.classList.add("active")}}const n=document.querySelectorAll(".directorist-booking-nav-link");n.length>0&&n.forEach(e=>{e.addEventListener("click",t=>{t.preventDefault();const n=e.getAttribute("target");n&&(this.switchToTab(n),this.updateURL(n))})})}setupTabNavigation(){const e=this.getCurrentTabFromURL(),t=document.querySelectorAll(".directorist-tab__pane");if(t.length>0&&t.forEach(e=>{e.style.display="none"}),e){const t=document.getElementById(e);t&&(t.style.display="block")}const n=document.querySelectorAll(".atbd-dashboard-nav a");n.length>0&&n.forEach(e=>{e.addEventListener("click",t=>{t.preventDefault();const n=e.getAttribute("target");n&&(this.switchToTab(n),this.updateURL(n))})})}setupURLSync(){window.addEventListener("popstate",e=>{const t=this.getCurrentTabFromURL();t&&this.switchToTab(t,!1)})}getCurrentTabFromURL(){const e=window.location.hash.substring(1);if(e&&this.isValidTab(e))return e;const t=new URLSearchParams(window.location.search).get("tab");return t&&this.isValidTab(t)?t:this.getDefaultTab()}isValidTab(e){return["my_booking","all_bookings","booking_calender","my_wallet"].includes(e)}getDefaultTab(){const e=document.querySelectorAll(".directorist-tab__pane");return e.length>0?e[0].id:"my_booking"}switchToTab(e,t=!0){const n=document.querySelectorAll(".directorist-tab__nav__item");n.length>0&&n.forEach(e=>{e.classList.remove("active")});const o=document.querySelector(`[target="${e}"]`);if(o){const e=o.closest(".directorist-tab__nav__item");e&&e.classList.add("active")}const i=document.querySelectorAll(".directorist-tab__pane");i.length>0&&i.forEach(e=>{e.style.display="none"});const a=document.getElementById(e);a&&(a.style.display="block"),"all_bookings"===e&&window.AllBookingsTabManager&&window.AllBookingsTabManager.activateTab("all_booking_approved",!1),"my_booking"===e&&window.MyBookingsTabManager&&window.MyBookingsTabManager.activateTab("my_booking_approved",!1),t&&this.updateURL(e),document.dispatchEvent(new CustomEvent("tabChanged",{detail:{tabId:e}}))}updateURL(e){const t=new URL(window.location);t.hash=e,t.searchParams.delete("tab"),window.history.pushState({tab:e},"",t)}},window.AllBookingsTabManager=new class{constructor(){this.statusTabMap={confirmed:"all_booking_approved",waiting:"all_booking_waiting",cancelled:"all_booking_cancelled",refund:"all_booking_refund"},this.tabStatusMap={all_booking_approved:"confirmed",all_booking_waiting:"waiting",all_booking_cancelled:"cancelled",all_booking_refund:"refund"},this.init()}init(){this.setupTabNavigation(),"loading"===document.readyState?document.addEventListener("DOMContentLoaded",()=>{this.initializeFromURL()}):this.initializeFromURL()}setupTabNavigation(){document.addEventListener("click",e=>{if(e.target.closest(".directorist-tab-nav__link")&&e.target.closest("#all_bookings")){e.preventDefault();const t=e.target.closest(".directorist-tab-nav__link").getAttribute("data-tab");t&&t.startsWith("all_booking_")&&this.activateTab(t)}})}initializeFromURL(){const e=new URLSearchParams(window.location.search),t=e.get("tab"),n=e.get("status"),o=document.querySelector(".directorist-all-bookings-wrapper"),i=document.getElementById("all_bookings");("all_bookings"===t||o||i&&"none"!==i.style.display)&&setTimeout(()=>{this.checkActiveTabOnReload(),n&&this.statusTabMap[n]?this.activateTab(this.statusTabMap[n],!1):this.activateTab("all_booking_approved",!1)},100)}checkActiveTabOnReload(){const e=document.querySelector("#all_bookings");if(!e)return;const t=e.querySelector(".directorist-tab-nav__item.active");if(t){const n=t.getAttribute("data-tab");e.querySelectorAll(".directorist-tab__pane").forEach(e=>{e.style.display="none"});const o=document.getElementById(n);o&&(o.style.display="block")}else{const t=e.querySelector('[data-tab="all_booking_approved"]');if(t){t.classList.add("active"),e.querySelectorAll(".directorist-tab__pane").forEach(e=>{e.style.display="none"});const n=document.getElementById("all_booking_approved");n&&(n.style.display="block")}}}activateTab(e,t=!0){this.updateTabNavigation(e),this.updateTabContent(e),t&&this.updateURL(e)}updateTabNavigation(e){document.querySelectorAll(".directorist-all-bookings-wrapper .directorist-tab-nav__item").forEach(e=>{e.classList.remove("active")});const t=document.querySelector(`.directorist-all-bookings-wrapper [data-tab="${e}"]`);t&&t.classList.add("active")}updateTabContent(e){const t=document.querySelector("#all_bookings");if(!t)return;t.querySelectorAll(".directorist-tab__pane").forEach(e=>{e.style.display="none"});const n=document.getElementById(e);n&&(n.style.display="block")}updateURL(e){const t=new URL(window.location);t.hash="all_bookings",t.searchParams.delete("tab"),this.tabStatusMap[e]&&t.searchParams.set("status",this.tabStatusMap[e]),window.history.pushState({tab:"all_bookings",status:this.tabStatusMap[e]},"",t)}},window.MyBookingsTabManager=new class{constructor(){this.statusTabMap={confirmed:"my_booking_approved",waiting:"my_booking_waiting",cancelled:"my_booking_cancelled"},this.tabStatusMap={my_booking_approved:"confirmed",my_booking_waiting:"waiting",my_booking_cancelled:"cancelled"},this.init()}init(){this.setupTabNavigation(),"loading"===document.readyState?document.addEventListener("DOMContentLoaded",()=>{this.initializeFromURL()}):this.initializeFromURL()}setupTabNavigation(){document.addEventListener("click",e=>{if(e.target.closest(".directorist-tab-nav__link")&&e.target.closest("#my_booking")){e.preventDefault();const t=e.target.closest(".directorist-tab-nav__link").getAttribute("data-tab");t&&t.startsWith("my_booking_")&&this.activateTab(t)}})}initializeFromURL(){const e=new URLSearchParams(window.location.search),t=e.get("tab"),n=e.get("status"),o=document.querySelector("#my_booking .directorist-all-bookings-wrapper"),i=document.getElementById("my_booking");("my_booking"===t||o||i&&"none"!==i.style.display)&&setTimeout(()=>{this.checkActiveTabOnReload(),n&&this.statusTabMap[n]?this.activateTab(this.statusTabMap[n],!1):this.activateTab("my_booking_approved",!1)},100)}checkActiveTabOnReload(){const e=document.querySelector("#my_booking");if(!e)return;const t=e.querySelector(".directorist-tab-nav__item.active");if(t){const n=t.getAttribute("data-tab");e.querySelectorAll(".directorist-tab__pane").forEach(e=>{e.style.display="none"});const o=document.getElementById(n);o&&(o.style.display="block")}else{const t=e.querySelector('[data-tab="my_booking_approved"]');if(t){t.classList.add("active"),e.querySelectorAll(".directorist-tab__pane").forEach(e=>{e.style.display="none"});const n=document.getElementById("my_booking_approved");n&&(n.style.display="block")}}}activateTab(e,t=!0){this.updateTabNavigation(e),this.updateTabContent(e),t&&this.updateURL(e)}updateTabNavigation(e){document.querySelectorAll("#my_booking .directorist-all-bookings-wrapper .directorist-tab-nav__item").forEach(e=>{e.classList.remove("active")});const t=document.querySelector(`#my_booking .directorist-all-bookings-wrapper [data-tab="${e}"]`);t&&t.classList.add("active")}updateTabContent(e){const t=document.querySelector("#my_booking");if(!t)return;t.querySelectorAll(".directorist-tab__pane").forEach(e=>{e.style.display="none"});const n=document.getElementById(e);n&&(n.style.display="block")}updateURL(e){const t=new URL(window.location);t.hash="my_booking",t.searchParams.delete("tab"),this.tabStatusMap[e]&&t.searchParams.set("status",this.tabStatusMap[e]),window.history.pushState({tab:"my_booking",status:this.tabStatusMap[e]},"",t)}},t(document).on("click","#reject_user_booking",function(e){if(e.preventDefault(),window.confirm(bdb_booking.areyousure)){var n=t(this).closest(".directorist-booking-card");n.addClass("loading");var o={action:"bdb_user_bookings_manage",booking_id:t(this).data("booking_id"),status:"cancelled"};t.ajax({type:"POST",dataType:"json",url:bdb_booking.ajax_url,data:o,success:function(e){n.removeClass("loading"),n.fadeOut(300,function(){t(this).remove()})}})}}),t(document).on("click",".owner-cancel-btn",function(e){if(e.preventDefault(),window.confirm(bdb_booking.areyousure)){var n=t(this).closest(".directorist-booking-card");n.addClass("loading");var o={action:"bdb_owner_approved_bookings_manage",booking_id:t(this).data("booking_id"),status:"cancelled"};t.ajax({type:"POST",dataType:"json",url:bdb_booking.ajax_url,data:o,success:function(e){n.removeClass("loading"),n.fadeOut(300,function(){t(this).remove()})}})}}),t(document).on("click","#owner_delete",function(e){if(e.preventDefault(),window.confirm(bdb_booking.areyousure)){var n=t(this).closest(".directorist-booking-card");n.addClass("loading");var o={action:"bdb_owner_approved_bookings_manage",booking_id:t(this).data("booking_id"),status:"deleted"};t.ajax({type:"POST",dataType:"json",url:bdb_booking.ajax_url,data:o,success:function(e){n.removeClass("loading"),n.fadeOut(300,function(){t(this).remove()})}})}}),t(".bdb-approved").on("click",function(e){bdb_owner_approved_bookings_manage()}),t(".bdb-listing-approved").on("click",function(e){bdb_owner_approved_bookings_manage()}),t(document).on("click","#owner_approved",function(e){e.preventDefault();var n=t(this).closest(".directorist-booking-card");n.addClass("loading");var o={action:"bdb_owner_approved_bookings_manage",booking_id:t(this).data("booking_id"),status:"confirmed"};t.ajax({type:"POST",dataType:"json",url:bdb_booking.ajax_url,data:o,success:function(e){n.removeClass("loading"),n.fadeOut(300,function(){t(this).remove()})}})}),t(document).on("click","#owner_reject",function(e){if(e.preventDefault(),window.confirm(bdb_booking.areyousure)){var n=t(this).closest(".directorist-booking-card");n.addClass("loading");var o={action:"bdb_owner_approved_bookings_manage",booking_id:t(this).data("booking_id"),status:"cancelled"};t.ajax({type:"POST",dataType:"json",url:bdb_booking.ajax_url,data:o,success:function(e){n.removeClass("loading"),n.fadeOut(300,function(){t(this).remove()})}})}});const o=document.querySelectorAll(".directorist-booking-card__value__copy");o.length>0&&o.forEach(e=>{e.onclick=function(){const t=this.closest(".directorist-booking-card__value");if(!t)return;const n=(t.textContent||t.innerText||"").replace(/\s+/g," ").trim();function o(t){const n=Object.assign(document.createElement("textarea"),{value:t});document.body.appendChild(n),n.select();try{document.execCommand("copy")?(e.innerHTML="✔️",setTimeout(()=>{e.innerHTML=`<i class="directorist-icon-mask" aria-hidden="true" style="--directorist-icon: url(${bdb_booking.site_url}/wp-content/plugins/directorist/assets/icons/line-awesome/svgs/copy-solid.svg)"></i>`},1500)):alert("Copy failed")}catch(e){console.error("Copy error:",e),alert("Copy failed")}n.remove()}n?navigator.clipboard&&window.isSecureContext?navigator.clipboard.writeText(n).then(()=>{this.innerHTML="✔️",setTimeout(()=>{this.innerHTML=`<i class="directorist-icon-mask" aria-hidden="true" style="--directorist-icon: url(${bdb_booking.site_url}/wp-content/plugins/directorist/assets/icons/line-awesome/svgs/copy-solid.svg)"></i>`},1500)}).catch(e=>{console.error("Copy failed:",e),o(n)}):o(n):alert("No text to copy")}}),t(".bdb-listing-waiting").on("click",function(e){bdb_owner_pending_bookings_manage()}),t(".bdb-listing-cancelled").on("click",function(e){bdb_owner_cancelled_bookings_manage()}),t("#bdb_paid").click(function(){t("#bdb_paid").addClass("active"),t("#bdb_all_status").removeClass("active"),t("#bdb_confirmed").removeClass("active")}),t("#bdb_confirmed").click(function(){t("#bdb_confirmed").addClass("active"),t("#bdb_all_status").removeClass("active"),t("#bdb_paid").removeClass("active")}),t("#bdb_all_status").click(function(){t("#bdb_all_status").addClass("active"),t("#bdb_confirmed").removeClass("active"),t("#bdb_paid").removeClass("active")}),t(".directorist-booking-month-picker").datepicker({changeMonth:!0,changeYear:!0,showButtonPanel:!1,dateFormat:"MM yy",nextText:"",prevText:"",onClose:function(e,n){var o=t("#ui-datepicker-div .ui-datepicker-month :selected").val(),i=t("#ui-datepicker-div .ui-datepicker-year :selected").val();t(this).val(t.datepicker.formatDate("MM yy",new Date(i,o,1)))},onChangeMonthYear:function(e,n){var o=t("#ui-datepicker-div .ui-datepicker-month :selected").val(),i=parseInt(o)+1,a=t("#ui-datepicker-div .ui-datepicker-year :selected").val(),r=t(".directorist-listing-id").val();t(this).val(t.datepicker.formatDate("MM yy",new Date(a,o,1))),d().addClass("directorist-booking-calender--loader"),g(i,a,r)}}),t(".directorist-booking-month-picker").focus(function(){t(".ui-datepicker-calendar").hide(),t("#ui-datepicker-div").position({my:"center top",at:"center bottom",of:t(this)}),t("#ui-datepicker-div").addClass("directorist-monthpicker")});const i=[bdb_booking.january,bdb_booking.february,bdb_booking.march,bdb_booking.april,bdb_booking.may,bdb_booking.june,bdb_booking.july,bdb_booking.august,bdb_booking.september,bdb_booking.october,bdb_booking.november,bdb_booking.december];let a=new Date;t(".directorist-booking-month-picker").val(`${i[a.getMonth()]} ${a.getFullYear()}`),t(document).on("click",".directorist-booking-calender__calender-top-right button",function(e){t(".directorist-booking-modal").addClass("show")}),t(document).on("click","#connect-google-calendar",function(e){e.preventDefault(),"undefined"!=typeof GoogleCalendarModal?GoogleCalendarModal.show():console.error("GoogleCalendarModal not available")}),t(document).on("click",".directorist-booking-modal__cross, .directorist-booking-modal__footer-cancel",function(e){t(".directorist-booking-modal").removeClass("show")});const r=document.querySelectorAll(".directorist-user-listing"),s=document.querySelector(".directorist-listing-id");0!==r.length&&(r[0].classList.add("active"),s.value=r[0].getAttribute("data-id"));let d=()=>t("#directorist-calendar-outer-container");function c(){var e=t(".bdb_calender_unavailable").val();if(e){var n=e.split("|");t.each(n,function(e,n){n&&t("td.directorist-calendar-day[data-date='"+n+"']").addClass("not_active")})}}t("body").on("click",".directorist-user-listing",function(e){e.preventDefault(),t(".directorist-user-listing").removeClass("active"),t(this).addClass("active");var n=t(this).attr("data-id");t(".directorist-listing-id").val(n),d().addClass("directorist-booking-calender--loader"),g("","",n)}),t("body").on("click",".directorist-booking-calender__wrapper .directorist-dash-prev",function(e){e.preventDefault();var n=t(this).data("prev-month"),o=t(this).data("prev-year"),i=t(".directorist-listing-id").val();d().addClass("directorist-booking-calender--loader"),g(n,o,i)}),t("body").on("click",".directorist-booking-calender__wrapper .directorist-dash-next",function(e){e.preventDefault();var n=t(this).data("next-month"),o=t(this).data("next-year"),i=t(".directorist-listing-id").val();d().addClass("directorist-booking-calender--loader"),g(n,o,i)});var l=t(".directorist-price").val();t("body .directorist-calendar-day:not(.directorist-weekend) .directorist-calendar-price .directorist-calendar-price-money__currency span").html(l);var u=t(".directorist-weekend-price").val();function b(){var e=t(".bdb_calender_price").val();if(e){var n=JSON.parse(e);t.each(n,function(e,n){e&&t("td.directorist-calendar-day[data-date='"+e+"'] .directorist-calendar-price .directorist-calendar-price-money__currency span").html(n)})}}function g(e,n,o){t.ajax({type:"post",dataType:"json",url:bdb_add_booking.ajax_url,data:{action:"dashboard_rent_calendar",month:e,year:n,listingId:o},success:function(e){t(".directorist-booking-calender__wrapper").html(e.response),t(".directorist-price").val(e.pricing.normal_price),t(".directorist-weekend-price").val(e.pricing.weekend_price),t(".bdb_calender_price").val(e.pricing.calender_price),d().removeClass("directorist-booking-calender--loader");var n=t(".directorist-price").val();t("body .directorist-calendar-day:not(.directorist-weekend) .directorist-calendar-price .directorist-calendar-price-money__currency span").html(n);var o=t(".directorist-weekend-price").val();t("body .directorist-calendar-day.directorist-weekend .directorist-calendar-price .directorist-calendar-price-money__currency span").html(o),b(),c(),p()}})}function p(){document.querySelectorAll(".directorist-calendar-day-row").forEach(e=>{e.querySelectorAll(".directorist-calendar-day__booked").forEach(e=>{let t=e.previousElementSibling,n=e.nextElementSibling;null==t&&!e.nextElementSibling.classList.contains("directorist-calendar-day_available")&&e.classList.add("bdb-booked-start"),null==n&&!e.previousElementSibling.classList.contains("directorist-calendar-day_available")&&e.classList.add("bdb-booked-end"),null==t&&!e.nextElementSibling.classList.contains("directorist-calendar-day_available")&&e.querySelector(".directorist-calendar-event-title")&&""==e.querySelector(".directorist-calendar-event-title").innerHTML&&e.classList.add("bdb-booked-start-tail"),null==n&&!e.previousElementSibling.classList.contains("directorist-calendar-day_available")&&e.querySelector(".directorist-calendar-event-title")&&""==e.querySelector(".directorist-calendar-event-title").innerHTML&&e.classList.add("bdb-booked-end-tail"),null!=t&&e.previousElementSibling.classList.contains("directorist-calendar-day_available")&&e.classList.add("bdb-booked-start"),null!=n&&e.nextElementSibling.classList.contains("directorist-calendar-day_available")&&e.classList.add("bdb-booked-end"),null==t&&(e.nextElementSibling.classList.contains("directorist-calendar-day_available")||e.nextElementSibling.classList.contains("directorist-empty-calendar-day"))&&(e.classList.remove("bdb-booked-end"),e.classList.remove("bdb-booked-start"),e.classList.add("bdb-booked-single")),null==n&&(e.previousElementSibling.classList.contains("directorist-calendar-day_available")||e.previousElementSibling.classList.contains("directorist-empty-calendar-day"))&&(e.classList.remove("bdb-booked-start"),e.classList.remove("bdb-booked-end"),e.classList.add("bdb-booked-single"))})})}t("body .directorist-calendar-day.directorist-weekend .directorist-calendar-price .directorist-calendar-price-money__currency span").html(u),b(),p();let v=document.querySelector(".directorist-booking-calender__search input[type=text]");v&&v.addEventListener("keyup",function(){if(!v)return;let e=v.value.toUpperCase(),t=document.querySelector(".directorist-booking-calender__search-content ul");t&&t.querySelectorAll("li").forEach(t=>{(t.textContent||t.innerText).toUpperCase().indexOf(e)>-1?t.style.display="":t.style.display="none"})}),t(document).ready(function(){}),window.bdb_user_bookings_manage=function(o=1){var i={action:"bdb_user_bookings_manage",listing_id:t("#listing_id").val(),listing_status:t(".listing_status").val(),dashboard_type:t("#dashboard_type").val(),limit:5,offset:0,page:o};t(".dashboard-list-box").addClass("loading"),t.ajax({type:"POST",dataType:"json",url:bdb_booking.ajax_url,data:i,success:function(o){t(".dashboard-list-box").removeClass("loading"),n(o,e())}})},window.getBookingContainerIds=e,window.updateBookingContainers=n,window.bdb_owner_deleted_bookings_manage=function(o=1){var i={action:"bdb_owner_approved_bookings_manage",listing_id:t("#listing_id").val(),listing_status:"cancelled",dashboard_type:t("#dashboard_type").val(),limit:5,offset:0,page:o};t("#bdb_listing_status").attr("data-status")&&(i.listing_status=t("#bdb_listing_status").attr("data-status")),t("#bdb_listing_id_approved").attr("data-status")&&(i.listing_id=t("#bdb_listing_id_approved").attr("data-status")),t(".dashboard-list-box").addClass("loading"),t.ajax({type:"POST",dataType:"json",url:bdb_booking.ajax_url,data:i,success:function(o){t(".dashboard-list-box").removeClass("loading"),n(o,e())}})},window.submit_calendar_update_unav_days=c})})();