<?php

defined( 'ABSPATH' ) || exit;

use Directorist_Booking\App\Http\Middleware\EnsureIsUserAdmin;
use Directorist_Booking\App\Providers\MenuServiceProvider;
use Directorist_Booking\App\Providers\MetaSubmission;
use Directorist_Booking\App\Providers\CustomPage;
use Directorist_Booking\App\Providers\Widget;
use Directorist_Booking\App\Providers\Settings;
use Directorist_Booking\App\Providers\Payment;
use Directorist_Booking\App\Providers\Database;
use Directorist_Booking\App\Providers\WooCommercePayment;
use Directorist_Booking\App\Providers\Dashboard;
use Directorist_Booking\App\Providers\Calender;
use Directorist_Booking\App\Providers\FormBuilder;
use Directorist_Booking\App\Providers\Commission\Commission;
use Directorist_Booking\App\Providers\Commission\Wallet;
use Directorist_Booking\App\Providers\Refund\AdminRefund;
use Directorist_Booking\App\Providers\Refund\UserRefund;
use Directorist_Booking\App\Providers\GoogleCalendar;
// use Directorist_Booking\Database\Migrations\TestMigration;
use Directorist_Booking\WpMVC\Helpers\Helpers;

return [
    /**
     * The version of the plugin.
     */
    'version'                     => Helpers::get_plugin_version( 'directorist-booking' ),

    /**
     * Configuration for the REST API.
     */
    'rest_api'                    => [
        /**
         * The namespace for the REST API.
         */
        'namespace' => 'directorist_booking',
        
        /**
         * The versions of the REST API.
         */
        'versions'  => []
    ],

    /**
     * Configuration for the AJAX API.
     */
    'ajax_api'                    => [
        /**
         * The namespace for the AJAX API.
         */
        'namespace' => 'directorist_booking',
        
        /**
         * The versions of the AJAX API.
         */
        'versions'  => []
    ],

    /**
     * Service providers for the plugin.
     */
    'providers'                   => [
        MetaSubmission::class,
        Widget::class,
        Database::class,
        Payment::class,
        WooCommercePayment::class,
        Dashboard::class,
        Calender::class,
        Commission::class,
        Wallet::class,
        FormBuilder::class,
        UserRefund::class,
        GoogleCalendar::class,
    ],

    /**
     * Service providers for the admin area of the plugin.
     */
    'admin_providers'             => [
        CustomPage::class,
        Settings::class,
        AdminRefund::class,
    ],

    /**
     * Middleware configuration for the plugin.
     */
    'middleware'                  => [
        /**
         * Middleware for admin routes.
         */
        'admin' => EnsureIsUserAdmin::class,
        'auth'  => \Directorist_Booking\App\Http\Middleware\EnsureUserIsLoggedIn::class,
    ],

    /**
     * The database option key for storing migration information.
     */
    'migration_db_option_key'     => 'directorist_booking_migrations',

    /**
     * List of migrations for the plugin.
     */
    'migrations'                  => [
        // 'test-migration' => TestMigration::class,
    ],

    /**
     * This configuration option defines a hook that will fire before executing the route callback,
     * such as before a controller action. It provides two parameters:
     * 
     * @param WP_REST_Request $wp_rest_request The current REST request object.
     * @param string $full_route The full route being accessed.
     */
    'rest_response_action_hook'   => 'directorist-booking_rest_response_action',

    /**
     * Configuration for the REST API response filter hook.
     *
     * This filter hook allows overriding the entire REST API response.
     * 
     * @param $response The response object from the controller.
     * @param WP_REST_Request  $wp_rest_request The request object.
     * @param string           $full_route The full route of the request.
     */
    'rest_response_filter_hook'   => 'directorist-booking_rest_response_filter',

    /**
     * This filter hook that can override all REST API permissions.
     * 
     * @param mixed $permission The current permission setting.
     * @param mixed $middleware The middleware being applied.
     * @param string $full_route The full route of the API endpoint.
     */
    'rest_permission_filter_hook' => 'directorist-booking_rest_permission_filter',
];