<?php

defined( 'ABSPATH' ) || exit;

use Directorist_Booking\WpMVC\App;

/**
 * Plugin Name: Directorist - Booking
 * Plugin URI: http://directorist.com/plugins/directorist-booking
 * Description: This is an extension for Directorist Plugin.
 * Version: 3.0.2
 * Author: wpWax
 * Author URI: http://directorist.com
 * License: GPLv2 or later
 * Text Domain: directorist-booking
 * Domain Path: /languages
 * Requires Plugins:  directorist
 */

require_once __DIR__ . '/vendor/vendor-src/autoload.php';
require_once __DIR__ . '/app/Helpers/helper.php';
require_once __DIR__ . '/app/Helpers/EDDPluginUpdaterBooking.php';
use Directorist_Booking\WpMVC\Helpers\Helpers;

final class Directorist_Booking
{
    public static Directorist_Booking $instance;

    public static function instance(): Directorist_Booking {
        if ( empty( self::$instance ) ) {
            self::$instance = new self;
            self::$instance->setup_constants();
        }
        return self::$instance;
    }

    public function load() {
        $application = App::instance();

        $application->boot( __FILE__, __DIR__ );

        if ( is_admin() ) {
            add_action( 'admin_init', [ $this, 'update' ] );
        }

        /**
         * Fires once activated plugins have loaded.
         *
         */
        add_action(
            'plugins_loaded', function () use ( $application ): void {

                do_action( 'before_load_directorist_booking' );

                $application->load();

                do_action( 'after_load_directorist_booking' );
            }
        );
    }

    private function setup_constants() {
            // Plugin version
        if ( ! defined( 'BDB_VERSION' ) ) {
            define( 'BDB_VERSION', Helpers::get_plugin_version( 'directorist-booking' ) );
        }

            // plugin author url
        if ( ! defined( 'ATBDP_AUTHOR_URL' ) ) {
            define( 'ATBDP_AUTHOR_URL', 'https://directorist.com' );
        }
            // post id from download post type (edd)
        if ( ! defined( 'ATBDP_BDB_POST_ID' ) ) {
            define( 'ATBDP_BDB_POST_ID', 21718 );
        }
            // Plugin Folder Path.
        if ( ! defined( 'BDB_DIR' ) ) {
            define( 'BDB_DIR', plugin_dir_path( __FILE__ ) ); }
            // Plugin Folder URL.
        if ( ! defined( 'BDB_URL' ) ) {
            define( 'BDB_URL', plugin_dir_url( __FILE__ ) ); }
            // Plugin Root File.
        if ( ! defined( 'BDB_FILE' ) ) {
            define( 'BDB_FILE', __FILE__ ); }
        if ( ! defined( 'BDB_BASE' ) ) {
            define( 'BDB_BASE', plugin_basename( __FILE__ ) ); }
            // Plugin Text domain File.
        if ( ! defined( 'BDB_TEXTDOMAIN' ) ) {
            define( 'BDB_TEXTDOMAIN', 'directorist-booking' ); }
            // Plugin Language File Path
        if ( ! defined( 'BDB_LANG_DIR' ) ) {
            define( 'BDB_LANG_DIR', dirname( plugin_basename( __FILE__ ) ) . '/languages' ); }
            // Plugin Template Path
        if ( ! defined( 'BDB_TEMPLATES_DIR' ) ) {
            define( 'BDB_TEMPLATES_DIR', BDB_DIR . 'templates/' ); }
    }

    public function update(): void {

        $data        = get_user_meta( get_current_user_id(), '_plugins_available_in_subscriptions', true );
        $license_key = ! empty( $data['directorist-booking'] ) ? $data['directorist-booking']['license'] : '';
        new EDDPluginUpdaterBooking(
            ATBDP_AUTHOR_URL, __FILE__, [
                'version' => BDB_VERSION,        // current version number
                'license' => $license_key,    // license key (used get_option above to retrieve from DB)
                'item_id' => ATBDP_BDB_POST_ID,    // id of this plugin
                'author'  => 'AazzTech',    // author of this plugin
                'url'     => home_url(),
                'beta'    => false // set to true if you wish customers to receive update notifications of beta releases
            ]
        );
    }
}

Directorist_Booking::instance()->load();

function bdb_booking_db() {
    global $wpdb;
    directorist_booking_pricing_format_change();
    $collate = '';
    if ( $wpdb->has_cap( 'collation' ) ) {
        if ( ! empty( $wpdb->charset ) ) {
            $collate .= "DEFAULT CHARACTER SET $wpdb->charset";
        }
        if ( ! empty( $wpdb->collate ) ) {
            $collate .= " COLLATE $wpdb->collate";
        }
    }

    require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );

    $sql = "
CREATE TABLE {$wpdb->prefix}directorist_booking (
    `ID` bigint(20) UNSIGNED  NOT NULL auto_increment,
    `bookings_author` bigint(20) UNSIGNED NOT NULL,
    `owner_id` bigint(20) UNSIGNED NOT NULL,
    `listing_id` bigint(20) UNSIGNED NOT NULL,
    `date_start` datetime DEFAULT NULL,
    `date_end` datetime DEFAULT NULL,
    `comment` text,
    `order_id` bigint(20) UNSIGNED DEFAULT NULL,
    `status` varchar(100) DEFAULT NULL,
    `type` text,
    `created` datetime DEFAULT NULL,
    `expiring` datetime DEFAULT NULL,
    `price` FLOAT DEFAULT NULL,
    `google_calendar_event_id` varchar(255) DEFAULT NULL,
    PRIMARY KEY  (ID)
) $collate;
";

    dbDelta( $sql );
}

register_activation_hook( __FILE__,'bdb_booking_db' );
