<?php

use Directorist_Booking\WpMVC\Enqueue\Enqueue;

defined( 'ABSPATH' ) || exit;

// Load admin scripts
function bdb_admin_enqueue_scripts() {
    $booking_type               = get_directorist_option( 'booking_type', [ 'service', 'rent', 'booking' ] );
    $booking_type_default_value = get_directorist_option( 'booking_type_default_value', 'service' );
    $booking_type_default_value = ! empty( $booking_type_default_value ) ? $booking_type_default_value : 'service';
    $warning_value              = [
        'ajax_url'                   => admin_url( 'admin-ajax.php', 'relative' ),
        'confirmtion_text'           => __( 'Are you sure', 'directorist-booking' ),
        'ask_conf_sl_lnk_del_txt'    => __( 'Do you really want to remove!', 'directorist-booking' ),
        'confirm_delete'             => __( 'Yes, Delete it!', 'directorist-booking' ),
        'deleted'                    => __( 'Deleted!', 'directorist-booking' ),
        'booking_type'               => $booking_type,
        'booking_type_default_value' => $booking_type_default_value,
        'time_from_text'             => __( 'Time From', 'directorist-booking' ),
        'time_to_text'               => __( 'Time To', 'directorist-booking' ),
        'slots_text'                 => __( 'Slots', 'directorist-booking' )
    ];
    
    Enqueue::style( 'bdb-timepicker', 'build/css/timepicker' );
    Enqueue::style( 'bdb-global', 'build/css/common' );
    Enqueue::style( 'bdb-css', 'build/css/admin' );

    // Ensure hoverIntent is loaded
    wp_enqueue_script( 'hoverIntent' );

    // Timepicker script
    Enqueue::script( 'bdb-timepicker', 'build/js/timepicker', [ 'jquery' ] );

    // Common script
    Enqueue::script( 'bdb_common', 'build/js/common', [ 'jquery', 'hoverIntent' ] );
    // Localize scripts
    wp_localize_script( 'bdb_common', 'bdb_add_booking', $warning_value );
    wp_localize_script( 'bdb-adminmain', 'bdb_booking', $warning_value );
    wp_localize_script(
        'bdb_common', 'booking_hours', [
            'monday'    => __( 'Monday','directorist-booking' ),
            'tuesday'   => __( 'Tuesday', 'directorist-booking' ),
            'wednesday' => __( 'Wednesday', 'directorist-booking' ),
            'thursday'  => __( 'Thursday', 'directorist-booking' ),
            'friday'    => __( 'Friday', 'directorist-booking' ),
            'saturday'  => __( 'Saturday', 'directorist-booking' ),
            'sunday'    => __( 'Sunday', 'directorist-booking' )
        ] 
    );
}

add_action( 'admin_enqueue_scripts', 'bdb_admin_enqueue_scripts' );


// Load scripts for post type
if ( ATBDP_POST_TYPE === get_post_type() ) {
    bdb_admin_enqueue_scripts();
}