<?php

use Directorist_Booking\WpMVC\Enqueue\Enqueue;

defined( 'ABSPATH' ) || exit;

Enqueue::register_style( 'bdb-intlTelInput', 'build/css/intlTelInput' );
Enqueue::register_style( 'bdb-flatpickr', 'build/css/flatpickr' );
Enqueue::register_style( 'bdb-daterangepicker', 'build/css/daterangepicker' );
Enqueue::register_style( 'bdb-timepicker', 'build/css/timepicker' );
Enqueue::style( 'bdb-timepicker', 'build/css/timepicker' );


if ( is_rtl() ) {
    Enqueue::style( 'bdb-style-rtl', 'build/css/frontend-rtl', [ 'directorist-line-awesome' ] );
} else {
    
    Enqueue::style( 'bdb-global', 'build/css/common', [ 'directorist-line-awesome' ] );
    Enqueue::style( 'bdb-style', 'build/css/frontend' );
}
// Timepicker script
Enqueue::script( 'bdb-timepicker', 'build/js/timepicker', [ 'jquery' ] );

// Common script
Enqueue::script( 'bdb-front-admin', 'build/js/common.js', [ 'jquery' ] );

Enqueue::register_script( 'bdb-main', 'build/js/main.js', [ 'jquery' ] );
Enqueue::register_script( 'bdb-fullcalendar', 'build/js/fullcalendar.js', [ 'jquery' ] );
Enqueue::register_script( 'bdb-dashboard', 'build/js/dashboard.js', [ 'jquery-ui-datepicker', 'bdb-fullcalendar' ] );
// Enqueue::register_script( 'bdb-booking-filter', 'build/js/booking-filter.js', [ 'jquery' ] );
// Enqueue::register_script( 'bdb-navigation-state', 'build/js/navigation-state-manager.js', [ 'jquery' ] );
wp_enqueue_script( 'moment' );

Enqueue::register_script( 'bdb-flatpickr', 'build/js/flatpickr.js', [ 'jquery'] );
Enqueue::register_script( 'bdb-daterangepicker', 'build/js/daterangepicker.js', [ 'jquery' ] );
Enqueue::register_script( 'bdb-timepicker', 'build/js/timepicker.js', [ 'jquery' ] );

$wordpress_data_format      = bdb_date_time_wp_format();
$ajax_url                   = admin_url( 'admin-ajax.php', 'relative' );
$currency                   = get_directorist_option( 'g_currency', 'USD' );
$currency_position          = get_directorist_option( 'g_currency_position', 'before' );
$currency_symbol            = atbdp_currency_symbol( $currency );
$booking_array              = [
    'ajax_url'               => $ajax_url,
    'site_url'               => home_url(),
    'is_rtl'                 => is_rtl() ? 1 : 0,
    "applyLabel"             => esc_html__( "Apply",'directorist-booking' ),
    "cancelLabel"            => esc_html__( "Cancel",'directorist-booking' ),
    "clearLabel"             => esc_html__( "Clear",'directorist-booking' ),
    "fromLabel"              => esc_html__( "From",'directorist-booking' ),
    "toLabel"                => esc_html__( "To",'directorist-booking' ),
    "customRangeLabel"       => esc_html__( "Custom",'directorist-booking' ),
    "day_short_su"           => esc_html_x( "Su", 'Short for Sunday', 'directorist-booking' ),
    "day_short_mo"           => esc_html_x( "Mo", 'Short for Monday','directorist-booking' ),
    "day_short_tu"           => esc_html_x( "Tu", 'Short for Tuesday','directorist-booking' ),
    "day_short_we"           => esc_html_x( "We", 'Short for Wednesday','directorist-booking' ),
    "day_short_th"           => esc_html_x( "Th", 'Short for Thursday','directorist-booking' ),
    "day_short_fr"           => esc_html_x( "Fr", 'Short for Friday','directorist-booking' ),
    "day_short_sa"           => esc_html_x( "Sa", 'Short for Saturday','directorist-booking' ),
    "month_short_jan"        => esc_html_x( "Jan", 'Short for January', 'directorist-booking' ),
    "month_short_feb"        => esc_html_x( "Feb", 'Short for February', 'directorist-booking' ),
    "month_short_mar"        => esc_html_x( "Mar", 'Short for March', 'directorist-booking' ),
    "month_short_apr"        => esc_html_x( "Apr", 'Short for April', 'directorist-booking' ),
    "month_short_may"        => esc_html_x( "May", 'Short for May', 'directorist-booking' ),
    "month_short_jun"        => esc_html_x( "Jun", 'Short for June', 'directorist-booking' ),
    "month_short_jul"        => esc_html_x( "Jul", 'Short for July', 'directorist-booking' ),
    "month_short_aug"        => esc_html_x( "Aug", 'Short for August', 'directorist-booking' ),
    "month_short_sep"        => esc_html_x( "Sep", 'Short for September', 'directorist-booking' ),
    "month_short_oct"        => esc_html_x( "Oct", 'Short for October', 'directorist-booking' ),
    "month_short_nov"        => esc_html_x( "Nov", 'Short for November', 'directorist-booking' ),
    "month_short_dec"        => esc_html_x( "Dec", 'Short for December', 'directorist-booking' ),
    'january'                => esc_html__( "January","directorist-booking" ),
    'february'               => esc_html__( "February","directorist-booking" ),
    'march'                  => esc_html__( "March","directorist-booking" ),
    'april'                  => esc_html__( "April","directorist-booking" ),
    'may'                    => esc_html__( "May","directorist-booking" ),
    'june'                   => esc_html__( "June","directorist-booking" ),
    'july'                   => esc_html__( "July","directorist-booking" ),
    'august'                 => esc_html__( "August","directorist-booking" ),
    'september'              => esc_html__( "September","directorist-booking" ),
    'october'                => esc_html__( "October","directorist-booking" ),
    'november'               => esc_html__( "November","directorist-booking" ),
    'december'               => esc_html__( "December","directorist-booking" ),
    'areyousure'             => esc_html__( "Are you sure?","directorist-booking" ),
    'currency_position'      => $currency_position,
    'currency_symbol'        => $currency_symbol,
    'directorist_nonce'      => wp_create_nonce( directorist_get_nonce_key() ),
    'directorist_rest_nonce' => wp_create_nonce( 'wp_rest' ),
    'directorist_rest_url'   => esc_url_raw( rest_url() ),
    'date_format'            => get_option( 'date_format' ),
];
$booking_type               = get_directorist_option( 'booking_type', [ 'service', 'rent', 'event' ] );
$booking_type_default_value = get_directorist_option( 'booking_type_default_value', 'service' );
$booking_type_default_value = ! empty( $booking_type_default_value ) ? $booking_type_default_value : 'service';
$warning_value              = [
    'ajax_url'                   => admin_url( 'admin-ajax.php', 'relative' ),
    'confirmtion_text'           => __( 'Are you sure', 'directorist-booking' ),
    'ask_conf_sl_lnk_del_txt'    => __( 'Do you really want to remove!', 'directorist-booking' ),
    'confirm_delete'             => __( 'Yes, Delete it!', 'directorist-booking' ),
    'deleted'                    => __( 'Deleted!', 'directorist-booking' ),
    'booking_type'               => $booking_type,
    'booking_type_default_value' => $booking_type_default_value,
    'time_from_text'             => __( 'Time From', 'directorist-booking' ),
    'time_to_text'               => __( 'Time To', 'directorist-booking' ),
    'slots_text'                 => __( 'Slots', 'directorist-booking' )
];

wp_localize_script( 'bdb-main','wordpress_data_format',$wordpress_data_format );
wp_localize_script( 'bdb-main','bdb_booking',$booking_array );
wp_localize_script( 'bdb-dashboard','wordpress_data_format',$wordpress_data_format );
wp_localize_script( 'bdb-dashboard','bdb_booking',$booking_array );
// wp_localize_script( 'bdb-booking-filter','bdb_ajax',[
//     'ajax_url' => $ajax_url,
//     'nonce' => wp_create_nonce('bdb_ajax_nonce')
// ]);
wp_localize_script( 'bdb-front-admin', 'bdb_add_booking', $warning_value );
wp_localize_script(
    'bdb-front-admin', 'booking_hours', [
        'monday'    => __( 'Monday','directorist-booking' ),
        'tuesday'   => __( 'Tuesday', 'directorist-booking' ),
        'wednesday' => __( 'Wednesday', 'directorist-booking' ),
        'thursday'  => __( 'Thursday', 'directorist-booking' ),
        'friday'    => __( 'Friday', 'directorist-booking' ),
        'saturday'  => __( 'Saturday', 'directorist-booking' ),
        'sunday'    => __( 'Sunday', 'directorist-booking' )
    ] 
);
wp_localize_script( 'bdb-adminmain', 'bdb_booking', array_merge( $booking_array, $warning_value ) );