<?php
use Directorist_Booking\WpMVC\View\View;
wp_enqueue_style( 'bdb-style' );
wp_enqueue_script( 'bdb-main-js' );
$current_user = wp_get_current_user();
$roles        = $current_user->roles;
$role         = array_shift( $roles );
$type         = '';
if ( isset( $data['type'] ) && 'user_booking' == $data['type'] ) {
    if ( 'user_booking' == $data['type'] ) {
        $type = "user";
    }
}

$booking_status = 'All';
if ( ! empty( $data['bookings'] ) ) {
    foreach ( $data['bookings'] as $value ) {
        $booking_status = $value['status'];
    }
    wp_reset_postdata();
    switch ( $booking_status ) {
        case 'confirmed';
            $booking_status = 'Approved';
            break;
        case 'waiting';
            $booking_status = 'Pending';
            break;
    }
}

$status = 'user' == $type ? 'My Bookings' : $booking_status . ' Bookings';

/**
 * @since 1.0.0
 */
do_action( 'atbdp_user_dashboard_booking_before_content', $status ); ?>

<div class="row">
    <!-- Listings -->
    <div class="col-lg-12 col-md-12">
        <div class="dashboard-list-box  margin-top-0">

            <!-- Booking Requests Filters  -->
            <div class="directorist-booking-requests-filter">
                <?php if ( $type == "user" ) : ?>
                    <input type="hidden" id="dashboard_type" name="dashboard_type" value="user">
                <?php endif; ?>
            </div>

            <!-- Reply to review popup -->

            <?php
            $booking_area_title = $type == "user" ? __( 'My Bookings', 'directorist-booking' ) : __( 'All Bookings', 'directorist-booking' );
            $html               = sprintf( '<h4 class="directorist-bookings-title">%s</h4>', $booking_area_title );

            echo apply_filters( 'atbdp_user_dashboard_booking_header_area', $html );

            if ( $type != "user" ) { ?>
                <div class="directorist-booking-content-inner">
                    <?php /*if(  ( $type!== "user" && isset($_GET['status']) && $_GET['status'] == 'approved')) : */ ?><!--

                    <ul class="db-booking-parent" id="bdb_listing_status" data-status="">
                        <li class="db-booking-parent__child active" id="bdb_all_status"><a class="bdb-approved" data-status="approved"><?php /*_e("All Statuses","directorist-booking"); */ ?></a></li>
                        <li class="db-booking-parent__child" id="bdb_paid"><a class="bdb-approved" data-status="paid"><?php /*_e("Paid","directorist-booking"); */ ?></a></li>
                        <li class="db-booking-parent__child" id="bdb_confirmed"><a class="bdb-approved" data-status="confirmed"><?php /*_e("Unpaid","directorist-booking"); */ ?></a></li>
                    </ul>
                 --><?php /*endif; */ ?>
                    <!-- New Horizontal Booking Filter System -->
                    <div class="directorist-booking-filter-horizontal">
                        <div class="filter-bar">
                            <!-- Search Input -->
                            <div class="filter-search">
                                <div class="search-input-wrapper">
                                    <span class="search-icon">
                                        <?php directorist_icon( 'las la-search' ); ?>
                                    </span>
                                    <input type="text" 
                                           class="search-input booking-search-input" 
                                           autocomplete="off"
                                           autocorrect="off"
                                           autocapitalize="off"
                                           spellcheck="false"
                                           placeholder="<?php echo esc_attr__( 'Search by listing or booking name, date...', 'directorist-booking' ); ?>">
                                    <button type="button" class="search-clear-btn booking-search-clear" style="display: none;">
                                        <span class="clear-icon">✕</span>
                                    </button>
                                </div>
                            </div>

                            <!-- Sort Selector -->
                            <div class="filter-sort">
                                <button type="button" class="filter-dropdown-btn" id="sortDropdownBtn">
                                    <span class="filter-icon">
                                        <?php directorist_icon( 'las la-sort-amount-down' ); ?>
                                    </span>
                                    <span class="filter-text" id="sortText"><?php echo esc_html__( 'Sort by', 'directorist-booking' ); ?></span>
                                    <span class="dropdown-arrow">▼</span>
                                </button>
                                <div class="filter-dropdown" id="sortDropdown">
                                    <div class="dropdown-item" data-value="created_desc">
                                        <?php echo esc_html__( 'Request Date: Newest', 'directorist-booking' ); ?>
                                    </div>
                                    <div class="dropdown-item" data-value="created_asc">
                                        <?php echo esc_html__( 'Request Date: Oldest', 'directorist-booking' ); ?>
                                    </div>
                                    <div class="dropdown-item" data-value="price_desc">
                                        <?php echo esc_html__( 'Price: High to Low', 'directorist-booking' ); ?>
                                    </div>
                                    <div class="dropdown-item" data-value="price_asc">
                                        <?php echo esc_html__( 'Price: Low to High', 'directorist-booking' ); ?>
                                    </div>
                                </div>
                            </div>

                            <!-- Date Selector -->
                            <div class="filter-date">
                                <button type="button" class="filter-dropdown-btn" id="dateDropdownBtn">
                                    <span class="filter-icon">
                                        <?php directorist_icon( 'las la-calendar-alt' ); ?>
                                    </span>
                                    <span class="filter-text" id="dateText"><?php echo esc_html__( 'Booking Date', 'directorist-booking' ); ?></span>
                                    <span class="dropdown-arrow">▼</span>
                                </button>
                                <div class="filter-dropdown" id="dateDropdown">
                                    <div class="date-picker-wrapper">
                                        <div class="date-input-group">
                                            <label><?php echo esc_html__( 'From Date', 'directorist-booking' ); ?></label>
                                            <input type="date" class="date-input" id="dateFrom">
                                        </div>
                                        <div class="date-input-group">
                                            <label><?php echo esc_html__( 'To Date', 'directorist-booking' ); ?></label>
                                            <input type="date" class="date-input" id="dateTo">
                                        </div>
                                        <div class="date-actions">
                                            <button type="button" class="date-clear" id="clearDates">
                                                <?php echo esc_html__( 'Clear', 'directorist-booking' ); ?>
                                            </button>
                                            <button type="button" class="date-apply" id="applyDates">
                                                <?php echo esc_html__( 'Apply', 'directorist-booking' ); ?>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div><!-- ends: db-booking-tabs -->
            <?php } ?>
            <?php 
            // Generate unique ID based on tab and status context
            $tab_context    = isset( $tab_context ) ? $tab_context : ( isset( $_GET['tab'] ) ? sanitize_text_field( $_GET['tab'] ) : '' );
            $status_context = isset( $status_context ) ? $status_context : ( isset( $_GET['status'] ) ? sanitize_text_field( $_GET['status'] ) : '' );

            $suffix_parts  = array_filter( [$tab_context, $type, $status_context], 'strlen' );
            $unique_suffix = implode( '_', $suffix_parts );
            ?>
            <div class="directorist-booking-empty-state no-bookings-information-<?php echo esc_attr( $unique_suffix ); ?>"
                style="display: none">
                <div class="directorist-booking-empty-state__content">
                    <div class="directorist-booking-empty-state__icon">
                        <i class="las la-calendar-times"></i>
                    </div>
                    <p class="directorist-booking-empty-state__message">
                        <?php esc_html_e( 'We haven\'t found any bookings for that criteria', 'directorist-booking' ); ?>
                    </p>
                </div>
            </div>
            <?php if ( isset( $data['bookings'] ) && empty( $data['bookings'] ) ) { ?>
                <div class="directorist-booking-empty-state no-bookings-information-<?php echo esc_attr( $unique_suffix ); ?>">
                    <div class="directorist-booking-empty-state__content">
                        <div class="directorist-booking-empty-state__icon">
                            <i class="las la-calendar-times"></i>
                        </div>
                        <p class="directorist-booking-empty-state__message">
                            <?php esc_html_e( 'You don\'t have any bookings yet', 'directorist-booking' ); ?>
                        </p>
                    </div>
                </div>
            <?php } else { ?>
                <div id="directorist-booking-requests-<?php echo esc_attr( $unique_suffix ); ?>"
                     class="directorist-booking-requests">
                     <div class="directorist-booking-card-container">
                        <?php
                        foreach ( $data['bookings'] as $key => $value ) {
                            $value['listing_title'] = get_the_title( $value['listing_id'] );
                            if ( $type == "user" ) {
                                //include BDB_TEMPLATES_DIR . '/bookings/content-user-booking.php';
                                echo View::get( 
                                    'dashboard/content-user-booking', [
                                        'value' => $value,
                                    ] 
                                );
                            } else {
                                //include BDB_TEMPLATES_DIR . '/bookings/content-booking.php';
                                echo View::get( 
                                    'dashboard/content-booking', [
                                        'value' => $value,
                                    ] 
                                );
                            }

                        } ?>
                    </div>
                </div>
            <?php } ?>

        </div>

        <div class="pagination-container pagination-container-<?php echo esc_attr( $unique_suffix ); ?>">
            <?php 
            echo bdb_ajax_pagination( $data['pages'], 1 ); ?>
        </div>

    </div>
</div>

<?php
/**
 * @since 1.0.0
 */
do_action( 'atbdp_user_dashboard_booking_after_content' ); ?>
