<?php
    use Directorist_Booking\App\Providers\Calender;
    use Directorist_Booking\WpMVC\View\View;
?>
<div class='directorist-booking-calender'>
    <div class="directorist-booking-calender__main-content">
        <!-- Custom Filters (will be injected into calendar header) -->
        <div class="directorist-booking-calender__header">
            <h2 class="directorist-booking-calender__title"><?php _e( 'Booking Calendar', 'directorist-booking' );?></h2>
            <div class="directorist-booking-calender__filters">
                <!-- Search Bar -->
                <div class="directorist-booking-calender__filter-item directorist-booking-calender__search">
                    <svg width="16" height="16" class="directorist-search-icon" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M7.33301 2.66683C4.75568 2.66683 2.66634 4.75617 2.66634 7.3335C2.66634 9.91083 4.75568 12.0002 7.33301 12.0002C8.5903 12.0002 9.73147 11.5029 10.5706 10.6944C10.5881 10.6716 10.6074 10.6497 10.6283 10.6288C10.6492 10.6079 10.6711 10.5886 10.6939 10.5711C11.5025 9.73196 11.9997 8.59079 11.9997 7.3335C11.9997 4.75617 9.91034 2.66683 7.33301 2.66683ZM12.0209 11.0786C12.842 10.0522 13.333 8.75017 13.333 7.3335C13.333 4.01979 10.6467 1.3335 7.33301 1.3335C4.0193 1.3335 1.33301 4.01979 1.33301 7.3335C1.33301 10.6472 4.0193 13.3335 7.33301 13.3335C8.74968 13.3335 10.0517 12.8425 11.0781 12.0214L13.5283 14.4716C13.7886 14.7319 14.2107 14.7319 14.4711 14.4716C14.7314 14.2112 14.7314 13.7891 14.4711 13.5288L12.0209 11.0786Z" fill="#000D4D" fill-opacity="0.45"/>
                    </svg>
                    <input 
                        type="text" 
                        id="booking-event-search" 
                        class="directorist-form-element" 
                        placeholder="<?php _e( 'Search by title, guest name, email, or location...', 'directorist-booking' );?>"
                        autocomplete="off"
                        autocorrect="off"
                        autocapitalize="off"
                        spellcheck="false"
                        data-lpignore="true"
                    />
                </div>
                
                <!-- Booking Type Filter -->
                <div class="directorist-booking-calender__filter-item">
                    <select id="booking-event-category" class="directorist-form-element">
                        <option value=""><?php _e( 'All Booking Types', 'directorist-booking' );?></option>
                        <option value="service"><?php _e( 'Service', 'directorist-booking' );?></option>
                        <option value="rent"><?php _e( 'Rent', 'directorist-booking' );?></option>
                    </select>
                </div>
                
                <!-- Google Calendar Connect/Setup Buttons -->
                <div class="directorist-booking-calender__filter-item directorist-booking-calender__google-connect">
                    <!-- Connect Button (shown when NOT connected) -->
                    <button 
                        type="button" 
                        id="connect-google-calendar" 
                        class="directorist-google-connect-btn"
                    >
                        <div class="directorist-google-connect-btn__icon-wrapper">
                            <img src="<?php echo directorist_booking_url( 'resources/img/svg/google-calendar.svg' ); ?>" alt="Google Calendar" class="directorist-google-calendar-icon">
                        </div>
                        <span class="directorist-google-connect-text"><?php _e( 'Connect Google Calendar', 'directorist-booking' );?></span>
                    </button>
                    
                    <!-- Calendar Setup Button with Dropdown (shown when connected) -->
                    <div class="directorist-google-calendar-dropdown-wrapper" style="display: none;">
                        <button 
                            type="button" 
                            id="calendar-setup-btn" 
                            class="directorist-calendar-setup-btn"
                        >
                            <div class="directorist-google-connect-btn__icon-wrapper">
                                <img src="<?php echo directorist_booking_url( 'resources/img/svg/google-calendar.svg' ); ?>" alt="Google Calendar" class="directorist-google-calendar-icon">
                            </div>
                            <span class="directorist-google-connect-text"><?php _e( 'Google calendar', 'directorist-booking' );?></span>
                            <span class="directorist-connected-badge"><?php _e( 'Connected', 'directorist-booking' );?></span>
                            <svg class="directorist-google-connect-btn__chevron" width="10" height="6" viewBox="0 0 10 6" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M1 1L5 5L9 1" stroke="rgba(0, 8, 51, 0.65)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                        </button>
                        
                        <!-- Dropdown Menu -->
                        <div class="directorist-google-calendar-dropdown">
                            <div class="directorist-google-calendar-dropdown__header">
                                <span class="directorist-google-calendar-dropdown__header-text"><?php _e( 'Settings', 'directorist-booking' );?></span>
                            </div>
                            <div class="directorist-google-calendar-dropdown__body">
                                <button type="button" class="directorist-google-calendar-dropdown__item" id="disconnect-google-calendar-btn">
                                <svg class="directorist-google-calendar-dropdown__icon" width="16" height="16" viewBox="0 0 16 16" fill="none">
                                <g clip-path="url(#clip0_8492_4201)">
                                    <path d="M5.33398 10.6663L10.6663 5.33301" stroke="#000626" stroke-opacity="0.9" stroke-width="1.5" stroke-linejoin="round"/>
                                    <path d="M10.084 7.75016L11.0007 8.66683L14.6673 5.00016L11.0007 1.3335L7.33398 5.00016L8.25065 5.91683" stroke="#000626" stroke-opacity="0.9" stroke-width="1.5" stroke-linejoin="round"/>
                                    <path d="M7.75065 10.0835L8.66732 11.0002L5.00065 14.6668L1.33398 11.0002L5.00065 7.3335L5.91732 8.25016" stroke="#000626" stroke-opacity="0.9" stroke-width="1.5" stroke-linejoin="round"/>
                                    <path d="M14.0013 10.667H12.0013M10.668 14.0003V12.0003" stroke="#000626" stroke-opacity="0.9" stroke-width="1.5" stroke-linejoin="round"/>
                                    <path d="M2 5.33333H4M5.33333 2V4" stroke="#000626" stroke-opacity="0.9" stroke-width="1.5" stroke-linejoin="round"/>
                                </g>
                                <defs>
                                    <clipPath id="clip0_8492_4201">
                                    <rect width="16" height="16" fill="white"/>
                                    </clipPath>
                                </defs>
                                </svg>
                                    <span class="directorist-google-calendar-dropdown__text"><?php _e( 'Disconnect Google calendar', 'directorist-booking' );?></span>
                                </button>
                                <button type="button" class="directorist-google-calendar-dropdown__item" id="calendar-settings-btn">
                                <svg class="directorist-google-calendar-dropdown__icon" width="16" height="16" viewBox="0 0 16 16" fill="none">
                                <g clip-path="url(#clip0_8492_4218)">
                                    <path d="M9.96913 1.3335H6.03224V3.05451L4.77047 3.79594L3.30243 2.93478L1.33398 6.39888L2.80166 7.25983L2.80167 8.74053L1.33405 9.60144L3.3025 13.0655L4.7705 12.2044L6.03224 12.9458V14.6668H9.96913V12.9458L11.2308 12.2044L12.6988 13.0655L14.6673 9.60144L13.1997 8.74057L13.1997 7.25979L14.6673 6.39888L12.6989 2.93478L11.2309 3.79592L9.96913 3.05451V1.3335Z" stroke="#000626" stroke-opacity="0.9" stroke-width="1.5" stroke-linejoin="round"/>
                                    <path d="M10.3346 8.00033C10.3346 9.28899 9.28997 10.3337 8.0013 10.3337C6.71264 10.3337 5.66797 9.28899 5.66797 8.00033C5.66797 6.71166 6.71264 5.66699 8.0013 5.66699C9.28997 5.66699 10.3346 6.71166 10.3346 8.00033Z" stroke="#000626" stroke-opacity="0.9" stroke-width="1.5"/>
                                </g>
                                <defs>
                                    <clipPath id="clip0_8492_4218">
                                    <rect width="16" height="16" fill="white"/>
                                    </clipPath>
                                </defs>
                                </svg>
                                    <span class="directorist-google-calendar-dropdown__text"><?php _e( 'Calendar Settings', 'directorist-booking' );?></span>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Search Results Info -->
            <div class="search-results-info" style="display: none; margin-top: 10px; padding: 8px 12px; background: #f8f9fa; border-radius: 4px; font-size: 14px; color: #666;"></div>
        </div>
      
        <!-- View Dropdown -->
        <div class="directorist-booking-calender__view-dropdown" id="booking-calendar-view-dropdown">
            <div class="directorist-view-dropdown-wrapper">
                <svg width="16" height="16" class="directorist-calendar-icon" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M5.33301 0.666504C5.7012 0.666504 5.99967 0.964981 5.99967 1.33317V1.99984H9.99967V1.33317C9.99967 0.964981 10.2982 0.666504 10.6663 0.666504C11.0345 0.666504 11.333 0.964981 11.333 1.33317V2.00092C11.65 2.0031 11.927 2.00965 12.1676 2.0293C12.5423 2.05992 12.8868 2.12563 13.2103 2.29049C13.7121 2.54615 14.12 2.9541 14.3757 3.45586C14.5406 3.77942 14.6063 4.12389 14.6369 4.49862C14.6664 4.85941 14.6663 5.30231 14.6663 5.83895V11.4941C14.6663 12.0307 14.6664 12.4736 14.6369 12.8344C14.6063 13.2091 14.5406 13.5536 14.3757 13.8771C14.12 14.3789 13.7121 14.7869 13.2103 15.0425C12.8868 15.2074 12.5423 15.2731 12.1676 15.3037C11.8068 15.3332 11.3639 15.3332 10.8272 15.3332H5.17213C4.63549 15.3332 4.19258 15.3332 3.83179 15.3037C3.45706 15.2731 3.11259 15.2074 2.78903 15.0425C2.28727 14.7869 1.87932 14.3789 1.62366 13.8771C1.4588 13.5536 1.39309 13.2091 1.36247 12.8344C1.33299 12.4736 1.333 12.0307 1.33301 11.494V5.83897C1.333 5.30232 1.33299 4.85942 1.36247 4.49862C1.39309 4.12389 1.4588 3.77942 1.62366 3.45586C1.87932 2.9541 2.28727 2.54615 2.78903 2.29049C3.11259 2.12563 3.45706 2.05992 3.83179 2.0293C4.07233 2.00965 4.34936 2.0031 4.66634 2.00092V1.33317C4.66634 0.964981 4.96482 0.666504 5.33301 0.666504ZM4.66634 3.33435C4.36932 3.33643 4.13609 3.34221 3.94037 3.3582C3.64809 3.38208 3.49862 3.42537 3.39435 3.4785C3.14347 3.60633 2.9395 3.8103 2.81167 4.06118C2.75854 4.16545 2.71526 4.31492 2.69138 4.6072C2.66686 4.90725 2.66634 5.29545 2.66634 5.8665V5.99984H13.333V5.8665C13.333 5.29545 13.3325 4.90726 13.308 4.6072C13.2841 4.31492 13.2408 4.16545 13.1877 4.06118C13.0599 3.8103 12.8559 3.60633 12.605 3.4785C12.5007 3.42537 12.3513 3.38208 12.059 3.3582C11.8633 3.34221 11.63 3.33643 11.333 3.33435V3.99984C11.333 4.36803 11.0345 4.6665 10.6663 4.6665C10.2982 4.6665 9.99967 4.36803 9.99967 3.99984V3.33317H5.99967V3.99984C5.99967 4.36803 5.7012 4.6665 5.33301 4.6665C4.96482 4.6665 4.66634 4.36803 4.66634 3.99984V3.33435ZM13.333 7.33317H2.66634V11.4665C2.66634 12.0376 2.66686 12.4258 2.69138 12.7258C2.71526 13.0181 2.75854 13.1676 2.81167 13.2718C2.9395 13.5227 3.14347 13.7267 3.39435 13.8545C3.49862 13.9076 3.64809 13.9509 3.94037 13.9748C4.24043 13.9993 4.62862 13.9998 5.19967 13.9998H10.7997C11.3707 13.9998 11.7589 13.9993 12.059 13.9748C12.3513 13.9509 12.5007 13.9076 12.605 13.8545C12.8559 13.7267 13.0599 13.5227 13.1877 13.2718C13.2408 13.1676 13.2841 13.0181 13.308 12.7258C13.3325 12.4258 13.333 12.0376 13.333 11.4665V7.33317Z" fill="black"/>
                </svg>
                <select id="booking-calendar-view" class="directorist-form-element">
                    <option value="dayGridMonth"><?php _e( 'Month', 'directorist-booking' );?></option>
                    <option value="timeGridWeek"><?php _e( 'Week', 'directorist-booking' );?></option>
                    <option value="timeGridDay"><?php _e( 'Day', 'directorist-booking' );?></option>
                </select>
            </div>
        </div>
        
        <div id="directorist-booking-calender"></div>
    </div>
</div>

<?php
// Include Google Calendar Modal
echo View::get( 'google-calendar-modal' );
?>