<?php
// get user email
$current_user = wp_get_current_user();
$email        = ! empty( $booking_info->email ) ? $booking_info->email : $current_user->user_email;
$first_name   = ! empty( $booking_info->first_name ) ? $booking_info->first_name : $current_user->first_name;
$phone        = ! empty( $booking_info->phone ) ? $booking_info->phone : get_user_meta( $current_user->ID, "atbdp_phone", true );
$message      = ! empty( $booking_info->message ) ? $booking_info->message : "";
$last_name    = $current_user->last_name;
$full_name    = $current_user->display_name;
// get meta of listing
$listing_data         = get_post_meta( $data["listing_id"] );
$gallery              = get_post_meta( $data["listing_id"], "_listing_prv_img", true );
$prv_image_full       = wp_get_attachment_image_src( ! empty( $gallery ) ? $gallery : "", "full" );
$payment_booking      = get_post_meta( $data["listing_id"], "_bdb_payment_booking", true );
$reservation_fee      = get_post_meta( $data["listing_id"], "_bdb_reservation_fee", true );
$slot_status          = get_post_meta( $data["listing_id"], '_bdb_slot_status', true );
$checkout_page        = ! empty( $payment_booking ) ? true : false;
$url                  = ATBDP_Permalink::get_checkout_page_link( $data["listing_id"] );
$guest_booking        = get_directorist_option( "bdb_guest_booking" );
$booking_payment_type = get_directorist_option( "booking_payment_type", "directorist" );
$confirmation_class   = "directorist" == $booking_payment_type ? "directorist-payment" : "bdb-woocommerce-payment";

$show_date = "event" != $data["listing_type"] ? true : false;
$show_date = apply_filters( "directorist_booking_show_date_on_confirmation_page", $show_date );
?>
<div class="directorist-confirm-ticket">
    <div class="directorist-confirm-ticket__header">
        <nav class="directorist-confirm-breadcrumb">
            <ul class="directorist-confirm-breadcrumb-links">
                <li>
                    <a href="<?php echo esc_url( home_url( "/" ) ); ?>" class="directorist-confirm-breadcrumb-box">
                        <span class="directorist-confirm-breadcrumb-text"><?php esc_html_e( "Home", "directorist-booking" ); ?></span>
                    </a>
                </li>
                <li>
                    <div class="directorist-confirm-breadcrumb-box">
                        <?php directorist_icon( "las la-angle-right" ); ?>
                        <a href="<?php echo esc_url( ATBDP_Permalink::get_directorist_listings_page_link() ); ?>" class="directorist-confirm-breadcrumb-text"><?php esc_html_e( "All listing", "directorist-booking" ); ?></a>
                    </div>
                </li>
                <li>
                    <div class="directorist-confirm-breadcrumb-box">
                        <?php directorist_icon( "las la-angle-right" ); ?>
                        <a href="<?php echo esc_url( get_permalink( $data["listing_id"] ) . "#directorist-booking-wrapper" ); ?>" class="directorist-confirm-breadcrumb-text"><?php echo get_the_title( $data["listing_id"] ); ?></a>
                    </div>
                </li>
                <li>
                    <div class="directorist-confirm-breadcrumb-box">
                        <?php directorist_icon( "las la-angle-right" ); ?>
                        <a href="#" class="directorist-confirm-breadcrumb-text"><?php esc_html_e( "Review & Confirm", "directorist-booking" ); ?></a>
                    </div>
                </li>
            </ul>
         </nav>
         <h2 class="directorist-confirm-ticket__title"><?php esc_html_e( "Review & Confirm Booking", "directorist-booking" ); ?></h2>
    </div>
    <div class="directorist-confirm-ticket__contents">
        <div class="directorist-confirm-ticket__body">
            <h3 class="directorist-confirm-ticket__information"><?php echo apply_filters( "booking_confirmation_title", __( "Personal Information", "directorist-booking" ) ); ?>
            </h3>
            <form id="booking-confirmation" action="<?php echo ! empty( $checkout_page ) ? $url : ""; ?>" method="POST"
                role="form">
                <input type="hidden" name="confirmed" value="<?php echo ! empty( $booking_data ) ? "updated" : "done"; ?>" />
                <input type="hidden" name="price" value="<?php echo ! empty( $data["price"] ) ? $data["price"] : ""; ?>" />
                <input type="hidden" name="value" value="<?php echo ! empty( $data["submitteddata"] ) ? $data["submitteddata"] : ""; ?>" />
                <input type="hidden" name="user_id" value="<?php echo $current_user->ID; ?>" />
                <input type="hidden" name="owner_id" value="<?php echo get_post_field( "post_author", $data["listing_id"] ); ?>" />
                <input type="hidden" name="booking_id" value="<?php echo ! empty( $_GET["booking-id"] ) ? esc_attr( $_GET["booking-id"] ) : ""; ?>" />
                <input type="hidden" name="phone" value="<?php echo ! empty( $phone ) ? esc_attr( $phone ) : ""; ?>" />
                <div class="directorist-form-ticket-container">
                    <div class="directorist-form-ticket">
                        <div class="directorist-form-ticket__list">
                            <label for="first_name"><?php esc_html_e( "Full Name", "directorist-booking" ); ?> *</label>
                            <div class="directorist-form-ticket__icon-wrapper">
                                <?php directorist_icon( "las la-user" ); ?>
                                <input class="directorist-form-ticket__input"  type="text" name="firstname" required id="first_name" value="<?php esc_html_e( $full_name, "directorist-booking" ); ?>" <?php echo ! empty( $_GET["booking-id"] ) ? "disabled" : ""; ?> placeholder="<?php esc_html_e(
                                    "Enter your full name",
                                    "directorist-booking"
                                ); ?>">
                            </div>
                        </div>

                        <div class="directorist-form-ticket__list">
                            <div class="input-with-icon medium-icons">
                                <label for="bdb_email">
                                    <?php esc_html_e( "Email address", "directorist-booking" ); ?> *
                                </label>
                                <div class="directorist-form-ticket__icon-wrapper">
                                    <?php directorist_icon( "las la-envelope" ); ?>
                                    <input class="directorist-form-ticket__input" type="email" required name="email" id="bdb_email" placeholder="Email" value="<?php esc_html_e( $email, "directorist-booking" ); ?>" <?php echo ! empty( $_GET["booking-id"] ) ? "disabled" : ""; ?> placeholder="<?php esc_html_e(
                                        "Enter email address",
                                        "directorist-booking"
                                    ); ?>">
                                </div>
                            </div>
                        </div>

                        <div class="directorist-form-ticket__list">
                            <div class="input-with-icon medium-icons">
                                <label for="directorist-form-ticket__phone">
                                    <?php esc_html_e( "Phone number", "directorist-booking" ); ?>
                                </label>
                                <div class="directorist-form-ticket__international">
                                    <input type="tel" id="directorist-form-ticket__phone" name="phone" class="directorist-form-ticket__phone" required>
                                </div>
                            </div>
                        </div>

                        <?php echo bdb_render_refund_policy( $data["listing_id"] ); ?>

                        <div class="directorist-form-ticket__list">
                            <label for="booking_message" class="directorist-form-ticket__notes">
                                <?php esc_html_e( "Add booking notes", "directorist-booking" ); ?>
                                <span><?php esc_html_e( "(Optional)", "directorist-booking" ); ?></span>
                            </label>
                            <textarea maxlength="200" name="message"
                                placeholder="<?php esc_html_e( "Include comments or requests about your service", "directorist-booking" ); ?>"
                                id="booking_message" cols="20" rows="3" <?php echo ! empty( $_GET["booking-id"] ) ? "readonly" : ""; ?>><?php echo ! empty( $message ) ? esc_textarea( $message ) : ""; ?></textarea>
                        </div>

                        <p class='directorist-confirmation-error'></p>
                    </div>
                    <div class="directorist-confirm-ticket__summary">
                        <!-- Booking Summary -->
                        <div class="directorist-confirm-top">
                            <div class="directorist-confirm__header-listing">
                                <?php if ( $prv_image_full ) { ?>
                                    <div class="directorist-confirm__img">
                                        <img src="<?php echo ! empty( $prv_image_full ) ? $prv_image_full[0] : ""; ?>" alt="" >
                                    </div>
                                <?php } ?>
                                <div class="directorist-confirm__header-listing-details">
                                    <div class="directorist-confirm__header-listing-title">
                                        <?php echo get_the_title( $data["listing_id"] ); ?>
                                    </div>
                                    <div class="directorist-confirm__header-listing-rating">
                                        <?php echo bdb_render_listing_rating( $data["listing_id"] ); ?>
                                    </div>
                                    <?php
                                    $address = get_post_meta( $data['listing_id'], '_address', true );
                                    if ( ! empty( $address ) ) :
                                        ?>
                                        <div class="directorist-confirm__header-listing-location">
                                            <?php echo esc_html( $address ); ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="directorist-confirm__details">
                                <?php
                                $currency          = get_directorist_option( "g_currency", "USD" );
                                $currency_position = get_directorist_option( "g_currency_position", "before" );
                                $currency_symbol   = atbdp_currency_symbol( $currency );
                                ?>
                                <div class="directorist-booking-summary-box">
                                    <h3 class="directorist-booking-summary-title"><?php esc_html_e( "Booking Summary", "directorist-booking" ); ?></h3>
                                    <?php
                                    $total_guests = 0;

                                    if ( isset( $data["adults"] ) ) {
                                        $adults        = (int) filter_var( $data["adults"], FILTER_SANITIZE_NUMBER_INT );
                                        $total_guests += $adults;
                                    }

                                    if ( isset( $data["childrens"] ) ) {
                                        $childrens     = (int) filter_var( $data["childrens"], FILTER_SANITIZE_NUMBER_INT );
                                        $total_guests += $childrens;
                                    }

                                    // Show markup only if guest count is more than 0
                                    if ( $total_guests > 0 ) : ?>
                                        <div class="directorist-booking-summary-row">
                                            <div class="directorist-booking-summary-label"><?php esc_html_e( "Number of guests", "directorist-booking" ); ?></div>
                                            <span class="directorist-booking-summary-value">
                                                <strong><?php echo $total_guests; ?> <?php esc_html_e( "persons", "directorist-booking" ); ?></strong>
                                            </span>
                                        </div>
                                    <?php endif; ?>
                                    <?php if ( $show_date && ( ! empty( $booking_data ) || ( isset( $data["date_start"] ) && ! empty( $data["date_start"] ) ) ) ) : ?>
                                    <div class="directorist-booking-summary-row">
                                        <div class="directorist-booking-summary-label">Booking date & time</div>
                                        <span class="directorist-booking-summary-value">
                                            <?php
                                            if ( $show_date ) {
                                                if ( ! empty( $booking_data ) ) {
                                                    // Show booking data if available
                                                    $booking_date_start = ! empty( $booking_data->date_start ) ? $booking_data->date_start : '';
                                                    $booking_date_end   = ! empty( $booking_data->date_end ) ? $booking_data->date_end : '';
                                                    
                                                    if ( $booking_date_start ) {
                                                        $start_date_obj = new DateTime( $booking_date_start );
                                                        $date_str       = $start_date_obj->format( 'l, M j, Y' );
                                                        
                                                        if ( $booking_date_end && $booking_date_start != $booking_date_end ) {
                                                            $end_date_obj = new DateTime( $booking_date_end );
                                                            $date_range   = $date_str . " – " . $end_date_obj->format( 'M j, Y' );
                                                            
                                                            // Calculate total days
                                                            $total_days = $start_date_obj->diff( $end_date_obj )->days + 1;
                                                            $date_str   = "<strong>" . $date_range . "</strong> (" . $total_days . " " . ( $total_days == 1 ? 'day' : 'days' ) . ")";
                                                        } else {
                                                            $date_str = "<strong>" . $date_str . "</strong>";
                                                        }
                                                        echo $date_str;
                                                    } else {
                                                        echo '-';
                                                    }
                                                } else {
                                                    // Show new booking data with enhanced formatting
                                                    $start_date_obj = new DateTime( $data["date_start"] );
                                                    $date_str       = $start_date_obj->format( 'l, M j, Y' );
                                                    $total_days     = 1;
                                                    
                                                    if ( isset( $data["date_end"] ) && $data["date_start"] != $data["date_end"] ) {
                                                        $end_date_obj = new DateTime( $data["date_end"] );
                                                        $date_range   = $date_str . " – " . $end_date_obj->format( 'M j, Y' );
                                                        // Calculate total days
                                                        $total_days = $start_date_obj->diff( $end_date_obj )->days + 1;
                                                        $date_str   = "<strong>" . $date_range . "</strong> (" . $total_days . " " . ( $total_days == 1 ? 'day' : 'days' ) . ")";
                                                    } else {
                                                        $date_str = "<strong>" . $date_str . "</strong>";
                                                    }
                                                    
                                                    // Enhanced time display
                                                    if ( isset( $data['_hour'] ) && ! empty( $data['_hour'] ) ) {
                                                        $original_hour = $data['_hour'];
                                                        
                                                        // Extract slot number if it exists (but be more careful)
                                                        $slot_number = '';
                                                        // Only remove trailing numbers if they're clearly slot numbers (not part of time)
                                                        if ( preg_match( '/\s+(\d+)\s*$/', $original_hour, $matches ) ) {
                                                            $slot_number   = $matches[1];
                                                            $original_hour = preg_replace( '/\s+\d+\s*$/', '', $original_hour );
                                                        }
                                                        
                                                        // Clean and format the hour value - preserve complete time
                                                        $hour_value = trim( $original_hour );
                                                        
                                                        
                                                        // Check if we have a valid time format before cleaning
                                                        $is_valid_time = preg_match( '/^\d{1,2}:\d{2}/', $hour_value );
                                                        
                                                        // More careful cleaning - preserve time format but be less aggressive
                                                        // Only remove non-time characters, preserve colons and numbers
                                                        $hour_value = preg_replace( '/[^0-9:apm\s\-]/i', '', $hour_value );
                                                        $hour_value = preg_replace( '/\s*-\s*/', ' - ', $hour_value );
                                                        $hour_value = trim( $hour_value );
                                                        
                                                        // If the time looks incomplete (like "01:"), try to get the full time from the original
                                                        if ( preg_match( '/^\d{1,2}:$/', $hour_value ) ) {
                                                            // Try to find the complete time in the original string
                                                            if ( preg_match( '/\d{1,2}:\d{2}/', $original_hour, $complete_time ) ) {
                                                                $hour_value = $complete_time[0];
                                                            } else {
                                                                // For now, just use the original value as-is
                                                                $hour_value = $original_hour;
                                                            }
                                                        }
                                                        
                                                        // Additional check: if the time is still incomplete, try a different approach
                                                        if ( preg_match( '/^\d{1,2}:$/', $hour_value ) ) {
                                                            // Try to extract just the time part without any cleaning
                                                            if ( preg_match( '/(\d{1,2}:\d{2})/', $original_hour, $time_match ) ) {
                                                                $hour_value = $time_match[1];
                                                            }
                                                        }
                                                        
                                                        // Ensure we have a complete time format
                                                        if ( ! empty( $hour_value ) ) {
                                                            // If it's just a single time (not a range), format it properly
                                                            if ( strpos( $hour_value, ' - ' ) === false ) {
                                                                // Handle various time formats
                                                                if ( preg_match( '/^(\d{1,2}):(\d{2})$/', $hour_value, $time_matches ) ) {
                                                                    // 24-hour format (e.g., "15:45")
                                                                    $hour         = intval( $time_matches[1] );
                                                                    $minute       = $time_matches[2];
                                                                    $ampm         = $hour >= 12 ? 'PM' : 'AM';
                                                                    $display_hour = $hour > 12 ? $hour - 12 : ( $hour == 0 ? 12 : $hour );
                                                                    $hour_value   = $display_hour . ':' . $minute . ' ' . $ampm;
                                                                } elseif ( preg_match( '/^(\d{1,2}):(\d{2})\s*(AM|PM)/i', $hour_value, $time_matches ) ) {
                                                                    // 12-hour format (e.g., "3:45 PM")
                                                                    $hour       = intval( $time_matches[1] );
                                                                    $minute     = $time_matches[2];
                                                                    $ampm       = strtoupper( $time_matches[3] );
                                                                    $hour_value = $hour . ':' . $minute . ' ' . $ampm;
                                                                } elseif ( preg_match( '/^(\d{1,2}):(\d{2}):(\d{2})$/', $hour_value, $time_matches ) ) {
                                                                    // 24-hour format with seconds (e.g., "15:45:30")
                                                                    $hour         = intval( $time_matches[1] );
                                                                    $minute       = $time_matches[2];
                                                                    $ampm         = $hour >= 12 ? 'PM' : 'AM';
                                                                    $display_hour = $hour > 12 ? $hour - 12 : ( $hour == 0 ? 12 : $hour );
                                                                    $hour_value   = $display_hour . ':' . $minute . ' ' . $ampm;
                                                                } else {
                                                                    // If no pattern matches, try to preserve the original value
                                                                    error_log( 'No time pattern matched for: ' . $hour_value );
                                                                    // Don't modify the hour_value if no pattern matches
                                                                }
                                                            }
                                                            
                                                            $date_str .= '<br><span class="booking-time-display">' . esc_html( $hour_value ) . '</span>';
                                                        }
                                                    }
                                                    echo $date_str;
                                                }
                                            } else {
                                                echo '-';
                                            }
                                            ?>
                                        </span>
                                    </div>
                                    <?php endif; ?>
                                    
                                    <?php if ( isset( $data['_hour'] ) && ! empty( $data['_hour'] ) && ! empty( $hour_value ) && $slot_status != 'time_picker' ) : ?>
                                    <div class="directorist-booking-summary-row">
                                        <div class="directorist-booking-summary-label"><?php esc_html_e( "Total Duration", "directorist-booking" ); ?></div>
                                        <span class="directorist-booking-summary-value">
                                            <?php
                                            // Calculate time duration
                                            $time_parts = explode( ' - ', $hour_value );
                                            if ( count( $time_parts ) == 2 ) {
                                                $start_time = trim( $time_parts[0] );
                                                $end_time   = trim( $time_parts[1] );
                                                
                                                // Convert to 24-hour format for calculation
                                                $start_24 = date( 'H:i', strtotime( $start_time ) );
                                                $end_24   = date( 'H:i', strtotime( $end_time ) );
                                                
                                                // Calculate duration
                                                $start_timestamp = strtotime( $start_24 );
                                                $end_timestamp   = strtotime( $end_24 );
                                                
                                                // Handle overnight bookings
                                                if ( $end_timestamp <= $start_timestamp ) {
                                                    $end_timestamp += 86400; // Add 24 hours
                                                }
                                                
                                                $duration_minutes = ( $end_timestamp - $start_timestamp ) / 60;
                                                $hours            = floor( $duration_minutes / 60 );
                                                $minutes          = $duration_minutes % 60;
                                                
                                                if ( $hours > 0 && $minutes > 0 ) {
                                                    echo esc_html( $hours . 'h ' . $minutes . 'm' );
                                                } elseif ( $hours > 0 ) {
                                                    echo esc_html( $hours . 'h' );
                                                } else {
                                                    echo esc_html( $minutes . 'm' );
                                                }
                                            } else {
                                                // For single time slots, try to calculate duration from slot data
                                                if ( isset( $data['slot'] ) && ! empty( $data['slot'] ) ) {
                                                    $slot_data = json_decode( $data['slot'], true );
                                                    if ( is_array( $slot_data ) && count( $slot_data ) >= 2 ) {
                                                        $slot_time  = $slot_data[0]; // Time range like "9:00 AM - 10:00 AM"
                                                        $time_parts = explode( ' - ', $slot_time );
                                                        if ( count( $time_parts ) == 2 ) {
                                                            $start_time = trim( $time_parts[0] );
                                                            $end_time   = trim( $time_parts[1] );
                                                            
                                                            $start_24 = date( 'H:i', strtotime( $start_time ) );
                                                            $end_24   = date( 'H:i', strtotime( $end_time ) );
                                                            
                                                            $start_timestamp = strtotime( $start_24 );
                                                            $end_timestamp   = strtotime( $end_24 );
                                                            
                                                            if ( $end_timestamp <= $start_timestamp ) {
                                                                $end_timestamp += 86400;
                                                            }
                                                            
                                                            $duration_minutes = ( $end_timestamp - $start_timestamp ) / 60;
                                                            $hours            = floor( $duration_minutes / 60 );
                                                            $minutes          = $duration_minutes % 60;
                                                            
                                                            if ( $hours > 0 && $minutes > 0 ) {
                                                                echo esc_html( $hours . 'h ' . $minutes . 'm' );
                                                            } elseif ( $hours > 0 ) {
                                                                echo esc_html( $hours . 'h' );
                                                            } else {
                                                                echo esc_html( $minutes . 'm' );
                                                            }
                                                        } else {
                                                            echo '1h'; // Default duration for single time slots
                                                        }
                                                    } else {
                                                        echo '1h'; // Default duration
                                                    }
                                                } else {
                                                    echo '1h'; // Default duration for single time slots
                                                }
                                            }
                                            ?>
                                        </span>
                                    </div>
                                    <?php endif; ?>
                                    
                                    
                                    <?php if ( isset( $data['tickets'] ) && ! empty( $data['tickets'] ) ) : ?>
                                    <div class="directorist-booking-summary-row">
                                        <div class="directorist-booking-summary-label"><?php esc_html_e( "Ticket Quantity", "directorist-booking" ); ?></div>
                                        <span class="directorist-booking-summary-value">
                                            <?php echo esc_html( $data['tickets'] ); ?> <?php echo $data['tickets'] == 1 ? 'ticket' : 'tickets'; ?>
                                        </span>
                                    </div>
                                    <?php endif; ?>
                                    <div class="directorist-booking-summary-divider"></div>
                                    <div class="directorist-booking-summary-row">
                                        <span class="directorist-booking-summary-label"><?php esc_html_e( "Subtotal", "directorist-booking" ); ?></span>
                                        <span class="directorist-booking-summary-value">
                                            <strong>
                                                <?php
                                                if ( $currency_position == "before" ) {
                                                    echo $currency_symbol . " ";
                                                }
                                                echo isset( $data["subtotal"] ) ? atbdp_format_payment_amount( $data["subtotal"] ) : atbdp_format_payment_amount( $data["price"] );
                                                if ( $currency_position == "after" ) {
                                                    echo " " . $currency_symbol;
                                                }
                                                ?>
                                            </strong>
                                        </span>
                                    </div>
                                    <div class="directorist-booking-summary-divider"></div>
                                    <div class="directorist-booking-summary-row directorist-booking-summary-total">
                                        <span class="directorist-booking-summary-total"><?php esc_html_e( "Total", "directorist-booking" ); ?></span>
                                        <span class="directorist-booking-summary-total-value">
                                            <?php
                                            if ( $currency_position == "before" ) {
                                                echo $currency_symbol . " ";
                                            }
                                            echo atbdp_format_payment_amount( $data["price"] );
                                            if ( $currency_position == "after" ) {
                                                echo " " . $currency_symbol;
                                            }
                                            ?>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <input type="hidden" name='guest_booking' id='guest_booking'
                        value='<?php echo ! empty( $guest_booking ) && ! is_user_logged_in() ? "yes" : ""; ?>'>
                        <button type="submit" class="booking-confirmation-btn <?php echo $confirmation_class; ?>" id="booking-confirmation-btn">
                            <div class="loadingspinner"></div>
                            <span class="book-now-text"><?php ! empty( $payment_booking == "on" ) ? esc_html_e( "Confirm Booking", "directorist-booking" ) : esc_html_e( "Confirm Booking", "directorist-booking" ); ?></span>
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>