<?php
use Directorist_Booking\App\Providers\Calender;
use Directorist_Booking\WpMVC\View\View;

$bdb_value      = get_post_meta( $listing_id, '_bdb', true );
$enable_booking = get_post_meta( $listing_id, '_bdb_enable_booking', true );

$instant_booking             = get_post_meta( $listing_id, '_bdb_instant_booking', true );
$calender_unavailable        = get_post_meta( $listing_id, '_bdb_calender_unavailable', true );
$calender_price              = get_post_meta( $listing_id, '_bdb_calender_price', true );
$payment_booking             = get_post_meta( $listing_id, '_bdb_payment_booking', true );
$Reservation_fee             = get_post_meta( $listing_id, '_bdb_reservation_fee', true );
$weekend_price               = get_post_meta( $listing_id, '_bdb_weekend_price', true );
$reservation_guest           = get_post_meta( $listing_id, '_bdb_reservation_guest', true );
$slot_status                 = get_post_meta( $listing_id, '_bdb_slot_status', true );
$display_available_ticket    = get_post_meta( $listing_id, '_bdb_display_available_ticket', true );
$available_ticket_text       = get_post_meta( $listing_id, '_bdb_available_ticket_text', true );
$display_slot_available_text = get_post_meta( $listing_id, '_bdb_display_slot_available_text', true );
$display_available_time      = get_post_meta( $listing_id, '_bdb_display_available_time', true );
$slot_available_text         = get_post_meta( $listing_id, '_bdb_slot_available_text', true );
$available_time_text         = get_post_meta( $listing_id, '_bdb_available_time_text', true );
$slot_status_checked         = ! empty( $slot_status ) ? $slot_status : 'time_slot';
$booking_type                = get_post_meta( $listing_id, '_bdb_booking_type', true );
$event_ticket                = get_post_meta( $listing_id, '_bdb_event_ticket', true );
$maximum_ticket_allowed      = get_post_meta( $listing_id, '_bdb_maximum_ticket_allowed', true );
$bdb_booking_hide            = get_directorist_option( 'bdb_booking_hide', 1 );
$bdb_timing_type             = get_directorist_option( 'bdb_timing_type', 1 );
$set_booking_type            = get_directorist_option( 'booking_type', [ 'service', 'rent', 'event' ] );
$set_booking_type            = ! empty( $set_booking_type ) && 'all' != $set_booking_type ? $set_booking_type : [ 'service', 'rent', 'event' ];
$booking_type_label          = get_directorist_option( 'bdb_booking_type_label', 'Booking Type' );
$booking_type                = ! empty( $booking_type ) ? $booking_type : 'service';
$bdb_slot_label              = get_directorist_option( 'bdb_slot_label', __( 'Choose Timing Type', 'directorist-booking' ) );
$bdb_booking_hiding_label    = get_directorist_option( 'bdb_booking_hiding_label', __( 'Check it to hide booking', 'directorist-booking' ) );
$bdb_payment_booking_label   = get_directorist_option( 'bdb_payment_booking_label', __( 'Enable Payment', 'directorist-booking' ) );
$bdb_instant_booking_label   = get_directorist_option( 'bdb_instant_booking_label', __( 'Enable Instant Booking', 'directorist-booking' ) );
$bdb_reservation_fee_label   = get_directorist_option( 'bdb_reservation_fee_label', __( 'Reservation Fee', 'directorist-booking' ) );
$bdb_maximum_guests_label    = get_directorist_option( 'bdb_maximum_guests_label', __( 'Maximum Number of Guests', 'directorist-booking' ) );
$bdb_available_ticket_label  = get_directorist_option( 'bdb_available_ticket_label', __( 'Available Tickets', 'directorist-booking' ) );
$bdb_perbooking_ticket_label = get_directorist_option( 'bdb_perbooking_ticket_label', __( 'Tickets Allowed Per Booking', 'directorist-booking' ) );

$bdb_weekend_price_label               = get_directorist_option( 'bdb_weekend_price_label', __( 'Weekend Price', 'directorist-booking' ) );
$bdb_availability_calendar_title_label = get_directorist_option( 'bdb_availability_calendar_title_label', __( 'Availability Calendar', 'directorist-booking' ) );
$bdb_availability_calendar_desc_label  = get_directorist_option(
    'bdb_availability_calendar_desc_label',
    __( '<strong>Click date</strong> in the calendar to mark the day as unavailable and <strong>Click price</strong> to change the individual price.', 'directorist-booking' )
);

if ( ! empty( $bdb_value ) ) {
    $bdb_value = $bdb_value;
} else {
    $bdb_value = '';
}

//todo will be deleted later
$directorist_booking_version = get_post_meta( $listing_id, '_directorist_booking_version', true );
$bdb_version                 = ! empty( BDB_VERSION ) ? BDB_VERSION : '2.5';
$directorist_booking_version = ! empty( $directorist_booking_version ) ? $directorist_booking_version : $bdb_version;

$enable_booking_check = directorist_enable_booking( $listing_id );
?>
<input type="hidden" name="directorist_booking_version" value="<?php echo esc_attr( ! empty( $directorist_booking_version ) ? $directorist_booking_version : '2.5' ); ?>">
<div class="directorist-booking-wrap">

    <?php if ( ! empty( $bdb_booking_hide ) ) { ?>
        <div class="directorist-switch directorist-hide-booking directorist-booking-mb-24">
            <div class="directorist-hide-booking-wrapper directorist-booking-box">
                <div class="directorist-hide-booking-title directorist-booking-element">
                    <h3 class="directorist-booking-label"><?php _e( 'Enable Booking', 'directorist-booking' ); ?></h3>
                    <p class="directorist-booking-subheading"><?php _e( 'Enable or disable booking', 'directorist-booking' ); ?></p>
                </div>
                <div class="directorist-hide-booking-switch">
                    <input type="checkbox" name="bdb_enable_booking" id="bdb_enable_booking" class="directorist-switch-input" <?php echo esc_attr( ! empty( $enable_booking_check ) ? 'checked' : '' ); ?> >
                    <label for="bdb_enable_booking" class="directorist-switch-label"></label>
                </div>
            </div>
        </div>
    <?php } ?>

    <div class="directorist-booking-extras">
        <?php if ( is_array( $set_booking_type ) && 2 <= count( $set_booking_type ) ) { ?>
        <div class="directorist-booking-type-selection directorist-booking-mb-24">
            <p class="directorist-booking-label directorist-booking-mb-12"><?php echo ! empty( $booking_type_label ) ? $booking_type_label : 'Choose Booking Type'; ?></p>
            <div class="directorist-form-group">
                <div class="directorist-booking-flex-wrap directorist-booking-radio-group">
                    <?php if ( in_array( 'service', $set_booking_type ) ) { ?>
                        <label class="directorist-booking-radio-button directorist-booking-mb-0">
                            <input class="directorist-booking-radio-input" type="radio" id="bdb-booking-type-service" name="bdb_booking_type" data-booking-type="service" value="service" <?php checked( 'service', $booking_type ); ?>>
                            <span class="directorist-booking-radio-card">
                            <span class="directorist-booking-radio-icon">
                                <i class="las la-briefcase"></i>
                            </span>
                            <span class="directorist-booking-radio-label"><?php _e( 'Service', 'directorist-booking' );?></span>
                            </span>
                        </label>
                    <?php } ?>    
                    <?php if ( in_array( 'event', $set_booking_type ) ) { ?>
                        <label class="directorist-booking-radio-button directorist-booking-mb-0">
                            <input class="directorist-booking-radio-input" id="bdb-booking-type-event" type="radio" name="bdb_booking_type"  data-booking-type="event" value="event" <?php checked( 'event', $booking_type ); ?>>
                            <span class="directorist-booking-radio-card">
                            <span class="directorist-booking-radio-icon">
                                <i class="las la-calendar"></i>
                            </span>
                            <span class="directorist-booking-radio-label"><?php _e( 'Event', 'directorist-booking' );?></span>
                            </span>
                        </label>
                    <?php } ?>   
                    <?php if ( in_array( 'rent', $set_booking_type ) ) { ?>
                        <label class="directorist-booking-radio-button directorist-booking-mb-0">
                            <input class="directorist-booking-radio-input" type="radio" id="bdb-booking-type-rent" name="bdb_booking_type"  data-booking-type="rent" value="rent" <?php checked( 'rent', $booking_type ); ?>>
                            <span class="directorist-booking-radio-card">
                            <span class="directorist-booking-radio-icon">
                                <i class="las la-file-invoice"></i>
                            </span>
                            <span class="directorist-booking-radio-label"><?php _e( 'Rent', 'directorist-booking' );?></span>
                            </span>
                        </label>
                    <?php } ?>   
                </div>
            </div>
        </div>
        <?php } else { ?>
            <input type="hidden" name="bdb_booking_type" data-booking-type="<?php echo $set_booking_type[0]; ?>" value="<?php echo $set_booking_type[0]; ?>">
        <?php } ?>

        <div class="directorist-booking-event directorist-booking-mb-32">
            <div class="directorist-booking-event-ticket directorist-booking-box directorist-booking-mb-12">
                <div class="directorist-booking-element">
                    <h2 class="directorist-booking-big-label"><?php echo ! empty( $bdb_available_ticket_label ) ? esc_html( $bdb_available_ticket_label ) : __( 'Available Tickets', 'directorist-booking' ); ?></h2>
                    <p class="directorist-booking-subheading"><?php esc_html_e( 'Tickets allowed per booking for event', 'directorist-booking' ); ?></p>
                </div>
                <div class="directorist-booking-input-more">
                    <input type="number" class="directorist-form-element" name="bdb_event_ticket" value="<?php echo ! empty( $event_ticket ) ? $event_ticket : ''; ?>"
                    id="event_ticket" min="0">
                </div>
            </div>
            <div class="directorist-booking-available-ticket-wrapper directorist-booking-mb-12">
                <div class="directorist-booking-available-ticket-check">
                    <div class="directorist-switch directorist-checkbox-primary">
                        <input type="checkbox" class="directorist-switch-input" name="bdb_display_available_ticket"
                            id="display_available_ticket" <?=( ( 'on' === $display_available_ticket ) || ( '1' === $display_available_ticket ) ) ? 'checked' : $available_ticket_checked;?> >
                        <label for="display_available_ticket" class="directorist-switch-label"> <?php esc_html_e( 'Display Available Tickets', 'directorist-booking' );?> </label>
                    </div>
                </div>
                <div class="directorist-booking-available-ticket-text">
                    <input type="text" class="directorist-form-element" name="bdb_available_ticket_text" placeholder="Type available ticket text here..." value="<?php echo ! empty( $available_ticket_text ) ? $available_ticket_text : __( 'Available Tickets :', 'directorist-booking' ); ?>"
                    id="bdb_available_ticket_text">
                </div>
            </div>
            <div class="directorist-max-allowed-tickets directorist-booking-box directorist-booking-mb-12">
                <div class="directorist-booking-element">
                    <h2 class="directorist-booking-big-label"><?php echo ! empty( $bdb_perbooking_ticket_label ) ? esc_html( $bdb_perbooking_ticket_label ) : __( 'Ticket allowed per booking', 'directorist-booking' ); ?></h2>
                    <p class="directorist-booking-subheading"><?php esc_html_e( 'Tickets allowed per booking for event', 'directorist-booking' ); ?></p>
                </div>
                <div class="directorist-booking-input-more">
                    <input type="number" class="directorist-form-element" name="bdb_maximum_ticket_allowed" value="<?php echo ! empty( $maximum_ticket_allowed ) ? $maximum_ticket_allowed : 5; ?>"
                    id="maximum_ticket_allowed">
                </div>
            </div>
        </div>
        <div class="directorist-booking-service">
            <div class="directorist-booking-service-wrapper directorist-booking-box directorist-booking-mb-32">
                <?php if ( ! empty( $bdb_timing_type ) ) {?>
                <div class="directorist-booking-timing-type directorist-booking-mb-20">
                    <p class="directorist-booking-label directorist-booking-mb-12"><?php echo ! empty( $bdb_slot_label ) ? esc_html( $bdb_slot_label ) : __( 'Choose Timing Type', 'directorist-booking' ); ?></p>
                    <div class="directorist-booking-timing-type-select">
                        <label for="slot_status" class="directorist-booking-radio-tab">
                            <input type="radio" name="bdb_slot_status"
                                id="slot_status" value="time_slot" <?php checked( $slot_status_checked, 'time_slot' );?> style="display: none;">
                            <div class="directorist-booking-radio-tab-label"><?php _e( 'Time Slot', 'directorist-booking' );?></div>
                        </label>
                        <label for="time_picker" class="directorist-booking-radio-tab">
                            <input type="radio" name="bdb_slot_status"
                                id="time_picker" value="time_picker" <?php checked( $slot_status_checked, 'time_picker' );?> style="display: none;">
                            <div class="directorist-booking-radio-tab-label"><?php _e( 'Time Picker', 'directorist-booking' );?></div>
                        </label>
                    </div>
                </div>
                <?php }?>
                <div class="directorist-booking-slot-available-wrapper">
                    <div class="directorist-booking-slot-available-check">
                        <div class="directorist-switch directorist-checkbox-primary">
                            <input class="directorist-switch-input" type="checkbox" name="bdb_display_slot_available_text" id="display_slot_available_text" <?=( ( 'on' === $display_slot_available_text ) || ( '1' === $display_slot_available_text ) ) ? 'checked' : $slot_available_checked;?> >
                            <label for="display_slot_available_text" class="directorist-switch-label"><?php   esc_html_e( 'Show availability text', 'directorist-booking' );?> </label>
                        </div>
                    </div>
                    <div class="directorist-booking-slot-available-text">
                    <input type="text" class="directorist-form-element" name="bdb_slot_available_text" placeholder="Available Time" value="<?php echo ! empty( $slot_available_text ) ? $slot_available_text : __( '"Available Time "', 'directorist-booking' ); ?>"
                    id="bdb_slot_available_text">
                    </div>
                </div>

                <div class="directorist-booking-available-time-wrapper" style="display: none;">
                    <div class="directorist-booking-available-time-check">
                        <div class="directorist-switch directorist-checkbox-primary">
                            <input class="directorist-switch-input" type="checkbox" name="bdb_display_available_time"
                                id="display_available_time" placeholder="" <?=( ( 'on' === $display_available_time ) || ( '1' === $display_available_time ) ) ? 'checked' : $available_time_checked;?> >
                            <label for="display_available_time" class="directorist-switch-label"><?php esc_html_e( 'Display "Available Time" Text', 'directorist-booking' );?> </label>
                        </div>
                    </div>
                    <div class="directorist-booking-available-time-text">
                        <input type="text" class="directorist-form-element" name="bdb_available_time_text" placeholder="Available Time" value="<?php echo ! empty( $available_time_text ) ? $available_time_text : __( 'Available Time', 'directorist-booking' ); ?>"
                    id="bdb_available_time_text">
                    </div>
                </div>
            </div>
            <?php
            $hours = [
                0 => ! empty( $bdb_value[0] ) ? $bdb_value[0] : [],
                1 => ! empty( $bdb_value[1] ) ? $bdb_value[1] : [],
                2 => ! empty( $bdb_value[2] ) ? $bdb_value[2] : [],
                3 => ! empty( $bdb_value[3] ) ? $bdb_value[3] : [],
                4 => ! empty( $bdb_value[4] ) ? $bdb_value[4] : [],
                5 => ! empty( $bdb_value[5] ) ? $bdb_value[5] : [],
                6 => ! empty( $bdb_value[6] ) ? $bdb_value[6] : [],
            ];
            
            // support old data
            if ( ! empty( $directorist_booking_version ) && $directorist_booking_version < 2.5 ) {
                foreach ( $hours as $day => $value ) {
                    if ( ! empty( $value ) ) {
                        $hours[$day] = array_merge( ['enable' => 'yes'], $value );
                    } else {
                        $hours[$day] = ['enable' => 'yes'];
                    }
                }
            }
            
            wp_localize_script(
                'bdb-adminmain', 'booking_hours', [
                    'monday'      => __( 'Monday', 'directorist-booking' ),
                    'tuesday'     => __( 'Tuesday', 'directorist-booking' ),
                    'wednesday'   => __( 'Wednesday', 'directorist-booking' ),
                    'thursday'    => __( 'Thursday', 'directorist-booking' ),
                    'friday'      => __( 'Friday', 'directorist-booking' ),
                    'saturday'    => __( 'Saturday', 'directorist-booking' ),
                    'sunday'      => __( 'Sunday', 'directorist-booking' ),
                    'time_copied' => __( "Time copied to selected days!", 'directorist-booking' ),
                ] 
            );
            //  wp_localize_script( 'bdb-front-main', 'booking_hours', $hours );

            ?>
            <div class="directorist-booking-time-slots-configure">
                <div class="directorist-booking-element">
                    <h2 class="directorist-booking-big-label"><?php esc_html_e( 'Configure time slots', 'directorist-booking' ); ?></h2>
                    <p class="directorist-booking-subheading"><?php esc_html_e( 'Set when you are typically available for service', 'directorist-booking' ); ?></p>
                </div>
                
                <input id="bdb_hours" type="hidden" value='<?php echo json_encode( $hours ); ?>'>
                <div class="directorist-booking-hour-selection-wrapper directorist-booking-mb-32">
                    <?php
                    //e_var_dump( $bdb_value );
                    $days = [
                        'monday'    => 0,
                        'tuesday'   => 1,
                        'wednesday' => 2,
                        'thursday'  => 3,
                        'friday'    => 4,
                        'saturday'  => 5,
                        'sunday'    => 6
                    ];
                    foreach ( $days as $day => $key ) {
                         $enable_day = isset( $bdb_value[$key]['enable'] ) ? $bdb_value[$key]['enable'] : '';
                        $extra_class = ( $enable_day !== 'yes' ) ? 'is-false' : 'is-true'; 
                        //e_var_dump( $bdb_value);
                        ?>
                        <div class="directorist-booking-hour-selection-item" data-day="<?php echo $day; ?>">
                            <div class="directorist-booking-day-header">
                                <div class="directorist-switch directorist-checkbox-primary">
                                    <input class="directorist-switch-input <?php echo $extra_class; ?>" type="checkbox" name="bdb[<?php echo $key; ?>][enable]" value="yes" id="<?php echo $day; ?>-switch" <?php checked( $enable_day, 'yes' ); ?>>
                                    <label for="<?php echo $day; ?>-switch" class="directorist-switch-label directorist-booking-day-header-title"  data-id="<?php echo $day; ?>" data-key="<?php echo $key; ?>">
                                        <?php echo ucfirst( substr( $day, 0, 3 ) ); ?>
                                    </label>
                                </div>
                            </div>
                            <div class="directorist-week-day-content">
                                <div class="directorist-booking-hour-selection-time directorist-hour-selection-<?php echo $day; ?>" id="<?php echo $day; ?>ID-0">
                                    <!-- Initial time slot group -->
                                </div>
                                <div class="directorist-booking-add-day">
                                    <button class="directorist-btn-add-hours" data-day="<?php echo $day; ?>" type="button">
                                        <?php directorist_icon( 'las la-plus' ); ?>
                                    </button>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                </div>

                <!-- Duplicate time dropdown -->
                <div class="directorist-booking-time-duplicate-dropdown">
                    <div class="directorist-booking-time-duplicate-dropdown__wrapper" style="display: none;">
                        <div class="directorist-booking-time-duplicate-dropdown__content">
                            <div class="directorist-booking-time-duplicate-dropdown__content__header">
                                <h3 class="directorist-booking-time-duplicate-dropdown__content__header-title"><?php _e( 'Copy times to...', 'directorist-booking' ); ?></h3>
                            </div>
                            <div class="directorist-booking-time-duplicate-dropdown__content__inner">
                                <div class="directorist-checkbox directorist-checkbox-primary directorist-checkbox--select-all">
                                    <input type="checkbox" name="" id="directorist-checkbox-select-all">
                                    <label for="directorist-checkbox-select-all" class="directorist-checkbox__label"><?php _e( 'Select All', 'directorist-booking' ); ?></label>
                                </div>
                                <div class="directorist-checkbox directorist-checkbox-primary">
                                    <input type="checkbox" name="directorist-booking-duplicate-days" id="directorist-booking-duplicate-monday" class="directorist-booking-duplicate-day" data-day-id="0">
                                    <label for="directorist-booking-duplicate-monday" class="directorist-checkbox__label"><?php _e( 'Monday', 'directorist-booking' ); ?></label>
                                </div>
                                <div class="directorist-checkbox directorist-checkbox-primary">
                                    <input type="checkbox" name="directorist-booking-duplicate-days" id="directorist-booking-duplicate-tuesday" class="directorist-booking-duplicate-day" data-day-id="1">
                                    <label for="directorist-booking-duplicate-tuesday" class="directorist-checkbox__label"><?php _e( 'Tuesday', 'directorist-booking' ); ?></label>
                                </div>
                                <div class="directorist-checkbox directorist-checkbox-primary">
                                    <input type="checkbox" name="directorist-booking-duplicate-days" id="directorist-booking-duplicate-wednesday" class="directorist-booking-duplicate-day" data-day-id="2">
                                    <label for="directorist-booking-duplicate-wednesday" class="directorist-checkbox__label"><?php _e( 'Wednesday', 'directorist-booking' ); ?></label>
                                </div>
                                <div class="directorist-checkbox directorist-checkbox-primary">
                                    <input type="checkbox" name="directorist-booking-duplicate-days" id="directorist-booking-duplicate-thursday" class="directorist-booking-duplicate-day" data-day-id="3">
                                    <label for="directorist-booking-duplicate-thursday" class="directorist-checkbox__label"><?php _e( 'Thursday', 'directorist-booking' ); ?></label>
                                </div>
                                <div class="directorist-checkbox directorist-checkbox-primary">
                                    <input type="checkbox" name="directorist-booking-duplicate-days" id="directorist-booking-duplicate-friday" class="directorist-booking-duplicate-day" data-day-id="4">
                                    <label for="directorist-booking-duplicate-friday" class="directorist-checkbox__label"><?php _e( 'Friday', 'directorist-booking' ); ?></label>
                                </div>
                                <div class="directorist-checkbox directorist-checkbox-primary">
                                    <input type="checkbox" name="directorist-booking-duplicate-days" id="directorist-booking-duplicate-saturday" class="directorist-booking-duplicate-day" data-day-id="5">
                                    <label for="directorist-booking-duplicate-saturday" class="directorist-checkbox__label"><?php _e( 'Saturday', 'directorist-booking' ); ?></label>
                                </div>
                                <div class="directorist-checkbox directorist-checkbox-primary">
                                    <input type="checkbox" name="directorist-booking-duplicate-days" id="directorist-booking-duplicate-sunday" class="directorist-booking-duplicate-day" data-day-id="6">
                                    <label for="directorist-booking-duplicate-sunday" class="directorist-checkbox__label"><?php _e( 'Sunday', 'directorist-booking' ); ?></label>
                                </div>
                            </div>
                            <div class="directorist-booking-time-duplicate-dropdown__content__footer">
                                <a href="#" class="directorist-booking-time-duplicate-dropdown-reset"><?php _e( 'Reset All', 'directorist-booking' ); ?></a>
                                <button class="directorist-booking-time-duplicate-dropdown-apply" id="diretorist-booking-btn-copy" type="button"><?php _e( 'Apply', 'directorist-booking' );?></button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="directorist-booking-weekend-price directorist-booking-rent directorist-booking-rental directorist-booking-box directorist-booking-mb-12">
            <div class="directorist-booking-element">
                <h3 class="directorist-booking-label"><?php echo ! empty( $bdb_weekend_price_label ) ? esc_html( $bdb_weekend_price_label ) : __( 'Weekend price', 'directorist-booking' ); ?></h3>
                <p class="directorist-booking-subheading"><?php _e( 'Default price for weekend', 'directorist-booking' ); ?></p>
            </div>
            <div class="directorist-booking-input-more">
                 <input type="number" class="directorist-form-element directorist-weekend-price" placeholder="0" step="any" name="bdb_weekend_price" value="<?php echo ! empty( $weekend_price ) ? $weekend_price : ''; ?>" id="bdb_weekend_price" min="0">
            </div>
        </div>
        <div class='directorist-booking-rental directorist-booking-rental-box directorist-booking-mb-32'>
            
            <?php 
            $calender_type_default =  apply_filters( 'directorist_booking_calender_type_default', true, $listing_id );
            if ( $calender_type_default ) : ?>

            <div class="directorist-booking-calender">
                <div class="directorist-booking-rental-box-header">
                    <div class="directorist-booking-rental-box-header-content">
                        <h4 class="directorist-booking-rental-box-header-title"><?php echo ! empty( $bdb_availability_calendar_title_label ) ? esc_html( $bdb_availability_calendar_title_label ) : __( 'Availability Calendar', 'directorist-booking' ); ?></h4>
                        <p class="directorist-booking-rental-box-header-subheading"><?php _e( 'Set when you are typically available for service', 'directorist-booking' );?></p>
                    </div>
                    <div class="directorist-booking-calender__alert" role="alert">
                        <i class="las la-info-circle"></i>
                        <p>
                            <?php
                            // Check if the old plain text is being used and replace it with formatted text
                            $formatted_text = __( '<strong>Click date</strong> in the calendar to mark the day as unavailable and <strong>Click price</strong> to change the individual price.', 'directorist-booking' );
                            $old_plain_text = __( 'Click date in the calendar to mark the day as unavailable and Click price to change the individual price.', 'directorist-booking' );
                            
                            if ( ! empty( $bdb_availability_calendar_desc_label ) ) {
                                // If the old plain text is detected, use the formatted version instead
                                if ( $bdb_availability_calendar_desc_label === $old_plain_text ) {
                                    echo wp_kses( $formatted_text, [ 'strong' => [] ] );
                                } else {
                                    echo wp_kses( $bdb_availability_calendar_desc_label, [ 'strong' => [] ] );
                                }
                            } else {
                                echo wp_kses( $formatted_text, [ 'strong' => [] ] );
                            }
                            ?>
                        </p>

                    </div>
                </div>
                <div class="directorist-booking-rental-box-content">
                    <div class='directorist-booking-rent'>
                        <input type="hidden" class="bdb_calender_unavailable" name="bdb_calender_unavailable" value="<?php echo ! empty( $calender_unavailable ) ? esc_attr( $calender_unavailable ) : ''; ?>">
                        <input type="hidden" class="bdb_calender_price" name="bdb_calender_price" value="<?php echo ! empty( $calender_price ) ? esc_attr( $calender_price ) : ''; ?>">
                        <?php echo ( new Calender() )->getCalendarHTML(); ?>
                    </div>
                </div>
            </div>    

            <?php endif;?>

        </div>
        <div class="directorist-booking-reservation-fee directorist-booking-box directorist-booking-mb-12">
            <div class="directorist-booking-element">
                <h3 class="directorist-booking-label"><?php _e( 'Reservation Fee', 'directorist-booking' ); ?></h3>
                <p class="directorist-booking-subheading"><?php _e( 'One time fee for booking', 'directorist-booking' ); ?></p>
            </div>
            <div class="directorist-booking-input-more">
                <input type="number" class="directorist-form-element" placeholder="0" step="any" name="bdb_reservation_fee" value="<?php echo ! empty( $Reservation_fee ) ? $Reservation_fee : ''; ?>" id="reservation_fee" min="0">
                <span class="directorist-booking-input-more-usd" for="reservation_fee"><?php echo get_directorist_option( 'g_currency', '$' );?></span>
            </div>
        </div>

        <div class="directorist-booking-guest-reservation directorist-booking-box directorist-booking-mb-12">
            <div class="directorist-booking-element">
                <h3 class="directorist-booking-label"><?php echo ! empty( $bdb_maximum_guests_label ) ? esc_html( $bdb_maximum_guests_label ) : __( 'Maximum number of guests allowed', 'directorist-booking' ); ?></h3>
                <p class="directorist-booking-subheading"><?php _e( 'Choose maximum number of guest per reservation', 'directorist-booking' ); ?></p>
            </div>
            <div class="directorist-booking-input-more">
                <input type="number" class="directorist-form-element" placeholder="0" name="bdb_reservation_guest" value="<?php echo ! empty( $reservation_guest ) ? $reservation_guest : ''; ?>"
                                    id="reservation_guest" min="0">
            </div>
        </div>

        <div class="directorist-booking-options directorist-booking-box directorist-booking-mb-12">
            <div class="directorist-booking-element">
                <h3 class="directorist-booking-label"><?php _e( 'Enable payment', 'directorist-booking' ); ?></h3>
                <p class="directorist-booking-subheading">
                    <?php _e( 'Enable it to let users pay a booking fee.', 'directorist-booking' ); ?>
                </p>
            </div>
            <div class="directorist-hide-booking-switch  directorist-switch">
                    <input type="checkbox" name="bdb_payment_booking" id="payment_booking" class="directorist-switch-input" <?=( ! empty( $payment_booking ) ) ? 'checked' : '';?> >
                    <label for="payment_booking" class="directorist-switch-label"></label>
            </div>
        </div>

        <div class="directorist-booking-instant directorist-booking-box directorist-booking-mb-12">
            <div class="directorist-booking-element">
                <h3 class="directorist-booking-label"><?php echo ! empty( $bdb_instant_booking_label ) ? esc_html( $bdb_instant_booking_label ) : __( 'Enable Instant Booking', 'directorist-booking' ); ?></h3>
                <p class="directorist-booking-subheading">
                    <?php _e( 'Enable it instantly approve approve booking request.', 'directorist-booking' ); ?>
                </p>
            </div>
            <div class="directorist-hide-booking-switch directorist-switch">
                <input type="checkbox" name="bdb_instant_booking" id="instant_booking" class="directorist-switch-input" <?=( ! empty( $instant_booking ) ) ? 'checked' : '';?> >
                <label for="instant_booking" class="directorist-switch-label"></label>
            </div>
        </div>
        <?php do_action( 'directorist_booking_show_custom_booking_calendar', $listing_id ); ?>

            <!-- Refund policy -->
            <?php
            //$file = BDB_DIR . 'templates/refund-policy/refund-policy.php';
            //BD_Booking()->get_template( $file, [ 'listing_id' => $listing_id ] );
            echo View::get(
                'refund-policy/refund-policy', [ 
                    'listing_id' => $listing_id,
                ] 
            );
            ?>

    </div>

</div><!-- ends: .bdb-wrapper -->
