
<?php do_action( 'wallet_dashboard_before_content' ); ?>

<div class="directorist-wallet-wrap">
    <div class="directorist-row">
        <div class="directorist-col-12">
            <?php
                $html = sprintf( '<h2 class="directorist-wallet-title">%s</h2>', __( 'Wallet', 'directorist-booking' ) );
                echo apply_filters( 'wallet_dashboard_content_area_title', $html );
            ?>
        </div>
        <div class="directorist-col-12 directorist-mb-10">
            <div class="directorist-wallet-card-list">
                <div class="directorist-card directorist-card-wallet directorist-wallet-balance">
                    <span class="directorist-card-wallet__amount">
                    <?php
                    echo ! empty( $total_available_amount ) ? $total_available_amount : 0;
                    ?>
                    </span>
                    <span class="directorist-card-wallet__type"><?php _e( 'Available Balance', 'directorist-booking' ); ?></span>
                </div>
                <div class="directorist-card directorist-card-wallet directorist-wallet-earning">
                    <span class="directorist-card-wallet__amount">
                    <?php
                    echo ! empty( $total_earning ) ? $total_earning : 0;
                    ?>
                    </span>
                    <span class="directorist-card-wallet__type"><?php _e( 'Total Earnings', 'directorist-booking' ); ?></span>
                </div>
                <div class="directorist-card directorist-card-wallet directorist-wallet-orders">
                    <span class="directorist-card-wallet__amount">
                    <?php
                    echo ! empty( $total_orders ) ? $total_orders : 0;
                    ?>
                    </span>
                    <span class="directorist-card-wallet__type"><?php _e( 'Total Orders', 'directorist-booking' ); ?></span>
                </div>
            </div><!-- ends: .directorist-wallet-card-list -->
        </div>
        <div class="directorist-col-12 directorist-mb-20">
            <div class="directorist-card directorist-wallet-table">
                <div class="directorist-card__header directorist-wallet-table__top">
                    <h3><?php _e( 'Earnings', 'directorist-booking' ); ?></h3><span><?php _e( 'Fee', 'directorist-booking' ); ?>: <strong><?php echo ! empty( $commission_rate ) ? $commission_rate : 0; ?>%</strong></span>
                </div>
                <div class="directorist-card__body">
                    <div class="directorist-table-responsive" role="region" aria-label="<?php esc_attr_e( 'Earnings table', 'directorist-booking' ); ?>" tabindex="0">
                        <table class="directorist-wallet-earnings-table" role="table" aria-label="<?php esc_attr_e( 'Earnings breakdown by order', 'directorist-booking' ); ?>">
                            <thead>
                                <tr role="row">
                                    <th scope="col" role="columnheader" aria-sort="none"><?php _e( 'Items', 'directorist-booking' ); ?></th>
                                    <th scope="col" role="columnheader" aria-sort="none"><?php _e( 'Order ID', 'directorist-booking' ); ?></th>
                                    <th scope="col" role="columnheader" aria-sort="none"><?php _e( 'Date', 'directorist-booking' ); ?></th>
                                    <th scope="col" role="columnheader" aria-sort="none"><?php _e( 'Price', 'directorist-booking' ); ?></th>
                                    <th scope="col" role="columnheader" aria-sort="none"><?php _e( 'Fee', 'directorist-booking' ); ?></th>
                                    <th scope="col" role="columnheader" aria-sort="none"><?php _e( 'Earnings', 'directorist-booking' ); ?></th>
                                    <th scope="col" role="columnheader" aria-sort="none"><?php _e( 'Status', 'directorist-booking' ); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                            <?php
                            if ( $all_earnings && is_array( $all_earnings ) ) {
                                foreach ( array_reverse( $all_earnings ) as $index => $earning ) {
                                    $status_class = '';
                                    $status_text  = '';
                                    
                                    // Normalize status for consistent styling
                                    if ( ! empty( $earning['status'] ) ) {
                                        $status_lower = strtolower( trim( $earning['status'] ) );
                                        switch ( $status_lower ) {
                                            case 'completed':
                                            case 'paid':
                                            case 'success':
                                                $status_class = 'directorist-status-success';
                                                $status_text  = __( 'Completed', 'directorist-booking' );
                                                break;
                                            case 'pending':
                                            case 'processing':
                                                $status_class = 'directorist-status-pending';
                                                $status_text  = __( 'Pending', 'directorist-booking' );
                                                break;
                                            case 'cancelled':
                                            case 'canceled':
                                            case 'failed':
                                                $status_class = 'directorist-status-cancelled';
                                                $status_text  = __( 'Cancelled', 'directorist-booking' );
                                                break;
                                            default:
                                                $status_class = 'directorist-status-default';
                                                $status_text  = esc_html( $earning['status'] );
                                        }
                                    }
                                    ?>
                                    <tr role="row" class="directorist-wallet-earnings-row" data-order-id="<?php echo esc_attr( $earning['order_id'] ?? '' ); ?>">
                                        <td role="cell" class="directorist-wallet-item-name">
                                            <div class="directorist-wallet-item-info">
                                                <span class="directorist-wallet-item-title"><?php echo ! empty( $earning['listing_name'] ) ? esc_html( $earning['listing_name'] ) : __( 'N/A', 'directorist-booking' ); ?></span>
                                            </div>
                                        </td>
                                        <td role="cell" class="directorist-wallet-order-id">
                                            <span class="directorist-wallet-order-number">#<?php echo ! empty( $earning['order_id'] ) ? esc_html( $earning['order_id'] ) : __( 'N/A', 'directorist-booking' ); ?></span>
                                        </td>
                                        <td role="cell" class="directorist-wallet-date">
                                            <time datetime="<?php echo ! empty( $earning['date'] ) ? esc_attr( date( 'Y-m-d', strtotime( $earning['date'] ) ) ) : ''; ?>" class="directorist-wallet-table-date">
                                                <?php echo ! empty( $earning['date'] ) ? esc_html( $earning['date'] ) : __( 'N/A', 'directorist-booking' ); ?>
                                            </time>
                                        </td>
                                        <td role="cell" class="directorist-wallet-price">
                                            <span class="directorist-wallet-amount"><?php echo ! empty( $earning['amount'] ) ? atbdp_display_price( $earning['amount'], false, '', '', '', false ) : __( 'N/A', 'directorist-booking' ); ?></span>
                                        </td>
                                        <td role="cell" class="directorist-wallet-fee">
                                            <span class="directorist-wallet-fee-amount"><?php echo ! empty( $earning['site_fee'] ) ? atbdp_display_price( $earning['site_fee'], false, '', '', '', false ) : __( 'N/A', 'directorist-booking' ); ?></span>
                                        </td>
                                        <td role="cell" class="directorist-wallet-earnings">
                                            <span class="directorist-wallet-earnings-amount"><?php echo ! empty( $earning['earning'] ) ? atbdp_display_price( $earning['earning'], false, '', '', '', false ) : __( 'N/A', 'directorist-booking' ); ?></span>
                                        </td>
                                        <td role="cell" class="directorist-wallet-status">
                                            <span class="directorist-status-badge <?php echo esc_attr( $status_class ); ?>" aria-label="<?php echo esc_attr( sprintf( __( 'Order status: %s', 'directorist-booking' ), $status_text ) ); ?>">
                                                <?php echo esc_html( $status_text ); ?>
                                            </span>
                                        </td>
                                    </tr>
                                    <?php
                                }
                            } else {
                                ?>
                                <tr role="row" class="directorist-wallet-empty-row">
                                    <td colspan="7" role="cell" class="directorist-wallet-empty-state">
                                        <div class="directorist-wallet-empty-content">
                                            <div class="directorist-wallet-empty-icon">
                                                <svg width="48" height="48" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                    <path d="M3 7H21L19 21H5L3 7Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                                    <path d="M8 11V13" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                                    <path d="M16 11V13" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                                </svg>
                                            </div>
                                            <h4 class="directorist-wallet-empty-title"><?php _e( 'No earnings yet', 'directorist-booking' ); ?></h4>
                                            <p class="directorist-wallet-empty-description"><?php _e( 'Your earnings will appear here once you start receiving bookings.', 'directorist-booking' ); ?></p>
                                        </div>
                                    </td>
                                </tr>
                                <?php
                            }
                            ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="directorist-wallet-table__pagination">
                        <!-- Pagination markup goes here -->
                    </div>
                </div>
            </div><!-- ends: .directorist-wallet-table -->
        </div>
        <div class="directorist-col-lg-6 directorist-mb-20">
            <div class="directorist-card directorist-wallet-table directorist-wallet-table-payout-history">
                <div class="directorist-card__header directorist-wallet-table__top">
                    <h3><?php _e( 'Payout History', 'directorist-booking' ); ?></h3>
                </div>
                <div class="directorist-card__body">
                    <div class="directorist-table-responsive" role="region" aria-label="<?php esc_attr_e( 'Payout history table', 'directorist-booking' ); ?>" tabindex="0">
                        <table class="directorist-wallet-payouts-table" role="table" aria-label="<?php esc_attr_e( 'Payout history by date', 'directorist-booking' ); ?>">
                            <thead>
                                <tr role="row">
                                    <th scope="col" role="columnheader" aria-sort="none"><?php _e( 'Amount', 'directorist-booking' ); ?></th>
                                    <th scope="col" role="columnheader" aria-sort="none"><?php _e( 'Payout Method', 'directorist-booking' ); ?></th>
                                    <th scope="col" role="columnheader" aria-sort="none"><?php _e( 'Date', 'directorist-booking' ); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $has_payouts = false;
                                if ( $payouts->have_posts() ) {
                                    while ( $payouts->have_posts() ) :
                                        $payouts->the_post();
                                        $username = get_post_meta( get_the_ID(), '_username', true );
                                        if ( $author_name == $username ) {
                                            $has_payouts    = true;
                                            $amount         = get_post_meta( get_the_ID(), '_total_balance_pay', true );
                                            $payment_method = get_post_meta( get_the_ID(), '_method', true );
                                            
                                            $t           = get_the_time( 'U' );
                                            $date_format = get_option( 'date_format' );
                                            $date        = date_i18n( $date_format, $t );
                                            ?>
                                        <tr role="row" class="directorist-wallet-payout-row">
                                            <td role="cell" class="directorist-wallet-payout-amount">
                                                <span class="directorist-wallet-amount"><?php echo ! empty( $amount ) ? atbdp_display_price( $amount, false, '', '', '', false ) : __( 'N/A', 'directorist-booking' ); ?></span>
                                            </td>
                                            <td role="cell" class="directorist-wallet-payout-method">
                                                <span class="directorist-wallet-method-name"><?php echo ! empty( $payment_method ) ? esc_html( $payment_method ) : __( 'No Payment Method', 'directorist-booking' ); ?></span>
                                            </td>
                                            <td role="cell" class="directorist-wallet-payout-date">
                                                <time datetime="<?php echo esc_attr( date( 'Y-m-d', $t ) ); ?>" class="directorist-wallet-table-date">
                                                    <?php echo ! empty( $date ) ? esc_html( $date ) : __( 'N/A', 'directorist-booking' ); ?>
                                                </time>
                                            </td>
                                        </tr>
                                            <?php
                                        }
                                endwhile;
                                    wp_reset_query();
                                }
                                
                                if ( ! $has_payouts ) {
                                    ?>
                                    <tr role="row" class="directorist-wallet-empty-row">
                                        <td colspan="3" role="cell" class="directorist-wallet-empty-state">
                                            <div class="directorist-wallet-empty-content">
                                                <div class="directorist-wallet-empty-icon">
                                                    <svg width="48" height="48" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <path d="M12 2L2 7L12 12L22 7L12 2Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                                        <path d="M2 17L12 22L22 17" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                                        <path d="M2 12L12 17L22 12" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                                    </svg>
                                                </div>
                                                <h4 class="directorist-wallet-empty-title"><?php _e( 'No payouts yet', 'directorist-booking' ); ?></h4>
                                                <p class="directorist-wallet-empty-description"><?php _e( 'Your payout history will appear here once payments are processed.', 'directorist-booking' ); ?></p>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php
                                }
                                ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="directorist-wallet-table__pagination">
                        <!-- Pagination markup goes here -->
                    </div>
                </div>
            </div><!-- ends: .directorist-wallet-table -->
        </div>
        <?php
            $current_user          = wp_get_current_user();
            $payment_method        = get_user_meta( $current_user->ID, 'bdb_payment_method', true );
            $paypal_checked        = ( ! empty( $payment_method ) && 'paypal' == $payment_method ) ? 'checked' : '';
            $bank_transfer_checked = ( ! empty( $payment_method ) && 'bank_transfer' == $payment_method ) ? 'checked' : '';
            $bdb_other_checked     = ( ! empty( $payment_method ) && 'bdb_other' == $payment_method ) ? 'checked' : '';
            $paypal_email          = get_user_meta( $current_user->ID, 'bdb_paypal_email', true );
            $bank_details          = get_user_meta( $current_user->ID, 'bdb_bank_details', true );
            $other_details         = get_user_meta( $current_user->ID, 'bdb_other_details', true );
            $payout_methods        = get_terms( [ 'taxonomy' => 'bdb_payout_method', 'hide_empty' => false, ] );
            $user_id               = get_current_user_id();    
            //$method_details      = get_user_meta( $user_id, '_payout_methods', true );
            
        ?>
        <div class="directorist-col-lg-6 directorist-mb-20">
            <div class="directorist-card directorist-wallet-payment-method">
                <div class="directorist-card__header directorist-wallet-payment-method__title">
                    <h3><?php _e( 'Payout Method', 'directorist-booking' ); ?></h3>
                </div>

                <div class="directorist-card__body">
                    <?php 
                    if ( ! empty( $payout_methods ) ) {
                        ?>
                    <form id="ddm_process_payout">
                    <input type="hidden" name="commission_id" value="<?php echo ! empty( $commission_id ) ? $commission_id : 0; ?>" />
                        <?php
                    
                        foreach ( $payout_methods as $key => $method ) { 
                            $method_slug = $method->slug ?? '';
                            ?>
                            <div class="directorist-wallet-payment-method__card">
                                <div class="directorist-wallet-payment-method__input">
                                    <div class="directorist-radio directorist-radio-circle">
                                        <input type="radio" name="method" <?php echo $key === 0 ? esc_attr( 'checked' ) : ''; ?> id="<?php echo esc_attr( $method_slug ?? '' ); ?>" value="<?php echo esc_attr( $method_slug ?? '' ); ?>">
                                        <label for="<?php echo esc_attr( $method_slug ?? '' ); ?>" class="directorist-radio__label"><?php echo esc_html( $method->name ?? '' ); ?></label>
                                    </div>
                                    <p class="directorist-wallet-payment-method__desc"><small><?php echo esc_attr( $method->description ?? '' ); ?></small></p>
                                </div>
                                <div class="directorist-wallet-payment-method__fields">
                                    <div class="directorist-form-group">
                                        <textarea name="payment_method_details[<?php echo esc_attr( $method_slug ?? '' ); ?>]" id="<?php echo esc_attr( $method_slug ?? '' ); ?>" class="directorist-form-element ddm_payment_method_details"><?php echo ! empty( $method_details[$method_slug] ) ? esc_attr( $method_details[$method_slug] ) : ''; ?></textarea>
                                    </div>
                                </div>
                            </div><!-- ends: .directorist-wallet-payment-method__card -->
                        <?php } ?>
                        <p id="ddm_notice_board"></p>
                        <button class="directorist-btn directorist-btn-md directorist-booking-btn-save-card" id="ddm_submit_payment_method" type="submit"><?php _e( 'Save', 'directorist-booking' ); ?></button>
                    </form>
                    <?php } else { ?>
                        <div class="directorist-wallet-empty-state">
                            <div class="directorist-wallet-empty-content">
                                <div class="directorist-wallet-empty-icon">
                                    <svg width="48" height="48" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M3 7H21L19 21H5L3 7Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                        <path d="M8 11V13" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                        <path d="M16 11V13" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                    </svg>
                                </div>
                                <h4 class="directorist-wallet-empty-title"><?php esc_html_e( 'No method found!', 'directorist-booking' ); ?></h4>
                            </div>
                        </div>
                    <?php } ?>      
                </div>
            </div>
        </div>
    </div>
</div><!-- ends: .wallet-wrapper -->
<?php do_action( 'wallet_dashboard_after_content' ); ?>
