<?php
use Directorist_Booking\App\Providers\Database;

$guest_booking             = get_directorist_option( 'bdb_guest_booking' );
$bdb_request_booking_label = get_directorist_option( 'bdb_request_booking_label', __( 'Request Booking', 'directorist-booking' ) );
$bdb_reservation_fee_label = get_directorist_option( 'bdb_reservation_fee_label', __( 'Total Cost', 'directorist-booking' ) );
$refund_desc               = get_post_meta( get_the_ID(), '_refund_policy', true );
$enable_refund             = get_post_meta( get_the_ID(), '_enable_refund', true );
$bdb_refund_policy         = get_directorist_option( 'bdb_refund_policy' );
$bdb_refund_policy_label   = get_directorist_option( 'bdb_refund_policy_label', __( 'Refund Policy', 'directorist-booking' ) );

$records = Database::get_bookings( date( 'Y-m-d H:i:s' ),  date( 'Y-m-d H:i:s', strtotime( '+3 years' ) ), [ 'listing_id' => get_the_ID(), 'type' => 'reservation' ] );
       
$has_record              = $records ? $records : [];
$has_record              =  apply_filters( 'directorist_booking_records', $has_record );
$bdb_login_booking_label = get_directorist_option( 'bdb_login_booking_label', __( 'Login for Booking', 'directorist-booking' ) );
$disable_dates           = []; // Initialize as empty array
if ( $has_record ) {
    foreach ( $records as $record ) {
        // Ensure $record is an array and has the required keys
        if ( ! is_array( $record ) || ! isset( $record['date_start'] ) || ! isset( $record['date_end'] ) ) {
            continue;
        }

        // when we have one day reservation
        if ( $record['date_start'] == $record['date_end'] ) {
            $disable_dates[] = date( 'Y-m-d', strtotime( $record['date_start'] ) );
        } else {
            
            // if we have many days reservations we have to add every date between this days
            $period = new DatePeriod(
                new DateTime( date( 'Y-m-d', strtotime( $record['date_start'] ) ) ),
                new DateInterval( 'P1D' ),
                new DateTime( date( 'Y-m-d', strtotime( $record['date_end'] . ' +1 day' ) ) )
            );

            foreach ( $period as $day_number => $value ) {
                $disable_dates[] = $value->format( 'Y-m-d' );  
            }

        }

    }

    $disable_dates = apply_filters( 'disable_dates_booking', $disable_dates );
    $show_dates    = 'rent' == $booking_type ? true : false;
    $show_dates    = apply_filters( 'send_disable_dates_in_js', $show_dates );
    if ( $show_dates ) {
        ?>
            <script>
                var disabedDates = <?php echo json_encode( $disable_dates ); ?>;
            </script>
            <?php
    }
        
}
$date_picker = 'service' == $booking_type || 'rent' == $booking_type ? true : false;
$date_picker = apply_filters( 'show_date_picker_in_single_listing_booking_area', $date_picker );
?>
<div class="directorist-booking-form-container">
<form id="form-booking" method="post" action="<?php echo bdb_booking_confirmation_page(); ?>">
        <?php if ( $date_picker ) { ?>
            <div class="directorist-booking-date-item">
                <label for="date-picker" class="directorist-booking-date-picker-label"><?php esc_html_e( 'Select date', 'directorist-booking' ); ?></label>
                <div class="directorist-booking-date-picker-container">
                    <div class="directorist-booking-date-picker-icon">
                        <i class="la la-calendar"></i>
                    </div>
                    <input type="text" id="date-picker" booking_type ="<?php echo $booking_type; ?>" readonly="readonly" class="directorist-booking-date-picker-service" autocomplete="off" placeholder="<?php esc_attr_e( 'Select your preferred date', 'directorist-booking' ); ?>" value="" />
                </div>
            </div>
        <?php } ?>

        <?php if ( 'service' == $booking_type ) { ?>
            <?php if ( ! empty( $slot_status ) && 'time_slot' == $slot_status ) { ?>
            <div class="directorist-booking-date-item">
                <div class="directorist-booking-panel-dropdown directorist-booking-time-slots-dropdown">
                    <div  class="directorist-booking-time-slots-dropdown-label" data-placeholder="<?php esc_html_e( 'Available slot', 'directorist-booking' ) ?>"><?php esc_html_e( 'Available slot', 'directorist-booking' ) ?></div>
                    <div class="directorist-booking-panel-dropdown-content">
                        <div class="directorist-booking-no-slots"><?php esc_html_e( 'No slots for this day', 'directorist-booking' ) ?></div>
                        <div class="directorist-booking-panel-dropdown-scrollable">
                            <input id="slot-input" type="hidden" name="slot" value="" />

                            <?php
                            // Process booking data to get only enabled days
                            $enabled_values = process_booking_data_for_template( $values );
                            
                            foreach ( $enabled_values as $day => $day_slots ) {
                                // Get time slots for this day
                                $time_slots = get_time_slots_for_day_template( $day_slots );
                                
                                if ( empty( $time_slots ) ) continue;

                                foreach ( $time_slots as $key => $day_slot ) {
                                    // Ensure $day_slot is an array before accessing its elements
                                    if ( ! is_array( $day_slot ) ) {
                                        continue;
                                    }
                                    
                                    $slot       = isset( $day_slot['slots'] ) ? $day_slot['slots'] : 1;
                                    $start_time = ! empty( $day_slot['start'] ) ? $day_slot['start'] : '';
                                    $close_time = ! empty( $day_slot['close'] ) ? $day_slot['close'] : '';
                                    $number     = $key; ?>
                                        <!-- Time Slot -->
                                        <div class="time-slot" data-day="<?php echo $day; ?>">
                                            <input type="radio" name="time-slot" id="<?php echo $day . '|' . $number; ?>" value="<?php echo $day . '|' . $number; ?>">
                                            <label for="<?php echo $day . '|' . $number; ?>">
                                                <p class="day" style="display: none;"><?php echo isset( $days_list[$day] ) ? $days_list[$day] : ''; ?></p>
                                                <strong class="time-duration"><?php echo $start_time . '-' . $close_time; ?></strong>
                                                <?php if ( ! empty( $display_slot_available_text ) ) { ?>
                                                    <span class="total-slots">
                                                        <strong><?php echo esc_html( $slot ); ?></strong> <?php echo esc_html( $slot_available_text ); ?>
                                                    </span>
                                                <?php } ?>
                                            </label>
                                        </div>

                                    <?php
                                }
                            }
                            ?>

                        </div>
                    </div>
                </div>
            </div>
        <?php } else { ?>
            <div class="directorist-booking-date-item">
                <div class="directorist-booking-time-picker-wrap">
                    <div class="directorist-form-group">
                        <input type="time" class="directorist-booking-time-picker directorist-form-element flatpickr-input active" name="_hours" value="00:00" placeholder="00:00">
                    </div>
                    <?php if ( ! empty( $display_available_time ) ) { ?>
                        <div class="directorist-available-time-block">
                            <span><?php echo ! empty( $available_time_text ) ? $available_time_text : __( 'Available Time', 'directorist-booking' ); ?>:</span>
                            <div class="directorist-available-time-list">

                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
            <script>
                <?php
                // Process booking data to get only enabled days for JavaScript
                $enabled_days = process_booking_data_for_template( $values );
                
                // Filter out the enable field from each day's data for JavaScript
                $js_enabled_days = [];
                foreach ( $enabled_days as $day => $day_slots ) {
                    $time_slots = get_time_slots_for_day_template( $day_slots );
                    if ( ! empty( $time_slots ) ) {
                        $js_enabled_days[$day] = $time_slots;
                    }
                }
                ?>
                var availableDays = <?php echo json_encode( $js_enabled_days, true ); ?>;
            </script>
        <?php } ?>
        
        <?php } elseif ( 'event' == $booking_type ) {
            $event_ticket    = get_post_meta( get_the_ID(), '_bdb_event_ticket', true );
            $payment_booking = get_post_meta( get_the_ID(), '_bdb_payment_booking', true );
            if ( $payment_booking ) {
                $reservation_fee = get_post_meta( get_the_ID(), '_bdb_reservation_fee', true );
            }
            $event_ticket           = ! empty( $event_ticket ) ? $event_ticket : 0;
            $event_tickets_sold     = get_post_meta( get_the_ID(), '_event_tickets_sold', true );
            $event_tickets_sold     = ! empty( $event_tickets_sold ) ? $event_tickets_sold : 0;
            $maximum_ticket_allowed = get_post_meta( get_the_ID(), '_bdb_maximum_ticket_allowed', true );
            $bdb_book_ticket_label  = get_directorist_option( 'bdb_book_ticket_label', __( 'Book Ticket', 'directorist-booking' ) );
            if ( $payment_booking ) {
                $price = get_post_meta( get_the_ID(), '_price', true );
            }
            if ( isset( $event_tickets_sold ) ) {
                $available_ticket = $event_ticket - $event_tickets_sold;
            }
            if ( ! empty( $available_ticket ) ) {
                $maximum_ticket_allowed = ( $maximum_ticket_allowed < $available_ticket ) ? $maximum_ticket_allowed : $available_ticket;
                ?>
            <div class="directorist-booking-event-tickets">
                <div class="directorist-dropdown directorist-dropdown-js atbd-drop-select">
                    <div class="directorist-booking-dropdown-label">Tickets</div>
                    <a href="#" class="directorist-booking-dropdown-link atbd-dropdown-toggle directorist-dropdown__toggle directorist-dropdown__toggle-js" id="tickets" data-drop-toggle="atbd-toggle"><?php _e( 'Select ticket QTY','directorist-booking' ); ?></a>
                    <span class="directorist-booking-total-reservation">
                        <?php printf( __( 'Only %d ticket%s allowed per reservation', 'directorist-booking' ), $maximum_ticket_allowed, $maximum_ticket_allowed > 1 ? 's' : '' ); ?>
                    </span>
                    <div class="directorist-booking-dropdown directorist-dropdown__links directorist-dropdown__links-js atbd-dropdown-items">
                        <?php for ( $i = 1; $i <= $maximum_ticket_allowed; $i++ ) { ?>
                        <a href="#" class="atbd-dropdown-item" data-price="<?php echo ! empty( $price ) ? $price : 0; ?>" data-fee = "<?php echo ! empty( $reservation_fee ) ? $reservation_fee : ''; ?>" data-id="<?php echo $i; ?>"><?php echo $i; ?></a>
                       <?php } ?>
                    </div>
                </div>
            </div>
        <?php } else { ?>
            <p><?php _e( 'The tickets have sold out', 'directorist-booking' ); ?></p>
        <?php } ?>
    <?php } ?>
    
    <?php if ( ( 'rent' == $booking_type || 'service' == $booking_type ) && ! empty( $reservation_guest ) ) { ?>
        <div class="directorist-booking-date-item">
            <div class="directorist-dropdown directorist-dropdown-js atbd-drop-select">
                <div class="directorist-booking-dropdown-label">Select Guest</div>
                <a href="#" class="directorist-booking-dropdown-link directorist-guest-select atbd-dropdown-toggle adults directorist-dropdown__toggle directorist-dropdown__toggle-js" data-drop-toggle="atbd-toggle"><?php _e( "Selected Value", "directorist-booking" ) ?></a>
                <div class="directorist-booking-dropdown directorist-dropdown__links directorist-dropdown__links-js">
                    <?php
                    for ( $i = 1; $i <= $reservation_guest; $i++ ) { ?>
                        <a href="#" class="atbd-dropdown-item"><?php printf( "%s %s", $i, __( "Person", "directorist-booking" ) ) ?></a>
                    <?php } ?>
                </div>
            </div>
        </div>
    <?php } ?>

    <?php if ( 'event' == $booking_type && ! empty( $available_ticket ) && ! empty( $display_available_ticket ) ) { ?>
    <div class="directorist-booking-date-item">
        <div class="directorist-booking-available-ticket">
            <svg xmlns="http://www.w3.org/2000/svg" width="22" height="20" viewBox="0 0 22 20" fill="none">
            <path fill-rule="evenodd" clip-rule="evenodd" d="M0.248047 1.5C0.248047 1.08579 0.583834 0.75 0.998047 0.75H20.9972C21.4114 0.75 21.7472 1.08579 21.7472 1.5V18.5C21.7472 18.9142 21.4114 19.25 20.9972 19.25H0.998047C0.583834 19.25 0.248047 18.9142 0.248047 18.5V11.75H1.47115C2.43765 11.75 3.22115 10.9665 3.22115 10C3.22115 9.0335 2.43765 8.25 1.47115 8.25H0.248047V1.5ZM16.998 9L11.998 9V11L16.998 11V9ZM7.99805 13L16.998 13V15L7.99805 15V13Z" fill="#8F6C1A"/>
            </svg>
            <div class="directorist-booking-available-ticket-content">
                only
                <strong><?php echo $available_ticket; ?></strong>
                <?php echo ! empty( $available_ticket_text ) ? $available_ticket_text : __( 'Available Tickets :','directorist-booking' ); ?>
            </div>
        </div>
    </div>
    <?php } ?>
    <div class="directorist-booking-estimated-cost" style="display:none;">
        <div class="directorist-booking-estimated-cost-content">
            <div class="directorist-booking-estimated-cost-top">
                <div class="directorist-booking-listing-title">
                    <?php 
                    // Fix: Use get_the_ID() if $data is not set or is invalid
                    $listing_id = ( ! empty( $data ) && is_array( $data ) && isset( $data['listing_id'] ) ) ? $data['listing_id'] : get_the_ID();
                    echo get_the_title( $listing_id ); 
                    ?>
                </div>
                <div class="directorist-booking-listing-details" id="booking-details-display">
                    <span class="booking-date-display">Select a date to see details</span>
                    <span class="booking-time-display" style="display: none;"></span>
                    <span class="booking-duration-display" style="display: none;"></span>
                </div>
            </div>
            <div class="directorist-booking-estimated-cost-bottom">
            <div class="directorist-booking-reservation-label">Total Cost</div>
            <span class="directorist-booking-reservation-price"></span>
            </div>
        </div>
    </div>
    <div class="directorist-booking-error-msg" style="display: none;">
        <?php esc_html_e( 'Unfortunately this request can\'t be processed. Try different dates please.', 'directorist-booking' ); ?>
    </div>
        <div class="directorist-booking-date-item">
        <input id="listing_id" type="hidden" name="listing_id" value="<?php echo get_the_ID(); ?>" />
        <input id="booking" type="hidden" name="value" value="booking_form" />
        <input id="listing_type" type="hidden" name="listing_type" value="<?php echo ! empty( $booking_type ) ? $booking_type : 'service'; ?>" />

        <?php if ( is_user_logged_in() || ! empty( $guest_booking ) ) { ?>
            <?php 
            // Check if this is an event booking and if tickets are selected
            $is_event_booking = $booking_type == "event";
            $tickets_selected = false;
            
            if ( $is_event_booking ) {
                // Check if tickets are available and selected
                $tickets_selected = ! empty( $available_ticket ) && $available_ticket > 0;
            }
            
            $button_disabled = $is_event_booking && ! $tickets_selected;
            ?>
            
            <a href="#" class="directorist-book-now <?php echo $button_disabled ? 'disabled' : ''; ?>" 
               <?php echo $button_disabled ? 'style="pointer-events: none; opacity: 0.6;"' : ''; ?>>
                <?php 
                if ( $button_disabled ) {
                    esc_html_e( 'Please select ticket quantity', 'directorist-booking' );
                } else {
                    echo ( 'event' == $booking_type && ! empty( $bdb_book_ticket_label ) ) ? $bdb_book_ticket_label : $bdb_request_booking_label;
                }
                ?>
            </a>
        <?php } else { ?>
            <a href="<?php echo ! empty( $login_page ) ? $login_page : ''; ?>" class="login-booking"><?php echo $bdb_login_booking_label; ?></a>
        <?php } ?>
    </div>
</form>
</div>

<div id="info"></div>