<?php
if ( $value['comment'] == 'owner reservations' ) {
    return;
}
$class                = [];
$tag                  = [];
$show_approve         = false;
$show_reject          = false;
$show_cancel          = false;
$enable_payment       = get_post_meta( $value['listing_id'], '_bdb_payment_booking', true );
$booking_payment_type = get_directorist_option( 'booking_payment_type', 'directorist' );

switch ( $value['status'] ) {
    case 'waiting' :
        $class[]      = 'waiting-booking';
        $tag[]        = '<span class="directorist-booking-card__status directorist-booking-card__status--pending">' . esc_html__( 'Pending', 'directorist-booking' ) . '</span>';
        $show_approve = true;
        $show_reject  = true;
        $show_delete  = false;
        break;

    case 'confirmed' :
        $class[] = 'approved-booking';
        $tag[]   = '<span  class="directorist-booking-card__status directorist-booking-card__status--approved">' . esc_html__( 'Approved', 'directorist-booking' ) . '</span>';

        if ( $value['price'] > 0 && ! empty( $enable_payment ) && ! empty( $value['order_id'] ) ) {
            $tag[] = '<span class="directorist-booking-card__status directorist-booking-card__status--processing">' . esc_html__( 'Processing Payment', 'directorist-booking' ) . '</span>';
        }

        $show_approve = false;
        $show_reject  = false;
        $show_cancel  = true;
        $show_delete  = false;
        break;

    case 'paid' :

        $class[] = 'approved-booking';
        $tag[]   = '<span class="directorist-booking-card__status directorist-booking-card__status--approved">' . esc_html__( 'Approved', 'directorist-booking' ) . '</span>';
        if ( $value['price'] > 0 ) {
            $tag[] = '<span class="directorist-booking-card__status directorist-booking-card__status--paid">' . esc_html__( 'Paid', 'directorist-booking' ) . '</span>';
        }
        $show_approve = false;
        $show_reject  = false;
        $show_cancel  = true;
        $show_delete  = false;
        break;

    case 'cancelled' :

        $class[]      = 'canceled-booking';
        $tag[]        = '<span class="directorist-booking-card__status directorist-booking-card__status--reject">' . esc_html__( 'Canceled', 'directorist-booking' ) . '</span>';
        $show_approve = false;
        $show_reject  = false;
        $show_delete  = true;
        break;

    default:
        # code...
        break;
}
$author_pro_pic_id  = get_user_meta( $value['bookings_author'], 'pro_pic', true );
$author_profile_pic = wp_get_attachment_image_src( $author_pro_pic_id, 'thumbnail' );
$listing_img_id     = get_post_meta( $value['listing_id'], '_listing_prv_img', true );
if ( ! empty( $listing_img_id ) ) {
    $listing_img = wp_get_attachment_image_src( $listing_img_id, 'thumbnail' );
}
$default_image_src = get_directorist_option( 'default_preview_image', ATBDP_PUBLIC_ASSETS . 'images/grid.jpg' );
$listing_type      = get_post_meta( $value['listing_id'],'_bdb_booking_type',true );
$booking_type      = get_directorist_option( 'booking_type', [ 'service', 'rent', 'booking' ] );
$booking_type      = ! empty( $booking_type ) ? $booking_type : 'service';
$listing_type      = ( ! empty( $listing_type ) && 'undefined' !== $listing_type ) ? $listing_type : $booking_type;
?>
<?php
// Parse booking details from comment
$details = json_decode( $value['comment'] );

// Prepare guests information
$guests_text = '';
if ( ( isset( $details->childrens ) && $details->childrens > 0 )
    || ( isset( $details->adults ) && $details->adults > 0 )
    || ( isset( $details->tickets ) && $details->tickets > 0 )
) {
    $guest_parts = [];
    if ( isset( $details->childrens ) && $details->childrens > 0 ) {
        $guest_parts[] = sprintf( _n( '%d Child', '%d Children', $details->childrens, 'directorist-booking' ), $details->childrens );
    }
    if ( isset( $details->adults ) && $details->adults > 0 ) {
        $guest_parts[] = sprintf( _n( '%d Guest', '%d Guests', $details->adults, 'directorist-booking' ), $details->adults );
    }
    if ( isset( $details->tickets ) && $details->tickets > 0 ) {
        $guest_parts[] = sprintf( _n( '%d Ticket', '%d Tickets', $details->tickets, 'directorist-booking' ), $details->tickets );
    }
    $guests_text = implode( ', ', $guest_parts );
}

// Prepare date and time information
$date_time_text = '';
if ( 'event' != $listing_type ) {
    if ( $listing_type == 'rent' ) {
        $date_time_text = date( get_option( 'date_format' ), strtotime( $value['date_start'] ) ) . ' - ' . date( get_option( 'date_format' ), strtotime( $value['date_end'] ) );
    } else if ( $listing_type == 'service' ) {
        $date_time_text = date( get_option( 'date_format' ), strtotime( $value['date_start'] ) ) . ' ' . esc_html__( 'at', 'directorist-booking' ) . ' ';
        if ( $value['date_start'] != $value['date_end'] ) {
            $date_time_text .= date( get_option( 'time_format' ), strtotime( $value['date_start'] ) ) . ' - ' . date( get_option( 'time_format' ), strtotime( $value['date_end'] ) );
        } else {
            $date_time_text .= date( get_option( 'time_format' ), strtotime( $value['date_start'] ) );
        }
    } else { // event
        $date_time_text = date( get_option( 'date_format' ), strtotime( $value['date_start'] ) ) . ' ' . esc_html__( 'at', 'directorist-booking' ) . ' ' . date( get_option( 'time_format' ), strtotime( $value['date_start'] ) );
    }
}

// Prepare price information
$price_text = '';
if ( $value['price'] ) {
    $currency          = get_directorist_option( 'g_currency', 'USD' );
    $currency_position = get_directorist_option( 'g_currency_position', 'before' );
    $currency_symbol   = atbdp_currency_symbol( $currency );
    
    if ( $currency_position == 'before' ) {
        $price_text = $currency_symbol . ' ' . $value['price'];
    } else {
        $price_text = $value['price'] . ' ' . $currency_symbol;
    }
}

// Prepare client information
$client_name  = '';
$client_email = '';
if ( isset( $details->first_name ) || isset( $details->last_name ) ) {
    $client_name = trim( ( isset( $details->first_name ) ? $details->first_name : '' ) . ' ' . ( isset( $details->last_name ) ? $details->last_name : '' ) );
}
if ( isset( $details->email ) ) {
    $client_email = $details->email;
}

// Prepare request sent date (date only, no time)
$request_date = date( get_option( 'date_format' ), strtotime( $value['created'] ) );

// Prepare message/notes
$booking_notes = '';
if ( isset( $details->message ) && ! empty( $details->message ) ) {
    $booking_notes = $details->message;
}
?>

<!-- New dynamic card -->
<div class="directorist-booking-card <?php echo implode( ' ',$class ); ?>" 
     id="booking-list-<?php echo esc_attr( $value['ID'] );?>"
     data-request-date="<?php echo esc_attr( date( 'Y-m-d', strtotime( $value['created'] ) ) ); ?>"
     data-booking-date="<?php echo esc_attr( date( 'Y-m-d', strtotime( $value['date_start'] ) ) ); ?>"
     data-price="<?php echo esc_attr( $value['price'] ); ?>"
     data-listing-id="<?php echo esc_attr( $value['listing_id'] ); ?>">
  <div class="directorist-booking-card__header">
    <a href="<?php echo get_permalink( $value['listing_id'] ); ?>"><?php
    if ( empty( $listing_img_id ) ) { ?>
        <?php   } else { ?>
            <img class="directorist-booking-card__image" src="<?php echo esc_url( $listing_img[0] ); ?>" alt="Listing Image">
        <?php }
        ?>
    </a>
    <div class="directorist-booking-card__info">
      <h2 class="directorist-booking-card__title">
        <a href="<?php echo get_permalink( $value['listing_id'] ); ?>">
            <?php echo get_the_title( $value['listing_id'] ); ?>
        </a>
        
        <span class="directorist-booking-card__status-wrapper">
            <?php echo implode( ' ',$tag ); ?>
        </span>
      </h2>
      <ul class="directorist-booking-card__details">
        <?php if ( ! empty( $guests_text ) ) : ?>
        <li class="directorist-booking-card__guests">
            <?php directorist_icon( 'las la-user' ); ?>
            <?php echo esc_html( $guests_text ); ?>
        </li>
        <?php endif; ?>
        <?php if ( ! empty( $date_time_text ) ) : ?>
        <li class="directorist-booking-card__date">
            <?php directorist_icon( 'las la-calendar' ); ?>
            <?php echo esc_html( $date_time_text ); ?>
        </li>
        <?php endif; ?>
      </ul>
      <?php if ( ! empty( $price_text ) ) : ?>
      <div class="directorist-booking-card__price"><?php echo esc_html( $price_text ); ?></div>
      <?php endif; ?>
    </div>
    <div class="directorist-booking-card__actions">
         <?php if ( $show_cancel ) : ?>
                <a href="#" class="directorist-booking-card__btn directorist-booking-card__btn--reject owner-cancel-btn" data-booking_id="<?php echo esc_attr( $value['ID'] ); ?>"><?php directorist_icon( 'las la-times' ); ?> <?php esc_html_e( 'Cancel Order', 'directorist-booking' ); ?></a>
            <?php endif; ?>
        <?php if ( $show_approve ) : ?>
            <a href="#" class="directorist-booking-card__btn directorist-booking-card__btn--approve" id="owner_approved" data-booking_id="<?php echo esc_attr( $value['ID'] ); ?>"><?php directorist_icon( 'las la-check' ); ?> <?php esc_html_e( 'Approve Order', 'directorist-booking' ); ?></a>
        <?php endif; ?>
        <?php if ( $show_reject ) : ?>
            <a href="#" class="directorist-booking-card__btn directorist-booking-card__btn--reject" id="owner_reject" data-booking_id="<?php echo esc_attr( $value['ID'] ); ?>"><?php directorist_icon( 'las la-times' ); ?> <?php esc_html_e( 'Reject', 'directorist-booking' ); ?></a>
        <?php endif; ?>
        <?php if ( $show_delete ) : ?>
            <a href="#" class="directorist-booking-card__btn directorist-booking-card__btn--reject" id="owner_delete" data-booking_id="<?php echo esc_attr( $value['ID'] ); ?>"><?php directorist_icon( 'las la-times' ); ?> <?php esc_html_e( 'Delete', 'directorist-booking' ); ?></a>
        <?php endif; ?>
    </div>
  </div>

  <div class="directorist-booking-card__footer">
    <div class="directorist-booking-card__user">
      <?php if ( ! empty( $client_name ) ) : ?>
      <div class="directorist-booking-card__label"><?php echo esc_html( $client_name ); ?></div>
      <?php endif; ?>
      <?php if ( ! empty( $client_email ) ) : ?>
      <div class="directorist-booking-card__value directorist-booking-card__value--email">
        <a href="mailto:<?php echo esc_attr( $client_email ); ?>"><?php echo esc_html( $client_email ); ?></a>
        <div class="directorist-booking-card__value__copy" title="Copy"><?php directorist_icon( 'las la-copy' ); ?></div>
      </div>
      <?php endif; ?>
      <?php if ( isset( $details->phone ) && ! empty( $details->phone ) ) : ?>
      <div class="directorist-booking-card__value directorist-booking-card__value--phone">
        <a href="tel:<?php echo esc_attr( $details->phone ); ?>"><?php echo esc_html( $details->phone ); ?></a>
      </div>
      <?php endif; ?>
    </div>
    <div class="directorist-booking-card__request">
      <div class="directorist-booking-card__label"><?php esc_html_e( 'Request sent', 'directorist-booking' ); ?></div>
      <div class="directorist-booking-card__value directorist-booking-card__value--date"><?php echo esc_html( $request_date ); ?></div>
    </div>
    <div class="directorist-booking-card__notes">
      <div class="directorist-booking-card__label"><?php esc_html_e( 'Booking notes', 'directorist-booking' ); ?></div>
      <?php if ( ! empty( $booking_notes ) ) : ?>
        <div class="directorist-booking-card__value">
            <?php echo wpautop( esc_html( $booking_notes ) ); ?>
        </div>
      <?php else : ?>
        <div class="directorist-booking-card__value directorist-booking-card__value--empty">
          <?php esc_html_e( 'no notes are available', 'directorist-booking' ); ?>
        </div>
      <?php endif; ?>
    </div>
    <?php if ( isset( $details->service ) && ! empty( $details->service ) ) : ?>
    <div class="directorist-booking-card__notes">
      <div class="directorist-booking-card__label"><?php esc_html_e( 'Extra Services', 'directorist-booking' ); ?></div>
      <div class="directorist-booking-card__value">
        <?php echo wpautop( esc_html( $details->service ) ); ?>
      </div>
    </div>
    <?php endif; ?>
  </div>
</div>

<?php
/*
<!-- Old dynamic card - COMMENTED OUT -->
<div class="directorist-booking-single <?php echo implode( ' ',$class ); ?>" id="booking-list-<?php echo esc_attr( $value['ID'] );?>">
    <div class="directorist-list-box-listing">
        <div class="directorist-list-box-listing__img"><a href="<?php echo get_permalink( $value['listing_id'] ); ?>"><?php
        if ( empty( $listing_img_id ) ) { ?>
                    
                <?php   } else { ?>
                    <img src="<?php echo esc_url( $listing_img[0] ); ?>" alt="Listing Image">
                <?php }
                ?></a>
        </div>
        <div class="directorist-list-box-listing__content">
            <div class="directorist-inner">
                <div class="directorist-inner__top directorist-flex">
                    <h3 class="directorist-inner__h3title" id="title"><a href="<?php echo get_permalink( $value['listing_id'] ); ?>">
                        <?php echo get_the_title( $value['listing_id'] ); ?>
                        </a>
                    </h3>
                    <div class="directorist-booking-status-list">
                        <?php echo implode( ' ',$tag ); ?>
                    </div>
                </div>
                
              <div class="directorist-inner__booking-wrapper">
                  <?php if ( 'event' != $listing_type ) { ?>
                    <div class="directorist-inner__booking-list">
                        <h5 class="directorist-inner__h5title"><?php esc_html_e( 'Booking Date:', 'directorist-booking' ); ?></h5>
                        <ul class="directorist-booking-list">
                            <?php
                            //get post type to show proper date
                            //$listing_type = 'service';
                            if ( $listing_type == 'rent' ) { ?>
                                <li class="directorist-highlighted" id="date"><?php echo date( get_option( 'date_format' ), strtotime( $value['date_start'] ) ); ?> - <?php echo date( get_option( 'date_format' ), strtotime( $value['date_end'] ) ); ?></li>
                            <?php } else if ( $listing_type == 'service' ) { ?>
                                <li class="directorist-highlighted" id="date">
                                    <?php echo date( get_option( 'date_format' ), strtotime( $value['date_start'] ) ); ?> <?php esc_html_e( 'at','directorist-booking' ); ?> <?php if ( $value['date_start'] != $value['date_end'] ) {
                                        echo date( get_option( 'time_format' ), strtotime( $value['date_start'] ) ); ?> - <?php echo date( get_option( 'time_format' ), strtotime( $value['date_end'] ) );
                                    } else {
                                        echo date( get_option( 'time_format' ), strtotime( $value['date_start'] ) );
                                    }

                                    ?></li>
                            <?php } else { //event ?>
                                <li class="directorist-highlighted" id="date">
                                    <?php echo date( get_option( 'date_format' ), strtotime( $value['date_start'] ) ); ?> <?php esc_html_e( 'at','directorist-booking' ); ?>
                                    <?php echo date( get_option( 'time_format' ), strtotime( $value['date_start'] ) ); ?>
                                </li>
                            <?php }
                            ?>

                        </ul>
                    </div>
                            <?php } ?>                
                    <?php $details = json_decode( $value['comment'] );

                    if ( ( isset( $details->childrens ) && $details->childrens > 0 )
                        ||
                        ( isset( $details->adults ) && $details->adults > 0 )
                        ||
                        ( isset( $details->tickets ) && $details->tickets > 0 )
                    ) { ?>
                        <div class="directorist-inner__booking-list">
                            <h5 class="directorist-inner__h5title"><?php esc_html_e( 'Guests:', 'directorist-booking' ); ?></h5>
                            <ul class="directorist-booking-list">
                                <li class="directorist-highlighted" id="details">
                                    <?php if ( isset( $details->childrens ) && $details->childrens > 0 ) : ?>
                                        <?php printf( _n( '%d Child', '%s Children', $details->childrens, 'directorist-booking' ), $details->childrens ) ?>
                                    <?php endif; ?>
                                    <?php if ( isset( $details->adults )  && $details->adults > 0 ) : ?>
                                        <?php printf( _n( '%d Guest', '%s', $details->adults, 'directorist-booking' ), $details->adults ) ?>
                                    <?php endif; ?>
                                    <?php if ( isset( $details->tickets )  && $details->tickets > 0 ) : ?>
                                        <?php printf( _n( '%d Ticket', '%s Tickets', $details->tickets, 'directorist-booking' ), $details->tickets ) ?>
                                    <?php endif; ?>
                                </li>
                            </ul>
                        </div>
                    <?php } ?>

                    <?php
                    $currency          = get_directorist_option( 'g_currency', 'USD' );
                    $currency_position = get_directorist_option( 'g_currency_position', 'before' );
                    $currency_symbol   = atbdp_currency_symbol( $currency );
                    if ( $value['price'] ) :?>
                        <div class="directorist-inner__booking-list">
                            <h5 class="directorist-inner__h5title"><?php esc_html_e( 'Price:', 'directorist-booking' );?></h5>
                            <ul class="directorist-booking-list">
                                <li class="directorist-highlighted" id="price">
                                    <?php if ( $currency_position == 'before' ) {
                                        echo $currency_symbol . ' '; } ?>
                                    <?php echo $value['price']?>
                                    <?php if ( $currency_position == 'after' ) {
                                        echo ' ' . $currency_symbol; } ?>
                                </li>
                            </ul>
                        </div>
                   <?php endif;?>

                    <div class="directorist-inner__booking-list">

                        <h5 class="directorist-inner__h5title"><?php esc_html_e( 'Client:', 'directorist-booking' ); ?></h5>
                        <ul class="directorist-booking-list" id="client">
                            <?php if ( isset( $details->first_name ) || isset( $details->last_name ) ) : ?>
                                <li id="name"><?php if ( isset( $details->first_name ) ) echo $details->first_name; ?> <?php if ( isset( $details->last_name ) ) echo $details->last_name; ?></li>
                            <?php endif; ?>
                            <?php if ( isset( $details->email ) ) :
                                ?><li id="email"><a href="mailto:<?php echo esc_attr( $details->email ) ?>"><?php echo $details->email; ?></a></li>
                            <?php endif; ?>
                            <?php if ( isset( $details->phone ) ) :
                                ?><li id="phone"><a href="tel:<?php echo esc_attr( $details->phone ) ?>"><?php echo $details->phone; ?></a></li>
                            <?php endif; ?>
                        </ul>

                    </div>
                    <?php if ( isset( $details->service ) && ! empty( $details->service ) ) : ?>
                        <div class="directorist-inner__booking-list">
                            <h5 class="directorist-inner__h5title"><?php esc_html_e( 'Extra Services:', 'directorist-booking' ); ?></h5>
                            <?php echo wpautop( $details->service ); ?>
                        </div>
                    <?php endif; ?>
                    <?php if ( isset( $details->message ) && ! empty( $details->message ) ) : ?>
                        <div class="directorist-inner__booking-list">
                            <h5 class="directorist-inner__h5title"><?php esc_html_e( 'Message:', 'directorist-booking' ); ?></h5>
                            <div class="directorist-inner__msg">
                            <?php echo wpautop( $details->message ); ?>
                            </div>
                        </div>
                    <?php endif; ?>


                    <div class="directorist-inner__booking-list">
                        <h5 class="directorist-inner__h5title"><?php esc_html_e( 'Request sent:', 'directorist-booking' ); ?></h5>
                        <ul class="directorist-booking-list">
                            <li class="directorist-highlighted" id="price">
                                <?php echo date( get_option( 'date_format' ), strtotime( $value['created'] ) ); ?> <?php esc_html_e( 'at','directorist-booking' ); ?> <?php echo date( get_option( 'time_format' ), strtotime( $value['created'] ) ); ?>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="directorist-booking-list-actions">
                    <?php if ( $show_cancel ) : ?>
                            <a href="#" class="directorist-btn directorist-btn-sm directorist-btn-warning directorist-booking-list-actions__reject owner-cancel-btn" data-booking_id="<?php echo esc_attr( $value['ID'] ); ?>"><?php directorist_icon( 'las la-times' ); ?> <?php esc_html_e( 'Cancel', 'directorist-booking' ); ?></a>
                        <?php endif; ?>
                    <?php if ( $show_approve ) : ?>
                        <a href="#" class="directorist-btn directorist-btn-sm directorist-btn-success directorist-booking-list-actions__approve" id="owner_approved" data-booking_id="<?php echo esc_attr( $value['ID'] ); ?>"><?php directorist_icon( 'las la-check' ); ?> <?php esc_html_e( 'Approve', 'directorist-booking' ); ?></a>
                    <?php endif; ?>
                    <?php if ( $show_reject ) : ?>
                        <a href="#" class="directorist-btn directorist-btn-sm directorist-btn-warning directorist-booking-list-actions__reject" id="owner_reject" data-booking_id="<?php echo esc_attr( $value['ID'] ); ?>"><?php directorist_icon( 'las la-times' ); ?> <?php esc_html_e( 'Reject', 'directorist-booking' ); ?></a>
                    <?php endif; ?>
                    <?php if ( $show_delete ) : ?>
                        <a href="#" class="directorist-btn directorist-btn-sm directorist-btn-warning directorist-booking-list-actions__reject" id="owner_delete" data-booking_id="<?php echo esc_attr( $value['ID'] ); ?>"><?php directorist_icon( 'las la-times' ); ?> <?php esc_html_e( 'Delete', 'directorist-booking' ); ?></a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
*/
?>


