<?php
use Directorist\Helper;
if ( 'owner reservations' == $value['comment'] ) {
    return;
}
$class                     = [];
$tag                       = [];
$show_approve              = false;
$show_reject               = false;
$show_refund               = false;
$booking_confirmation_page = bdb_booking_confirmation_page();
$query_var                 = add_query_arg( 'booking-id', $value['ID'], $booking_confirmation_page );
$enable_payment            = get_post_meta( $value['listing_id'], '_bdb_payment_booking', true );
$enable_refund             = get_post_meta( $value['listing_id'], '_enable_refund', true );
$refund_desc               = get_post_meta( $value['listing_id'], '_refund_policy', true );
$booking_payment_type      = get_directorist_option( 'booking_payment_type', 'directorist' );
$first_name                = json_decode( $value['comment'] )->first_name ? json_decode( $value['comment'] )->first_name : '';
if ( ! empty( $value['order_id'] ) && 'woocommerce' == $booking_payment_type ) {
    $wcc_order = wc_get_order( $value['order_id'] );
}
//var_dump( $value );
if ( ! empty( $wcc_order ) && 'woocommerce' == $booking_payment_type ) {
    $wcc_order_status = $wcc_order->get_status();
}

$user     = get_userdata( $value['owner_id'] );
$username = $user->user_login;

$commission_args  = [
    'post_type'  => 'bdb_commission',
    'meta_query' => [
        [
            'key'     => '_username',
            'value'   => $username,
            'compare' => '='
        ],
    ],
];
$commission_query = new WP_Query( $commission_args );

if ( $commission_query->have_posts() ) {
    $commission_id = $commission_query->post->ID;
}

$refund_rules     = get_post_meta( $value['listing_id'], '_refund_rules', true );
$day              = isset( $refund_rules['day'] ) ? $refund_rules['day'] : [];
$amount           = isset( $refund_rules['amount'] ) ? $refund_rules['amount'] : [];
$day_amount_array = array_combine( $day, $amount );                              //create array(day => amount)

ksort( $day_amount_array ); //sort by array key

$booking_date = $value['created'];
$time         = time() - strtotime( $booking_date );  // check booking duration

$amount_in_percent = [];
foreach ( $day_amount_array as $day => $amount ) {
    if ( gmdate( "d", $time ) <= $day ) {
        $amount_in_percent[] = $amount;
        break;
    }
}

$amount        = ( $value['price'] / 100 ) * end( $amount_in_percent );
$refund_amount = $amount;

switch ( $value['status'] ) {
    case 'waiting' :
        $class[] = 'waiting-booking';
        $tag[]   = '<span class="directorist-booking-card__status directorist-booking-card__status--pending">' . esc_html__( 'Pending', 'directorist-booking' ) . '</span>';

        if ( ( $value['price'] > 0 && ! empty( $enable_payment ) && ! empty( $value['order_id'] ) && 'directorist' == $booking_payment_type ) || ( $value['price'] > 0 && ! empty( $enable_payment ) && 'woocommerce' == $booking_payment_type && ! empty( $wcc_order_status ) && 'pending' != $wcc_order_status ) ) {
            $tag[] = '<span class="directorist-booking-card__status directorist-booking-card__status--processing">' . esc_html__( 'Processing Payment', 'directorist-booking' ) . '</span>';
        }

        // if( ( $value['price'] > 0 && ! empty( $enable_payment ) && empty( $value['order_id'] ) && 'directorist' == $booking_payment_type ) || ( $value['price'] > 0 && ! empty( $enable_payment ) && 'woocommerce' == $booking_payment_type && 'pending' == $wcc_order_status ) ) {
        //     $tag[] = '<a href=' . $query_var . '><span class="directorist-booking-status directorist-badge directorist-booking-status-pay-now">'.esc_html__('Pay Now', 'directorist-booking').'</span></a>';
        // }

        if ( ( $value['price'] > 0 && ! empty( $enable_payment ) && empty( $value['order_id'] ) && 'directorist' == $booking_payment_type ) || ( $value['price'] > 0 && ! empty( $enable_payment ) && 'woocommerce' == $booking_payment_type && ! empty( $wcc_order_status ) && 'pending' == $wcc_order_status ) ) {
            $tag[] = '<span class="directorist-booking-card__status directorist-booking-card__status--unpaid">' . esc_html__( 'Unpaid', 'directorist-booking' ) . '</span>';
        }

        $show_approve = true;
        $show_reject  = true;
        $show_delete  = false;
        break;

    case 'confirmed' :

        $class[] = 'approved-booking';
        $tag[]   = '<span  class="directorist-booking-card__status directorist-booking-card__status--approved">' . esc_html__( 'Approved', 'directorist-booking' ) . '</span>';

        if ( ( $value['price'] > 0 && ! empty( $enable_payment ) && ! empty( $value['order_id'] ) && 'directorist' == $booking_payment_type ) || ( $value['price'] > 0 && ! empty( $enable_payment ) && 'woocommerce' == $booking_payment_type && ! empty( $wcc_order_status ) && 'pending' != $wcc_order_status ) ) {
            $tag[] = '<span class="directorist-booking-card__status directorist-booking-card__status--processing">' . esc_html__( 'Processing Payment', 'directorist-booking' ) . '</span>';
        }

        if ( ( $value['price'] > 0 && ! empty( $enable_payment ) && empty( $value['order_id'] ) && 'directorist' == $booking_payment_type ) || ( $value['price'] > 0 && ! empty( $enable_payment ) && 'woocommerce' == $booking_payment_type && ! empty( $wcc_order_status ) && 'pending' == $wcc_order_status ) ) {
            $tag[] = '<a href=' . $query_var . '><span class="directorist-booking-card__status directorist-booking-card__status--payNow">' . esc_html__( 'Pay Now', 'directorist-booking' ) . '</span></a>';
        }

        if ( ( $value['price'] > 0 && ! empty( $enable_payment ) && empty( $value['order_id'] ) && 'directorist' == $booking_payment_type ) || ( $value['price'] > 0 && ! empty( $enable_payment ) && 'woocommerce' == $booking_payment_type && ! empty( $wcc_order_status ) && 'pending' == $wcc_order_status ) ) {
            $tag[] = '<span class="directorist-booking-card__status directorist-booking-card__status--unpaid">' . esc_html__( 'Unpaid', 'directorist-booking' ) . '</span>';
        }
        
        $show_approve = false;
        $show_reject  = true;
        $show_delete  = false;
        break;

    case 'paid' :

        $refund_req = new WP_Query(
            [ 
                'post_type'   => 'bdb_refund',
                'post_status' => 'pending',
                'meta_query'  => [
                    [
                        'key'     => '_refund_booking_id',
                        'value'   => ! empty( $value['ID'] ) ? (int) $value['ID'] : '',
                        'compare' => '='
                    ]
                ]
            ] 
        );

        $class[] = 'approved-booking';
        $tag[]   = '<span class="directorist-booking-card__status directorist-booking-card__status--approved">' . esc_html__( 'Approved', 'directorist-booking' ) . '</span>';

        if ( $value['price'] > 0 ) {
            $tag[] = '<span class="directorist-booking-card__status directorist-booking-card__status--paid">' . esc_html__( 'Paid', 'directorist-booking' ) . '</span>';
        }

        if ( $refund_req->have_posts() ) {
            $tag[] = '<span class="directorist-booking-card__status directorist-booking-card__status--refund">' . esc_html__( 'Processing Refund', 'directorist-booking' ) . '</span>';
        }

        $show_approve = false;
        $show_reject  = false;
        $show_delete  = false;
        if ( ! $refund_req->have_posts() && ! empty( $amount ) && ! empty( $enable_refund ) ) {
            $show_refund = true;
        }
        break;

    case 'cancelled' :

        $refund_req = new WP_Query(
            [ 
                'post_type'   => 'bdb_refund',
                'post_status' => 'publish',
                'meta_query'  => [
                    [
                        'key'     => '_refund_booking_id',
                        'value'   => ! empty( $value['ID'] ) ? (int) $value['ID'] : '',
                        'compare' => '='
                    ]
                ]
            ] 
        );

        $class[] = 'canceled-booking';
        $tag[]   = '<span class="directorist-booking-card__status directorist-booking-card__status--reject">' . esc_html__( 'Cancelled', 'directorist-booking' ) . '</span>';

        if ( $refund_req->have_posts() ) {
            $tag[] = '<span class="directorist-booking-card__status directorist-booking-card__status--refund">' . esc_html__( 'Refunded', 'directorist-booking' ) . '</span>';
        }

        $show_approve = false;
        $show_reject  = false;
        $show_delete  = true;
        break;

    default:
        # code...
        break;
}
$author_pro_pic_id  = get_user_meta( $value['bookings_author'], 'pro_pic', true );
$author_profile_pic = wp_get_attachment_image_src( $author_pro_pic_id, 'thumbnail' );
$listing_img_id     = get_post_meta( $value['listing_id'], '_listing_prv_img', true );
if ( ! empty( $listing_img_id ) ) {
    $listing_img = wp_get_attachment_image_src( $listing_img_id, 'thumbnail' );
}
$default_image_src = get_directorist_option( 'default_preview_image', ATBDP_PUBLIC_ASSETS . 'images/grid.jpg' );
$listing_type      = get_post_meta( $value['listing_id'],'_bdb_booking_type',true );
$booking_type      = get_directorist_option( 'booking_type', [ 'service', 'rent', 'booking' ] );
$booking_type      = ! empty( $booking_type ) ? $booking_type : 'service';
$listing_type      = ( ! empty( $listing_type ) && 'undefined' !== $listing_type ) ? $listing_type : $booking_type;
?>
<?php
// Parse booking details from comment
$details = json_decode( $value['comment'] );

// Prepare guests information
$guests_text = '';
if ( ( isset( $details->childrens ) && $details->childrens > 0 )
    || ( isset( $details->adults ) && $details->adults > 0 )
    || ( isset( $details->tickets ) && $details->tickets > 0 )
) {
    $guest_parts = [];
    if ( isset( $details->childrens ) && $details->childrens > 0 ) {
        $guest_parts[] = sprintf( _n( '%d Child', '%d Children', $details->childrens, 'directorist-booking' ), $details->childrens );
    }
    if ( isset( $details->adults ) && $details->adults > 0 ) {
        $guest_parts[] = sprintf( _n( '%d Guest', '%d Guests', $details->adults, 'directorist-booking' ), $details->adults );
    }
    if ( isset( $details->tickets ) && $details->tickets > 0 ) {
        $guest_parts[] = sprintf( _n( '%d Ticket', '%d Tickets', $details->tickets, 'directorist-booking' ), $details->tickets );
    }
    $guests_text = implode( ', ', $guest_parts );
}

// Prepare date and time information
$date_time_text = '';
if ( 'event' != $listing_type ) {
    if ( $listing_type == 'rent' ) {
        $date_time_text = date( get_option( 'date_format' ), strtotime( $value['date_start'] ) ) . ' - ' . date( get_option( 'date_format' ), strtotime( $value['date_end'] ) );
    } else if ( $listing_type == 'service' ) {
        $date_time_text = date( get_option( 'date_format' ), strtotime( $value['date_start'] ) ) . ' ' . esc_html__( 'at', 'directorist-booking' ) . ' ';
        if ( $value['date_start'] != $value['date_end'] ) {
            $date_time_text .= date( get_option( 'time_format' ), strtotime( $value['date_start'] ) ) . ' - ' . date( get_option( 'time_format' ), strtotime( $value['date_end'] ) );
        } else {
            $date_time_text .= date( get_option( 'time_format' ), strtotime( $value['date_start'] ) );
        }
    } else { // event
        $date_time_text = date( get_option( 'date_format' ), strtotime( $value['date_start'] ) ) . ' ' . esc_html__( 'at', 'directorist-booking' ) . ' ' . date( get_option( 'time_format' ), strtotime( $value['date_start'] ) );
    }
}

// Prepare price information
$price_text = '';
if ( $value['price'] ) {
    $currency          = get_directorist_option( 'g_currency', 'USD' );
    $currency_position = get_directorist_option( 'g_currency_position', 'before' );
    $currency_symbol   = atbdp_currency_symbol( $currency );
    
    if ( $currency_position == 'before' ) {
        $price_text = $currency_symbol . ' ' . $value['price'];
    } else {
        $price_text = $value['price'] . ' ' . $currency_symbol;
    }
}

// Prepare client information
$client_name  = '';
$client_email = '';
if ( isset( $details->first_name ) || isset( $details->last_name ) ) {
    $client_name = trim( ( isset( $details->first_name ) ? $details->first_name : '' ) . ' ' . ( isset( $details->last_name ) ? $details->last_name : '' ) );
}
if ( isset( $details->email ) ) {
    $client_email = $details->email;
}

// Prepare request sent date (date only, no time)
$request_date = date_i18n( get_option( 'date_format' ), strtotime( $value['created'] ) );

// Prepare message/notes
$booking_notes = '';
if ( isset( $details->message ) && ! empty( $details->message ) ) {
    $booking_notes = $details->message;
}
?>
<!-- New dynamic card -->
<div class="directorist-booking-card <?php echo implode( ' ',$class ); ?>" 
     id="booking-list-<?php echo esc_attr( $value['ID'] );?>"
     data-request-date="<?php echo esc_attr( date( 'Y-m-d', strtotime( $value['created'] ) ) ); ?>"
     data-booking-date="<?php echo esc_attr( date( 'Y-m-d', strtotime( $value['date_start'] ) ) ); ?>"
     data-price="<?php echo esc_attr( $value['price'] ); ?>"
     data-listing-id="<?php echo esc_attr( $value['listing_id'] ); ?>">
  <div class="directorist-booking-card__header">
    <a href="<?php echo get_permalink( $value['listing_id'] ); ?>"><?php
    if ( empty( $listing_img_id ) ) { ?>
        <?php   } else { ?>
            <img class="directorist-booking-card__image" src="<?php echo esc_url( $listing_img[0] ); ?>" alt="Listing Image">
        <?php }
        ?>
    </a>
    <div class="directorist-booking-card__info">
      <h2 class="directorist-booking-card__title">
        <a href="<?php echo get_permalink( $value['listing_id'] ); ?>">
            <?php echo get_the_title( $value['listing_id'] ); ?>
        </a>
        
        <span class="directorist-booking-card__status-wrapper">
            <?php echo implode( ' ',$tag ); ?>
        </span>
      </h2>
      <ul class="directorist-booking-card__details">
        <?php if ( ! empty( $guests_text ) ) : ?>
        <li class="directorist-booking-card__guests">
            <?php directorist_icon( 'las la-user' ); ?>
            <?php echo esc_html( $guests_text ); ?>
        </li>
        <?php endif; ?>
        <?php if ( ! empty( $date_time_text ) ) : ?>
        <li class="directorist-booking-card__date">
            <?php directorist_icon( 'las la-calendar' ); ?>
            <?php echo esc_html( $date_time_text ); ?>
        </li>
        <?php endif; ?>
      </ul>
      <?php if ( ! empty( $price_text ) ) : ?>
      <div class="directorist-booking-card__price"><?php echo esc_html( $price_text ); ?></div>
      <?php endif; ?>
    </div>
    <div class="directorist-booking-card__actions">
        <?php if ( ( $value['price'] > 0 && ! empty( $enable_payment ) && empty( $value['order_id'] ) && 'directorist' == $booking_payment_type ) || ( $value['price'] > 0 && ! empty( $enable_payment ) && 'woocommerce' == $booking_payment_type && ! empty( $wcc_order_status ) && 'pending' == $wcc_order_status ) ) : ?>
            <a href="<?php echo ! empty( $query_var ) ? esc_url( $query_var ) : ''; ?>" class="directorist-booking-card__btn directorist-booking-card__btn--pay">
                <?php esc_html_e( 'Pay Now', 'directorist-booking' ); ?>
            </a>
        <?php endif; ?>

        <?php if ( $show_reject ) : ?>
            <a href="#" class="directorist-booking-card__btn directorist-booking-card__btn--reject" id="reject_user_booking" data-booking_id="<?php echo esc_attr( $value['ID'] ); ?>">
                <?php directorist_icon( 'las la-times' ); ?>
                <?php esc_html_e( 'Cancel Booking', 'directorist-booking' ); ?>
            </a>
        <?php endif; ?>

        <?php if ( $show_refund ) : ?>
            <a href="#" class="directorist-booking-card__btn directorist-booking-card__btn--refund" 
               id="refund_user_booking"
               data-target="dcl-claim-modal"
               data-booking_author="<?php echo esc_attr( $value['bookings_author'] ); ?>"
               data-owner_id="<?php echo esc_attr( $value['owner_id'] ); ?>"
               data-booking_id="<?php echo esc_attr( $value['ID'] ); ?>"
               data-user_name="<?php echo ! empty( $first_name ) ? esc_attr( $first_name ) : ''; ?>"
               data-refund_amount="<?php echo esc_attr( $refund_amount ); ?>"
               data-refund_desc="<?php echo esc_attr( $refund_desc ); ?>"
               data-listing_id="<?php echo esc_attr( $value['listing_id'] ); ?>"
               data-commission_id="<?php echo ! empty( $commission_id ) ? esc_attr( $commission_id ) : ''; ?>">
                <?php directorist_icon( 'las la-undo' ); ?>
                <?php esc_html_e( 'Request Refund', 'directorist-booking' ); ?>
            </a>
        <?php endif; ?>
    </div>
  </div>

  <div class="directorist-booking-card__footer">
    <div class="directorist-booking-card__user">
      <?php if ( ! empty( $client_name ) ) : ?>
      <div class="directorist-booking-card__label"><?php echo esc_html( $client_name ); ?></div>
      <?php endif; ?>
      <?php if ( ! empty( $client_email ) ) : ?>
      <div class="directorist-booking-card__value directorist-booking-card__value--email">
        <a href="mailto:<?php echo esc_attr( $client_email ); ?>"><?php echo esc_html( $client_email ); ?></a>
        <div class="directorist-booking-card__value__copy" title="Copy"><?php directorist_icon( 'las la-copy' ); ?></div>
      </div>
      <?php endif; ?>
      <?php if ( isset( $details->phone ) && ! empty( $details->phone ) ) : ?>
      <div class="directorist-booking-card__value directorist-booking-card__value--phone">
        <a href="tel:<?php echo esc_attr( $details->phone ); ?>"><?php echo esc_html( $details->phone ); ?></a>
      </div>
      <?php endif; ?>
    </div>
    <div class="directorist-booking-card__request">
      <div class="directorist-booking-card__label"><?php esc_html_e( 'Booking requested on', 'directorist-booking' ); ?></div>
      <div class="directorist-booking-card__value directorist-booking-card__value--date"><?php echo esc_html( $request_date ); ?></div>
    </div>
    <div class="directorist-booking-card__notes">
      <div class="directorist-booking-card__label"><?php esc_html_e( 'Booking notes', 'directorist-booking' ); ?></div>
      <?php if ( ! empty( $booking_notes ) ) : ?>
        <div class="directorist-booking-card__value">
            <?php echo wpautop( esc_html( $booking_notes ) ); ?>
        </div>
      <?php else : ?>
        <div class="directorist-booking-card__value directorist-booking-card__value--empty">
          <?php esc_html_e( 'no notes are available', 'directorist-booking' ); ?>
        </div>
      <?php endif; ?>
    </div>
    <?php if ( isset( $details->service ) && ! empty( $details->service ) ) : ?>
    <div class="directorist-booking-card__notes">
      <div class="directorist-booking-card__label"><?php esc_html_e( 'Extra Services', 'directorist-booking' ); ?></div>
      <div class="directorist-booking-card__value">
        <?php echo wpautop( esc_html( $details->service ) ); ?>
      </div>
    </div>
    <?php endif; ?>
  </div>
</div>