<?php
/**
 * Google Calendar Connection Modal
 * Two-step process: Connect to calendar → Calendar setup
 */
?>

<!-- Google Calendar Connection Modal -->
<div id="google-calendar-modal" class="directorist-google-calendar-modal" style="display: none;">
    <div class="directorist-google-calendar-modal__overlay"></div>
    <div class="directorist-google-calendar-modal__content">
        <!-- Modal Header -->
        <div class="directorist-google-calendar-modal__header">
            <div class="directorist-google-calendar-modal__header-left">
                <div class="directorist-google-calendar-modal__icon">
                    <img src="<?php echo directorist_booking_url( 'resources/img/svg/google-calendar.svg' ); ?>"
                        alt="Google Calendar">
                </div>
                <div class="directorist-google-calendar-modal__title-section">
                    <h2 class="directorist-google-calendar-modal__title">Connect Google calendar</h2>
                    <p class="directorist-google-calendar-modal__subtitle">Configure Google calendar to sync your
                        booking</p>
                </div>
            </div>
            <button type="button" class="directorist-google-calendar-modal__close" aria-label="Close modal">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M5 5L19 19M5 19L19 5" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                        stroke-linejoin="round" />
                </svg>
            </button>
        </div>

        <div class="directorist-google-calendar-modal__body">
            <!-- Step Indicator -->
            <div class="directorist-google-calendar-modal__steps">
                <div class="directorist-google-calendar-modal__step directorist-google-calendar-modal__step--active"
                    data-step="1">
                    <div class="directorist-google-calendar-modal__step-icon">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <circle cx="12" cy="12" r="10" fill="#14B570" />
                            <path d="M9 12L11 14L15 10" stroke="white" stroke-width="2" stroke-linecap="round"
                                stroke-linejoin="round" />
                        </svg>
                    </div>
                    <span class="directorist-google-calendar-modal__step-text">Connect to calendar</span>
                </div>
                <div class="directorist-google-calendar-modal__step-arrow">
                    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M6 4L10 8L6 12" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                            stroke-linejoin="round" />
                    </svg>
                </div>
                <div class="directorist-google-calendar-modal__step" data-step="2">
                    <div class="directorist-google-calendar-modal__step-icon">
                        <span>2</span>
                    </div>
                    <span class="directorist-google-calendar-modal__step-text">Calendar setup</span>
                </div>
            </div>

            <!-- Step 1: Connect to Calendar -->
            <div class="directorist-google-calendar-modal__step-content directorist-google-calendar-modal__step-content--active" data-step-content="1">
                <!-- Help Section -->
                <!-- <div class="directorist-google-calendar-modal__help" style="display: none;">
                    <div class="directorist-google-calendar-modal__help-content">
                        <div class="directorist-google-calendar-modal__help-icon">
                            <svg width="32" height="32" viewBox="0 0 32 32" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <circle cx="16" cy="16" r="13.33" stroke="rgba(0, 6, 38, 0.9)" stroke-width="1.5" />
                                <path d="M16 10.67v5.33M16 21.33h.01" stroke="rgba(0, 6, 38, 0.9)" stroke-width="2"
                                    stroke-linecap="round" stroke-linejoin="round" />
                            </svg>
                        </div>
                        <div class="directorist-google-calendar-modal__help-text">
                            <h4>Need help to setting up?</h4>
                            <p>Don't know how to connect</p>
                        </div>
                    </div>
                    <button type="button" class="directorist-google-calendar-modal__tutorial-btn">
                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M8 1.33333C4.318 1.33333 1.33333 4.318 1.33333 8C1.33333 11.682 4.318 14.6667 8 14.6667C11.682 14.6667 14.6667 11.682 14.6667 8C14.6667 4.318 11.682 1.33333 8 1.33333ZM8 12C5.79067 12 4 10.2093 4 8C4 5.79067 5.79067 4 8 4C10.2093 4 12 5.79067 12 8C12 10.2093 10.2093 12 8 12Z"
                                fill="currentColor" />
                            <path d="M6 6L10 8L6 10V6Z" fill="currentColor" />
                        </svg>
                        Watch tutorial
                    </button>
                </div> -->

                <!-- API Credentials Form -->
                <form class="directorist-google-calendar-modal__form">
                    <div class="directorist-google-calendar-modal__field">
                        <label class="directorist-google-calendar-modal__label">
                            Google API client ID
                            <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                xmlns="http://www.w3.org/2000/svg" class="directorist-google-calendar-modal__info-icon">
                                <circle cx="8" cy="8" r="7" stroke="currentColor" stroke-width="1.5" />
                                <path d="M8 5.5V8M8 10.5H8.01" stroke="currentColor" stroke-width="1.5"
                                    stroke-linecap="round" stroke-linejoin="round" />
                            </svg>
                        </label>
                        <input type="text" id="google-api-client-id" class="directorist-google-calendar-modal__input"
                            placeholder="Enter your Google Client ID" value="" />
                    </div>

                    <div class="directorist-google-calendar-modal__field">
                        <label class="directorist-google-calendar-modal__label">Secret key</label>
                        <input type="password" id="google-api-secret" class="directorist-google-calendar-modal__input"
                            placeholder="Enter your Google Client Secret" value="" />
                    </div>
                </form>
            </div>

            <!-- Step 2: Calendar Setup -->
            <div class="directorist-google-calendar-modal__step-content" data-step-content="2">
                <!-- Primary Calendar Selection -->
                <div class="directorist-google-calendar-modal__section">
                    <h3 class="directorist-google-calendar-modal__section-title">
                        Primary booking calendar <span class="directorist-google-calendar-modal__required">*</span>
                    </h3>
                    <div class="directorist-google-calendar-modal__dropdown">
                        <button type="button" class="directorist-google-calendar-modal__dropdown-btn"
                            id="primary-calendar-dropdown">
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none"
                                xmlns="http://www.w3.org/2000/svg"
                                class="directorist-google-calendar-modal__dropdown-icon">
                                <rect x="3" y="4" width="14" height="12" rx="2" stroke="currentColor"
                                    stroke-width="1.5" />
                                <path d="M16 8H4M8 2V4M12 2V4" stroke="currentColor" stroke-width="1.5"
                                    stroke-linecap="round" />
                            </svg>
                            <span class="directorist-google-calendar-modal__dropdown-text">Select your primary
                                calendar</span>
                            <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                xmlns="http://www.w3.org/2000/svg"
                                class="directorist-google-calendar-modal__dropdown-arrow">
                                <path d="M4 6L8 10L12 6" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                    stroke-linejoin="round" />
                            </svg>
                        </button>
                        <div class="directorist-google-calendar-modal__dropdown-menu" id="primary-calendar-menu">
                            <!-- Dynamic calendar items will be populated here -->
                            <div class="directorist-google-calendar-modal__loading" id="calendar-loading" style="display: none;">
                                <div class="directorist-google-calendar-modal__loading-spinner"></div>
                                <span>Loading calendars...</span>
                            </div>
                            <div class="directorist-google-calendar-modal__empty-state" id="calendar-empty" style="display: none;">
                                <span>No calendars found</span>
                            </div>
                        </div>
                    </div>
                    <p class="directorist-google-calendar-modal__help-text">New booking will automatically added to this
                        calendar</p>
                </div>

                <!-- Conflict Prevention -->
                <div class="directorist-google-calendar-modal__section">
                    <div class="directorist-google-calendar-modal__section-header">
                        <h3 class="directorist-google-calendar-modal__section-title">Conflict prevention</h3>
                        <span class="directorist-google-calendar-modal__recommended-badge">Recommended</span>
                    </div>
                    <p class="directorist-google-calendar-modal__section-description">Select calendars to check for conflicts before accepting bookings</p>

                    <div class="directorist-google-calendar-modal__calendar-options" id="conflict-calendars-container">
                        <!-- Dynamic calendar options will be populated here by JavaScript -->
                        <div class="directorist-google-calendar-modal__loading" id="conflict-calendars-loading" style="display: none;">
                            <div class="directorist-google-calendar-modal__loading-spinner"></div>
                            <span>Loading calendars...</span>
                        </div>
                        <div class="directorist-google-calendar-modal__empty-state" id="conflict-calendars-empty" style="display: none;">
                            <span>No additional calendars available</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Modal Footer -->
        <div class="directorist-google-calendar-modal__footer">
            <div class="directorist-google-calendar-modal__footer-left">
                <!-- Disconnect Button (shown in Step 2) -->
                <button 
                    type="button" 
                    id="disconnect-google-calendar" 
                    class="directorist-google-calendar-modal__disconnect-btn"
                    style="display: none;"
                >
                    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M3 3L13 13M3 13L13 3" stroke="currentColor" stroke-width="2"/>
                    </svg>
                    <span><?php _e( 'Disconnect', 'directorist-booking' );?></span>
                </button>
            </div>
            
            <div class="directorist-google-calendar-modal__footer-right">
                <button type="button" class="directorist-google-calendar-modal__cancel-btn" id="google-calendar-cancel">
                    Cancel
                </button>
                <button type="button" class="directorist-google-calendar-modal__connect-btn"
                    id="google-calendar-connect">
                    Connect calendar
                </button>
                <button type="button" class="directorist-google-calendar-modal__complete-btn"
                    id="google-calendar-complete" style="display: none;">
                    Complete setup
                </button>
            </div>
        </div>
    </div>
</div>