<?php
/**
 * @author  wpWax
 * @since   6.6
 * @version 7.4.0
 */

use \Directorist\Helper;
use Directorist_Booking\App\Providers\Database;

if ( ! defined( 'ABSPATH' ) ) exit;

$listings_per_page = get_directorist_option( 'user_listings_per_page', 9 );

$args = [
    'post_type'      => 'bdb_refund',
    'post_status'    => [ 'publish', 'pending' ],
    'posts_per_page' => (int) $listings_per_page,
];

$query = new \WP_Query( $args );

if ( $query->have_posts() ) {

    while ( $query->have_posts() ) {
        $query->the_post();

        $amount            = get_post_meta( get_the_ID(), '_amount' );
        $refund_reason     = get_post_meta( get_the_ID(), '_refund_reason' );
        $payment_details   = get_post_meta( get_the_ID(), '_payment_details' );
        $refund_booking_id = get_post_meta( get_the_ID(), '_refund_booking_id' );
        $refund_user_name  = get_post_meta( get_the_ID(), '_refund_user_name' );
        $refund_listing_id = get_post_meta( get_the_ID(), '_refund_listing_id' );
        $refund_status     = get_post_meta( get_the_ID(), '_refund_status' );
        $refund_owner_id   = get_post_meta( get_the_ID(), '_refund_owner_id' );

        $get_booking  = Database::get_booking_by_id( $refund_booking_id[0] );
        $booking_date = ! empty( $get_booking['created'] ) ? date( get_option( 'date_format' ), strtotime( $get_booking['created'] ) ) : '';
        ?>

        <?php if ( get_current_user_id() == $refund_owner_id[0] ) { ?>

            <tr class="directorist-refund-requests-table__row" data-id="<?php the_ID(); ?>" role="row">

                <!-- Listing Column -->
                <td class="directorist-refund-requests-table__cell directorist-refund-requests-table__listing" role="cell">
                    <div class="directorist-refund-requests-listing">
                        <div class="directorist-refund-requests-listing__image">
                            <?php 
                            $listing_image = get_the_post_thumbnail_url( $refund_listing_id[0], 'thumbnail' );
                            if ( $listing_image ) {
                                echo '<img src="' . esc_url( $listing_image ) . '" alt="' . esc_attr( get_the_title( $refund_listing_id[0] ) ) . '" loading="lazy">';
                            } else {
                                echo '<div class="directorist-refund-requests-listing__image-placeholder"><i class="las la-image"></i></div>';
                            }
                            ?>
                        </div>
                        
                        <div class="directorist-refund-requests-listing__content">
                            <h4 class="directorist-refund-requests-listing__title">
                                <a href="<?php echo esc_url( get_the_permalink( $refund_listing_id[0] ) ); ?>" class="directorist-refund-requests-listing__link">
                                    <?php echo esc_html( get_the_title( $refund_listing_id[0] ) ); ?>
                                </a>
                            </h4>
                            
                            <div class="directorist-refund-requests-listing__meta">
                                <span class="directorist-refund-requests-listing__price">
                                    <?php 
                                    $amount = ! empty( $amount[0] ) ? $amount[0] : '0';
                                    echo esc_html( '$' . number_format( $amount, 2 ) );
                                    ?>
                                </span>
                                <span class="directorist-refund-requests-listing__id">
                                    #<?php echo esc_html( $refund_listing_id[0] ); ?>
                                </span>
                            </div>
                        </div>
                    </div>
                </td>

                <!-- Customer Column -->
                <td class="directorist-refund-requests-table__cell directorist-refund-requests-table__user" role="cell">
                    <div class="directorist-refund-requests-customer">
                        <div class="directorist-refund-requests-customer__avatar">
                            <i class="las la-user"></i>
                        </div>
                        <div class="directorist-refund-requests-customer__info">
                            <span class="directorist-refund-requests-customer__name">
                                <?php echo esc_html( $refund_user_name[0] ); ?>
                            </span>
                            <span class="directorist-refund-requests-customer__email">
                                <?php 
                                $user_email = get_user_meta( get_current_user_id(), 'email', true );
                                echo esc_html( $user_email ? $user_email : 'N/A' );
                                ?>
                            </span>
                        </div>
                    </div>
                </td>

                <!-- Booked On Column -->
                <td class="directorist-refund-requests-table__cell directorist-refund-requests-table__booked" role="cell">
                    <div class="directorist-refund-requests-date">
                        <i class="las la-calendar"></i>
                        <span class="directorist-refund-requests-date__text">
                            <?php echo ! empty( $booking_date ) ? esc_html( $booking_date ) : 'N/A'; ?>
                        </span>
                    </div>
                </td>

                <!-- Requested On Column -->
                <td class="directorist-refund-requests-table__cell directorist-refund-requests-table__requested" role="cell">
                    <div class="directorist-refund-requests-date">
                        <i class="las la-clock"></i>
                        <span class="directorist-refund-requests-date__text">
                            <?php echo esc_html( get_the_date() ); ?>
                        </span>
                    </div>
                </td>

                <!-- Reason Column -->
                <td class="directorist-refund-requests-table__cell directorist-refund-requests-table__reason" role="cell">
                    <div class="directorist-refund-requests-reason">
                        <span class="directorist-refund-requests-reason__text" title="<?php echo esc_attr( $refund_reason[0] ); ?>">
                            <?php 
                            $reason_text = wp_kses_post( $refund_reason[0] );
                            echo esc_html( wp_trim_words( $reason_text, 10, '...' ) );
                            ?>
                        </span>
                        <?php if ( strlen( $refund_reason[0] ) > 50 ) : ?>
                            <button class="directorist-refund-requests-reason__toggle" type="button" data-toggle="reason-<?php echo get_the_ID(); ?>">
                                <i class="las la-eye"></i>
                            </button>
                        <?php endif; ?>
                    </div>
                </td>

                <!-- Payment Column -->
                <td class="directorist-refund-requests-table__cell directorist-refund-requests-table__payment" role="cell">
                    <div class="directorist-refund-requests-payment">
                        <span class="directorist-refund-requests-payment__text" title="<?php echo esc_attr( $payment_details[0] ); ?>">
                            <?php 
                            $payment_text = wp_kses_post( $payment_details[0] );
                            echo esc_html( wp_trim_words( $payment_text, 8, '...' ) );
                            ?>
                        </span>
                        <?php if ( strlen( $payment_details[0] ) > 40 ) : ?>
                            <button class="directorist-refund-requests-payment__toggle" type="button" data-toggle="payment-<?php echo get_the_ID(); ?>">
                                <i class="las la-eye"></i>
                            </button>
                        <?php endif; ?>
                    </div>
                </td>
                
                <!-- Status Column -->
                <td class="directorist-refund-requests-table__cell directorist-refund-requests-table__status" role="cell">
                    <div class="directorist-refund-requests-status">
                        <?php 
                        $status_class = '';
                        $status_icon  = '';
                        $status_text  = '';
                        
                        if ( 'on_hold' == $refund_status[0] ) {
                            $status_class = 'directorist-refund-requests-status--pending';
                            $status_icon  = 'las la-clock';
                            $status_text  = __( 'Pending', 'directorist-booking' );
                        } elseif ( 'admin_processing' == $refund_status[0] ) {
                            $status_class = 'directorist-refund-requests-status--processing';
                            $status_icon  = 'las la-spinner';
                            $status_text  = __( 'Processing', 'directorist-booking' );
                        } elseif ( 'paid' == $refund_status[0] ) {
                            $status_class = 'directorist-refund-requests-status--completed';
                            $status_icon  = 'las la-check-circle';
                            $status_text  = __( 'Completed', 'directorist-booking' );
                        }
                        ?>
                        
                        <span class="directorist-refund-requests-status__badge <?php echo esc_attr( $status_class ); ?>">
                            <i class="<?php echo esc_attr( $status_icon ); ?>"></i>
                            <span class="directorist-refund-requests-status__text"><?php echo esc_html( $status_text ); ?></span>
                        </span>
                        
                        <?php if ( 'admin_processing' == $refund_status[0] ) : ?>
                            <div class="directorist-refund-requests-status__note">
                                <i class="las la-info-circle"></i>
                                <span><?php esc_html_e( 'Being processed by admin', 'directorist-booking' ); ?></span>
                            </div>
                        <?php endif; ?>
                    </div>
                </td>
                
                <!-- Actions Column -->
                <td class="directorist-refund-requests-table__cell directorist-refund-requests-table__actions" role="cell">
                    <div class="directorist-refund-requests-actions">
                        <?php if ( 'on_hold' == $refund_status[0] ) : ?>
                            <div class="directorist-refund-requests-actions__group">
                                <button class="directorist-refund-requests-action directorist-refund-requests-action--approve bdb-refund-approve" 
                                        data-id="<?php echo get_the_ID(); ?>" 
                                        type="button"
                                        title="<?php esc_attr_e( 'Approve Refund', 'directorist-booking' ); ?>">
                                    <i class="las la-check"></i>
                                    <span><?php esc_html_e( 'Approve', 'directorist-booking' ); ?></span>
                                </button>
                                
                                <button class="directorist-refund-requests-action directorist-refund-requests-action--decline bdb-refund-decline" 
                                        data-id="<?php echo get_the_ID(); ?>" 
                                        type="button"
                                        title="<?php esc_attr_e( 'Decline Refund', 'directorist-booking' ); ?>">
                                    <i class="las la-times"></i>
                                    <span><?php esc_html_e( 'Decline', 'directorist-booking' ); ?></span>
                                </button>
                            </div>
                        <?php endif; ?>
                    </div>
                </td>

            </tr>

        <?php } else {
            echo sprintf( '<tr class="directorist-refund-requests-table__row directorist-refund-requests-table__row--empty"><td colspan="8" class="directorist-refund-requests-table__cell directorist-refund-requests-table__cell--empty">%s</td></tr>', esc_html__( 'No items found', 'directorist-booking' ) );
        }
    }
    wp_reset_postdata();
} else {
    echo sprintf( '<tr class="directorist-refund-requests-table__row directorist-refund-requests-table__row--empty"><td colspan="8" class="directorist-refund-requests-table__cell directorist-refund-requests-table__cell--empty">%s</td></tr>', esc_html__( 'No refund requests found', 'directorist-booking' ) );
}
