<?php
    // Exit if accessed directly
    if ( ! defined( 'ABSPATH' ) )
        exit;
?>

<div class="user-refund-modal at-modal atm-fade" id="dcl-claim-modal" role="dialog" aria-labelledby="refund-modal-title" aria-describedby="refund-modal-description" aria-modal="true">
    <div class="user-refund-modal__overlay" aria-hidden="true"></div>
    <div class="user-refund-modal__content">
        <div class="user-refund-modal__header">
            <h2 id="refund-modal-title" class="user-refund-modal__title">
                <?php esc_html_e( 'Request Refund', 'directorist-booking' ); ?>
            </h2>
            <a href="#" class="at-modal-close" aria-label="<?php esc_attr_e( 'Close modal', 'directorist-booking' ); ?>">
                <span aria-hidden="true">×</span>
            </a>
        </div>
        
        <div class="user-refund-modal__body">
            <form enctype="multipart/form-data" action="#" method="post" id="bdb_user_refund_form" class="user-refund-modal__form" novalidate="">
                <div class="user-refund-modal__field">
                    <label for="bdb_user_refund_amount" class="user-refund-modal__label">
                        <?php esc_html_e( 'Refund Amount', 'directorist-booking' ); ?>
                    </label>
                    <input 
                        id="bdb_user_refund_amount" 
                        class="user-refund-modal__input" 
                        placeholder="<?php esc_attr_e( 'Amount', 'directorist-booking' ); ?>" 
                        name="amount_demo" 
                        type="text" 
                        value="" 
                        required="required" 
                        disabled
                        aria-describedby="amount-info"
                    >
                </div>
                
                <div class="user-refund-modal__field">
                    <label for="bdb_user_refund_reason" class="user-refund-modal__label">
                        <?php esc_html_e( 'Reason', 'directorist-booking' ); ?>
                        <span class="asterisk">*</span>
                    </label>
                    <textarea 
                        id="bdb_user_refund_reason" 
                        class="user-refund-modal__textarea" 
                        name="refund_reason" 
                        rows="3" 
                        required="required"
                        placeholder="<?php esc_attr_e( 'Explain why you need a refund...', 'directorist-booking' ); ?>"
                    ></textarea>
                </div>
                
                <div class="user-refund-modal__field">
                    <label for="bdb_user_payment_details" class="user-refund-modal__label">
                        <?php esc_html_e( 'Payment Details', 'directorist-booking' ); ?>
                        <span class="asterisk">*</span>
                    </label>
                    <textarea 
                        id="bdb_user_payment_details" 
                        class="user-refund-modal__textarea" 
                        name="payment_details" 
                        rows="3" 
                        required="required"
                        placeholder="<?php esc_attr_e( 'Bank account, PayPal email, or payment info...', 'directorist-booking' ); ?>"
                    ></textarea>
                </div>
                
                <!-- Hidden fields -->
                <input type="hidden" name="refund_booking_id" />
                <input type="hidden" name="refund_user_name" />
                <input type="hidden" name="refund_booking_author" />
                <input type="hidden" name="refund_owner_id" />
                <input type="hidden" name="refund_listing_id" />
                <input type="hidden" name="refund_commission_id" />
                <input type="hidden" name="amount" />
                
            </form>
        </div>
        
        <div class="user-refund-modal__footer">
            <button type="button" class="user-refund-modal__cancel-btn" id="refund-modal-cancel">
                <?php esc_html_e( 'Cancel', 'directorist-booking' ); ?>
            </button>
            <button type="submit" form="bdb_user_refund_form" class="user-refund-modal__submit-btn" id="bdb_user_refund_submit">
                <?php esc_html_e( 'Submit', 'directorist-booking' ); ?>
            </button>
        </div>
    </div>
</div>