<?php

use Directorist_Booking\App\Http\Controllers\UserController;
use Directorist_Booking\App\Http\Controllers\BookingController;
use Directorist_Booking\WpMVC\Routing\Route;

Route::get( 'user', [UserController::class, 'index'], ['admin'] );

Route::get( 'bookings/confirmed', [BookingController::class, 'get_confirmed_bookings'], ['auth'] );

Route::get(
    'debug', function() {
        return [
            'status_code' => 200,
            'data'        => [
                'user_id'      => get_current_user_id(),
                'is_logged_in' => is_user_logged_in(),
                'user_login'   => wp_get_current_user()->user_login,
            ]
        ];
    }
);
