<?php
if ( ! empty( $field_data[ 'value' ] ) ) extract( $field_data[ 'value' ] ); // extract week days timing
$listing_id = ! empty( $field_data[ 'form' ] ) ? $field_data['form']->get_add_listing_id() : '';
$enable247hour = get_post_meta( $listing_id, '_enable247hour', true ); // extract settings
$enable_directorist_bh_listing = get_post_meta( $listing_id, '_enable_bz_hour_listing', true ); // extract settings
$bdbh_version = get_post_meta( $listing_id, '_bdbh_version', true );
$db_zone = get_post_meta($listing_id, '_timezone', true);
if (empty($db_zone)) {
    //$db_zone = get_directorist_option('timezone', 'America/New_York');
    $db_zone = directorist_get_wp_default_timezone_identifier( 'America/New_York' );
}
$timezones = DateTimeZone::listIdentifiers(DateTimeZone::ALL);
$section_label = $field_data['label'] ?? __('Business hours', 'directorist-business-hours');
?>
<div class="directorist-bh-wrap">
    <div class="directorist-bh-section directorist-bh-section--status">
        <div class="directorist-bh-section__wrapper">
            <input type="checkbox" name="enable_directorist_bh_listing" value="enable" id="enable_directorist_bh_listing" <?php echo ( directorist_is_business_hour_enabled_for_listing( $listing_id ) ) ? 'checked' : ''; ?> >
            <label class="directorist-bh-section__label" for="enable_directorist_bh_listing"> 
                <?php echo ! empty( $section_label ) ? $section_label : __( 'Business hours', 'directorist-business-hours' ); ?> 
                <span class="directorist-bh-section__desc">
                    <?php _e('Set your working hours to let others know when you\'re available or offline', 'directorist-business-hours'); ?>
                </span>
            </label>
        </div>
    </div>

    <div class="directorist-bh-section directorist-bh-section--timezone <?php echo directorist_is_business_hour_enabled_for_listing( $listing_id ) ? 'directorist-bh-show' : 'directorist-bh-hide'; ?>">
        <label class="directorist-bh-section__label" for="dbh-select-timezone">
            <h4 class="directorist-bh-section__title mb-0">
                <?php _e('Timezone', 'directorist-business-hours'); ?>
            </h4>
            <p class="directorist-bh-section__desc">
                <?php _e('Select your timezone.','directorist-business-hours'); ?>
            </p>
        </label>
        <div class="directorist-bh-section__wrapper">
            <div class="directorist-select">
                <select id="dbh-select-timezone" name="timezone">
                    <?php
                    foreach ($timezones as $key => $timezone) {
                        $checked = $timezone === $db_zone ? 'selected' : '';
                        printf('<option value="%s" %s>%s</option>', $timezone, $checked, $timezone);
                    }
                    ?>
                </select>
            </div>
        </div>
    </div>

    <div class="directorist-bh-section directorist-bh-section--type <?php echo ( directorist_is_business_hour_enabled_for_listing( $listing_id ) ) ? 'directorist-bh-show' : 'directorist-bh-hide'; ?>">
        <h4 class="directorist-bh-section__title">
            <?php _e('Timing Type', 'directorist-business-hours'); ?>
        </h4>
        <div class="directorist-bh-section__wrapper">
            <div class="directorist-bh-section__single">
                <!-- <input type="radio" name="directorist-bh-type" value="custom" id="directorist_bh_enable_custom" <?php echo ( empty( $enable247hour ) ) ? 'checked' : ''; ?> > -->
                 
                <input type="checkbox" name="directorist_bh_option" value="custom" id="bh_selected-hours" class="directorist-247-alternative" <?php echo ( empty( $enable247hour ) ) ? 'checked' : ''; ?> >
                <label class="directorist-bh-section__single__label" for="bh_selected-hours"> 
                    <span class="directorist-bh-section__single__icon">
                        <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M9.83333 7.3199V4H8.16667V7.3199C7.54928 7.62671 7.125 8.26381 7.125 9C7.125 10.0355 7.96447 10.875 9 10.875C9.73619 10.875 10.3733 10.4507 10.6801 9.83333H12.3333V8.16667H10.6801C10.498 7.80032 10.1997 7.50196 9.83333 7.3199Z" fill="#141921"/>
                            <path d="M9.96724 17.9219L9.15279 17.9502C8.94619 17.9573 8.73829 17.9573 8.53169 17.9502L7.71724 17.9219L7.77388 16.2939L8.58736 16.3223C8.75672 16.3281 8.92776 16.3281 9.09712 16.3223L9.9106 16.2939L9.96724 17.9219ZM13.2045 16.8438L12.4624 17.1787C12.2937 17.2549 12.1218 17.3259 11.9477 17.3916L11.185 17.6797L10.6108 16.1553L11.3725 15.8682C11.5143 15.8147 11.6541 15.7564 11.7915 15.6943L12.5336 15.3594L13.2045 16.8438ZM5.90083 15.6982C6.03298 15.7577 6.16792 15.8137 6.30415 15.8652L7.06587 16.1533L6.48872 17.6768L5.72798 17.3887C5.56058 17.3253 5.39519 17.2566 5.23286 17.1836L4.4897 16.8496L5.15865 15.3643L5.90083 15.6982ZM15.8461 14.5469L15.2924 15.1436C15.1491 15.2978 15.0001 15.4471 14.8461 15.5908L14.2504 16.1455L13.1391 14.9551L13.7348 14.3994C13.8605 14.2822 13.9821 14.1601 14.0991 14.0342L14.6538 13.4375L15.8461 14.5469ZM3.62251 14.0742C3.72255 14.1803 3.82581 14.284 3.93208 14.3838L4.52583 14.9404L3.4106 16.1279L2.81685 15.5703C2.68679 15.4482 2.56038 15.3222 2.43794 15.1924L1.87935 14.5996L3.06392 13.4824L3.62251 14.0742ZM17.3754 11.4707L17.0903 12.2344C17.0132 12.4406 16.9281 12.6433 16.8364 12.8418L16.4956 13.5811L15.017 12.8975L15.3579 12.1582C15.4326 11.9965 15.5022 11.8319 15.5649 11.6641L15.8501 10.9014L17.3754 11.4707ZM2.13033 11.6934C2.18503 11.8378 2.24445 11.9803 2.30806 12.1201L2.64595 12.8613L1.16255 13.5352L0.825638 12.7939C0.747506 12.6222 0.675086 12.447 0.607865 12.2695L0.318803 11.5088L1.84224 10.9316L2.13033 11.6934ZM1.69673 8.11035L1.67232 8.92383C1.66757 9.0766 1.66757 9.23046 1.67232 9.38281L1.69771 10.1973L0.0688025 10.248L0.0434119 9.43457C0.0375966 9.24821 0.0376288 9.06041 0.0434119 8.87402L0.0688025 8.05957L1.69673 8.11035ZM8.99751 0.0390625C13.9451 0.0390625 17.9565 4.04952 17.9565 8.99707V9.81152H16.3276V8.99707C16.3276 4.94907 13.0455 1.66797 8.99751 1.66797H8.18306V0.0390625H8.99751ZM2.63521 5.46289L2.30025 6.20508C2.2378 6.34342 2.17919 6.48413 2.12544 6.62695L1.83833 7.38867L0.31392 6.81543L0.601029 6.05273C0.667064 5.87727 0.738202 5.70408 0.814896 5.53418L1.15083 4.79199L2.63521 5.46289ZM4.53365 3.35938L3.93892 3.91602C3.82603 4.02176 3.71666 4.13137 3.61079 4.24414L3.05318 4.83789L1.86568 3.72266L2.42329 3.12891C2.55296 2.99079 2.68738 2.85705 2.82564 2.72754L3.41939 2.1709L4.53365 3.35938ZM7.09419 2.14551L6.3315 2.43066C6.1753 2.48903 6.02141 2.55234 5.87056 2.62109L5.12935 2.95898L4.45357 1.47754L5.19478 1.13965C5.38022 1.05512 5.56909 0.97608 5.76119 0.904297L6.52388 0.619141L7.09419 2.14551Z" fill="#141921"/>
                        </svg>
                    </span>
                    <span class="directorist-bh-section__single__content">
                        <?php _e('Custom Hours', 'directorist-business-hours'); ?> 
                        <span class="directorist-bh-section__single__desc">
                            <?php _e('Open for selected hours', 'directorist-business-hours'); ?>   
                        </span>
                    </span>
                </label>
            </div>
            <div class="directorist-bh-section__single">
                <!-- <input type="radio" name="directorist-bh-type" value="always" id="directorist_bh_enable_247" <?php echo (empty($enable247hour) && empty( $enable_directorist_bh_listing )) ? 'checked' : ''; ?> > -->

                <input type="checkbox" name="enable247hour" value="always" id="directorist-bh-extras__active-hour" class="directorist-247-alternative" class="directorist-247-alternative" <?php echo (!empty($enable247hour)) ? 'checked' : ''; ?> >
                <label class="directorist-bh-section__single__label" for="directorist-bh-extras__active-hour"> 
                    <span class="directorist-bh-section__single__icon">
                        <svg class="directorist-bh-section__single__icon__stroke" width="22" height="26" viewBox="0 0 22 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M4.7474 9.7474V9.53906C4.7474 9.15229 4.90104 8.78136 5.17453 8.50786C5.44802 8.23437 5.81896 8.08073 6.20573 8.08073C6.5925 8.08073 6.96344 8.23437 7.23693 8.50786C7.51042 8.78136 7.66406 9.15229 7.66406 9.53906V9.61406C7.66406 9.9699 7.54073 10.3141 7.31406 10.5891L4.7474 13.7057V13.9141H8.08073M12.2474 12.2474H8.91406V12.0391C9.72916 10.8165 10.1641 9.38007 10.1641 7.91073V7.66406M12.2474 12.2474V9.33073M12.2474 12.2474V14.3307M14.3307 7.66406V11.6224M14.3307 11.6224C14.3307 11.2356 14.4844 10.8647 14.7579 10.5912C15.0314 10.3177 15.4023 10.1641 15.7891 10.1641C16.1758 10.1641 16.5468 10.3177 16.8203 10.5912C17.0937 10.8647 17.2474 11.2356 17.2474 11.6224V14.3307M14.3307 11.6224V14.3307M10.9974 20.5807C5.7049 20.5807 1.41406 16.2899 1.41406 10.9974C1.41406 5.7049 5.7049 1.41406 10.9974 1.41406C16.2899 1.41406 20.5807 5.7049 20.5807 10.9974C20.5807 16.2899 16.2899 20.5807 10.9974 20.5807Z" stroke="black"/>
                        </svg>
                    </span>
                    <span class="directorist-bh-section__single__content">
                        <?php _e('24/7 Service', 'directorist-business-hours'); ?> 
                        <span class="directorist-bh-section__single__desc">
                            <?php _e('Open 24 hours 7 days', 'directorist-business-hours'); ?>
                        </span>
                    </span>
                </label>
                <input type="hidden" name="bdbh_version" id="bdbh_version" value="v3.6" >
            </div>
        </div>     
    </div>

    <div class="directorist-bh-section directorist-bh-section--selection <?php echo ( empty( $enable247hour ) && directorist_is_business_hour_enabled_for_listing( $listing_id ) ) ? 'directorist-bh-show' : 'directorist-bh-hide'; ?>">
        <div class="directorist-bh-dayzone">
            <div class="directorist-bh-dayzone__single" data-day="bdbh[monday]">
                <div class="directorist-bh-dayzone__single__switch">
                    <div class="directorist-switch directorist-switch-primary">
                        <input type="checkbox" class="directorist-switch-input" name="bdbh[monday][enable]" id="ds1" value="enable" <?php echo ( ! empty( $monday['enable'] ) && 'enable' == $monday['enable'] ) ? 'checked' : ''; ?> >
                        <label for="ds1" class="directorist-switch-label"><?php _e( 'Monday', 'directorist-business-hours' ); ?></label>
                    </div>
                </div>
                <div class="directorist-bh-dayzone__single__hour-selection">
                    <div class="directorist-checkbox">
                        <input type="checkbox" name="bdbh[monday][remain_close]" value="open" id="dc1" <?php echo ( ! empty( $monday['remain_close']) && 'open' == $monday['remain_close'] ) ? 'checked' : ''; ?> >
                        <label class="directorist-checkbox__label" for="dc1"><?php _e( 'All Day', 'directorist-business-hours' ); ?></label>
                    </div>
                </div>
                <div class="directorist-bh-dayzone__single__action">
                    <a href="#" class="directorist-bh-dayzone__single__action__btn directorist-bh-dayzone__single__action__btn--copy"><?php directorist_icon( 'la la-copy' ); ?></a>
                </div>
                <div class="directorist-bh-dayzone__single__status">
                    <span class="directorist-bh-dayzone__single__status__text directorist-bh-dayzone__single__status__text--247">
                        <?php _e( 'Open for 24 hours', 'directorist-business-hours' ); ?>
                    </span>
                    <span class="directorist-bh-dayzone__single__status__text directorist-bh-dayzone__single__status__text--closed">
                        <?php _e( 'Closed', 'directorist-business-hours' ); ?>
                    </span>
                </div>
                <div class="directorist-bh-dayzone__single__choice">
                    <div class="directorist-bh-dayzone__single__choice__wrapper">
                        <?php
                            $is_not_removable = ''; // default to empty string

                            if( ! empty( $monday['start'] ) ) {
                            $monday_starts = is_array( $monday['start'] ) ? $monday['start'] : array( $monday['start'] );
                            $monday_closes = is_array( $monday['close'] ) ? $monday['close'] : array( $monday['close'] );
                            foreach( $monday_starts as $index => $monday_start ) {
                                $monday_times[] = array(
                                    'start' => $monday_start,
                                    'close' => $monday_closes[ $index ]
                                );
                            }
                            $is_not_removable = count( $monday_times ) < 2 ? ' directorist-not-removable' : '';

                            foreach( $monday_times as $index => $monday_time  ) {
                            ?>

                            <div class="directorist-bh-dayzone__single__choice__item <?php echo $is_not_removable; ?>">
                                <div class="directorist-bh-dayzone__single__choice__slot">
                                    <div class="directorist-selects directorist-selects--start">
                                        <?php echo atbdp_hours( 'bdbh[monday][start][' . $index . ']', !empty( $monday_time ['start'] ) ? $monday_time ['start'] : '', 'open' ); ?>
                                    </div>
                                    <span class="directorist-selects directorist-selects--seperator">to</span>
                                    <div class="directorist-selects directorist-selects--close">
                                        <?php echo atbdp_hours( 'bdbh[monday][close][' . $index . ']', !empty( $monday_time ['close'] ) ? $monday_time ['close'] : '', 'close' ); ?>
                                    </div>
                                </div>
                                <div class="directorist-bh-dayzone__single__choice__action">
                                    <a href="#" class="directorist-bh-dayzone__single__choice__btn directorist-bh-dayzone__single__choice__remove"><?php directorist_icon( 'la la-trash' ); ?></a>
                                </div>
                            </div>

                            <?php }
                            } else { ?>
                                <div class="directorist-bh-dayzone__single__choice__item directorist-not-removable">
                                    <div class="directorist-bh-dayzone__single__choice__slot">
                                        <div class="directorist-selects directorist-selects--start">
                                            <?php echo atbdp_hours( 'bdbh[monday][start][0]', !empty( $monday['start'] ) ? $monday['start'] : '', 'open' ); ?>
                                        </div>
                                        <span class="directorist-selects directorist-selects--seperator">to</span>
                                        <div class="directorist-selects directorist-selects--close">
                                            <?php echo atbdp_hours( 'bdbh[monday][close][0]', !empty( $monday['close'] ) ? $monday['close'] : '', 'close' ); ?>
                                        </div>
                                    </div>
                                    <div class="directorist-bh-dayzone__single__choice__action">
                                        <a href="#" class="directorist-bh-dayzone__single__choice__btn directorist-bh-dayzone__single__choice__remove"><?php directorist_icon( 'la la-trash' ); ?></a>
                                    </div>
                                </div>
                            <?php }
                        ?>
                    </div>
                    <div class="directorist-bh-dayzone__single__choice__action__wrapper">
                        <a href="#" class="directorist-bh-dayzone__single__choice__btn directorist-bh-dayzone__single__choice__add"><?php directorist_icon( 'la la-plus' ); ?><?php _e( 'Add time slot', 'directorist-business-hours' ); ?></a>
                    </div>
                </div>
            </div> <!-- End of /.directorist-bh-dayzone__single -->
            <div class="directorist-bh-dayzone__single" data-day="bdbh[tuesday]">
                <div class="directorist-bh-dayzone__single__switch">
                    <div class="directorist-switch directorist-switch-primary">
                        <input type="checkbox" class="directorist-switch-input" name="bdbh[tuesday][enable]" value="enable" id="ds7" <?php echo ( ! empty( $tuesday['enable']) && 'enable' == $tuesday['enable'] ) ? 'checked' : ''; ?> >
                        <label for="ds7" class="directorist-switch-label"><?php _e( 'Tuesday', 'directorist-business-hours' ); ?></label>
                    </div>
                </div>
                <div class="directorist-bh-dayzone__single__hour-selection">
                    <div class="directorist-checkbox">
                        <input type="checkbox" name="bdbh[tuesday][remain_close]" value="open" id="dc7" <?php echo ( ! empty( $tuesday['remain_close']) && 'open' == $tuesday['remain_close'] ) ? 'checked' : ''; ?> >
                        <label class="directorist-checkbox__label" for="dc7"><?php _e( 'All Day', 'directorist-business-hours' ); ?></label>
                    </div>
                </div>
                <div class="directorist-bh-dayzone__single__action">
                    <a href="#" class="directorist-bh-dayzone__single__action__btn directorist-bh-dayzone__single__action__btn--copy"><?php directorist_icon( 'la la-copy' ); ?></a>
                </div>
                <div class="directorist-bh-dayzone__single__status">
                    <span class="directorist-bh-dayzone__single__status__text directorist-bh-dayzone__single__status__text--247">
                        <?php _e( 'Open for 24 hours', 'directorist-business-hours' ); ?>
                    </span>
                    <span class="directorist-bh-dayzone__single__status__text directorist-bh-dayzone__single__status__text--closed">
                        <?php _e( 'Closed', 'directorist-business-hours' ); ?>
                    </span>
                </div>
                <div class="directorist-bh-dayzone__single__choice">
                    <div class="directorist-bh-dayzone__single__choice__wrapper">
                        <?php
                            $is_not_removable = ''; // default to empty string

                            if( ! empty( $tuesday['start'] ) ) {
                            $tuesday_starts = is_array( $tuesday['start'] ) ? $tuesday['start'] : array( $tuesday['start'] );
                            $tuesday_closes = is_array( $tuesday['close'] ) ? $tuesday['close'] : array( $tuesday['close'] );
                            foreach( $tuesday_starts as $index => $tuesday_start ) {
                                $tuesday_times[] = array(
                                    'start' => $tuesday_start,
                                    'close' => $tuesday_closes[ $index ]
                                );
                            }

                            $is_not_removable = count( $tuesday_times ) < 2 ? ' directorist-not-removable' : '';

                            foreach( $tuesday_times as $index => $tuesday_time  ) {
                            ?>

                            <div class="directorist-bh-dayzone__single__choice__item <?php echo $is_not_removable; ?>">
                                <div class="directorist-bh-dayzone__single__choice__slot">
                                    <div class="directorist-selects directorist-selects--start">
                                        <?php echo atbdp_hours( 'bdbh[tuesday][start][' . $index . ']', !empty( $tuesday_time['start'] ) ? $tuesday_time['start'] : '', 'open'  ); ?>
                                    </div>
                                    <span class="directorist-selects directorist-selects--seperator">to</span>
                                    <div class="directorist-selects directorist-selects--close">
                                        <?php echo atbdp_hours( 'bdbh[tuesday][close][' . $index . ']', !empty( $tuesday_time['close'] ) ? $tuesday_time['close'] : '', 'close'  ); ?>
                                    </div>
                                </div>
                                <div class="directorist-bh-dayzone__single__choice__action">
                                    <a href="#" class="directorist-bh-dayzone__single__choice__btn directorist-bh-dayzone__single__choice__remove"><?php directorist_icon( 'la la-trash' ); ?></a>
                                </div>
                            </div>

                            <?php }
                            } else { ?>

                            <div class="directorist-bh-dayzone__single__choice__item  directorist-not-removable">
                                <div class="directorist-bh-dayzone__single__choice__slot">
                                    <div class="directorist-selects directorist-selects--start">
                                        <?php echo atbdp_hours( 'bdbh[tuesday][start][0]', !empty( $tuesday['start'] ) ? $tuesday['start'] : '', 'open' ); ?>
                                    </div>
                                    <span class="directorist-selects directorist-selects--seperator">to</span>
                                    <div class="directorist-selects directorist-selects--close">
                                        <?php echo atbdp_hours( 'bdbh[tuesday][close][0]', !empty( $tuesday['close'] ) ? $tuesday['close'] : '', 'close'  ); ?>
                                    </div>
                                </div>
                                <div class="directorist-bh-dayzone__single__choice__action">
                                    <a href="#" class="directorist-bh-dayzone__single__choice__btn directorist-bh-dayzone__single__choice__remove"><?php directorist_icon( 'la la-trash' ); ?></a>
                                </div>
                            </div>

                            <?php
                            }
                        ?>
                    </div>
                    <div class="directorist-bh-dayzone__single__choice__action__wrapper">
                        <a href="#" class="directorist-bh-dayzone__single__choice__btn directorist-bh-dayzone__single__choice__add"><?php directorist_icon( 'la la-plus' ); ?><?php _e( 'Add time slot', 'directorist-business-hours' ); ?></a>
                    </div>
                </div>
            </div> <!-- End of /.directorist-bh-dayzone__single -->
            <div class="directorist-bh-dayzone__single" data-day="bdbh[wednesday]">
                <div class="directorist-bh-dayzone__single__switch">
                    <div class="directorist-switch directorist-switch-primary">
                        <input type="checkbox" class="directorist-switch-input" name="bdbh[wednesday][enable]" value="enable" <?php echo ( ! empty( $wednesday['enable'] ) && 'enable' == $wednesday['enable'] ) ? 'checked' : ''; ?> id="ds6">
                        <label for="ds6" class="directorist-switch-label"><?php _e( 'Wednesday', 'directorist-business-hours' ); ?></label>
                    </div>
                </div>
                <div class="directorist-bh-dayzone__single__hour-selection">
                    <div class="directorist-checkbox">
                        <input type="checkbox" name="bdbh[wednesday][remain_close]" value="open" id="dc6" <?php echo ( ! empty( $wednesday['remain_close']) && 'open' == $wednesday['remain_close'] ) ? 'checked' : ''; ?> >
                        <label class="directorist-checkbox__label" for="dc6"><?php _e( 'All Day', 'directorist-business-hours' ); ?></label>
                    </div>
                </div>
                <div class="directorist-bh-dayzone__single__action">
                    <a href="#" class="directorist-bh-dayzone__single__action__btn directorist-bh-dayzone__single__action__btn--copy"><?php directorist_icon( 'la la-copy' ); ?></a>
                </div>
                <div class="directorist-bh-dayzone__single__status">
                    <span class="directorist-bh-dayzone__single__status__text directorist-bh-dayzone__single__status__text--247">
                        <?php _e( 'Open for 24 hours', 'directorist-business-hours' ); ?>
                    </span>
                    <span class="directorist-bh-dayzone__single__status__text directorist-bh-dayzone__single__status__text--closed">
                        <?php _e( 'Closed', 'directorist-business-hours' ); ?>
                    </span>
                </div>
                <div class="directorist-bh-dayzone__single__choice">
                    <div class="directorist-bh-dayzone__single__choice__wrapper">
                        <?php
                            $is_not_removable = ''; // default to empty string

                            if( ! empty( $wednesday['start'] ) ) {
                            $wednesday_starts = is_array( $wednesday['start'] ) ? $wednesday['start'] : array( $wednesday['start'] );
                            $wednesday_closes = is_array( $wednesday['close'] ) ? $wednesday['close'] : array( $wednesday['close'] );
                            foreach( $wednesday_starts as $index => $wednesday_start ) {
                                $wednesday_times[] = array(
                                    'start' => $wednesday_start,
                                    'close' => $wednesday_closes[ $index ]
                                );
                            }

                            $is_not_removable = count( $wednesday_times ) < 2 ? ' directorist-not-removable' : '';

                            foreach( $wednesday_times as $index => $wednesday_time  ) {
                            ?>

                            <div class="directorist-bh-dayzone__single__choice__item <?php echo $is_not_removable; ?>">
                                <div class="directorist-bh-dayzone__single__choice__slot">
                                    <div class="directorist-selects directorist-selects--start">
                                        <?php echo atbdp_hours( 'bdbh[wednesday][start][' . $index . ']', !empty( $wednesday_time['start'] ) ? $wednesday_time['start'] : '', 'open'  ); ?>
                                        </div>
                                        <span class="directorist-selects directorist-selects--seperator">to</span>
                                        <div class="directorist-selects directorist-selects--close">
                                        <?php echo atbdp_hours( 'bdbh[wednesday][close][' . $index . ']', !empty( $wednesday_time['close'] ) ? $wednesday_time['close'] : '', 'close'  ); ?>
                                    </div>
                                </div>
                                <div class="directorist-bh-dayzone__single__choice__action">
                                    <a href="#" class="directorist-bh-dayzone__single__choice__btn directorist-bh-dayzone__single__choice__remove"><?php directorist_icon( 'la la-trash' ); ?></a>
                                </div>
                            </div>

                            <?php }
                            } else { ?>

                                <div class="directorist-bh-dayzone__single__choice__item directorist-not-removable">
                                    <div class="directorist-bh-dayzone__single__choice__slot">
                                        <div class="directorist-selects directorist-selects--start">
                                            <?php echo atbdp_hours( 'bdbh[wednesday][start][0]', !empty( $wednesday['start'] ) ? $wednesday['start'] : '', 'open'  ); ?>
                                            </div>
                                            <span class="directorist-selects directorist-selects--seperator">to</span>
                                            <div class="directorist-selects directorist-selects--close">
                                            <?php echo atbdp_hours( 'bdbh[wednesday][close][0]', !empty( $wednesday['close'] ) ? $wednesday['close'] : '', 'close'  ); ?>
                                        </div>
                                    </div>
                                    <div class="directorist-bh-dayzone__single__choice__action">
                                        <a href="#" class="directorist-bh-dayzone__single__choice__btn directorist-bh-dayzone__single__choice__remove"><?php directorist_icon( 'la la-trash' ); ?></a>
                                    </div>
                                </div>

                            <?php }
                        ?>
                    </div>
                    <div class="directorist-bh-dayzone__single__choice__action__wrapper">
                        <a href="#" class="directorist-bh-dayzone__single__choice__btn directorist-bh-dayzone__single__choice__add"><?php directorist_icon( 'la la-plus' ); ?><?php _e( 'Add time slot', 'directorist-business-hours' ); ?></a>
                    </div>
                </div>
            </div> <!-- End of /.directorist-bh-dayzone__single -->
            <div class="directorist-bh-dayzone__single" data-day="bdbh[thursday]">
                <div class="directorist-bh-dayzone__single__switch">
                    <div class="directorist-switch directorist-switch-primary">
                        <input type="checkbox" class="directorist-switch-input" name="bdbh[thursday][enable]" value="enable" <?php echo ( ! empty( $thursday['enable'] ) && 'enable' == $thursday['enable'] ) ? 'checked' : ''; ?> id="ds2">
                        <label for="ds2" class="directorist-switch-label"><?php _e( 'Thursday', 'directorist-business-hours' ); ?></label>
                    </div>
                </div>
                <div class="directorist-bh-dayzone__single__hour-selection">
                    <div class="directorist-checkbox">
                        <input type="checkbox" name="bdbh[thursday][remain_close]" value="open" id="dc2" <?php echo ( ! empty( $thursday['remain_close']) && 'open' == $thursday['remain_close'] ) ? 'checked' : ''; ?> >
                        <label class="directorist-checkbox__label" for="dc2"><?php _e( 'All Day', 'directorist-business-hours' ); ?></label>
                    </div>
                </div>
                <div class="directorist-bh-dayzone__single__action">
                    <a href="#" class="directorist-bh-dayzone__single__action__btn directorist-bh-dayzone__single__action__btn--copy"><?php directorist_icon( 'la la-copy' ); ?></a>
                </div>
                <div class="directorist-bh-dayzone__single__status">
                    <span class="directorist-bh-dayzone__single__status__text directorist-bh-dayzone__single__status__text--247">
                        <?php _e( 'Open for 24 hours', 'directorist-business-hours' ); ?>
                    </span>
                    <span class="directorist-bh-dayzone__single__status__text directorist-bh-dayzone__single__status__text--closed">
                        <?php _e( 'Closed', 'directorist-business-hours' ); ?>
                    </span>
                </div>
                <div class="directorist-bh-dayzone__single__choice">
                    <div class="directorist-bh-dayzone__single__choice__wrapper">
                        <?php
                            $is_not_removable = ''; // default to empty string

                            if( ! empty( $thursday['start'] ) ) {

                            $thursday_starts = is_array( $thursday['start'] ) ? $thursday['start'] : array( $thursday['start'] );
                            $thursday_closes = is_array( $thursday['close'] ) ? $thursday['close'] : array( $thursday['close'] );
                            foreach( $thursday_starts as $index => $thursday_start ) {
                                $thursday_times[] = array(
                                    'start' => $thursday_start,
                                    'close' => $thursday_closes[ $index ]
                                );
                            }

                            $is_not_removable = count( $thursday_times ) < 2 ? ' directorist-not-removable' : '';

                            foreach( $thursday_times as $index => $thursday_time  ) {
                        ?>
                        <div class="directorist-bh-dayzone__single__choice__item <?php echo $is_not_removable; ?>">
                            <div class="directorist-bh-dayzone__single__choice__slot">
                                <div class="directorist-selects directorist-selects--start">
                                    <?php echo atbdp_hours( 'bdbh[thursday][start][' . $index . ']', !empty( $thursday_time['start'] ) ? $thursday_time['start'] : '', 'open'  ); ?>
                                </div>
                                <span class="directorist-selects directorist-selects--seperator">to</span>
                                <div class="directorist-selects directorist-selects--close">
                                    <?php echo atbdp_hours( 'bdbh[thursday][close][' . $index . ']', !empty( $thursday_time['close'] ) ? $thursday_time['close'] : '', 'close'  ); ?>
                                </div>
                            </div>
                            
                            <div class="directorist-bh-dayzone__single__choice__action">
                                <a href="#" class="directorist-bh-dayzone__single__choice__btn directorist-bh-dayzone__single__choice__remove"><?php directorist_icon( 'la la-trash' ); ?></a>
                            </div>
                        </div>

                        <?php }

                        } else { ?>
                            <div class="directorist-bh-dayzone__single__choice__item directorist-not-removable">
                                <div class="directorist-bh-dayzone__single__choice__slot">
                                    <div class="directorist-selects directorist-selects--start">
                                        <?php echo atbdp_hours( 'bdbh[thursday][start][0]', !empty( $thursday['start'] ) ? $thursday['start'] : '', 'open'  ); ?>
                                    </div>
                                    <span class="directorist-selects directorist-selects--seperator">to</span>
                                    <div class="directorist-selects directorist-selects--close">
                                        <?php echo atbdp_hours( 'bdbh[thursday][close][0]', !empty( $thursday['close'] ) ? $thursday['close'] : '', 'close'  ); ?>
                                    </div>
                                </div>
                                <div class="directorist-bh-dayzone__single__choice__action">
                                    <a href="#" class="directorist-bh-dayzone__single__choice__btn directorist-bh-dayzone__single__choice__remove"><?php directorist_icon( 'la la-trash' ); ?></a>
                                </div>
                            </div>
                        <?php
                        }
                        ?>
                    </div>
                    <div class="directorist-bh-dayzone__single__choice__action__wrapper">
                        <a href="#" class="directorist-bh-dayzone__single__choice__btn directorist-bh-dayzone__single__choice__add"><?php directorist_icon( 'la la-plus' ); ?><?php _e( 'Add time slot', 'directorist-business-hours' ); ?></a>
                    </div>
                </div>
            </div> <!-- End of /.directorist-bh-dayzone__single -->
            <div class="directorist-bh-dayzone__single" data-day="bdbh[friday]">
                <div class="directorist-bh-dayzone__single__switch">
                    <div class="directorist-switch directorist-switch-primary">
                        <input type="checkbox" class="directorist-switch-input" name="bdbh[friday][enable]" value="enable" <?php echo ( ! empty( $friday['enable'] ) && 'enable' == $friday['enable'] ) ? 'checked' : ''; ?> id="ds3">
                        <label for="ds3" class="directorist-switch-label"><?php _e( 'Friday', 'directorist-business-hours' ); ?></label>
                    </div>
                </div>
                <div class="directorist-bh-dayzone__single__hour-selection">
                    <div class="directorist-checkbox">
                        <input type="checkbox" name="bdbh[friday][remain_close]" value="open" id="dc3" <?php echo ( ! empty( $friday['remain_close']) && 'open' == $friday['remain_close'] ) ? 'checked' : ''; ?> >
                        <label class="directorist-checkbox__label" for="dc3"><?php _e( 'All Day', 'directorist-business-hours' ); ?></label>
                    </div>
                </div>
                <div class="directorist-bh-dayzone__single__action">
                    <a href="#" class="directorist-bh-dayzone__single__action__btn directorist-bh-dayzone__single__action__btn--copy"><?php directorist_icon( 'la la-copy' ); ?></a>
                </div>
                <div class="directorist-bh-dayzone__single__status">
                    <span class="directorist-bh-dayzone__single__status__text directorist-bh-dayzone__single__status__text--247">
                        <?php _e( 'Open for 24 hours', 'directorist-business-hours' ); ?>
                    </span>
                    <span class="directorist-bh-dayzone__single__status__text directorist-bh-dayzone__single__status__text--closed">
                        <?php _e( 'Closed', 'directorist-business-hours' ); ?>
                    </span>
                </div>
                <div class="directorist-bh-dayzone__single__choice">
                    <div class="directorist-bh-dayzone__single__choice__wrapper">
                        <?php
                            $is_not_removable = ''; // default to empty string
                            if( ! empty( $friday['start'] ) ) {
                            $friday_starts = is_array( $friday['start'] ) ? $friday['start'] : array( $friday['start'] );
                            $friday_closes = is_array( $friday['close'] ) ? $friday['close'] : array( $friday['close'] );
                            foreach( $friday_starts as $index => $friday_start ) {
                                $friday_times[] = array(
                                    'start' => $friday_start,
                                    'close' => $friday_closes[ $index ]
                                );
                            }

                            $is_not_removable = count( $friday_times ) < 2 ? ' directorist-not-removable' : '';

                            foreach( $friday_times as $index => $friday_time  ) {
                        ?>
                            <div class="directorist-bh-dayzone__single__choice__item <?php echo $is_not_removable; ?>">
                                <div class="directorist-bh-dayzone__single__choice__slot">
                                    <div class="directorist-selects directorist-selects--start">
                                        <?php echo atbdp_hours( 'bdbh[friday][start][' . $index . ']', !empty( $friday_time['start'] ) ? $friday_time['start'] : '', 'open'  ); ?>
                                    </div>
                                    <span class="directorist-selects directorist-selects--seperator">to</span>
                                    <div class="directorist-selects directorist-selects--close">
                                        <?php echo atbdp_hours( 'bdbh[friday][close][' . $index . ']', !empty( $friday_time['close'] ) ? $friday_time['close'] : '', 'close'  ); ?>
                                    </div>
                                </div>
                                <div class="directorist-bh-dayzone__single__choice__action">
                                    <a href="#" class="directorist-bh-dayzone__single__choice__btn directorist-bh-dayzone__single__choice__remove"><?php directorist_icon( 'la la-trash' ); ?></a>
                                </div>
                            </div>
                        <?php }
                        } else { ?>
                            <div class="directorist-bh-dayzone__single__choice__item directorist-not-removable">
                                <div class="directorist-bh-dayzone__single__choice__slot">
                                    <div class="directorist-selects directorist-selects--start">
                                        <?php echo atbdp_hours( 'bdbh[friday][start][0]', !empty( $friday['start'] ) ? $friday['start'] : '', 'open'  ); ?>
                                    </div>
                                    <span class="directorist-selects directorist-selects--seperator">to</span>
                                    <div class="directorist-selects directorist-selects--close">
                                        <?php echo atbdp_hours( 'bdbh[friday][close][0]', !empty( $friday['close'] ) ? $friday['close'] : '', 'close'  ); ?>
                                    </div>
                                </div>
                                <div class="directorist-bh-dayzone__single__choice__action">
                                    <a href="#" class="directorist-bh-dayzone__single__choice__btn directorist-bh-dayzone__single__choice__remove"><?php directorist_icon( 'la la-trash' ); ?></a>
                                </div>
                            </div>
                        <?php }
                        ?>
                    </div>
                    <div class="directorist-bh-dayzone__single__choice__action__wrapper">
                        <a href="#" class="directorist-bh-dayzone__single__choice__btn directorist-bh-dayzone__single__choice__add"><?php directorist_icon( 'la la-plus' ); ?><?php _e( 'Add time slot', 'directorist-business-hours' ); ?></a>
                    </div>
                </div>
            </div> <!-- End of /.directorist-bh-dayzone__single -->
            <div class="directorist-bh-dayzone__single" data-day="bdbh[saturday]">
                <div class="directorist-bh-dayzone__single__switch">
                    <div class="directorist-switch directorist-switch-primary">
                        <input type="checkbox" class="directorist-switch-input" name="bdbh[saturday][enable]" value="enable" <?php echo ( ! empty( $saturday['enable'] ) && 'enable' == $saturday['enable'] ) ? 'checked' : ''; ?> id="ds4">
                        <label for="ds4" class="directorist-switch-label"><?php _e( 'Saturday', 'directorist-business-hours' ); ?></label>
                    </div>
                </div>
                <div class="directorist-bh-dayzone__single__hour-selection">
                    <div class="directorist-checkbox">
                        <input type="checkbox" name="bdbh[saturday][remain_close]" value="open" id="dc4" <?php echo ( ! empty( $saturday['remain_close']) && 'open' == $saturday['remain_close'] ) ? 'checked' : ''; ?> >
                        <label class="directorist-checkbox__label" for="dc4"><?php _e( 'All Day', 'directorist-business-hours' ); ?></label>
                    </div>
                </div>
                <div class="directorist-bh-dayzone__single__action">
                    <a href="#" class="directorist-bh-dayzone__single__action__btn directorist-bh-dayzone__single__action__btn--copy"><?php directorist_icon( 'la la-copy' ); ?></a>
                </div>
                <div class="directorist-bh-dayzone__single__status">
                    <span class="directorist-bh-dayzone__single__status__text directorist-bh-dayzone__single__status__text--247">
                        <?php _e( 'Open for 24 hours', 'directorist-business-hours' ); ?>
                    </span>
                    <span class="directorist-bh-dayzone__single__status__text directorist-bh-dayzone__single__status__text--closed">
                        <?php _e( 'Closed', 'directorist-business-hours' ); ?>
                    </span>
                </div>
                <div class="directorist-bh-dayzone__single__choice">
                    <div class="directorist-bh-dayzone__single__choice__wrapper">
                    <?php
                        $is_not_removable = ''; // default to empty string

                        if( ! empty( $saturday['start'] ) ) {
                            $saturday_starts = is_array( $saturday['start'] ) ? $saturday['start'] : array( $saturday['start'] );
                            $saturday_closes = is_array( $saturday['close'] ) ? $saturday['close'] : array( $saturday['close'] );
                            foreach( $saturday_starts as $index => $saturday_start ) {
                                $saturday_times[] = array(
                                    'start' => $saturday_start,
                                    'close' => $saturday_closes[ $index ]
                                );
                            }
                            $is_not_removable = count( $saturday_times ) < 2 ? ' directorist-not-removable' : '';

                            foreach( $saturday_times as $index => $saturday_time  ) {
                        ?>
                            <div class="directorist-bh-dayzone__single__choice__item">
                                <div class="directorist-bh-dayzone__single__choice__slot">
                                    <div class="directorist-selects directorist-selects--start">
                                        <?php echo atbdp_hours( 'bdbh[saturday][start][' . $index . ']', !empty( $saturday_time['start'] ) ? $saturday_time['start'] : '', 'open'  ); ?>
                                    </div>
                                    <span class="directorist-selects directorist-selects--seperator">to</span>
                                    <div class="directorist-selects directorist-selects--close">
                                        <?php echo atbdp_hours( 'bdbh[saturday][close][' . $index . ']', !empty( $saturday_time['close'] ) ? $saturday_time['close'] : '', 'close'  ); ?>
                                    </div>
                                </div>
                                <div class="directorist-bh-dayzone__single__choice__action">
                                    <a href="#" class="directorist-bh-dayzone__single__choice__btn directorist-bh-dayzone__single__choice__remove"><?php directorist_icon( 'la la-trash' ); ?></a>
                                </div>
                            </div>
                        <?php }
                        } else { ?>
                            <div class="directorist-bh-dayzone__single__choice__item directorist-not-removable">
                                <div class="directorist-bh-dayzone__single__choice__slot">
                                    <div class="directorist-selects directorist-selects--start">
                                        <?php echo atbdp_hours( 'bdbh[saturday][start][0]', !empty( $saturday['start'] ) ? $saturday['start'] : '' ); ?>
                                    </div>
                                    <span class="directorist-selects directorist-selects--seperator">to</span>
                                    <div class="directorist-selects directorist-selects--close">
                                        <?php echo atbdp_hours( 'bdbh[saturday][close][0]', !empty( $saturday['close'] ) ? $saturday['close'] : '' ); ?>
                                    </div>
                                </div>
                                <div class="directorist-bh-dayzone__single__choice__action">
                                    <a href="#" class="directorist-bh-dayzone__single__choice__btn directorist-bh-dayzone__single__choice__remove"><?php directorist_icon( 'la la-trash' ); ?></a>
                                </div>
                            </div>
                        <?php }
                    ?>
                    </div>
                    <div class="directorist-bh-dayzone__single__choice__action__wrapper">
                        <a href="#" class="directorist-bh-dayzone__single__choice__btn directorist-bh-dayzone__single__choice__add"><?php directorist_icon( 'la la-plus' ); ?><?php _e( 'Add time slot', 'directorist-business-hours' ); ?></a>
                    </div>
                </div>
            </div> <!-- End of /.directorist-bh-dayzone__single -->
            <div class="directorist-bh-dayzone__single" data-day="bdbh[sunday]">
                <div class="directorist-bh-dayzone__single__switch">
                    <div class="directorist-switch directorist-switch-primary">
                        <input type="checkbox" class="directorist-switch-input" name="bdbh[sunday][enable]" value="enable" <?php echo ( ! empty( $sunday['enable']) && 'enable' == $sunday['enable'] ) ? 'checked' : ''; ?> id="ds5">
                        <label for="ds5" class="directorist-switch-label"><?php _e( 'Sunday', 'directorist-business-hours' ); ?></label>
                    </div>
                </div>
                <div class="directorist-bh-dayzone__single__hour-selection">
                    <div class="directorist-checkbox">
                        <input type="checkbox" name="bdbh[sunday][remain_close]" value="open" id="dc5" <?php echo ( ! empty( $sunday['remain_close']) && 'open' == $sunday['remain_close'] ) ? 'checked' : ''; ?> >
                        <label class="directorist-checkbox__label" for="dc5"><?php _e( 'All Day', 'directorist-business-hours' ); ?></label>
                    </div>
                </div>
                <div class="directorist-bh-dayzone__single__action">
                    <a href="#" class="directorist-bh-dayzone__single__action__btn directorist-bh-dayzone__single__action__btn--copy"><?php directorist_icon( 'la la-copy' ); ?></a>
                </div>
                <div class="directorist-bh-dayzone__single__status">
                    <span class="directorist-bh-dayzone__single__status__text directorist-bh-dayzone__single__status__text--247">
                        <?php _e( 'Open for 24 hours', 'directorist-business-hours' ); ?>
                    </span>
                    <span class="directorist-bh-dayzone__single__status__text directorist-bh-dayzone__single__status__text--closed">
                        <?php _e( 'Closed', 'directorist-business-hours' ); ?>
                    </span>
                </div>
                <div class="directorist-bh-dayzone__single__choice">
                    <div class="directorist-bh-dayzone__single__choice__wrapper">
                        <?php
                            $is_not_removable = ''; // default to empty string

                            if( ! empty( $sunday['start'] ) ) {
                            $sunday_starts = is_array( $sunday['start'] ) ? $sunday['start'] : array( $sunday['start'] );
                            $sunday_closes = is_array( $sunday['close'] ) ? $sunday['close'] : array( $sunday['close'] );
                            foreach( $sunday_starts as $index => $sunday_start ) {
                                $sunday_times[] = array(
                                    'start' => $sunday_start,
                                    'close' => $sunday_closes[ $index ]
                                );
                            }

                            $is_not_removable = count( $sunday_times ) < 2 ? ' directorist-not-removable' : '';

                            foreach( $sunday_times as $index => $sunday_time  ) {
                            ?>
                            <div class="directorist-bh-dayzone__single__choice__item <?php echo $is_not_removable; ?>">
                                <div class="directorist-bh-dayzone__single__choice__slot">
                                    <div class="directorist-selects directorist-selects--start">
                                        <?php echo atbdp_hours( 'bdbh[sunday][start][' . $index . ']', !empty( $sunday_time['start'] ) ? $sunday_time['start'] : '', 'open' ); ?>
                                    </div>
                                    <span class="directorist-selects directorist-selects--seperator">to</span>
                                    <div class="directorist-selects directorist-selects--close">
                                        <?php echo atbdp_hours( 'bdbh[sunday][close][' . $index . ']', !empty( $sunday_time['close'] ) ? $sunday_time['close'] : '', 'close' ); ?>
                                    </div>
                                </div>
                                <div class="directorist-bh-dayzone__single__choice__action">
                                    <a href="#" class="directorist-bh-dayzone__single__choice__btn directorist-bh-dayzone__single__choice__remove"><?php directorist_icon( 'la la-trash' ); ?></a>
                                </div>
                            </div>
                            <?php }
                            }else { ?>

                            <div class="directorist-bh-dayzone__single__choice__item directorist-not-removable">
                                <div class="directorist-bh-dayzone__single__choice__slot">
                                    <div class="directorist-selects directorist-selects--start">
                                        <?php echo atbdp_hours( 'bdbh[sunday][start][0]', !empty( $sunday['start'] ) ? $sunday['start'] : '' ); ?>
                                    </div>
                                    <span class="directorist-selects directorist-selects--seperator">to</span>
                                    <div class="directorist-selects directorist-selects--close">
                                        <?php echo atbdp_hours( 'bdbh[sunday][close][0]', !empty( $sunday['close'] ) ? $sunday['close'] : '' ); ?>
                                    </div>
                                </div>
                                <div class="directorist-bh-dayzone__single__choice__action">
                                    <a href="#" class="directorist-bh-dayzone__single__choice__btn directorist-bh-dayzone__single__choice__remove"><?php directorist_icon( 'la la-trash' ); ?></a>
                                </div>
                            </div>
                            <?php
                            }
                        ?>
                    </div>
                    <div class="directorist-bh-dayzone__single__choice__action__wrapper">
                        <a href="#" class="directorist-bh-dayzone__single__choice__btn directorist-bh-dayzone__single__choice__add"><?php directorist_icon( 'la la-plus' ); ?><?php _e( 'Add time slot', 'directorist-business-hours' ); ?></a>
                    </div>
                </div>
            </div> <!-- End of /.directorist-bh-dayzone__single -->

            <div class="directorist-bh-dayzone__copy-dropdown">
                <div class="directorist-bh-dayzone__copy-dropdown__header">
                    <span class="directorist-bh-dayzone__copy-dropdown__title"><?php _e('COPY TIMES TO...', 'directorist-business-hours'); ?></span>
                </div>
                <div class="directorist-bh-dayzone__copy-dropdown__content">
                    <div class="directorist-bh-dayzone__copy-dropdown__item directorist-checkbox">
                        <input type="checkbox" id="directorist-bh-copy-select-all" class="directorist-bh-dayzone__copy-dropdown__checkbox">
                        <label for="directorist-bh-copy-select-all" class="directorist-bh-dayzone__copy-dropdown__label directorist-checkbox__label"><?php _e('Select All', 'directorist-business-hours'); ?></label>
                    </div>
                    <div class="directorist-bh-dayzone__copy-dropdown__item directorist-checkbox disabled">
                        <input type="checkbox" id="directorist-bh-copy-bdbh[monday]" class="directorist-bh-dayzone__copy-dropdown__checkbox" value="bdbh[monday]">
                        <label for="directorist-bh-copy-bdbh[monday]" class="directorist-bh-dayzone__copy-dropdown__label directorist-checkbox__label"><?php _e('Monday', 'directorist-business-hours'); ?></label>
                    </div>
                    <div class="directorist-bh-dayzone__copy-dropdown__item directorist-checkbox">
                        <input type="checkbox" id="directorist-bh-copy-bdbh[tuesday]" class="directorist-bh-dayzone__copy-dropdown__checkbox" value="bdbh[tuesday]">
                        <label for="directorist-bh-copy-bdbh[tuesday]" class="directorist-bh-dayzone__copy-dropdown__label directorist-checkbox__label"><?php _e('Tuesday', 'directorist-business-hours'); ?></label>
                    </div>
                    <div class="directorist-bh-dayzone__copy-dropdown__item directorist-checkbox">
                        <input type="checkbox" id="directorist-bh-copy-bdbh[wednesday]" class="directorist-bh-dayzone__copy-dropdown__checkbox" value="bdbh[wednesday]">
                        <label for="directorist-bh-copy-bdbh[wednesday]" class="directorist-bh-dayzone__copy-dropdown__label directorist-checkbox__label"><?php _e('Wednesday', 'directorist-business-hours'); ?></label>
                    </div>
                    <div class="directorist-bh-dayzone__copy-dropdown__item directorist-checkbox">
                        <input type="checkbox" id="directorist-bh-copy-bdbh[thursday]" class="directorist-bh-dayzone__copy-dropdown__checkbox" value="bdbh[thursday]">
                        <label for="directorist-bh-copy-bdbh[thursday]" class="directorist-bh-dayzone__copy-dropdown__label directorist-checkbox__label"><?php _e('Thursday', 'directorist-business-hours'); ?></label>
                    </div>
                    <div class="directorist-bh-dayzone__copy-dropdown__item directorist-checkbox">
                        <input type="checkbox" id="directorist-bh-copy-bdbh[friday]" class="directorist-bh-dayzone__copy-dropdown__checkbox" value="bdbh[friday]">
                        <label for="directorist-bh-copy-bdbh[friday]" class="directorist-bh-dayzone__copy-dropdown__label directorist-checkbox__label"><?php _e('Friday', 'directorist-business-hours'); ?></label>
                    </div>
                    <div class="directorist-bh-dayzone__copy-dropdown__item directorist-checkbox">
                        <input type="checkbox" id="directorist-bh-copy-bdbh[saturday]" class="directorist-bh-dayzone__copy-dropdown__checkbox" value="bdbh[saturday]">
                        <label for="directorist-bh-copy-bdbh[saturday]" class="directorist-bh-dayzone__copy-dropdown__label directorist-checkbox__label"><?php _e('Saturday', 'directorist-business-hours'); ?></label>
                    </div>
                    <div class="directorist-bh-dayzone__copy-dropdown__item directorist-checkbox">
                        <input type="checkbox" id="directorist-bh-copy-bdbh[sunday]" class="directorist-bh-dayzone__copy-dropdown__checkbox" value="bdbh[sunday]">
                        <label for="directorist-bh-copy-bdbh[sunday]" class="directorist-bh-dayzone__copy-dropdown__label directorist-checkbox__label"><?php _e('Sunday', 'directorist-business-hours'); ?></label>
                    </div>
                </div>
                <div class="directorist-bh-dayzone__copy-dropdown__footer">
                    <button type="button" class="directorist-bh-dayzone__copy-dropdown__btn directorist-bh-dayzone__copy-dropdown__btn--reset"><?php _e('Reset All', 'directorist-business-hours'); ?></button>
                    <button type="button" class="directorist-bh-dayzone__copy-dropdown__btn directorist-bh-dayzone__copy-dropdown__btn--apply"><?php _e('Apply', 'directorist-business-hours'); ?></button>
                </div>
            </div>
        </div>
    </div>
</div><!-- ends: .dbh-wrapper -->


