<?php
// prevent direct access to the file
defined('ABSPATH') || die('No direct script access allowed!');
$listing_id                  = ! empty( $field_data[ 'listing_id' ] ) ? $field_data['listing_id'] : '';
$text247                     = get_directorist_option('text247', __('Open 24/7', 'directorist-business-hours'));                                              // text for 24/7 type listing
$business_hour_title         = $field_data['label'] ?? __( 'Business Hour', 'directorist-business-hours' );  // text Business Hour Title
$atbh_display_single_listing = get_directorist_option('atbh_display_single_listing', 1);
$bdbh                        = get_post_meta($listing_id, '_bdbh', true);
$enable247hour               = get_post_meta($listing_id, '_enable247hour', true);
$disable_bz_hour_listing     = get_post_meta($listing_id, '_disable_bz_hour_listing', true);
$business_hours              = !empty($bdbh) ? atbdp_sanitize_array($bdbh) : array();                                                                         // arrays of days and times if exist
$status                      = directorist_business_open_close_status( $listing_id );
if( ! empty( $status ) ) {
    $status_class = 'directorist-bh-module__status--open';
} else {
    $status_class = 'directorist-bh-module__status--closed';
}

// if business hour is active then add the following markup...

if ( !empty($atbh_display_single_listing) && ! empty( directorist_is_business_hour_enabled_for_listing( $listing_id ) ) && (!is_empty_v($business_hours) || !empty($enable247hour))) {
?>

<div class="atbd_content_module directorist-business-hour-module directorist-bh-module">
    <div class="atbd_content_module__tittle_area directorist-bh-module__header">
        <h4 class="atbd_area_title directorist-bh-module__title">
            <span class="directorist-bh-module__header__icon">
                <?php directorist_icon( "la las-clock" ); ?>
            </span>
            <?php echo esc_html($business_hour_title); ?>
        </h4>
        <div class="atbd_upper_badge directorist-bh-module__status <?php echo esc_attr( $status_class ); ?>" data-listing_id="<?php echo esc_attr( get_the_ID() ); ?>">
            <!-- Need to add separate tag for time -->
             <?php if( ! directorist_hours_cache_plugin_compatibility() ) {
                directorist_show_open_close_badge();
            } ?>
            <span class="directorist-bh-module__status__icon">
                <?php directorist_icon( "la las-clock" ); ?>
            </span>
        </div>
    </div>

    <div class="atbdb_content_module_contents directorist-bh-module__content">
        <div class="directorist-bh-schedule" data-listing_id="<?php echo esc_attr( get_the_ID() ); ?>">
        <?php
        if( ! directorist_hours_cache_plugin_compatibility() ){
            if (!empty($enable247hour)) {
                echo '<p class="directorist-bh-schedule-247">'. esc_html($text247) . '</p>';
            } else {
                show_business_hours(); // show the business hour in an unordered list.
            }
        }
        ?>
        </div>
    </div>
</div>
<?php
}