<?php
/**
 * @package  Directorist - Compare Listing
 */

if( ! class_exists( 'Activate' ) ){
    /**
     * Plugin active & initial loaded handler class
     */
    class Activate
    {
        /**
        * Class constructor
        * Call all hooks which we wanna triger
        */
        public function register()
        {
            // Textdomain loded hook
            add_action( 'plugins_loaded', array( $this, 'load_plugin_textdomain' ) );
            add_filter( 'atbdp_listing_type_settings_field_list', array( $this, 'atbdp_listing_type_settings_field_list' ) );
            add_action('atbdp_all_listings_badge_template', array($this, 'atbdp_all_listings_badge_template'));
            add_filter( 'directorist_single_item_template', array( $this, 'directorist_single_item_template' ), 10, 2 );


        }



        public function directorist_single_item_template( $template, $field_data ) {

            if( 'compare_badge' === $field_data['widget_name'] ) {
                $template .= $this->badge_html();
             }

             return $template;

        }


        public function atbdp_all_listings_badge_template( $field ) {
            switch ($field['widget_key']) {
                case 'compare_badge':
                    $this->badge_html();
                break;
            }
        }

        public function badge_html() {
                // Get listing ID
                $listingId          = get_the_ID();
                $tool_tip_text      = __( 'Add to compare', 'directorist-compare-listing' );

                // Get selected listings ID
                $listings           = HelperFunctions::get_selected_ids();

                if( in_array( $listingId, $listings ) ){
                    $select_mark    = 'directorist-compare-added';
                    $tool_tip_text  = __( 'Remove from compare', 'directorist-compare-listing' );
                }

                $select_mark        = !empty( $select_mark ) ? $select_mark : '';

                $compare_button = "
                    <a href='#' class='directorist-compare-btn directorist-tooltip directorist-tooltip_$listingId $select_mark' id='$listingId' data-label='$tool_tip_text'>
                    " . directorist_icon( 'las la-exchange-alt', false, 'atdlc-compare-icon' ) . "
                    </a>

                ";

                echo $compare_button;
        }

        public function atbdp_listing_type_settings_field_list( $fields ){
            foreach( $fields as $key => $value ) {
                // setup widgets
                $compare_widget = [
                    'type' => "badge",
                    'id' => "compare_badge",
                    'label' => "Compare",
                    'icon' => "uil uil-text-fields",
                    'hook' => "atbdp_compare_badge",
                    'options' => [
                        'title' => "Compare Badge Settings",
                        'fields' => [
                            'icon' => [
                                'type' => "icon",
                                'label' => "Icon",
                                'value' => "fa fa-stack-exchange",
                            ],
                        ],
                    ],
                ];

                if( 'listings_card_grid_view' === $key  ) {
                    // register widget
                    $fields[$key]['card_templates']['grid_view_with_thumbnail']['widgets']['compare_badge'] = $compare_widget;
                    $fields[$key]['card_templates']['grid_view_without_thumbnail']['widgets']['compare_badge'] = $compare_widget;

                    // grid with preview image
                      array_push( $fields[$key]['card_templates']['grid_view_with_thumbnail']['layout']['thumbnail']['top_right']['acceptedWidgets'], 'compare_badge' );
                      array_push( $fields[$key]['card_templates']['grid_view_with_thumbnail']['layout']['thumbnail']['top_left']['acceptedWidgets'], 'compare_badge' );
                      array_push( $fields[$key]['card_templates']['grid_view_with_thumbnail']['layout']['thumbnail']['bottom_right']['acceptedWidgets'], 'compare_badge' );
                      array_push( $fields[$key]['card_templates']['grid_view_with_thumbnail']['layout']['thumbnail']['bottom_left']['acceptedWidgets'], 'compare_badge' );
                      array_push( $fields[$key]['card_templates']['grid_view_with_thumbnail']['layout']['body']['top']['acceptedWidgets'], 'compare_badge' );

                      // grid without preview image
                      array_push( $fields[$key]['card_templates']['grid_view_without_thumbnail']['layout']['body']['quick_info']['acceptedWidgets'], 'compare_badge' );
                    }

                    if( 'listings_card_list_view' === $key ) {
                        // register widget
                        $fields[$key]['card_templates']['list_view_with_thumbnail']['widgets']['compare_badge'] = $compare_widget;
                        $fields[$key]['card_templates']['list_view_without_thumbnail']['widgets']['compare_badge'] = $compare_widget;

                        // grid with preview image
                        array_push( $fields[$key]['card_templates']['list_view_with_thumbnail']['layout']['thumbnail']['top_right']['acceptedWidgets'], 'compare_badge' );
                        array_push( $fields[$key]['card_templates']['list_view_with_thumbnail']['layout']['body']['top']['acceptedWidgets'], 'compare_badge' );
                        array_push( $fields[$key]['card_templates']['list_view_with_thumbnail']['layout']['body']['right']['acceptedWidgets'], 'compare_badge' );

                        // grid without preview image
                        array_push( $fields[$key]['card_templates']['list_view_without_thumbnail']['layout']['body']['top']['acceptedWidgets'], 'compare_badge' );
                        array_push( $fields[$key]['card_templates']['list_view_without_thumbnail']['layout']['body']['right']['acceptedWidgets'], 'compare_badge' );
                }

                if( 'single_listing_header' === $key ) {
                    $compare_widget = [
                        'type' => "badge",
                        'id' => "compare_badge",
                        'label' => "Compare",
                        'icon' => "uil uil-text-fields",
                        'hook' => "atbdp_compare_badge",
                        'options' => [
                            'title' => "Compare Badge Settings",
                            'fields' => [
                                'icon' => [
                                    'type' => "icon",
                                    'label' => "Icon",
                                    'value' => "fa fa-stack-exchange",
                                ],
                            ],
                        ],
                    ];
                    
                     $fields[$key]['widgets']['compare_badge'] = $compare_widget;
                     
                    // Check if 'acceptedWidgets' is not set or is not an array, then initialize it as an array
                    if ( ! isset( $fields[$key]['layout'][0]['placeholders'][1]['acceptedWidgets'] ) || ! is_array( $fields[$key]['layout'][0]['placeholders'][1]['acceptedWidgets'] ) ) {
                        $fields[$key]['layout'][0]['placeholders'][1]['acceptedWidgets'] = [];
                    }
                
                    // Now safely push 'compare_badge' into the array
                    array_push( $fields[$key]['layout'][0]['placeholders'][1]['acceptedWidgets'], 'compare_badge' );
                }

            }
            return $fields;
        }



        /**
         * Loaded plugin textdomain.
         */
        public function load_plugin_textdomain()
        {
            // Textdomain loded method
            load_plugin_textdomain( 'directorist-compare-listing', false, ATDLC_PLUGIN_DIRNAME. '/languages' );
        }


        /**
         * This for auto create page when the plugin are activae
         *
         * @return page ID
         */
        public static function atdlc_compare_page_auto_create()
        {
            if ( !get_option( 'atdlc_compare_page_create' ) ) {
                $create_permission = apply_filters( 'atbdp_create_required_pages', true );
                if ( $create_permission ) {
                    $options = get_option( 'atbdp_option' );
                    $id = wp_insert_post(
                        array(
                            'post_title'        => __( 'Compare Listings', 'directorist-compare-listing' ),  //title of page
                            'post_content'      => '[directorist_listing_compare]',         //content of page
                            'post_status'       => 'publish',       // status of page - publish or draft
                            'post_type'         => 'page',          // type of post
                            'comment_status'    => 'closed'
                        )
                    );

                    // if we have new options then lets update the options with new option values.
                    if ( $id ) {
                        update_option( 'atdlc_compare_page_create', 1 );
                        $options['compare_listings_page'] = ( int )$id;
                        update_option( 'atbdp_option', $options );
                    };
                }
            }
        }

    }// End class
}