<?php
/**
 * @package  Directorist - Compare Listing
 */

if (!class_exists('Enqueue')) {
    /**
     * All style & script files enqueue handler class
     */
    class Enqueue
    {
        /**
         * Class constructor
         * Call all hooks which we wanna triger
         */
        public function register()
        {
            // Admin enqueue hook 
            add_action('admin_enqueue_scripts', array($this, 'admin_enqueue_script'));
            // Frontend enqueue hook  
            add_action('wp_enqueue_scripts', array($this, 'frontend_enqueue_script'));
        }


        /**
         * Enqueue all frontend scripts & styles
         *
         * @return void
         */
        public function admin_enqueue_script()
        {            
            // Register admin style
            wp_register_style('atdlc-admin-css', ATDLC_ADMIN_CSS . 'atdlc-admin.css', time());
            // Register admin script
            wp_register_script('atdlc-admin-js', ATDLC_ADMIN_JS . 'atdlc-admin.js', true);

            $screen = get_current_screen();
            if(ATBDP_POST_TYPE == $screen->post_type) {
                // Enqueue admin style
                wp_enqueue_style('atdlc-admin-css');
                // Enqueue admin script
                wp_enqueue_script('atdlc-admin-js');
               
                // Make js variable
                wp_localize_script(
                    // Which file we wanna send the value or variable thats file handle
                    'atdlc-admin-js', // File handle
                    // This object name is similar to, Which file we wanna send the value
                    'atdlc_js_object', // Object name
                    array(
                        'ajaxurl' => admin_url('admin-ajax.php'), // It's a variable
                    )
                );
            }
        }

        

        /**
         * Enqueue all frontend scripts & styles
         *
         * @return void
         */
        public function frontend_enqueue_script()
        {
            // Register frontend style
            wp_register_style('atdlc-frontend-css', ATDLC_FRONTEND_CSS . 'atdlc-frontend.css', time());
            // Register frontend script
            wp_register_script('atdlc-frontend-ajax', ATDLC_FRONTEND_JS . 'atdlc-frontend-ajax.js', ['jquery'], true);

            // Enqueue frontend style
            wp_enqueue_style('atdlc-frontend-css');
            // Enqueue frontend script
            wp_enqueue_script('atdlc-frontend-ajax');          
        
            // Make js variable
            wp_localize_script(
                // Which file we wanna send the value or variable thats file handle
                'atdlc-frontend-ajax',     // File handle
                // This object name is similar to, Which file we wanna send the value
                'atdlc_frontend_ajax_object',     // Object name
                array(
                    'ajaxurl' => admin_url('admin-ajax.php')      // It's a variable                    
                )
            );
        }
    } // End class
}
