<?php
/**
 * @package  Directorist - Compare Listing
 */

/******************************************************************
               START, get Listing custom field's label
******************************************************************/
$fields_label = array();

while( $query->have_posts() ) : $query->the_post();

// Start for custom field's label
$listing_id    = get_the_ID();
// Get categories ID
$category_ids  = array();
$cats          = get_the_terms( $listing_id, ATBDP_CATEGORY );
if ( !empty( $cats ) ){
   foreach ( $cats as $single_cat ){
      $category_ids[] = $single_cat->term_id;
   }
}

// For custom fields query
$custom_field_args = array(
    'post_type'      => ATBDP_CUSTOM_FIELD_POST_TYPE,
    'posts_per_page' => -1,
    'post_status'    => 'publish',
);
$custom_fields = new WP_Query( $custom_field_args );

// Get custom fields
$has_field_value     = array();
$has_field_ids       = array();
$custom_fields_posts = $custom_fields->posts;

foreach( $custom_fields_posts as $custom_fields_post ){
   $cfp_id = $custom_fields_post->ID;
   $fields = get_post_meta( $cfp_id, 'associate', true );
   //lets match if the field is associated with a category and the category is selected
   if( 'form' != $fields ){
      $fields_id_with_cat = get_post_meta( $cfp_id, 'category_pass', true );
      if( in_array( $fields_id_with_cat, $category_ids ) ){
         $has_field_details = get_post_meta( $listing_id, $custom_fields_post->ID, true );
         if( !empty( $has_field_details ) ){
            $has_field_ids[]     = $cfp_id;
            $has_field_value[]   = $has_field_details;
         }
      }
   }else{
      $has_field_details = get_post_meta( $listing_id, $custom_fields_post->ID, true );
      if( !empty( $has_field_details ) ){
         $has_field_ids[]     = $cfp_id;
         $has_field_value[]   = $has_field_details;
      }
   }
}
wp_reset_postdata();

$has_field = join( $has_field_value );
$has_field = apply_filters( 'atbdp_single_listing_custom_field', $has_field );
if( !empty( $has_field ) ){
   foreach( $has_field_ids as $field_id ){
      $field_details       = get_post_meta( $listing_id, $field_id, true );
      $has_field_value[]   = $field_details;
      $field_title         = get_the_title( $field_id );
      $field_type          = get_post_meta( $field_id, 'type', true );

      // Custom field's label
      if( !empty( $field_details ) ){
         if( !in_array( $field_title, $fields_label ) ){
            array_push( $fields_label, $field_title );
         }
      }
   }
   wp_reset_query(); // End custom field query
}
endwhile;
wp_reset_query();
?>
<!--******************************************************************
                  END, get Listing custom field's label
*******************************************************************-->


<!--******************************************************************
                        START Compare table
*******************************************************************-->

<div id="directorist-compare-listing-table-wrapper" class="directorist-compare-listing-table-wrapper">
   <table class="directorist-compare-listing-table">
   <?php if( !empty( $listing_ids ) ): ?>
      <thead>
         <tr>
            <th class="directorist-compare-listing-ct-hide"></th>
            <?php
            while( $query->have_posts() ) : $query->the_post();

            $listing_id = get_the_id();

            // Default image
            $default_img    = get_directorist_option( 'default_preview_image', ATBDP_PUBLIC_ASSETS . 'images/grid.jpg' );

            // Listing image
            $prv_img        = get_post_meta( $listing_id, '_listing_prv_img', true );
            $prv_img_src    = atbdp_get_image_source( $prv_img );
            $img_src        = !empty( $prv_img_src ) ? $prv_img_src : $default_img;
            ?>
            <th id="directorist-compare-listing-th_<?php echo $listing_id; ?>">
               <!-- compare top-->
               <div  class="directorist-compare-listing-table-wrapper-top">
                  <!-- compare remover option -->
                  <div class="directorist-compare-listing-table-wrapper-remove atdlc_listing__center">
                     <div id="directorist-compare-listing-single__action__btn" remove_btn_id="<?php echo $listing_id; ?>" class="directorist-compare-listing-single__action__btn">
                     <?php directorist_icon( 'las la-trash' ); ?>
                     </div>
                  </div>
                  <!-- compare remover option -->
                  <!-- compare top img -->
                  <div class="directorist-compare-listing-table-wrapper-img">
                     <a href="<?php echo esc_url(get_post_permalink(get_the_ID())); ?>" target='_blank'>
                        <img src="<?php echo $img_src; ?>" alt="listing-image">
                     </a>
                  </div>
                  <!-- compare top img -->
                  <!-- compare table img title -->
                  <div class="directorist-compare-listing-table-wrapper-title">
                     <h5>
                        <a href="<?php echo esc_url(get_post_permalink(get_the_ID())); ?>" target='_blank'>
                        <?php echo get_the_title();?>
                        </a>
                     </h5>
                  </div>
                  <!-- compare top img -->
               </div>
               <!-- compare top -->
            </th>
            <?php
            endwhile;
            wp_reset_query();
            ?>
         </tr>
      </thead>
      <tbody>
         <?php
            $enable_multi_directory = get_directorist_option( 'enable_multi_directory' );
            if( ! empty( $enable_multi_directory ) ) {
         ?>
         <tr>
            <td>
               <div class="directorist-compare-listing-table-headings">
                  <?php _e( 'Listing Type', 'directorist-compare-listing' ); ?>
               </div>
            </td>
            <?php
            $listing_types = array();
            while( $query->have_posts() ) : $query->the_post();
               // Get listing ID
               $listing_id      = get_the_id();
               $directory_type  = get_the_terms( $listing_id, ATBDP_TYPE );
               if( ! in_array( $directory_type[0]->term_id, $listing_types ) ) {
                  $listing_types[] =  $directory_type[0]->term_id;
               }
               ?>
               <td id="directorist-compare-listing-th_<?php echo $listing_id; ?>">
                  <div class="directorist-compare-listing-table-price directorist-compare-listing-table-body-text">
                     <?php
                     

                     if( $directory_type ){
                        echo $directory_type[0]->name;
                     }else{
                        echo '<div class="directorist-compare-listing-table-unchecked">'. directorist_icon( 'las la-times' ) .'</i></div>';
                     }
                     ?>
                  </div>
               </td>
               <?php
            endwhile;
            wp_reset_query();
            ?>
         </tr>
            <?php } ?>
         <tr>
            <td>
               <div class="directorist-compare-listing-table-headings">
                  <?php _e( 'Price', 'directorist-compare-listing' ); ?>
               </div>
            </td>
            <?php
            while( $query->have_posts() ) : $query->the_post();
               // Get listing ID
               $listing_id = get_the_id();

               $price = get_post_meta( $listing_id, '_price', true );
               ?>
               <td id="directorist-compare-listing-th_<?php echo $listing_id; ?>">
                  <div class="directorist-compare-listing-table-price directorist-compare-listing-table-body-text">
                     <?php
                     $atbd_listing_pricing = get_post_meta( get_the_ID(), '_atbd_listing_pricing', true );
                     $atbd_listing_pricing = !empty( $atbd_listing_pricing ) ? $atbd_listing_pricing : '';

                     $price_range = get_post_meta( get_the_ID(), '_price_range', true );
                     $price = get_post_meta( get_the_ID(), '_price', true );

                     if( !empty( $price ) || !empty($price_range) ){
                        if ( 'range' === $atbd_listing_pricing ){
                           $output = atbdp_display_price_range( $price_range );
                           echo '<div class="atbd_listing_meta">'. $output .'</div>';

                           if( 0 === strlen( $price_range ) ){
                              echo apply_filters( 'atbdp_listing_card_price', atbdp_display_price( $price, $currency = null, $symbol = null, $c_position = null, $echo = false ) );
                           }
                        }else{
                           echo apply_filters( 'atbdp_listing_card_price', atbdp_display_price( $price, $currency = null, $symbol = null, $c_position = null, $echo = false ) );
                        }
                     }else{
                        echo '<div class="directorist-compare-listing-table-unchecked">'. directorist_icon( 'las la-times' ) .'</div>';
                     }
                     ?>
                  </div>
               </td>
               <?php
            endwhile;
            wp_reset_query();
            ?>
         </tr>
         <tr>
            <td>
               <div class="directorist-compare-listing-table-headings">
                  <?php _e( 'Reviews', 'directorist-compare-listing' ); ?>
               </div>
            </td>
            <?php
            while( $query->have_posts() ) : $query->the_post();
               $listing_id = get_the_id();

               // Get listing review
               $listing_review = ATBDP()->review->get_average( get_the_ID() );
               $listing_review = ! empty( $listing_review ) ? ( int )$listing_review : '';
               ?>
               <td id="directorist-compare-listing-th_<?php echo $listing_id; ?>">
                  <div class="atdlc_listing-ct-review">
                     <?php
                     if( !empty( $listing_review ) ){
                        for( $i = 1; $i <= $listing_review; $i++ ){
                           directorist_icon( 'las la-star' );
                        }
                     }else{
                        echo '<div class="directorist-compare-listing-table-unchecked">'. directorist_icon( 'las la-times') .'</i></div>';
                     }
                     ?>
                  </div>
               </td>
               <?php
            endwhile;
            wp_reset_query();
            ?>
         </tr>
         <tr>
            <td>
               <div class="directorist-compare-listing-table-headings">
                  <?php _e( 'Category', 'directorist-compare-listing' ); ?>
               </div>
            </td>
            <?php
            while( $query->have_posts() ) : $query->the_post();
               $listing_id = get_the_id();
               // Get listing category
               $categories = get_the_terms( $listing_id, ATBDP_CATEGORY );
               ?>
               <td id="directorist-compare-listing-th_<?php echo $listing_id; ?>">
                  <div class="directorist-compare-listing-table-body-text">
                     <?php
                     if( ! empty( $categories ) && ( '' != $categories ) ){
                        foreach( $categories as $category ){
                           echo $category->name."<br>";
                        }
                     }else{
                        echo "Uncategorized";
                     }
                     ?>
                  </div>
               </td>
               <?php
            endwhile;
            wp_reset_query();
            ?>
         </tr>
         <?php
         // Start custom field
         $fields = [ 'file', 'title', 'excerpt', 'image_upload', 'description', 'pricing', 'location', 'tag', 'category', 'zip', 'phone', 'phone2', 'fax', 'email', 'website', 'social_info', 'view_count', 'map', 'hide_contact_owner', 'video', 'tagline', 'address', 'booking', 'faqs', 'gallery', 'listing-type', 'business_hours' ];
         $args             = array(
                              'taxonomy'   => ATBDP_TYPE,
                              'hide_empty' => false
                             );
         if( isset( $listing_types ) && $listing_types ) {
            foreach( $listing_types as $listing_type ) {
               $submission_form_fields = get_term_meta( $listing_type, 'submission_form_fields', true );
               if( $submission_form_fields['fields'] ) {
                  foreach( $submission_form_fields['fields'] as $key => $value ) {
                     if( ! empty( $value['label'] ) && ! empty(  $value['field_key'] ) ) {
                        if( ! in_array( $key, $fields ) ) { ?>
                           <tr>
                              <td>
                                 <div class="directorist-compare-listing-table-headings">
                                    <?php echo $value['label']; ?>
                                 </div>
                              </td>
                              <?php
                              while( $query->have_posts() ) : $query->the_post();
                                 $listing_id = get_the_id();
                                 // Get listing category
                                 $post_meta = get_post_meta( $listing_id, '_' . $value['field_key'], true );
                                 ?>
                                 <td id="directorist-compare-listing-th_<?php echo $listing_id; ?>">
                                    <div class="directorist-compare-listing-table-body-text">
                                       <?php
                                       if( ! empty( $post_meta ) ) {
                                          
                                          switch( $value['type'] ) {
                                             case 'select':
                                                foreach( $value['options'] as $option ) {
                                                   $select_key = $option['option_value'];
                                                   if( $select_key == $post_meta ) {
                                                      echo $option['option_label'];
                                                      break;
                                                   }
                                                }
                                                break;
                                             case 'radio':
                                                foreach( $value['options'] as $option ) {
                                                   $select_key = $option['option_value'];
                                                   if( $select_key == $post_meta ) {
                                                      echo $option['option_label'];
                                                      break;
                                                   }
                                                }
                                                break;
                                             case 'checkbox':
                                                $checkbox_value = is_array( $post_meta ) ? join( ",",$post_meta ) : $post_meta;
                                                $option_value = [];
                                                foreach( $value['options'] as $option ) {
                                                   $checkbox_key = $option['option_value'];
                                                   if( in_array( $checkbox_key, explode( ',', $checkbox_value ) ) ) {
                                                      $space = str_repeat(' ', 1);
                                                      $option_value[] = $space . $option['option_label'];
                                                   }
                                                }
                                                $output = join( ',', $option_value );
                                                echo  $output ? $output : $checkbox_value;
                                                break;
                                             case 'color':
                                                echo '<div class="directorist-field-type-color" style="background-color:' . esc_html( $post_meta ) . '"></div>';
                                                break;
                                             case 'time':
                                                echo date( 'h:i A', strtotime( esc_html( $post_meta ) ) );  
                                                break; 
                                             default:
                                                echo  $post_meta;
                                          }

                                       }else{
                                          echo '<div class="directorist-compare-listing-table-unchecked">'. directorist_icon( 'las la-times') .'</div>';
                                       }
                                       ?>
                                    </div>
                                 </td>
                                 <?php
                              endwhile;
                              wp_reset_query();
                              ?>
                           </tr>
                           <?php
                        }
                     }
                  } 

               }
            }
         }
         ?>
      </tbody>
      <?php endif;wp_reset_query(); ?>
   </table>
</div>

<!--******************************************************************
                           END Compare table
*******************************************************************-->
