<?php
/**
 * @package  Directorist - Compare Listing
 */
?>

<div id='directorist-compare-listing-wrapper' class='directorist-compare-listing-wrapper'>
    <!-- START Collapse button -->
    <div class='directorist-compare-listing-collapse'>
        <div id='directorist-compare-listing-collapse-out' class='directorist-compare-listing-collapse-btn'>
            <div id='directorist-compare-listing-count' class='directorist-compare-listing-count'><?php echo $total_selected; ?></div>
            <?php directorist_icon( 'las la-exchange-alt' ); ?>
        </div>
    </div>
    <!-- END Collapse button -->
    <div class='directorist-compare-listing-items'>
        <h2 class='directorist-compare-listing-items__title'><?php echo $select_window_title; ?></h2>
        <!-- START Selected listings area -->
        <div id='directorist-compare-listing-items__wrapper' class='directorist-compare-listing-items__wrapper'>
            <?php
            $args = array(
                'post_type'     => 'at_biz_dir',
                'post_status'   => 'publish',
                'post__in'      => $selected_listings_id
            );
            $query = new WP_Query( $args );

            while( $query->have_posts() ) : $query->the_post();
            $listing_id = get_the_ID();

            if( isset( $listing_id ) && !empty( $listing_id ) ){
                $listing_title  = get_the_title( $listing_id );

                // Get listing image
                $default_img    = get_directorist_option( 'default_preview_image', ATBDP_PUBLIC_ASSETS .'images/grid.jpg' );
                $prv_img        = get_post_meta( $listing_id, '_listing_prv_img', true );
                $prv_img_src    = atbdp_get_image_source( $prv_img );
                $img_src        = !empty( $prv_img_src ) ? $prv_img_src : $default_img;
                ?>
                <!-- START per listing -->
                <div id='directorist-compare-listing-single<?php echo $listing_id; ?>' class='directorist-compare-listing-single'>
                    <div class='directorist-compare-listing-single__img'>
                        <img src='<?php echo $img_src; ?>' alt=''>
                    </div>
                    <div class="directorist-compare-listing-single__content">
                        <p class='directorist-compare-listing-single__title'><?php echo $listing_title;?></p>
                        <div class="directorist-compare-listing-single__action">
                            <div id='directorist-compare-listing-single__action__btn' remove_btn_id='<?php echo $listing_id; ?>' class='directorist-compare-listing-single__action__btn'>
                                <?php directorist_icon( 'las la-trash' ); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- END per listing -->
                <?php
            }
            endwhile;
            wp_reset_query();
        ?>
        </div>
        <!-- END Selected listings area -->
        <!-- START compare redirect button -->
        <div class='directorist-compare-listing-all'>
            <a id='directorist-compare-listing-all__btn' class='directorist-compare-listing-all__btn' href='<?php echo $compare_page_url; ?>' target='_blank'><?php echo $compare_btn_title; ?></a>
        </div>
        <!-- END compare redirect button -->
    </div>
</div>
