/**
 * @package  Directorist - Compare Listing
 */

(function ($) {
    $(document).ready(function () {
        // activate license and set up updated
        $('#compare_listings_activated input[name="compare_listings_activated"]').on('change', function (event) {
            event.preventDefault();
            var form_data = new FormData();
            var compare_listings_license = $('#compare_listings_license input[name="compare_listings_license"]').val();
            form_data.append('action', 'atbdp_compare_listings_license_activation');
            form_data.append('compare_listings_license', compare_listings_license);
            $.ajax({
                method: 'POST',
                processData: false,
                contentType: false,
                url: atdlc_js_object.ajaxurl,
                data: form_data,
                success: function (response) {
                    if (response.status === true) {
                        $('#success_msg').remove();
                        $('#compare_listings_activated').after('<p id="success_msg">' + response.msg + '</p>');
                        location.reload();
                    } else {
                        $('#error_msg').remove();
                        $('#compare_listings_activated').after('<p id="error_msg">' + response.msg + '</p>');
                    }
                },
                error: function (error) {
                    // console.log(error);
                }
            });
        });

        
        // deactivate license
        $('#compare_listings_deactivated input[name="compare_listings_deactivated"]').on('change', function (event) {
            event.preventDefault();
            var form_data = new FormData();
            var compare_listings_license = $('#compare_listings_license input[name="compare_listings_license"]').val();
            form_data.append('action', 'atbdp_compare_listings_license_deactivation');
            form_data.append('compare_listings_license', compare_listings_license);
            $.ajax({
                method: 'POST',
                processData: false,
                contentType: false,
                url: atdlc_js_object.ajaxurl,
                data: form_data,
                success: function (response) {
                    if (response.status === true) {
                        $('#success_msg').remove();
                        $('#compare_listings_deactivated').after('<p id="success_msg">' + response.msg + '</p>');
                        location.reload();
                    } else {
                        $('#error_msg').remove();
                        $('#compare_listings_deactivated').after('<p id="error_msg">' + response.msg + '</p>');
                    }
                },
                error: function (error) {
                    // console.log(error);
                }
            });
        });

    });
})(jQuery);