(function ($) {
    $(document).ready(function () {
        // activate license and set up updated
        $('#featured_labels_activated input[name="featured_labels_activated"]').on('change', function (event) {
            event.preventDefault();
            var form_data = new FormData();
            var featured_labels_license = $('#featured_labels_license input[name="featured_labels_license"]').val();
            form_data.append('action', 'atbdp_featured_labels_license_activation');
            form_data.append('featured_labels_license', featured_labels_license);
            $.ajax({
                method: 'POST',
                processData: false,
                contentType: false,
                url: fl_js_object.ajaxurl,
                data: form_data,
                success: function (response) {
                    if (response.status === true) {
                        $('#success_msg').remove();
                        $('#featured_labels_activated').after('<p id="success_msg">' + response.msg + '</p>');
                        location.reload();
                    } else {
                        $('#error_msg').remove();
                        $('#featured_labels_activated').after('<p id="error_msg">' + response.msg + '</p>');
                    }
                },
                error: function (error) {
                    // console.log(error);
                }
            });
        });
        // deactivate license
        $('#featured_labels_deactivated input[name="featured_labels_deactivated"]').on('change', function (event) {
            event.preventDefault();
            var form_data = new FormData();
            var featured_labels_license = $('#featured_labels_license input[name="featured_labels_license"]').val();
            form_data.append('action', 'atbdp_featured_labels_license_deactivation');
            form_data.append('featured_labels_license', featured_labels_license);
            $.ajax({
                method: 'POST',
                processData: false,
                contentType: false,
                url: fl_js_object.ajaxurl,
                data: form_data,
                success: function (response) {
                    if (response.status === true) {
                        $('#success_msg').remove();
                        $('#featured_labels_deactivated').after('<p id="success_msg">' + response.msg + '</p>');
                        location.reload();
                    } else {
                        $('#error_msg').remove();
                        $('#featured_labels_deactivated').after('<p id="error_msg">' + response.msg + '</p>');
                    }
                },
                error: function (error) {
                    // console.log(error);
                }
            });
        });

    });
})(jQuery);